/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMServerPing;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.UnauthorizedUserException;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.URL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;

public class MeasureLatency {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$util$MeasureLatency == null ? (class$com$sap$lcr$api$util$MeasureLatency = MeasureLatency.class$("com.sap.lcr.api.util.MeasureLatency")) : class$com$sap$lcr$api$util$MeasureLatency).getName());
    private static final int MAX_ENUM_COUNT = 1000;
    private static final int MAX_INTERNAL_REPEAT = 4;
    private static final boolean INCLUDE_QUALIFIERS = false;
    private static final boolean INCLUDE_CLASSORIGIN = false;
    private static final boolean LOCAL_ONLY = false;
    private String myServerURL;
    private String myUser;
    private String myPwd;
    private int myRepeatCount;
    private String myObjType;
    private int myTimeout;
    private CIMOMHandle myClient = null;
    private String myHost;
    private int myPort;
    private ArrayList myResults = new ArrayList();
    private ArrayList myPingResults = new ArrayList();
    static /* synthetic */ Class class$com$sap$lcr$api$util$MeasureLatency;

    public static void main(String[] args) {
        MeasureLatency tester = new MeasureLatency();
        if (args.length < 6) {
            myLogger.info("Usage: MeasureLatency <server-url> <user> <pwd>");
            myLogger.info("                      <repeat count> classes/assocs/all <timeout/sec>");
            return;
        }
        tester.myServerURL = args[0];
        tester.myUser = args[1];
        tester.myPwd = args[2];
        tester.myRepeatCount = Integer.parseInt(args[3]);
        if (tester.myRepeatCount <= 0) {
            tester.myRepeatCount = 1;
        }
        tester.myObjType = args[4];
        tester.myTimeout = 1000 * Integer.parseInt(args[5]);
        try {
            myLogger.info("Starting measurement of client request latency.");
            myLogger.info("Target server: " + tester.myServerURL);
            myLogger.info("Please be patient...");
            tester.setClient();
            tester.runMeasurement();
            tester.logResult();
        }
        catch (CIMClientException cce) {
            myLogger.error("Client exception, aborted.", cce);
            return;
        }
        catch (LcrException lce) {
            myLogger.error("LCR exception, aborted.", lce);
            return;
        }
        catch (MalformedURLException mfue) {
            myLogger.error("Malformed URL exception, aborted.", mfue);
            return;
        }
    }

    private void setClient() throws CIMClientException, MalformedURLException {
        URL addr = new URL(this.myServerURL);
        this.myClient = ClientFactory.newInstance().createClient(addr, this.myUser, this.myPwd);
        HttpRequestSender sender = (HttpRequestSender)((CIMOMClient)this.myClient).getRequestSender();
        Connection conn = sender.getConnection();
        conn.setSocketReadTimeout(this.myTimeout);
        this.myHost = addr.getHost();
        this.myPort = addr.getPort();
    }

    private void runMeasurement() throws CIMClientException, LcrException {
        if (this.myClient == null) {
            return;
        }
        CIMClassList allClasses = this.myClient.enumerateClasses(null, true, true, true, false);
        myLogger.info("Number of classes = " + allClasses.size());
        int i = 0;
        while (i < allClasses.size()) {
            CIMClass nextClass = allClasses.get(i);
            if (!(nextClass.isIndication() || nextClass.isAbstractClass() || (!this.myObjType.equals("classes") ? this.myObjType.equals("assocs") && !nextClass.isAssociation() : nextClass.isAssociation()))) {
                CIMClassname nextClassName = nextClass.getCIMClassname();
                int nobj = this.myClient.getInstanceCount(nextClassName);
                if (nobj > 0 && nobj < 1000) {
                    int intrep = 1 + 3 * (100 - nobj) / 99;
                    if (intrep <= 0) {
                        intrep = 1;
                    }
                    myLogger.info("Enumerating " + nobj + " instances of class " + nextClassName.toDisplayString());
                    this.myClient.enumerateInstancesNoSubclasses(nextClassName, false, false, false, null);
                    CIMValueNamedInstanceList result = null;
                    int k = 0;
                    while (k < this.myRepeatCount) {
                        Date startDate = new Date();
                        int nres = 0;
                        int j = 0;
                        while (j < intrep) {
                            result = this.myClient.enumerateInstancesNoSubclasses(nextClassName, false, false, false, null);
                            nres += result.size();
                            ++j;
                        }
                        double ddt = this.calculateAverageDuration(startDate, intrep);
                        this.addResult(new RuntimeResult(nres / intrep, ddt));
                        String logMsg = MessageFormat.format("Runtime for enum of {0} ({3}) objects with internal repeat {1} = {2,number,#.00}", new Integer(nobj), new Integer(intrep), new Double(ddt), new Integer(nres / intrep));
                        myLogger.info(logMsg);
                        if (result != null) {
                            byte[] resultBytes = result.toUTF8Xml(null);
                            byte[] compressedBytes = result.toCompressedXml();
                            myLogger.info("Result size (uncompressed/compressed) [Bytes] = " + resultBytes.length + " / " + compressedBytes.length);
                        }
                        ++k;
                    }
                    this.measurePingDuration();
                }
            }
            ++i;
        }
    }

    private void measurePingDuration() {
        try {
            Date startDate1 = new Date();
            boolean pingResult = CIMServerPing.ping(this.myHost, this.myPort);
            double ddt = this.calculateAverageDuration(startDate1, 1);
            this.addPingResult(new RuntimeResult(0, ddt));
            myLogger.info("Simple server ping returns " + pingResult);
            Date startDate2 = new Date();
            ClientUtil.ping(this.myClient);
            ddt = this.calculateAverageDuration(startDate2, 1);
            this.addPingResult(new RuntimeResult(1, ddt));
            myLogger.info("Authenticated server ping O.K.");
        }
        catch (IOException ioe) {
            myLogger.warning("IO exception during server ping", ioe);
        }
        catch (UnauthorizedUserException uaue) {
            myLogger.warning("Authorization exception during server ping", uaue);
        }
        catch (CIMClientException cce) {
            myLogger.warning("Client exception during server ping", cce);
        }
    }

    private double calculateAverageDuration(Date startDate, int count) {
        Date endDate = new Date();
        long ldt = endDate.getTime() - startDate.getTime();
        double selnum = count;
        if (selnum == 0.0) {
            selnum = 1.0;
        }
        return (double)ldt / selnum;
    }

    synchronized void addResult(RuntimeResult res) {
        this.myResults.add(res);
    }

    synchronized void addPingResult(RuntimeResult res) {
        this.myPingResults.add(res);
    }

    private void logResult() {
        if (this.myResults.size() == 0) {
            return;
        }
        double[] rtSumList = new double[1000];
        double[] rtSquareDistList = new double[1000];
        int[] rtNum = new int[1000];
        int ires = 0;
        while (ires < this.myResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myResults.get(ires);
            int n = nextResult.objCount;
            rtSumList[n] = rtSumList[n] + nextResult.duration;
            int n2 = nextResult.objCount;
            rtNum[n2] = rtNum[n2] + 1;
            ++ires;
        }
        int i = 0;
        while (i < 1000) {
            if (rtNum[i] > 0) {
                int n = i;
                rtSumList[n] = rtSumList[n] / (double)rtNum[i];
            }
            ++i;
        }
        int ires2 = 0;
        while (ires2 < this.myResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myResults.get(ires2);
            double dist = nextResult.duration - rtSumList[nextResult.objCount];
            int n = nextResult.objCount;
            rtSquareDistList[n] = rtSquareDistList[n] + dist * dist;
            ++ires2;
        }
        int i2 = 0;
        while (i2 < 1000) {
            if (rtNum[i2] > 1) {
                int n = i2;
                rtSquareDistList[n] = rtSquareDistList[n] / (double)rtNum[i2];
            }
            ++i2;
        }
        myLogger.info("-----------------------------------------------------------------------");
        myLogger.info("Latency measurement result (#objects, duration[msec], deviation, count:");
        myLogger.info("-----------------------------------------------------------------------");
        int i3 = 0;
        while (i3 < 1000) {
            if (rtNum[i3] > 0) {
                double avdev = 0.0;
                if (rtNum[i3] > 1) {
                    avdev = Math.sqrt(rtSquareDistList[i3]);
                }
                String logMsg = MessageFormat.format("{0}  {1,number,#.00}  {2,number,#.00}  {3}", new Integer(i3), new Double(rtSumList[i3]), new Double(avdev), new Integer(rtNum[i3]));
                System.out.println(logMsg);
            }
            ++i3;
        }
        double[] rtpSumList = new double[2];
        double[] rtpSquareDistList = new double[2];
        int[] rtpNum = new int[2];
        int ires3 = 0;
        while (ires3 < this.myPingResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myPingResults.get(ires3);
            int n = nextResult.objCount;
            rtpSumList[n] = rtpSumList[n] + nextResult.duration;
            int n3 = nextResult.objCount;
            rtpNum[n3] = rtpNum[n3] + 1;
            ++ires3;
        }
        int i4 = 0;
        while (i4 < 2) {
            if (rtpNum[i4] > 0) {
                int n = i4;
                rtpSumList[n] = rtpSumList[n] / (double)rtpNum[i4];
            }
            ++i4;
        }
        int ires4 = 0;
        while (ires4 < this.myPingResults.size()) {
            RuntimeResult nextResult = (RuntimeResult)this.myPingResults.get(ires4);
            double dist = nextResult.duration - rtpSumList[nextResult.objCount];
            int n = nextResult.objCount;
            rtpSquareDistList[n] = rtpSquareDistList[n] + dist * dist;
            ++ires4;
        }
        int i5 = 0;
        while (i5 < 2) {
            if (rtpNum[i5] > 1) {
                int n = i5;
                rtpSquareDistList[n] = rtpSquareDistList[n] / (double)rtpNum[i5];
            }
            ++i5;
        }
        myLogger.info("Ping result (First without and second with authentication):");
        int i6 = 0;
        while (i6 < 2) {
            String logMsg = MessageFormat.format("{0,number,#.00}  {1,number,#.00}  {2}", new Double(rtpSumList[i6]), new Double(Math.sqrt(rtpSquareDistList[i6])), new Integer(rtpNum[i6]));
            myLogger.info(logMsg);
            ++i6;
        }
        myLogger.info("Latency measurement finished successfully.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RuntimeResult {
        int objCount;
        double duration;

        RuntimeResult(int objCount, double duration) {
            this.objCount = Math.min(objCount, 999);
            if (this.objCount < 0) {
                this.objCount = 0;
            }
            this.duration = duration;
        }
    }
}

