/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.util;

public final class ByteBuffer {
    private byte[] bytes;
    private int count;

    public ByteBuffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.count = 0;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.bytes.length) {
            return;
        }
        int newCapacity = this.bytes.length * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        byte[] newBytes = new byte[newCapacity];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.count);
        this.bytes = newBytes;
    }

    public void append(byte[] newBytes) {
        this.append(newBytes, 0, newBytes.length);
    }

    public void append(byte[] newBytes, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.bytes.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(newBytes, offset, this.bytes, this.count, len);
        this.count = newcount;
    }

    public int getCapacity() {
        return this.bytes.length;
    }

    public int getLength() {
        return this.count;
    }

    public byte[] toByteArray() {
        if (this.count == 0) {
            return null;
        }
        byte[] result = new byte[this.count];
        System.arraycopy(this.bytes, 0, result, 0, this.count);
        return result;
    }
}

