/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapmodel;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.util.StringTokenizer;

public class SapmodelVersion {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$sapmodel$SapmodelVersion == null ? (class$com$sap$lcr$api$sapmodel$SapmodelVersion = SapmodelVersion.class$("com.sap.lcr.api.sapmodel.SapmodelVersion")) : class$com$sap$lcr$api$sapmodel$SapmodelVersion).getName());
    private static final int EXPECT_MAJOR = 1;
    private static final int EXPECT_MINOR = 2;
    private static final int EXPECT_PATCH = 3;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    static /* synthetic */ Class class$com$sap$lcr$api$sapmodel$SapmodelVersion;

    SapmodelVersion(int aMajor, int aMinor, int aPatch) {
        this.major = aMajor;
        this.minor = aMinor;
        this.patch = aPatch;
    }

    public static SapmodelVersion fromVersionString(String aVersionString) {
        SapmodelVersion newInstance = null;
        int currentState = 1;
        int localMajor = 0;
        int localMinor = 0;
        int localPatch = 0;
        StringTokenizer tokenizer = new StringTokenizer(aVersionString, ".");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            try {
                Integer tokenAsInteger = Integer.valueOf(nextToken);
                int tokenAsInt = tokenAsInteger;
                if (tokenAsInt < 0) {
                    return null;
                }
                switch (currentState) {
                    case 1: {
                        localMajor = tokenAsInt;
                        break;
                    }
                    case 2: {
                        localMinor = tokenAsInt;
                        break;
                    }
                    case 3: {
                        localPatch = tokenAsInt;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++currentState;
            }
            catch (NumberFormatException e) {
                logger.debug("Bad version string: " + aVersionString, e);
                return null;
            }
        }
        if (currentState < 3) {
            return null;
        }
        newInstance = new SapmodelVersion(localMajor, localMinor, localPatch);
        return newInstance;
    }

    public String versionString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static boolean isConnectedServerCompatible(CIMClientHandle aClientConnectedToAnLcrServer) {
        SapmodelVersion clientVersion = SapmodelVersion.fromVersionString("1.3.26");
        if (clientVersion == null) {
            return false;
        }
        SapmodelVersion serverVersion = SapmodelVersion.getConnectedServerVersion(aClientConnectedToAnLcrServer);
        if (serverVersion == null) {
            return false;
        }
        return SapmodelVersion.areSapmodelVersionsCompatible(clientVersion, serverVersion);
    }

    public static SapmodelVersion getClientVersion() {
        return SapmodelVersion.fromVersionString("1.3.26");
    }

    public static SapmodelVersion getConnectedServerVersion(CIMClientHandle aClientConnectedToAnLcrServer) {
        CIMClass cimClass;
        try {
            cimClass = aClientConnectedToAnLcrServer.getCIMClass("SAP_CimSchema");
        }
        catch (CIMClientException e) {
            logger.debug("Caught CIMClientException during getClass() operation for class SAP_CimSchema", e);
            return null;
        }
        catch (LcrException le) {
            logger.debug("Caught LcrException during getClass() operation for class SAP_CimSchema", le);
            return null;
        }
        CIMProperty cimProperty = cimClass.getPropertyByName("Version");
        if (cimProperty == null) {
            return null;
        }
        String serverVersionString = cimProperty.getValue();
        return SapmodelVersion.fromVersionString(serverVersionString);
    }

    public static boolean pingConnectedServer(CIMClientHandle aClientConnectedToAnLcrServer) {
        return CIMClient.pingConnectedServer(aClientConnectedToAnLcrServer);
    }

    public static boolean areSapmodelVersionsCompatible(SapmodelVersion clientVersion, SapmodelVersion serverVersion) {
        if (clientVersion.getMajor() != serverVersion.getMajor()) {
            return false;
        }
        return SapmodelVersion.isFirstGreaterOrEqual(serverVersion, clientVersion);
    }

    public static boolean isFirstGreaterOrEqual(SapmodelVersion firstVersion, SapmodelVersion secondVersion) {
        int secondVersionPatch;
        int secondVersionMinor;
        int secondVersionMajor;
        int firstVersionMajor = firstVersion.getMajor();
        if (firstVersionMajor < (secondVersionMajor = secondVersion.getMajor())) {
            return false;
        }
        if (firstVersionMajor > secondVersionMajor) {
            return true;
        }
        int firstVersionMinor = firstVersion.getMinor();
        if (firstVersionMinor < (secondVersionMinor = secondVersion.getMinor())) {
            return false;
        }
        if (firstVersionMinor > secondVersionMinor) {
            return true;
        }
        int firstVersionPatch = firstVersion.getPatch();
        return firstVersionPatch >= (secondVersionPatch = secondVersion.getPatch());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    static void compareVerbose(String clientVersionString, String serverVersionString) {
        System.out.println("clientVersionString: " + clientVersionString);
        System.out.println("serverVersionString: " + serverVersionString);
        SapmodelVersion clientVersion = SapmodelVersion.fromVersionString(clientVersionString);
        if (clientVersion == null) {
            System.out.println("*** clientVersionString: Invalid version specification\n");
            return;
        }
        SapmodelVersion serverVersion = SapmodelVersion.fromVersionString(serverVersionString);
        if (serverVersion == null) {
            System.out.println("*** serverVersionString: Invalid version specification\n");
            return;
        }
        if (SapmodelVersion.isFirstGreaterOrEqual(clientVersion, serverVersion)) {
            System.out.println("clientVersion >= serverVersion");
        } else {
            System.out.println("clientVersion <  serverVersion");
        }
        if (SapmodelVersion.areSapmodelVersionsCompatible(clientVersion, serverVersion)) {
            System.out.println("+++ Versions are compatible +++\n");
        } else {
            System.out.println("*** Versions are NOT compatible ***\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

