/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapmodel;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMPropertyValue;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.sapmodel.CIMInstancenameJavacimobject;
import com.sap.lcr.api.sapmodel.JavaCIMObject;
import com.sap.lcr.api.sapmodel.JavaCIMObjectAccessor;
import com.sap.lcr.api.sapmodel.SAP_CIMData;
import com.sap.lcr.api.sapmodel.SAP_CIMDataFilter;
import com.sap.lcr.api.sapmodel.SapmodelUtilities;
import java.util.Date;

public class SAP_CIMDataAccessor
extends JavaCIMObjectAccessor {
    public SAP_CIMDataAccessor(CIMClientHandle aClient) {
        super(aClient);
    }

    public SAP_CIMData getInstance(String aName, String aSoftwareElementID, short aSoftwareElementState, short aTargetOperatingSystem, String aVersion) throws LcrException {
        CIMInstancename in = CIMFactory.instancename("SAP_CIMData");
        CIMKeyValue keyval = CIMFactory.keyValue(aName);
        keyval.setValuetypeString();
        in.addKeybinding(CIMFactory.keybinding("Name", keyval));
        keyval = CIMFactory.keyValue(aSoftwareElementID);
        keyval.setValuetypeString();
        in.addKeybinding(CIMFactory.keybinding("SoftwareElementID", keyval));
        keyval = CIMFactory.keyValue(new Short(aSoftwareElementState).toString());
        keyval.setValuetypeNumeric();
        in.addKeybinding(CIMFactory.keybinding("SoftwareElementState", keyval));
        keyval = CIMFactory.keyValue(new Short(aTargetOperatingSystem).toString());
        keyval.setValuetypeNumeric();
        in.addKeybinding(CIMFactory.keybinding("TargetOperatingSystem", keyval));
        keyval = CIMFactory.keyValue(aVersion);
        keyval.setValuetypeString();
        in.addKeybinding(CIMFactory.keybinding("Version", keyval));
        return this.getInstance(in);
    }

    public SAP_CIMData getInstance(CIMInstancename anInstancename) throws LcrException {
        CIMInstance cimInstance;
        try {
            cimInstance = this.client.getInstance(anInstancename, false, false, false, null);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
        return (SAP_CIMData)JavaCIMObject.fromCIMInstance(cimInstance);
    }

    public void deleteInstance(String aName, String aSoftwareElementID, short aSoftwareElementState, short aTargetOperatingSystem, String aVersion) throws LcrException {
        SAP_CIMData instance2delete = new SAP_CIMData(aName, aSoftwareElementID, aSoftwareElementState, aTargetOperatingSystem, aVersion);
        this.deleteInstance(instance2delete);
    }

    public void deleteAllInstances() throws LcrException {
        this.deleteAllInstances("SAP_CIMData");
    }

    public void deleteAllInstancesNoSubclasses() throws LcrException {
        this.deleteAllInstancesNoSubclasses("SAP_CIMData");
    }

    public void deleteClass() throws LcrException {
        this.deleteClass("SAP_CIMData");
    }

    public CIMInstancename[] enumerateInstanceNames() throws LcrException {
        return this.enumerateInstanceNames("SAP_CIMData");
    }

    public CIMInstancenameJavacimobject[] enumerateInstances() throws LcrException {
        return this.enumerateInstances(false, true, null);
    }

    public CIMInstancenameJavacimobject[] enumerateInstances(boolean localOnly, boolean deepInheritance, String[] propertyList) throws LcrException {
        return this.enumerateInstances("SAP_CIMData", localOnly, deepInheritance, propertyList);
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstances() throws LcrException {
        return this.enumerateSAP_CIMDataInstances(false, true, null);
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstances(boolean localOnly, boolean deepInheritance, String[] propertyList) throws LcrException {
        CIMInstancenameJavacimobject[] enumerateInstancesResult = this.enumerateInstances(localOnly, deepInheritance, propertyList);
        int length = enumerateInstancesResult.length;
        SAP_CIMData[] result = new SAP_CIMData[length];
        int i = 0;
        while (i < length) {
            result[i] = (SAP_CIMData)enumerateInstancesResult[i].getJavaCIMObject();
            ++i;
        }
        return result;
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstances(boolean localOnly, boolean deepInheritance, String[] propertyList, SAP_CIMDataFilter aFilter) throws LcrException {
        SAP_CIMData[] unfilteredResult = this.enumerateSAP_CIMDataInstances(localOnly, deepInheritance, propertyList);
        if (aFilter == null) {
            return unfilteredResult;
        }
        return aFilter.filter(unfilteredResult);
    }

    public CIMInstancename[] enumerateInstanceNamesNoSubclasses() throws LcrException {
        return this.enumerateInstanceNamesNoSubclasses("SAP_CIMData");
    }

    public CIMInstancenameJavacimobject[] enumerateInstancesNoSubclasses() throws LcrException {
        return this.enumerateInstancesNoSubclasses(false, null);
    }

    public CIMInstancenameJavacimobject[] enumerateInstancesNoSubclasses(boolean localOnly, String[] propertyList) throws LcrException {
        return this.enumerateInstancesNoSubclasses("SAP_CIMData", localOnly, propertyList);
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstancesNoSubclasses() throws LcrException {
        return this.enumerateSAP_CIMDataInstancesNoSubclasses(false, null);
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstancesNoSubclasses(boolean localOnly, String[] propertyList) throws LcrException {
        CIMInstancenameJavacimobject[] enumerateInstancesNoSubclassesResult = this.enumerateInstancesNoSubclasses(localOnly, propertyList);
        int length = enumerateInstancesNoSubclassesResult.length;
        SAP_CIMData[] result = new SAP_CIMData[length];
        int i = 0;
        while (i < length) {
            result[i] = (SAP_CIMData)enumerateInstancesNoSubclassesResult[i].getJavaCIMObject();
            ++i;
        }
        return result;
    }

    public SAP_CIMData[] enumerateSAP_CIMDataInstancesNoSubclasses(boolean localOnly, String[] propertyList, SAP_CIMDataFilter aFilter) throws LcrException {
        SAP_CIMData[] unfilteredResult = this.enumerateSAP_CIMDataInstancesNoSubclasses(localOnly, propertyList);
        if (aFilter == null) {
            return unfilteredResult;
        }
        return aFilter.filter(unfilteredResult);
    }

    public Date getPropertyDataEndDate(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "DataEndDate");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                Date result = SapmodelUtilities.datetimeCIMValue2Date((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyDataEndDate: 'DataEndDate' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyDataEndDate(CIMInstancename anInstancename, Date newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.Date2datetimeCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "DataEndDate", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public Date getPropertyDataStartDate(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "DataStartDate");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                Date result = SapmodelUtilities.datetimeCIMValue2Date((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyDataStartDate: 'DataStartDate' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyDataStartDate(CIMInstancename anInstancename, Date newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.Date2datetimeCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "DataStartDate", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public Date getPropertyExportDate(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "ExportDate");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                Date result = SapmodelUtilities.datetimeCIMValue2Date((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyExportDate: 'ExportDate' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyExportDate(CIMInstancename anInstancename, Date newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.Date2datetimeCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "ExportDate", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public String getPropertyExportFileName(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "ExportFileName");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                String result = SapmodelUtilities.stringCIMValue2String((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyExportFileName: 'ExportFileName' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyExportFileName(CIMInstancename anInstancename, String newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.String2stringCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "ExportFileName", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public String getPropertyExportLine(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "ExportLine");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                String result = SapmodelUtilities.stringCIMValue2String((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyExportLine: 'ExportLine' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyExportLine(CIMInstancename anInstancename, String newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.String2stringCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "ExportLine", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public String getPropertyExportType(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "ExportType");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                String result = SapmodelUtilities.stringCIMValue2String((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyExportType: 'ExportType' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyExportType(CIMInstancename anInstancename, String newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.String2stringCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "ExportType", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public String getPropertyModelVersion(CIMInstancename anInstancename) throws LcrException {
        try {
            CIMPropertyValue cimPropertyValue = this.client.getProperty(anInstancename, "ModelVersion");
            CIMItem cimItem = cimPropertyValue.getValue();
            if (cimItem == null) {
                return null;
            }
            if (cimItem instanceof CIMValue) {
                String result = SapmodelUtilities.stringCIMValue2String((CIMValue)cimItem);
                return result;
            }
            throw new LcrException(1, "getPropertyModelVersion: 'ModelVersion' is not a simple property");
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    public void setPropertyModelVersion(CIMInstancename anInstancename, String newValue) throws LcrException {
        try {
            CIMValue aCIMValue = SapmodelUtilities.String2stringCIMValue(newValue);
            CIMPropertyValue aCIMPropertyValue = CIMFactory.propertyValue(aCIMValue);
            this.client.setProperty(anInstancename, "ModelVersion", aCIMPropertyValue);
        }
        catch (CIMClientException e) {
            throw new LcrException(e);
        }
    }

    void keepImportsUsed(CIMInstance anInst, CIMObjectReference aRef, Date aDate) throws LcrException {
    }
}

