/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapaccess;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMValueObjectWithPath;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cimclient.CIMBatchClient;
import com.sap.lcr.api.cimclient.CIMBatchHandle;
import com.sap.lcr.api.cimclient.CIMBatchResult;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.sapaccess.XIReadAccess;
import com.sap.lcr.api.sapmodel.CIMInstancepathJavacimobject;
import com.sap.lcr.api.sapmodel.JavaCIMObject;
import com.sap.lcr.api.sapmodel.JavaCIMObjectAccessor;
import com.sap.lcr.api.sapmodel.SAP_BCApplicationServer;
import com.sap.lcr.api.sapmodel.SAP_BCSystem;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystem;
import com.sap.lcr.api.sapmodel.SAP_HTTPServicePort;
import com.sap.lcr.api.sapmodel.SAP_HostedXIAdapterService;
import com.sap.lcr.api.sapmodel.SAP_HostedXIRemoteAdminService;
import com.sap.lcr.api.sapmodel.SAP_XIAdapterFramework;
import com.sap.lcr.api.sapmodel.SAP_XIAdapterService;
import com.sap.lcr.api.sapmodel.SAP_XIAdapterServiceAccessByHTTP;
import com.sap.lcr.api.sapmodel.SAP_XIContainedAdapter;
import com.sap.lcr.api.sapmodel.SAP_XIContainedIntegrationDirectory;
import com.sap.lcr.api.sapmodel.SAP_XIContainedIntegrationRepository;
import com.sap.lcr.api.sapmodel.SAP_XIContainedIntegrationServer;
import com.sap.lcr.api.sapmodel.SAP_XIContainedRuntimeManagementServer;
import com.sap.lcr.api.sapmodel.SAP_XIDomain;
import com.sap.lcr.api.sapmodel.SAP_XIIntegrationDirectory;
import com.sap.lcr.api.sapmodel.SAP_XIIntegrationRepository;
import com.sap.lcr.api.sapmodel.SAP_XIIntegrationServer;
import com.sap.lcr.api.sapmodel.SAP_XIIntegrationServerLogicalIdentity;
import com.sap.lcr.api.sapmodel.SAP_XIRemoteAdminService;
import com.sap.lcr.api.sapmodel.SAP_XIRemoteAdminServiceAccessByHTTP;
import com.sap.lcr.api.sapmodel.SAP_XIRuntimeManagementServer;
import com.sap.lcr.api.sapmodel.SAP_XISubSystem;
import com.sap.lcr.api.sapmodel.SAP_XIViewedXISubSystem;

public class XIWriteAccess {
    private CIMClientHandle client = null;
    private XIReadAccess reader = null;

    public XIWriteAccess(CIMClientHandle clientHandle) {
        this.client = clientHandle;
        this.reader = new XIReadAccess(this.client);
    }

    public SAP_XIIntegrationServer createXIIntegrationServer(String ssName, String ssCaption, SAP_BusinessSystem bs) throws LcrException, CIMClientException {
        SAP_XIIntegrationServer is = new SAP_XIIntegrationServer("SAP_XIIntegrationServer", ssName);
        is.setCaption(ssCaption);
        this.add(is.toCIMInstance());
        SAP_XIIntegrationServerLogicalIdentity bs2is = new SAP_XIIntegrationServerLogicalIdentity(bs.toCIMObjectReference(), is.toCIMObjectReference());
        this.add(bs2is.toCIMInstance());
        return is;
    }

    public SAP_XIDomain addXIDomain(SAP_BusinessSystem bsWithRoleIS, SAP_BCSystem tecSys) throws LcrException, CIMClientException {
        if (bsWithRoleIS == null) {
            return null;
        }
        SAP_BCApplicationServer centralAS = (SAP_BCApplicationServer)this.reader.getAssociatedJavaCIMObject(tecSys, "SAP_BCSystemCentralApplicationServer", "SAP_BCApplicationServer");
        if (centralAS == null) {
            return null;
        }
        String hostName = centralAS.getHostName();
        String sysNo = centralAS.getNumber();
        String isName = XIReadAccess.constructISName(hostName, sysNo);
        String isCaption = "Integration Server on " + hostName;
        SAP_XIIntegrationServer is = new SAP_XIIntegrationServer("SAP_XIIntegrationServer", isName);
        is.setCaption(isCaption);
        this.add(is.toCIMInstance());
        SAP_XIIntegrationServerLogicalIdentity bs2is = new SAP_XIIntegrationServerLogicalIdentity(bsWithRoleIS.toCIMObjectReference(), is.toCIMObjectReference());
        this.add(bs2is.toCIMInstance());
        SAP_XIViewedXISubSystem tecSys2is = new SAP_XIViewedXISubSystem(is.toCIMObjectReference(), tecSys.toCIMObjectReference());
        this.add(tecSys2is.toCIMInstance());
        String domainName = XIReadAccess.constructDomainName(hostName, sysNo);
        SAP_XIDomain domain = new SAP_XIDomain("SAP_XIDomain", domainName);
        String domainCaption = "Domain " + hostName;
        domain.setCaption(domainCaption);
        this.add(domain.toCIMInstance());
        SAP_XIContainedIntegrationServer domain2is = new SAP_XIContainedIntegrationServer(domain.toCIMObjectReference(), is.toCIMObjectReference());
        this.add(domain2is.toCIMInstance());
        return domain;
    }

    public SAP_XIDomain addXIDomain(String hostName, String sysNo) throws LcrException, CIMClientException {
        if (hostName == null) {
            return null;
        }
        String isName = XIReadAccess.constructISName(hostName, sysNo);
        String isCaption = "Integration Server on " + hostName;
        SAP_XIIntegrationServer is = new SAP_XIIntegrationServer("SAP_XIIntegrationServer", isName);
        is.setCaption(isCaption);
        this.add(is.toCIMInstance());
        String domainName = XIReadAccess.constructDomainName(hostName, sysNo);
        SAP_XIDomain domain = new SAP_XIDomain("SAP_XIDomain", domainName);
        String domainCaption = "Domain " + hostName;
        domain.setCaption(domainCaption);
        this.add(domain.toCIMInstance());
        SAP_XIContainedIntegrationServer domain2is = new SAP_XIContainedIntegrationServer(domain.toCIMObjectReference(), is.toCIMObjectReference());
        this.add(domain2is.toCIMInstance());
        return domain;
    }

    public SAP_XIRemoteAdminService addXIRemoteAdminService(SAP_XISubSystem subSystem, String purpose, String url, String protocol) throws LcrException, CIMClientException {
        String nameOfOwner = subSystem.getName();
        String classOfOwner = subSystem.getCreationClassName();
        String adminName = XIReadAccess.constructServiceName(purpose, nameOfOwner);
        SAP_XIRemoteAdminService as = new SAP_XIRemoteAdminService("SAP_XIRemoteAdminService", adminName, classOfOwner, nameOfOwner);
        as.setpurpose(purpose);
        String caption = purpose + " of " + nameOfOwner;
        as.setCaption(caption);
        this.add(as.toCIMInstance());
        String portName = XIReadAccess.constructHTTPServicePortName(adminName);
        SAP_HTTPServicePort port = new SAP_HTTPServicePort("SAP_HTTPServicePort", portName, "SAP_XIRemoteAdminService", adminName);
        port.setURL(url);
        port.setProtocol(protocol);
        caption = "Port for " + caption;
        port.setCaption(caption);
        this.add(port.toCIMInstance());
        SAP_XIRemoteAdminServiceAccessByHTTP service2port = new SAP_XIRemoteAdminServiceAccessByHTTP(as.toCIMObjectReference(), port.toCIMObjectReference());
        this.add(service2port.toCIMInstance());
        SAP_HostedXIRemoteAdminService service2subSys = new SAP_HostedXIRemoteAdminService(subSystem.toCIMObjectReference(), as.toCIMObjectReference());
        this.add(service2subSys.toCIMInstance());
        return as;
    }

    public SAP_XIAdapterService addXIAdapterService(SAP_XISubSystem subSystem, String adapterType, String url, String protocol) throws LcrException, CIMClientException {
        String nameOfOwner = subSystem.getName();
        String classOfOwner = subSystem.getCreationClassName();
        String adminName = XIReadAccess.constructAdapterServiceName(adapterType, nameOfOwner);
        SAP_XIAdapterService as = new SAP_XIAdapterService("SAP_XIAdapterService", adminName, classOfOwner, nameOfOwner);
        as.setadapterType(adapterType);
        String caption = adapterType + " of " + nameOfOwner;
        as.setCaption(caption);
        this.add(as.toCIMInstance());
        String portName = XIReadAccess.constructHTTPServicePortName(adminName);
        SAP_HTTPServicePort port = new SAP_HTTPServicePort("SAP_HTTPServicePort", portName, "SAP_XIAdapterService", adminName);
        port.setURL(url);
        port.setProtocol(protocol);
        caption = "Port for " + caption;
        port.setCaption(caption);
        this.add(port.toCIMInstance());
        SAP_XIAdapterServiceAccessByHTTP service2port = new SAP_XIAdapterServiceAccessByHTTP(as.toCIMObjectReference(), port.toCIMObjectReference());
        this.add(service2port.toCIMInstance());
        SAP_HostedXIAdapterService service2subSys = new SAP_HostedXIAdapterService(subSystem.toCIMObjectReference(), as.toCIMObjectReference());
        this.add(service2subSys.toCIMInstance());
        return as;
    }

    public SAP_XISubSystem addXISubSystem(SAP_XIDomain domain, String className) throws LcrException, CIMClientException {
        return null;
    }

    public SAP_XIRuntimeManagementServer addXIRuntimeManagementServer(String hostName, SAP_XIDomain domain) throws LcrException, CIMClientException {
        if (domain == null) {
            return null;
        }
        SAP_XIRuntimeManagementServer inst = null;
        String name = null;
        Object caption = null;
        String domainName = domain.getName();
        String subSysId = "rwb";
        name = XIReadAccess.constructSubSystemName(subSysId, hostName);
        inst = new SAP_XIRuntimeManagementServer("SAP_XIRuntimeManagementServer", name);
        inst.setCaption("RWB on " + hostName);
        this.add(inst.toCIMInstance());
        SAP_XIContainedRuntimeManagementServer domain2inst = new SAP_XIContainedRuntimeManagementServer(domain.toCIMObjectReference(), inst.toCIMObjectReference());
        this.add(domain2inst.toCIMInstance());
        return inst;
    }

    public SAP_XIAdapterFramework addXIAdapterFramework(String hostName, SAP_XIDomain domain) throws LcrException, CIMClientException {
        if (domain == null) {
            return null;
        }
        SAP_XIAdapterFramework inst = null;
        String name = null;
        Object caption = null;
        String domainName = domain.getName();
        String subSysId = "af";
        name = XIReadAccess.constructSubSystemName(subSysId, hostName);
        inst = new SAP_XIAdapterFramework("SAP_XIAdapterFramework", name);
        inst.setCaption("Adapter Engine on " + hostName);
        this.add(inst.toCIMInstance());
        SAP_XIContainedAdapter domain2inst = new SAP_XIContainedAdapter(domain.toCIMObjectReference(), inst.toCIMObjectReference());
        this.add(domain2inst.toCIMInstance());
        return inst;
    }

    public SAP_XIIntegrationDirectory addXIIntegrationDirectory(String hostName, SAP_XIDomain domain) throws LcrException, CIMClientException {
        if (domain == null) {
            return null;
        }
        SAP_XIIntegrationDirectory inst = null;
        String name = null;
        Object caption = null;
        String domainName = domain.getName();
        String subSysId = "directory";
        name = XIReadAccess.constructSubSystemName(subSysId, hostName);
        inst = new SAP_XIIntegrationDirectory("SAP_XIIntegrationDirectory", name);
        inst.setCaption("Integration Directory on " + hostName);
        this.add(inst.toCIMInstance());
        SAP_XIContainedIntegrationDirectory domain2inst = new SAP_XIContainedIntegrationDirectory(domain.toCIMObjectReference(), inst.toCIMObjectReference());
        this.add(domain2inst.toCIMInstance());
        return inst;
    }

    public SAP_XIIntegrationRepository addXIIntegrationRepository(String hostName, SAP_XIDomain domain) throws LcrException, CIMClientException {
        if (domain == null) {
            return null;
        }
        SAP_XIIntegrationRepository inst = null;
        String name = null;
        Object caption = null;
        String domainName = domain.getName();
        String subSysId = "repository";
        name = XIReadAccess.constructSubSystemName(subSysId, hostName);
        inst = new SAP_XIIntegrationRepository("SAP_XIIntegrationRepository", name);
        inst.setCaption("Integration Repository on " + hostName);
        this.add(inst.toCIMInstance());
        SAP_XIContainedIntegrationRepository domain2inst = new SAP_XIContainedIntegrationRepository(domain.toCIMObjectReference(), inst.toCIMObjectReference());
        this.add(domain2inst.toCIMInstance());
        return inst;
    }

    public void removeDomain(SAP_XIDomain domain) throws LcrException, CIMClientException {
        if (domain == null) {
            return;
        }
        SAP_XISubSystem[] subSysArray = this.reader.getXISubSystemList(domain);
        if (subSysArray == null) {
            return;
        }
        int i = 0;
        while (i < subSysArray.length) {
            this.removeSubSystem(subSysArray[i]);
            ++i;
        }
        this.remove(domain.toCIMInstancename());
    }

    public void removeDomain(String isHostName, String isSysNo) throws LcrException, CIMClientException {
        SAP_XIDomain domain = this.reader.getXIDomain(isHostName, isSysNo);
        this.removeDomain(domain);
    }

    public void removeSubSystem(SAP_XISubSystem subSys) throws LcrException, CIMClientException {
        CIMInstancepathJavacimobject[] instPathArray = null;
        JavaCIMObjectAccessor javaCIMObjectAcc = new JavaCIMObjectAccessor(this.client);
        instPathArray = javaCIMObjectAcc.associators(subSys, "CIM_HostedService", "SAP_XIService", null, null, null);
        if (instPathArray == null) {
            return;
        }
        CIMBatchClient bh = new CIMBatchClient();
        CIMBatchClient bhRemove = new CIMBatchClient();
        int i = 0;
        while (i < instPathArray.length) {
            ((CIMBatchHandle)bh).associators(instPathArray[i].getCIMInstancepath().getInstancename(), CIMNames.C_CIM_ServiceAccessBySAP, CIMNames.C_SAP_HTTPServicePort, null, null, false, false, null);
            ((CIMBatchHandle)bhRemove).deleteInstance(instPathArray[i].getCIMInstancepath().getInstancename(), true);
            ++i;
        }
        if (instPathArray.length > 0) {
            CIMBatchResult br = this.client.performBatchOperation(bh);
            int i2 = 0;
            while (i2 < br.size()) {
                CIMValueObjectWithPathList assocs = (CIMValueObjectWithPathList)br.getResult(i2);
                CIMValueObjectWithPath obj = assocs.get(0);
                CIMInstancename inst = obj.getInstancename();
                ((CIMBatchHandle)bhRemove).deleteInstance(inst, true);
                ++i2;
            }
        }
        ((CIMBatchHandle)bhRemove).deleteInstance(subSys.toCIMInstancename(), true);
        this.client.performBatchOperation(bhRemove);
    }

    public void removeSubSystem(String className, String instanceName) throws LcrException, CIMClientException {
        SAP_XISubSystem subSys = this.reader.getXISubSystem(className, instanceName);
        if (subSys == null) {
            return;
        }
        this.removeSubSystem(subSys);
    }

    public void remove(String className, String instanceName) throws LcrException, CIMClientException {
        String[] keys = new String[]{"Name", "CreationClassName"};
        String[] values = new String[]{instanceName, className};
        CIMInstancename ci = CIMFactory.instancename(className, keys, values);
        this.remove(ci);
    }

    public void removeXIRemoteAdminService(String instanceName, String ownerClassName, String ownerName) throws LcrException, CIMClientException {
        String className = "SAP_XIRemoteAdminService";
        String[] keys = new String[]{"Name", "CreationClassName", "SystemName", "SystemCreationClassName"};
        String[] values = new String[]{instanceName, className, ownerName, ownerClassName};
        CIMInstancename ci = CIMFactory.instancename(className, keys, values);
        String portName = XIReadAccess.constructHTTPServicePortName(instanceName);
        SAP_HTTPServicePort port = new SAP_HTTPServicePort("SAP_HTTPServicePort", portName, "SAP_XIRemoteAdminService", instanceName);
        this.remove(port.toCIMInstancename());
        this.remove(ci);
    }

    public void remove(CIMInstancename ci) throws LcrException, CIMClientException {
        block2: {
            try {
                this.client.deleteInstance(ci, true);
            }
            catch (LcrException e) {
                if (e.getStatusCode() == 6) break block2;
                throw e;
            }
        }
    }

    public void remove(JavaCIMObject[] coArray) throws LcrException, CIMClientException {
        block3: {
            try {
                int i = 0;
                while (i < coArray.length) {
                    this.client.deleteInstance(coArray[i].toCIMInstancename(), true);
                    ++i;
                }
            }
            catch (LcrException e) {
                if (e.getStatusCode() == 6) break block3;
                throw e;
            }
        }
    }

    public void add(CIMInstance ci) throws LcrException, CIMClientException {
        block2: {
            try {
                this.client.createInstance(ci);
            }
            catch (LcrException e) {
                if (e.getStatusCode() == 11) break block2;
                throw e;
            }
        }
    }
}

