/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.sapaccess;

import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.sapaccess.SDAccess;
import com.sap.lcr.api.sapmodel.SAP_BCApplicationServer;
import com.sap.lcr.api.sapmodel.SAP_BCClient;
import com.sap.lcr.api.sapmodel.SAP_BCMessageServer;
import com.sap.lcr.api.sapmodel.SAP_BCSystem;
import com.sap.lcr.api.sapmodel.SAP_BusinessSystem;
import com.sap.lcr.api.sapmodel.SAP_ComputerSystem;

public class CacheAccess {
    private CIMClientHandle client = null;
    private SDAccess access = null;

    public CacheAccess(CIMClientHandle clientHandle) {
        this.client = clientHandle;
        this.access = new SDAccess(this.client);
    }

    public SAP_BusinessSystem[] getSAPBusinessSystemList() throws LcrException {
        return this.access.getSAPBusinessSystemList();
    }

    public SAP_BusinessSystem[] getSAPIntegrationServerList() throws LcrException {
        return this.access.getSAPIntegrationServerList();
    }

    public SAP_BCMessageServer getMessageServer(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BCMessageServer[] messageServerArray;
        SAP_BCSystem BCSystem = this.access.getBCSystem(businessSystem);
        if (BCSystem != null && (messageServerArray = this.access.getBCMessageServerList(BCSystem)).length != 0) {
            return messageServerArray[0];
        }
        return null;
    }

    public SAP_BCApplicationServer[] getApplicationServerList(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BCSystem BCSystem = this.access.getBCSystem(businessSystem);
        SAP_BCApplicationServer[] applicationServerArray = null;
        applicationServerArray = BCSystem != null ? this.access.getBCApplicationServerList(BCSystem) : new SAP_BCApplicationServer[]{};
        return applicationServerArray;
    }

    public SAP_BCApplicationServer getSystemApplicationServer(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BCApplicationServer[] applicationServerArray;
        SAP_BCSystem BCSystem = this.access.getBCSystem(businessSystem);
        if (BCSystem != null && (applicationServerArray = this.access.getBCApplicationServerList(BCSystem)).length != 0) {
            return applicationServerArray[0];
        }
        return null;
    }

    public String getIPAddress(SAP_BCApplicationServer applicationServer) throws LcrException {
        SAP_ComputerSystem computerSystem = this.access.getComputerSystem(applicationServer);
        if (computerSystem != null) {
            return computerSystem.getIPAddress_WT();
        }
        return new String();
    }

    public String getHostName(SAP_BCApplicationServer applicationServer) throws LcrException {
        return applicationServer.getHostName_WT();
    }

    public String getIPAddress(SAP_BCMessageServer messageServer) throws LcrException {
        SAP_ComputerSystem computerSystem = this.access.getComputerSystem(messageServer);
        if (computerSystem != null) {
            return computerSystem.getIPAddress_WT();
        }
        return new String();
    }

    public String getSystemNumber(SAP_BCApplicationServer applicationServer) throws LcrException {
        return applicationServer.getNumber_WT();
    }

    public String getClientNumber(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BCClient BCClient = this.access.getBCClient(businessSystem);
        if (BCClient != null) {
            return BCClient.getClientNumber();
        }
        return new String();
    }

    public String getSystemName(SAP_BusinessSystem businessSystem) throws LcrException {
        SAP_BCSystem BCSystem = this.access.getBCSystem(businessSystem);
        if (BCSystem != null) {
            return BCSystem.getSAPSystemName_WT();
        }
        return new String();
    }
}

