/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Filter;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.Logger;

public class SimpleFilter
implements Filter {
    private Logger logger;
    private Level level;
    private String thread;

    public SimpleFilter(Logger logger, Level level, String threadName) {
        this.logger = logger;
        this.level = level;
        this.thread = threadName;
    }

    public boolean isLoggable(LogRecord rec) {
        return !(this.level != null && rec.getLevel().getPriority() < this.level.getPriority() || this.logger != null && !this.logger.contains(rec.getLogger()) || this.thread != null && !rec.getThreadName().equals(this.thread));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.logger != null) {
            sb.append("\"").append(this.logger.getName()).append("\"");
        }
        if (this.level != null) {
            sb.append(" [").append(this.level.getName()).append("]");
        }
        if (this.thread != null) {
            sb.append(", ").append(this.thread);
        }
        return sb.toString();
    }
}

