/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.Filter;
import com.sap.lcr.api.log.Handler;
import com.sap.lcr.api.log.Level;
import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.log.SimpleFilter;
import java.util.Enumeration;

public class MemLogHandler
extends Handler {
    private LogRecord[] buffer;
    private int count;
    private int size;
    private int start;

    public MemLogHandler(String name, int size) {
        super(name);
        this.buffer = new LogRecord[size];
        this.count = -1;
        this.size = size;
        this.start = 0;
        Handler currHandler = Handler.getHandler(name);
        if (currHandler instanceof MemLogHandler && currHandler != this) {
            MemLogHandler currMemLogHandler = (MemLogHandler)currHandler;
            int i = currMemLogHandler.start;
            while (i <= currMemLogHandler.count) {
                LogRecord nextOldRec = currMemLogHandler.buffer[i % currMemLogHandler.size];
                this.publish(nextOldRec);
                ++i;
            }
            Handler.setHandler(name, this);
        }
    }

    public MemLogHandler(int size) {
        this(null, size);
    }

    public synchronized void publish(LogRecord rec) {
        if (this.getLevel() == null || rec.getLevel().getPriority() >= this.getLevel().getPriority()) {
            ++this.count;
            this.buffer[this.count % this.size] = rec;
        }
    }

    public void publish(String message) {
    }

    public void close() {
    }

    void flush() {
    }

    public synchronized void setSize(int size) {
        if (size != this.size) {
            this.buffer = new LogRecord[size];
            this.count = -1;
            this.size = size;
            this.start = 0;
        }
    }

    public synchronized int getSize() {
        return this.size;
    }

    public void clear() {
        this.count = -1;
    }

    public Enumeration getLogMessages(Logger logger, Level level, String thread) {
        return new MHEnum(this, new SimpleFilter(logger, level, thread), true);
    }

    public Enumeration getLogMessages(Filter filter) {
        return new MHEnum(this, filter, true);
    }

    public Enumeration getLogRecords() {
        return new MHEnum(this, null, false);
    }

    class MHEnum
    implements Enumeration {
        private int n;
        private Object nextOutput;
        private Filter filter;
        private boolean formatIt;
        private final Object lock;

        public MHEnum(Object lock, Filter filter, boolean formatIt) {
            this.lock = lock;
            this.filter = filter;
            this.formatIt = formatIt;
            this.n = MemLogHandler.this.count + 1;
            this.nextOutput = this.getNext();
        }

        private Object getNext() {
            LogRecord rec;
            do {
                Object object = this.lock;
                synchronized (object) {
                    if (this.n <= MemLogHandler.this.start || this.n <= MemLogHandler.this.count - MemLogHandler.this.size + 1) {
                        Object var3_3 = null;
                        return var3_3;
                    }
                    --this.n;
                    rec = MemLogHandler.this.buffer[this.n % MemLogHandler.this.size];
                }
            } while (this.filter != null && !this.filter.isLoggable(rec));
            if (this.formatIt) {
                return MemLogHandler.this.formatter.format(rec);
            }
            return rec;
        }

        public boolean hasMoreElements() {
            return this.nextOutput != null;
        }

        public Object nextElement() {
            Object output = this.nextOutput;
            this.nextOutput = this.getNext();
            return output;
        }
    }
}

