/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.NameMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;

public class Level
implements Serializable,
Comparable {
    static final long serialVersionUID = -8597698560773402178L;
    private static NameMap levels = new NameMap();
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level FATAL = new Level("FATAL", 8000);
    public static final Level SEVERE = new Level("SEVERE", 8000);
    public static final Level ERROR = new Level("ERROR", 7000);
    public static final Level WARNING = new Level("WARNING", 6000);
    public static final Level INFO = new Level("INFO", 5000);
    public static final Level DEBUG = new Level("DEBUG", 4000);
    public static final Level FINE = new Level("FINE", 3000);
    public static final Level FINER = new Level("FINER", 2000);
    public static final Level FINEST = new Level("FINEST", 1000);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    public static final Level DEFAULT = INFO;
    private String name;
    private int priority;

    public Level(String name, int priority) {
        this.name = name;
        this.priority = priority;
        levels.put(name, this);
    }

    public static Level getLevel(int priority) {
        String name = Integer.toString(priority);
        Level level = Level.getLevel(name);
        if (level != null) {
            return level;
        }
        return new Level(name, priority);
    }

    public static Level getLevel(String name) {
        return (Level)levels.get(name);
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public int intValue() {
        return this.priority;
    }

    public String toString() {
        return this.name;
    }

    public static Enumeration listLevels() {
        return Collections.enumeration(levels.keySet());
    }

    public int compareTo(Object o) throws ClassCastException {
        return ((Level)o).getPriority() - this.getPriority();
    }

    public int hashCode() {
        return this.intValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Level)) {
            return false;
        }
        return this.intValue() == ((Level)obj).intValue();
    }
}

