/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.log;

import com.sap.lcr.api.log.LogRecord;
import com.sap.lcr.api.log.PipedHandler;
import com.sap.lcr.api.log.SimpleLog;
import java.util.Vector;

public final class AsyncHandler
extends PipedHandler {
    private Vector queue = new Vector();
    private AsyncHandlerThread outputThread = new AsyncHandlerThread();
    private boolean closed = false;

    public AsyncHandler(String name) {
        super(name);
        this.outputThread.start();
    }

    public AsyncHandler() {
        this(null);
    }

    public void publish(LogRecord rec) {
        if (this.isLoggable(rec)) {
            this.push(rec);
        }
    }

    public void publish(String message) {
        this.push(message);
    }

    public void close() {
        this.closed = true;
        this.stopAsyncThread();
        try {
            SimpleLog.debug("waiting for async output thread...");
            this.outputThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SimpleLog.debug("writing remaining messages");
        Vector vector = this.queue;
        synchronized (vector) {
            int i = 0;
            while (i < this.queue.size()) {
                Object obj = this.queue.get(i);
                if (obj instanceof LogRecord) {
                    this.publishToAllHandlers((LogRecord)obj);
                } else if (obj instanceof String) {
                    this.publishToAllHandlers((String)obj);
                }
                ++i;
            }
        }
    }

    synchronized void stopAsyncThread() {
        this.outputThread.stopIt();
        this.notifyAll();
    }

    private synchronized void push(Object rec) {
        if (this.closed) {
            return;
        }
        this.queue.add(rec);
        this.notifyAll();
    }

    private synchronized Object pop() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
                if (!this.closed) continue;
                return null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (LogRecord)this.queue.remove(0);
    }

    class AsyncHandlerThread
    extends Thread {
        private boolean running = true;

        AsyncHandlerThread() {
        }

        public void run() {
            SimpleLog.debug("started thread " + this.getName());
            while (this.running) {
                Object obj = AsyncHandler.this.pop();
                if (obj instanceof LogRecord) {
                    AsyncHandler.this.publishToAllHandlers((LogRecord)obj);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                AsyncHandler.this.publishToAllHandlers((String)obj);
            }
            SimpleLog.debug("stopped thread " + this.getName());
        }

        public void stopIt() {
            this.running = false;
        }
    }
}

