/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import java.io.PrintStream;
import java.io.PrintWriter;

public class WrapperException
extends Exception {
    private static final String CAUSED_BY = "caused by:";
    private final Exception wrapped;
    private Throwable cause;

    private WrapperException(String msg, Exception wrapped, Throwable cause) {
        super(msg);
        this.wrapped = wrapped;
        this.cause = cause;
    }

    public WrapperException() {
        this(null, null, null);
    }

    public WrapperException(String msg) {
        this(msg, null, null);
    }

    public WrapperException(Exception e) {
        this(null, e, null);
    }

    public WrapperException(String msg, Exception cause) {
        this(msg, null, cause);
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Exception getWrappedException() {
        return this.wrapped;
    }

    public Exception getEmbeddedExcp() {
        if (this.wrapped != null) {
            return this.wrapped;
        }
        if (this.cause instanceof Exception) {
            return (Exception)this.cause;
        }
        return null;
    }

    public String toString() {
        if (this.wrapped != null) {
            return this.getClass().getName() + ": " + this.wrapped.toString();
        }
        return super.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        if (this.wrapped == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.getClass().getName());
            s.print(": ");
            this.wrapped.printStackTrace(s);
        }
        if (this.cause != null) {
            s.println(CAUSED_BY);
            this.cause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.wrapped == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.getClass().getName());
            s.print(": ");
            this.wrapped.printStackTrace(s);
        }
        if (this.cause != null) {
            s.println(CAUSED_BY);
            this.cause.printStackTrace(s);
        }
    }

    public String getMessage() {
        if (this.wrapped == null) {
            return super.getMessage();
        }
        String msg = this.wrapped.getMessage();
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        return this.wrapped.toString();
    }

    public String getLocalizedMessage() {
        if (this.wrapped == null) {
            return super.getLocalizedMessage();
        }
        String msg = this.wrapped.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        return this.wrapped.toString();
    }
}

