/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMError;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMIMethodResponse;
import com.sap.lcr.api.cim.CIMIReturnValue;
import com.sap.lcr.api.cim.CIMInstancenameList;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMMethodResponse;
import com.sap.lcr.api.cim.CIMObjectpathList;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMSimpleRsp;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueList;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.CIMXmlAppender;
import com.sap.lcr.api.cim.ICIMReadOnly;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.util.Util;

final class SimpleResponseAnalyser {
    private static final CIMClassList EMPTYLIST_RO_CLASS = (CIMClassList)CIMFactory.classList(0).makeReadOnly();
    private static final CIMClassnameList EMPTYLIST_RO_CLASSNAME = (CIMClassnameList)CIMFactory.classnameList(0).makeReadOnly();
    private static final CIMInstancenameList EMPTYLIST_RO_INSTANCENAME = (CIMInstancenameList)CIMFactory.instancenameList(0).makeReadOnly();
    private static final CIMObjectpathList EMPTYLIST_RO_OBJECTPATH = (CIMObjectpathList)CIMFactory.objectpathList(0).makeReadOnly();
    private static final CIMQualifierDeclarationList EMPTYLIST_RO_QUALIFIERDECLARATION = (CIMQualifierDeclarationList)CIMFactory.qualifierDeclarationList(0).makeReadOnly();
    private static final CIMValueNamedInstanceList EMPTYLIST_RO_VALUENAMEDINSTANCE = (CIMValueNamedInstanceList)CIMFactory.valueNamedInstanceList(0).makeReadOnly();
    private static final CIMValueObjectWithPathList EMPTYLIST_RO_VALUEOBJECTSWITHPATH = (CIMValueObjectWithPathList)CIMFactory.valueObjectWithPathList(0).makeReadOnly();

    private SimpleResponseAnalyser() {
    }

    static Object getIResult(CIMSimpleRsp simpleRsp, boolean returnWritable) throws CIMClientException, LcrException {
        Object iResult;
        SimpleResponseAnalyser.raiseExceptionOnError(simpleRsp);
        CIMIMethodResponse iMethodResponse = simpleRsp.getIMethodResponse();
        if (iMethodResponse == null) {
            throw new CIMClientException("Corrupt intrinsic method response received");
        }
        String methodName = iMethodResponse.getName();
        CIMIReturnValue iReturnValue = iMethodResponse.getIReturnValue();
        Object object = iResult = iReturnValue == null ? null : iReturnValue.getContainedValue();
        if (iResult == null) {
            iResult = SimpleResponseAnalyser.getEmptyIntrinsicResult(methodName);
        }
        if (iResult == null) {
            return null;
        }
        if ((iResult = SimpleResponseAnalyser.unwrapIntrinsicResult(methodName, iResult)) instanceof ICIMReadOnly) {
            ICIMReadOnly ro = (ICIMReadOnly)iResult;
            return returnWritable ? ro.getWritable() : ro.makeReadOnly();
        }
        return iResult;
    }

    private static void raiseExceptionOnError(CIMSimpleRsp simpleRsp) throws LcrException, CIMClientException {
        CIMError error = null;
        CIMIMethodResponse iMethodResponse = simpleRsp.getIMethodResponse();
        if (iMethodResponse != null) {
            error = iMethodResponse.getError();
        } else {
            CIMMethodResponse methodResponse = simpleRsp.getMethodResponse();
            if (methodResponse != null) {
                error = methodResponse.getError();
            } else {
                throw new CIMClientException("Invalid SIMPLERSP");
            }
        }
        if (error != null) {
            int errorCode = error.getErrorCode();
            String description = error.getDescription();
            String errorName = LcrException.mapStatusName(errorCode);
            if (description == null) {
                description = "";
            } else if (description.startsWith(errorName)) {
                int start = errorName.length();
                if (description.charAt(start) == ':') {
                    ++start;
                }
                description = description.substring(start).trim();
            }
            throw new LcrException(errorCode, description);
        }
    }

    private static CIMXmlAppender getEmptyIntrinsicResult(String methodName) {
        if (methodName.equals("AssociatorNames") || methodName.equals("ReferenceNames") || methodName.equals("SAPExt_DeleteInstanceWithReferences") || methodName.equals("SAPExt_RenameInstance") || methodName.equals("SAPExt_CopyInstance")) {
            return EMPTYLIST_RO_OBJECTPATH;
        }
        if (methodName.equals("Associators") || methodName.equals("References") || methodName.equals("ExecQuery")) {
            return EMPTYLIST_RO_VALUEOBJECTSWITHPATH;
        }
        if (methodName.equals("EnumerateInstances") || methodName.equals("SAPExt_EnumerateInstancesNoSubclasses")) {
            return EMPTYLIST_RO_VALUENAMEDINSTANCE;
        }
        if (methodName.equals("EnumerateInstanceNames") || methodName.equals("SAPExt_EnumerateInstanceNamesNoSubclasses")) {
            return EMPTYLIST_RO_INSTANCENAME;
        }
        if (methodName.equals("EnumerateClasses")) {
            return EMPTYLIST_RO_CLASS;
        }
        if (methodName.equals("EnumerateClassNames")) {
            return EMPTYLIST_RO_CLASSNAME;
        }
        if (methodName.equals("EnumerateQualifiers")) {
            return EMPTYLIST_RO_QUALIFIERDECLARATION;
        }
        return null;
    }

    private static Object unwrapIntrinsicResult(String methodName, Object wrappedResult) throws CIMClientException {
        boolean typeOK = true;
        if (methodName.equals("GetInstance") || methodName.equals("GetClass") || methodName.equals("CreateInstance") || methodName.equals("CreateClass") || methodName.equals("GetQualifier")) {
            typeOK = wrappedResult instanceof CIMItemList;
            if (typeOK) {
                CIMItemList items = (CIMItemList)wrappedResult;
                if (items.size() != 1) {
                    throw new CIMClientException("Bad server response: 1 element expected but " + items.size() + " received");
                }
                return items.getItem(0);
            }
        } else if (methodName.equals("GetProperty")) {
            if (wrappedResult instanceof CIMValueList) {
                CIMValueList valueList = (CIMValueList)wrappedResult;
                if (valueList.size() != 1) {
                    throw new CIMClientException("Bad server response: 1 value expected but " + valueList.size() + " received");
                }
                return CIMFactory.propertyValue(valueList.get(0));
            }
            if (wrappedResult instanceof CIMValueArray) {
                CIMValueArray valueArray = (CIMValueArray)wrappedResult;
                return CIMFactory.propertyValue(valueArray);
            }
            if (wrappedResult instanceof CIMValueReference) {
                CIMValueReference valueReference = (CIMValueReference)wrappedResult;
                return CIMFactory.propertyValue(valueReference);
            }
            typeOK = false;
        } else if (methodName.equals("SAPExt_GetInstanceCount") || methodName.equals("SAPExt_ReferenceCount")) {
            typeOK = wrappedResult instanceof CIMValueList;
            if (typeOK) {
                try {
                    CIMValueList valueList = (CIMValueList)wrappedResult;
                    if (valueList.size() != 1) {
                        throw new CIMClientException("IRETURNVALUE must contain exactly one VALUE");
                    }
                    return new Integer(valueList.get(0).getStringvalue());
                }
                catch (NumberFormatException ex) {
                    throw new CIMClientException("VALUE is not a valid integer");
                }
            }
        } else if (methodName.equals("SAPExt_GetObjectServer") && (typeOK = wrappedResult instanceof CIMValueList)) {
            CIMValueList valueList = (CIMValueList)wrappedResult;
            if (valueList.size() != 1) {
                throw new CIMClientException("IRETURNVALUE must contain exactly one VALUE");
            }
            return valueList.get(0).getStringvalue();
        }
        if (!typeOK) {
            throw new CIMClientException("Illegal return type: " + Util.getClassName(wrappedResult));
        }
        return wrappedResult;
    }
}

