/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMIMethodCall;
import com.sap.lcr.api.cim.CIMIParamValueList;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMPropertyValue;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMSimpleReq;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cimclient.LcrException;
import java.util.Date;

final class SimpleRequestAssembler {
    private static final CIMLocalnamespacepath DEFAULT_LNSP;
    private CIMLocalnamespacepath localnamespacepath = DEFAULT_LNSP;

    SimpleRequestAssembler() {
    }

    void setLocalnamespacepath(CIMLocalnamespacepath localnamespacepath) {
        this.localnamespacepath = localnamespacepath == null ? DEFAULT_LNSP : localnamespacepath;
    }

    CIMLocalnamespacepath getLocalNamespacePath() {
        return this.localnamespacepath;
    }

    private CIMSimpleReq buildSimpleReqIMethodCall(String aMethodCallName, CIMIParamValueList anIPVList) {
        this.localnamespacepath = this.localnamespacepath.toWritable();
        CIMIMethodCall iMethodCall = CIMFactory.iMethodCall(aMethodCallName, this.localnamespacepath, anIPVList);
        return CIMFactory.simpleReq(iMethodCall);
    }

    CIMSimpleReq getCIMClass(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        anIPVList.addReadOnly(CIMFactory.iParamValue("LocalOnly", localOnly));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        if (propertyList != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyList", propertyList));
        }
        return this.buildSimpleReqIMethodCall("GetClass", anIPVList);
    }

    CIMSimpleReq getInstance(CIMInstancename instanceName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instanceName));
        anIPVList.addReadOnly(CIMFactory.iParamValue("LocalOnly", localOnly));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        if (propertyList != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyList", propertyList));
        }
        return this.buildSimpleReqIMethodCall("GetInstance", anIPVList);
    }

    CIMSimpleReq deleteClass(CIMClassname className) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        return this.buildSimpleReqIMethodCall("DeleteClass", anIPVList);
    }

    CIMSimpleReq deleteInstance(CIMInstancename instanceName, boolean withReferences) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instanceName));
        String method = withReferences ? "SAPExt_DeleteInstanceWithReferences" : "DeleteInstance";
        return this.buildSimpleReqIMethodCall(method, anIPVList);
    }

    CIMSimpleReq createClass(CIMClass newClass) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("NewClass", newClass));
        return this.buildSimpleReqIMethodCall("CreateClass", anIPVList);
    }

    CIMSimpleReq createInstance(CIMInstance newInstance) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("NewInstance", newInstance));
        return this.buildSimpleReqIMethodCall("CreateInstance", anIPVList);
    }

    CIMSimpleReq modifyClass(CIMClass modifiedClass) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ModifiedClass", modifiedClass));
        return this.buildSimpleReqIMethodCall("ModifyClass", anIPVList);
    }

    CIMSimpleReq modifyMergeInstance(CIMValueNamedInstance modifiedInstance, boolean merge) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ModifiedInstance", modifiedInstance));
        String method = merge ? "SAPExt_MergeInstance" : "ModifyInstance";
        return this.buildSimpleReqIMethodCall(method, anIPVList);
    }

    CIMSimpleReq enumerateClasses(CIMClassname className, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (className != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        }
        anIPVList.addReadOnly(CIMFactory.iParamValue("DeepInheritance", deepInheritance));
        anIPVList.addReadOnly(CIMFactory.iParamValue("LocalOnly", localOnly));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        return this.buildSimpleReqIMethodCall("EnumerateClasses", anIPVList);
    }

    CIMSimpleReq enumerateClassNames(CIMClassname className, boolean deepInheritance) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (className != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        }
        anIPVList.addReadOnly(CIMFactory.iParamValue("DeepInheritance", deepInheritance));
        return this.buildSimpleReqIMethodCall("EnumerateClassNames", anIPVList);
    }

    CIMSimpleReq enumerateInstances(boolean subclasses, CIMClassname className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        anIPVList.addReadOnly(CIMFactory.iParamValue("LocalOnly", localOnly));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        if (subclasses) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("DeepInheritance", deepInheritance));
        }
        if (propertyList != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyList", propertyList));
        }
        String method = subclasses ? "EnumerateInstances" : "SAPExt_EnumerateInstancesNoSubclasses";
        return this.buildSimpleReqIMethodCall(method, anIPVList);
    }

    CIMSimpleReq enumerateInstanceNames(boolean subclasses, CIMClassname className) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        String method = subclasses ? "EnumerateInstanceNames" : "SAPExt_EnumerateInstanceNamesNoSubclasses";
        return this.buildSimpleReqIMethodCall(method, anIPVList);
    }

    CIMSimpleReq associators(CIMClassname className, CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (instanceName != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", instanceName));
        } else {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", className));
        }
        if (assocClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("AssocClass", assocClass));
        }
        if (resultClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultClass", resultClass));
        }
        if (role != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("Role", role));
        }
        if (resultRole != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultRole", resultRole));
        }
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        if (propertyList != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyList", propertyList));
        }
        return this.buildSimpleReqIMethodCall("Associators", anIPVList);
    }

    CIMSimpleReq associatorNames(CIMClassname className, CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (className != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", className));
        } else {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", instanceName));
        }
        if (assocClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("AssocClass", assocClass));
        }
        if (resultClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultClass", resultClass));
        }
        if (role != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("Role", role));
        }
        if (resultRole != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultRole", resultRole));
        }
        return this.buildSimpleReqIMethodCall("AssociatorNames", anIPVList);
    }

    CIMSimpleReq references(CIMClassname className, CIMInstancename instanceName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (className != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", className));
        } else {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", instanceName));
        }
        if (resultClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultClass", resultClass));
        }
        if (role != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("Role", role));
        }
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeQualifiers", includeQualifiers));
        anIPVList.addReadOnly(CIMFactory.iParamValue("IncludeClassOrigin", includeClassOrigin));
        if (propertyList != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyList", propertyList));
        }
        return this.buildSimpleReqIMethodCall("References", anIPVList);
    }

    CIMSimpleReq referenceNames(CIMClassname className, CIMInstancename instanceName, CIMClassname resultClass, String role) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        if (className != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", className));
        } else {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ObjectName", instanceName));
        }
        if (resultClass != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("ResultClass", resultClass));
        }
        if (role != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("Role", role));
        }
        return this.buildSimpleReqIMethodCall("ReferenceNames", anIPVList);
    }

    CIMSimpleReq getProperty(CIMInstancename instanceName, String propertyName) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instanceName));
        anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyName", propertyName));
        return this.buildSimpleReqIMethodCall("GetProperty", anIPVList);
    }

    CIMSimpleReq setProperty(CIMInstancename instanceName, String propertyName, CIMPropertyValue newValue) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instanceName));
        anIPVList.addReadOnly(CIMFactory.iParamValue("PropertyName", propertyName));
        if (newValue != null) {
            CIMItem value = newValue.getValue();
            if (value instanceof CIMValue) {
                anIPVList.addReadOnly(CIMFactory.iParamValue("NewValue", (CIMValue)value));
            } else if (value instanceof CIMValueArray) {
                anIPVList.addReadOnly(CIMFactory.iParamValue("NewValue", (CIMValueArray)value));
            } else {
                anIPVList.addReadOnly(CIMFactory.iParamValue("NewValue", (CIMValueReference)value));
            }
        }
        return this.buildSimpleReqIMethodCall("SetProperty", anIPVList);
    }

    CIMSimpleReq getQualifier(String qualifierName) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList(1);
        anIPVList.addReadOnly(CIMFactory.iParamValue("QualifierName", qualifierName));
        return this.buildSimpleReqIMethodCall("GetQualifier", anIPVList);
    }

    CIMSimpleReq setQualifier(CIMQualifierDeclaration qualifierDeclaration) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList(1);
        anIPVList.addReadOnly(CIMFactory.iParamValue("QualifierDeclaration", qualifierDeclaration));
        return this.buildSimpleReqIMethodCall("SetQualifier", anIPVList);
    }

    CIMSimpleReq deleteQualifier(String qualifierName) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList(1);
        anIPVList.addReadOnly(CIMFactory.iParamValue("QualifierName", qualifierName));
        return this.buildSimpleReqIMethodCall("DeleteQualifier", anIPVList);
    }

    CIMSimpleReq enumerateQualifiers() {
        return this.buildSimpleReqIMethodCall("EnumerateQualifiers", null);
    }

    CIMSimpleReq execQuery(String queryLanguage, String query) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList(1);
        anIPVList.addReadOnly(CIMFactory.iParamValue("QueryLanguage", queryLanguage));
        anIPVList.addReadOnly(CIMFactory.iParamValue("Query", query));
        return this.buildSimpleReqIMethodCall("ExecQuery", anIPVList);
    }

    CIMSimpleReq getInstanceCount(CIMClassname className) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("ClassName", className));
        return this.buildSimpleReqIMethodCall("SAPExt_GetInstanceCount", anIPVList);
    }

    CIMSimpleReq getReferenceCount(CIMInstancename instancename) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList();
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instancename));
        return this.buildSimpleReqIMethodCall("SAPExt_ReferenceCount", anIPVList);
    }

    CIMSimpleReq setProviderSyncTime(CIMInstancename instanceName, Date date) {
        CIMIParamValueList anIPVList = CIMFactory.iParamValueList(2);
        anIPVList.addReadOnly(CIMFactory.iParamValue("InstanceName", instanceName));
        if (date != null) {
            anIPVList.addReadOnly(CIMFactory.iParamValue("DateTime", CIMUtil.date2CimDateTime(date)));
        }
        return this.buildSimpleReqIMethodCall("SAPExt_SetProviderSyncTime", anIPVList);
    }

    CIMSimpleReq copyOrRenameInstance(boolean doCopy, CIMInstancename sourceName, CIMInstancename targetName, CIMInstance targetInstance, boolean allowExistingTargets, boolean addReadOnlyitionalReferences, boolean weakReferences, boolean merge) {
        CIMIParamValueList ipvList = CIMFactory.iParamValueList();
        ipvList.addReadOnly(CIMFactory.iParamValue("SourceName", sourceName));
        if (targetName != null) {
            ipvList.addReadOnly(CIMFactory.iParamValue("TargetName", targetName));
        } else {
            ipvList.addReadOnly(CIMFactory.iParamValue("TargetInstance", targetInstance));
        }
        ipvList.addReadOnly(CIMFactory.iParamValue("AllowExistingTargets", allowExistingTargets));
        ipvList.addReadOnly(CIMFactory.iParamValue("AdditionalReferences", addReadOnlyitionalReferences));
        ipvList.addReadOnly(CIMFactory.iParamValue("WeakReferences", weakReferences));
        ipvList.addReadOnly(CIMFactory.iParamValue("Merge", merge));
        String method = doCopy ? "SAPExt_CopyInstance" : "SAPExt_RenameInstance";
        return this.buildSimpleReqIMethodCall(method, ipvList);
    }

    CIMSimpleReq getObjectServer() {
        return this.buildSimpleReqIMethodCall("SAPExt_GetObjectServer", null);
    }

    static {
        try {
            DEFAULT_LNSP = CIMFactory.createLocalNamespacepathFromString("sld/active");
            DEFAULT_LNSP.makeReadOnly();
        }
        catch (LcrException ex) {
            throw new InternalError(ex.toString());
        }
    }
}

