/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.CIMConst;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.HttpDestinationStore;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class SecureStoreAccess
implements CIMConst {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimclient$SecureStoreAccess == null ? (class$com$sap$lcr$api$cimclient$SecureStoreAccess = SecureStoreAccess.class$("com.sap.lcr.api.cimclient.SecureStoreAccess")) : class$com$sap$lcr$api$cimclient$SecureStoreAccess).getName());
    static /* synthetic */ Class class$com$sap$lcr$api$cimclient$SecureStoreAccess;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;

    private SecureStoreAccess() {
    }

    public static HttpDestinationStore loadConfigFromSecureStore() throws LcrException {
        ClassLoader saveLoader;
        HttpDestinationStore result;
        block21: {
            Class<?> secureStoreSFr;
            Class<?> secureStoreCcI;
            Class<?> secureStoreRtI;
            result = null;
            String currentMethodName = "none";
            try {
                secureStoreRtI = Class.forName("com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface");
                secureStoreCcI = Class.forName("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface");
                secureStoreSFr = Class.forName("com.sap.security.core.server.securestorage.SecureStorageServiceFrame");
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
            saveLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$lcr$api$cimclient$SecureStoreAccess == null ? (class$com$sap$lcr$api$cimclient$SecureStoreAccess = SecureStoreAccess.class$("com.sap.lcr.api.cimclient.SecureStoreAccess")) : class$com$sap$lcr$api$cimclient$SecureStoreAccess).getClassLoader());
            try {
                try {
                    InitialContext initialContext = new InitialContext();
                    Object secureStoreClientObj = initialContext.lookup("tc~sec~securestorage~service");
                    if (secureStoreRtI.isInstance(secureStoreClientObj)) {
                        currentMethodName = "getSecureStorageClientContext";
                        Object secureStoreContextObject = SecureStoreAccess.getSecureStoreContextObject(secureStoreSFr, secureStoreRtI, secureStoreClientObj);
                        Method retObjMethod = secureStoreCcI.getDeclaredMethod("retrieveObject", class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
                        currentMethodName = "retrieveObject";
                        Object secureStoreResultObject = null;
                        try {
                            secureStoreResultObject = retObjMethod.invoke(secureStoreContextObject, "SLDDestinations");
                        }
                        catch (InvocationTargetException iteore) {
                            boolean objExists = SecureStoreAccess.checkObjectInSecureStore(secureStoreCcI, secureStoreContextObject);
                            if (!objExists) {
                                Throwable cft;
                                if (CIMTraceUtil.traceLevel >= 3) {
                                    cft = iteore.getTargetException();
                                    logger.debug("Error during read access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)");
                                }
                                cft = null;
                                Object var15_22 = null;
                                Thread.currentThread().setContextClassLoader(saveLoader);
                                return cft;
                            }
                            Throwable cftore = iteore.getTargetException();
                            logger.error("Read error during access to secure store. Re-enter the SLD destinations to re-write the secure store object.", cftore);
                        }
                        if (secureStoreResultObject == null) {
                            if (CIMTraceUtil.traceLevel >= 3) {
                                logger.debug("Null returned by read access to secure store, method = " + currentMethodName);
                            }
                            HttpDestinationStore httpDestinationStore = null;
                            Object var15_23 = null;
                            Thread.currentThread().setContextClassLoader(saveLoader);
                            return httpDestinationStore;
                        }
                        if (secureStoreResultObject instanceof HttpDestinationStore) {
                            result = (HttpDestinationStore)secureStoreResultObject;
                            break block21;
                        }
                        logger.error("Invalid object retrieved from secure store, class = \"" + secureStoreResultObject.getClass().getName() + "\", must be \"HttpDestinationStore\". Re-enter the SLD destinations" + " to re-write the secure store object.");
                        throw new LcrException("Invalid object retrieved from secure store");
                    }
                    if (CIMTraceUtil.traceLevel >= 3) {
                        logger.debug("JNDI lookup failed, secure storage context does not fit; class = " + secureStoreClientObj.getClass().getName() + " -> secure store version mismatch?");
                    }
                    throw new LcrException("secure storage context does not fit");
                }
                catch (NamingException ne) {
                    if (CIMTraceUtil.traceLevel >= 3) {
                        logger.debug("JNDI lookup failed; secure store service not started?");
                    }
                    throw new LcrException(ne);
                }
                catch (IllegalAccessException iae) {
                    logger.error("No permission to read from secure store. Check the grantsin the secure store service of the J2EE engine.", iae);
                    throw new LcrException(iae);
                }
                catch (InvocationTargetException ite) {
                    Throwable cft = ite.getTargetException();
                    logger.warning("Error during read access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)." + " The error can be ignored, if no SLD destinations have been configured so far.", cft);
                    if (cft != null && cft instanceof Exception) {
                        throw new LcrException((Exception)cft);
                    }
                    throw new LcrException(ite);
                }
                catch (Exception ore) {
                    if (ore instanceof LcrException) {
                        throw (LcrException)ore;
                    }
                    logger.error("Unspecific error during read access to secure store. Try to repeat the activity and check the SLD and Secure Store log", ore);
                    throw new LcrException(ore);
                }
            }
            catch (Throwable throwable) {
                Object var15_25 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
                throw throwable;
            }
        }
        Object var15_24 = null;
        Thread.currentThread().setContextClassLoader(saveLoader);
        return result;
    }

    public static void storeConfigInSecureStore(HttpDestinationStore destinations) throws LcrException {
        Class<?> secureStoreSFr;
        Class<?> secureStoreCcI;
        Class<?> secureStoreRtI;
        String currentMethodName = "none";
        try {
            secureStoreRtI = Class.forName("com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface");
            secureStoreCcI = Class.forName("com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface");
            secureStoreSFr = Class.forName("com.sap.security.core.server.securestorage.SecureStorageServiceFrame");
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Secure store service not available. Check the status of the secure store J2EE service.", cnfe);
            throw new LcrException("Secure store service not available");
        }
        ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$lcr$api$cimclient$SecureStoreAccess == null ? (class$com$sap$lcr$api$cimclient$SecureStoreAccess = SecureStoreAccess.class$("com.sap.lcr.api.cimclient.SecureStoreAccess")) : class$com$sap$lcr$api$cimclient$SecureStoreAccess).getClassLoader());
        try {
            try {
                InitialContext initialContext = new InitialContext();
                Object secureStoreClientObj = initialContext.lookup("tc~sec~securestorage~service");
                if (secureStoreRtI.isInstance(secureStoreClientObj)) {
                    currentMethodName = "getSecureStorageClientContext";
                    Object secureStoreContextObject = SecureStoreAccess.getSecureStoreContextObject(secureStoreSFr, secureStoreRtI, secureStoreClientObj);
                    currentMethodName = "deleteObject";
                    SecureStoreAccess.cleanConfigInSecureStore(secureStoreCcI, secureStoreContextObject);
                    if (destinations != null) {
                        Method storeObjMethod = secureStoreCcI.getDeclaredMethod("storeObject", class$java$io$Serializable == null ? (class$java$io$Serializable = SecureStoreAccess.class$("java.io.Serializable")) : class$java$io$Serializable, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
                        currentMethodName = "storeObject";
                        storeObjMethod.invoke(secureStoreContextObject, destinations, "SLDDestinations");
                    }
                } else {
                    logger.error("Secure store service lookup failed. This may be caused by a secure store version mismatch. Check the versions of your software components and deploy the latest Support Packages, if not yet installed.");
                    throw new LcrException("JNDI lookup failed; secure store version mismatch");
                }
                Object var11_16 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
            }
            catch (NamingException ne) {
                logger.error("Secure store service lookup failed. This may be caused by a stopped secure store service. Check the status of the secure store J2EE service.");
                throw new LcrException(ne);
            }
            catch (IllegalAccessException iae) {
                logger.error("No permission to write to the secure store. Check the grantsin the secure store service of the J2EE engine.", iae);
                throw new LcrException(iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cft = ite.getTargetException();
                logger.error("Error during write access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)." + " Try to repeat the activity, which caused this error.", cft);
                if (cft != null && cft instanceof Exception) {
                    throw new LcrException((Exception)cft);
                }
                throw new LcrException(ite);
            }
            catch (Exception ore) {
                if (ore instanceof LcrException) {
                    throw (LcrException)ore;
                }
                logger.error("Unspecific error during write access to secure store. Try to repeat the activity and check the SLD and Secure Store log", ore);
                throw new LcrException(ore);
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            Thread.currentThread().setContextClassLoader(saveLoader);
            throw throwable;
        }
    }

    private static Object getSecureStoreContextObject(Class secureStoreSFr, Class secureStoreRtI, Object secureStoreClientObj) throws IllegalAccessException, InvocationTargetException, LcrException {
        try {
            Method getCcIMethod = secureStoreRtI.getDeclaredMethod("getSecureStorageClientContext", class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
            Object[] cciParams = new Object[]{"SLDDestinations"};
            return getCcIMethod.invoke(secureStoreClientObj, cciParams);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Field webAppConst = secureStoreSFr.getDeclaredField("CLIENT_TYPE_WEB_APPLICATION");
                int webAppType = webAppConst.getInt(secureStoreSFr);
                Method getCcIMethod = secureStoreRtI.getDeclaredMethod("getSecureStorageClientContext", class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                Object[] cciParams = new Object[]{"SLDDestinations", new Integer(webAppType)};
                return getCcIMethod.invoke(secureStoreClientObj, cciParams);
            }
            catch (NoSuchMethodException nsme2) {
                throw new LcrException("Secure Storage method getSecureStorageClientContext not found");
            }
            catch (NoSuchFieldException nsfe) {
                throw new LcrException("Secure Storage method getSecureStorageClientContext not found");
            }
        }
    }

    private static void cleanConfigInSecureStore(Class secureStoreCcI, Object secureStoreContextObject) {
        try {
            Method deleteObjMethod = secureStoreCcI.getDeclaredMethod("deleteObject", class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
            deleteObjMethod.invoke(secureStoreContextObject, "SLDDestinations");
        }
        catch (IllegalAccessException iae) {
            logger.warning("No permission to delete the SLD destination object in secure store. Check the grants in the secure store service of the J2EE engine.", iae);
            return;
        }
        catch (InvocationTargetException ite) {
            if (CIMTraceUtil.traceLevel >= 3) {
                Throwable cft = ite.getTargetException();
                logger.debug("Failed to delete object in secure store, message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)");
            }
            return;
        }
        catch (Exception ore) {
            logger.warning("Unspecific error during delete in secure store. Try to repeat the activity and check the SLD and Secure Store log", ore);
            return;
        }
    }

    private static boolean checkObjectInSecureStore(Class secureStoreCcI, Object secureStoreContextObject) {
        Object resultObj = null;
        try {
            Method isStoredObjMethod = secureStoreCcI.getDeclaredMethod("exist", class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
            resultObj = isStoredObjMethod.invoke(secureStoreContextObject, "SLDDestinations");
        }
        catch (IllegalAccessException iae) {
            logger.warning("No permission to check the SLD destination object in secure store. Check the grants in the secure store service of the J2EE engine.", iae);
            return false;
        }
        catch (InvocationTargetException ite) {
            if (CIMTraceUtil.traceLevel >= 3) {
                Throwable cft = ite.getTargetException();
                logger.debug("Failed to check object in secure store, message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)");
            }
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (Exception ore) {
            logger.warning("Unspecific error during check object in secure store. Try to repeat the activity and check the SLD and Secure Store log", ore);
            return false;
        }
        if (resultObj != null && resultObj instanceof Boolean) {
            return (Boolean)resultObj;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

