/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.CIMStatusCodes;
import com.sap.lcr.api.cimclient.WrapperException;
import java.text.MessageFormat;

public class LcrException
extends WrapperException
implements CIMStatusCodes {
    private static String[] CIM_STATUS_NAMES = new String[]{"UNKNOWN_CIM_STATUS", "CIM_ERR_FAILED", "CIM_ERR_ACCESS_DENIED", "CIM_ERR_INVALID_NAMESPACE", "CIM_ERR_INVALID_PARAMETER", "CIM_ERR_INVALID_CLASS", "CIM_ERR_NOT_FOUND", "CIM_ERR_NOT_SUPPORTED", "CIM_ERR_CLASS_HAS_CHILDREN", "CIM_ERR_CLASS_HAS_INSTANCES", "CIM_ERR_INVALID_SUPERCLASS", "CIM_ERR_ALREADY_EXISTS", "CIM_ERR_NO_SUCH_PROPERTY", "CIM_ERR_TYPE_MISMATCH", "CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED", "CIM_ERR_INVALID_QUERY", "CIM_ERR_METHOD_NOT_AVAILABLE", "CIM_ERR_METHOD_NOT_FOUND"};
    private final int statusCode;

    public LcrException() {
        this(1, "");
    }

    public LcrException(String s) {
        this(1, s);
    }

    public LcrException(String pattern, Object[] arguments) {
        this(1, pattern, arguments);
    }

    public LcrException(int statusCode, String str) {
        super(LcrException.mapStatusName(statusCode) + ": " + str);
        this.statusCode = LcrException.mapStatusCode(statusCode);
    }

    public LcrException(int statusCode, String pattern, Object[] arguments) {
        this(statusCode, MessageFormat.format(pattern, arguments));
    }

    public LcrException(Exception e) {
        super(e);
        this.statusCode = 1;
    }

    public LcrException(String msg, Exception cause) {
        super(msg, cause);
        this.statusCode = 1;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusName() {
        return LcrException.mapStatusName(this.statusCode);
    }

    public static String mapStatusName(int statusCode) {
        return CIM_STATUS_NAMES[LcrException.mapStatusCode(statusCode)];
    }

    public static int mapStatusCode(int statusCode) {
        return statusCode >= CIM_STATUS_NAMES.length || statusCode < 0 ? 0 : statusCode;
    }
}

