/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cimclient.CIMHttp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.ssl.IAIKSecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;

public class CIMServerPing {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cimclient$CIMServerPing == null ? (class$com$sap$lcr$api$cimclient$CIMServerPing = CIMServerPing.class$("com.sap.lcr.api.cimclient.CIMServerPing")) : class$com$sap$lcr$api$cimclient$CIMServerPing).getName());
    private static final String okPattern = "<messalert>OKAY</messalert>";
    static String request = "<scenario><scenname>BasicTest</scenname><scenversion>000</scenversion><sceninst>000</sceninst><components><component><compname>BasicTest</compname><compversion>000</compversion><properties><property><propname>..</propname><propvalue>..</propvalue></property></properties></component></components></scenario>";
    static final String HTTP = "http";
    static final String HTTPS = "https";
    private static final String trustStore = "TrustedCAs";
    static /* synthetic */ Class class$com$sap$lcr$api$cimclient$CIMServerPing;

    public static boolean ping(String aHost, int aPort) throws IOException {
        URL tURL = CIMServerPing.constructURL(aHost, aPort);
        return CIMServerPing.privatePing(tURL);
    }

    public static boolean pingNoException(String aHost, int aPort) {
        boolean tResult;
        try {
            tResult = CIMServerPing.ping(aHost, aPort);
        }
        catch (IOException e) {
            tResult = false;
        }
        return tResult;
    }

    public static boolean ping(String aStringURL) throws IOException {
        URL tURL = CIMServerPing.constructURL(aStringURL);
        return CIMServerPing.privatePing(tURL);
    }

    public static boolean pingNoException(String aStringURL) {
        boolean tResult;
        try {
            tResult = CIMServerPing.ping(aStringURL);
        }
        catch (IOException e) {
            tResult = false;
        }
        return tResult;
    }

    public static boolean ping(URL anURL) throws IOException {
        URL tURL = CIMServerPing.constructURL(anURL);
        return CIMServerPing.privatePing(tURL);
    }

    public static boolean pingNoException(URL anURL) {
        boolean tResult;
        try {
            tResult = CIMServerPing.ping(anURL);
        }
        catch (IOException e) {
            tResult = false;
        }
        return tResult;
    }

    public static boolean ping(com.tssap.dtr.client.lib.protocol.URL anURL, KeyStore scstore) throws IOException, HTTPException {
        String protocol = anURL.getProtocol();
        if (protocol == null) {
            throw new MalformedURLException("Protocol missing in URL to ping: " + anURL.toString());
        }
        String host = anURL.getHost();
        if (host == null) {
            throw new MalformedURLException("Host missing in URL to ping: " + anURL.toString());
        }
        int port = anURL.getPort();
        if (port == -1) {
            throw new MalformedURLException("Port missing in URL to ping: " + anURL.toString());
        }
        com.tssap.dtr.client.lib.protocol.URL pingURL = new com.tssap.dtr.client.lib.protocol.URL(protocol, host, port, "/sld/rtc");
        return CIMServerPing.pingImpl(pingURL, scstore);
    }

    public static boolean pingNoException(com.tssap.dtr.client.lib.protocol.URL anURL, KeyStore scstore) {
        boolean tResult;
        try {
            tResult = CIMServerPing.ping(anURL, scstore);
        }
        catch (IOException e) {
            tResult = false;
        }
        catch (HTTPException he) {
            tResult = false;
        }
        return tResult;
    }

    static URL constructURL(String aHost, int aPort) throws MalformedURLException {
        URL tURL = new URL(HTTP, aHost, aPort, "/sld/rtc");
        return tURL;
    }

    static URL constructURL(String aStringURL) throws MalformedURLException {
        URL tURL1 = new URL(aStringURL);
        URL tURL2 = CIMServerPing.constructURL(tURL1);
        return tURL2;
    }

    static URL constructURL(URL anURL) throws MalformedURLException {
        String tHost = anURL.getHost();
        if (tHost == null) {
            throw new MalformedURLException("*** No host in given URL " + anURL + " ***");
        }
        int tPort = anURL.getPort();
        if (tPort == -1) {
            throw new MalformedURLException("*** No port in given URL " + anURL + " ***");
        }
        URL tURL = CIMServerPing.constructURL(tHost, tPort);
        return tURL;
    }

    /*
     * WARNING - void declaration
     */
    static boolean privatePing(URL anURL) throws IOException {
        if (anURL.getProtocol().equalsIgnoreCase(HTTPS)) {
            boolean result = false;
            com.tssap.dtr.client.lib.protocol.URL sapURL = CIMHttp.java2DtrHttpURL(anURL);
            try {
                result = CIMServerPing.pingImpl(sapURL, null);
            }
            catch (HTTPException he) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    logger.debug("HTTP exception thrown: ", he);
                }
                throw new IOException("HTTP exception thrown: " + he.getMessage());
            }
            return result;
        }
        URLConnection servletConnection = null;
        servletConnection = anURL.openConnection();
        servletConnection.setDoOutput(true);
        OutputStream outputStream = servletConnection.getOutputStream();
        outputStream.write(request.getBytes());
        outputStream.close();
        StringBuffer stringBuffer = new StringBuffer(256);
        InputStreamReader streamReader = new InputStreamReader(servletConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        try {
            String inputLine;
            while ((inputLine = bufferedReader.readLine()) != null) {
                void he;
                stringBuffer.append((String)he);
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString().indexOf(okPattern) != -1;
    }

    static boolean pingImpl(com.tssap.dtr.client.lib.protocol.URL anURL, KeyStore scstore) throws IOException, HTTPException {
        String contentCharset;
        String responseString;
        SessionContext sessionContext = new SessionContext();
        Connection connection = new Connection(anURL, (ISessionContext)sessionContext);
        if (anURL.getProtocol().equalsIgnoreCase(HTTPS)) {
            IAIKSecureSocketProvider sslProvider = scstore != null ? new IAIKSecureSocketProvider(scstore) : new IAIKSecureSocketProvider(trustStore, null);
            connection.setSecureSocketProvider((ISecureSocketProvider)sslProvider);
        }
        PostRequest postRequest = new PostRequest("/sld/rtc");
        postRequest.setRequestEntity((IRequestEntity)new ByteArrayEntity(request.getBytes("UTF-8"), "application/xml; charset=utf-8"));
        IResponse response = connection.send((IRequest)postRequest);
        int responseCode = response.getStatus();
        if (CIMTraceUtil.traceLevel >= 3) {
            logger.debug("Ping HTTP response code = " + responseCode);
        }
        switch (responseCode) {
            case 200: {
                break;
            }
            default: {
                String errorMsg = response.getStatusDescription();
                if (errorMsg == null) {
                    throw new IOException("HTTP return code " + responseCode);
                }
                throw new IOException(errorMsg);
            }
        }
        ByteArrayEntity inBytes = new ByteArrayEntity(response);
        return inBytes != null && (responseString = (contentCharset = inBytes.getContentCharset()) == null ? new String(inBytes.getContent()) : new String(inBytes.getContent(), contentCharset)).indexOf(okPattern) != -1;
    }

    public static void main(String[] args) {
        boolean success;
        String host = null;
        String port = null;
        String okMsg = "--- Success ---";
        String failMsg = "*** Failure ***";
        URL tURL = null;
        System.out.println();
        if (args.length != 4) {
            System.out.println("Usage: CIMServerPing <host> <port> <url1> <url2>");
            System.out.println("       <java-vm> <java-classpath> com.sap.lcr.api.cimclient.CIMServerPing pwdf0367 56700 http://pwdf0367:56700 http://pwdf0367:56700/gibt_es_nicht");
            System.exit(1);
        }
        host = args[0];
        port = args[1];
        int portAsInt = Integer.valueOf(port);
        String stringURL1 = args[2];
        String stringURL2 = args[3];
        System.out.println("--- Ping (host/port -> URL): " + host + " " + port + " ---");
        try {
            success = CIMServerPing.ping(host, portAsInt);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
            failMsg = "*** Failure: (" + e.getClass() + ") ***";
        }
        String msg = success ? okMsg : failMsg;
        System.out.println(msg);
        System.out.println();
        System.out.println("--- Ping (String -> URL): " + stringURL1 + " ---");
        try {
            success = CIMServerPing.ping(stringURL1);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
            failMsg = "*** Failure: (" + e.getClass() + ") ***";
        }
        msg = success ? okMsg : failMsg;
        System.out.println(msg);
        System.out.println();
        try {
            tURL = new URL(stringURL2);
            System.out.println("--- Ping (URL -> URL): " + tURL + " ---");
            success = CIMServerPing.ping(tURL);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
            failMsg = "*** Failure: (" + e.getClass() + ") ***";
        }
        msg = success ? okMsg : failMsg;
        System.out.println(msg);
        System.out.println();
        try {
            tURL = new URL(stringURL2);
            System.out.println("--- PrivatePing (DirectURL): " + tURL + " ---");
            success = CIMServerPing.privatePing(tURL);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
            failMsg = "*** Failure: " + tURL + " (" + e.getClass() + ") ***";
        }
        msg = success ? okMsg : failMsg;
        System.out.println(msg);
        System.out.println();
        System.out.println("--- SAP HTTP Client Ping to " + stringURL1 + " ---");
        try {
            success = CIMServerPing.pingImpl(new com.tssap.dtr.client.lib.protocol.URL(stringURL1), null);
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
            failMsg = "*** Failure: (" + e.getClass() + ") ***";
        }
        catch (HTTPException he) {
            success = false;
            he.printStackTrace();
            failMsg = "*** Failure: (" + ((Object)((Object)he)).getClass() + ") ***";
        }
        msg = success ? okMsg : failMsg;
        System.out.println(msg);
        System.out.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

