/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cimclient;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMInstancenameList;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespace;
import com.sap.lcr.api.cim.CIMObjectname;
import com.sap.lcr.api.cim.CIMObjectpath;
import com.sap.lcr.api.cim.CIMObjectpathList;
import com.sap.lcr.api.cim.CIMPropertyValue;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.lcr.api.cim.CIMValueObjectWithPath;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cim.ICIMObjRef;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMBatchHandle;
import com.sap.lcr.api.cimclient.CIMBatchResult;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.CIMNames;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.HttpRequestSender;
import com.sap.lcr.api.cimclient.IRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.ModelVersion;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class CIMClient
implements CIMClientHandle {
    private final CIMOMClient clientImpl;

    public CIMClient(CIMOMClient cimomClient) {
        if (cimomClient == null) {
            throw new NullPointerException("Argument in constructor CIMClient(CIMOMClient) must not be null!");
        }
        this.clientImpl = cimomClient;
    }

    public CIMClient(IRequestSender aSender) {
        this.clientImpl = new CIMOMClient(aSender);
    }

    public CIMClient(IRequestSender aSender, ArrayList namespaceFragments) {
        this(aSender);
        this.setLocalNamespacePath(namespaceFragments);
    }

    public CIMClient(IRequestSender aSender, String aLocalNamespacepath) throws LcrException {
        this(aSender);
        this.setLocalNamespacePath(aLocalNamespacepath);
    }

    public CIMClient(IRequestSender aSender, CIMLocalnamespacepath aLocalNamespacepath) {
        this(aSender);
        this.setLocalNamespacePath(aLocalNamespacepath);
    }

    public String getLocalNamespacePathString() {
        return this.clientImpl.getLocalNamespacePath().toDisplayString();
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        return this.clientImpl.getLocalNamespacePath();
    }

    public void setLocalNamespacePath(ArrayList namespaceFragments) {
        if (namespaceFragments == null || namespaceFragments.isEmpty()) {
            this.clientImpl.setLocalNamespacePath(null);
            return;
        }
        CIMLocalnamespacepath path = null;
        Iterator iter = ((AbstractList)namespaceFragments).iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            CIMNamespace nextNamespace = CIMFactory.namespace(next);
            if (path == null) {
                path = CIMFactory.localnamespacepath(nextNamespace);
                continue;
            }
            path.addNamespace(nextNamespace);
        }
        this.clientImpl.setLocalNamespacePath(path);
    }

    public void setLocalNamespacePath(String localNSPath) throws LcrException {
        this.clientImpl.setLocalNamespacePath(localNSPath == null || localNSPath.length() == 0 ? null : CIMFactory.createLocalNamespacepathFromString(localNSPath));
    }

    public void setLocalNamespacePath(CIMLocalnamespacepath aLocalNamespacepath) {
        this.clientImpl.setLocalNamespacePath(aLocalNamespacepath);
    }

    public IRequestSender getRequestSender() {
        return this.clientImpl.getRequestSender();
    }

    public CIMOMClient getClientImpl() {
        return this.clientImpl;
    }

    public CIMOMHandle getCIMOMHandle() {
        return this.clientImpl;
    }

    public boolean isReturnWritableObjects() {
        return this.clientImpl.isReturnWritableObjects();
    }

    public void setReturnWritableObjects(boolean returnWritables) {
        this.clientImpl.setReturnWritableObjects(returnWritables);
    }

    public static void setTraceLevel(int level) {
        CIMTraceUtil.traceLevel = level;
        if (level < 0) {
            CIMTraceUtil.traceLevel = 0;
        } else if (level > 6) {
            CIMTraceUtil.traceLevel = 6;
        }
    }

    public void disconnect() {
        this.clientImpl.disconnect();
    }

    public void ping() throws CIMClientException {
        try {
            this.getCIMClass(CIMNames.C_SAP_CIMSchema);
        }
        catch (LcrException lcrException) {
            // empty catch block
        }
    }

    public static boolean pingConnectedServer(CIMClientHandle aClient) {
        return ModelVersion.pingConnectedServer(aClient);
    }

    public String getHost() {
        IRequestSender sender = this.clientImpl.getRequestSender();
        if (sender instanceof HttpRequestSender) {
            HttpRequestSender httprequestsender = (HttpRequestSender)sender;
            return httprequestsender.getHost();
        }
        return null;
    }

    public int getPort() {
        IRequestSender sender = this.clientImpl.getRequestSender();
        if (sender instanceof HttpRequestSender) {
            HttpRequestSender httprequestsender = (HttpRequestSender)sender;
            return httprequestsender.getPort();
        }
        return 0;
    }

    public String toString() {
        return this.clientImpl.toString();
    }

    public CIMObjectpath[] associatorNames(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(objectName, assocClass, resultClass, role, resultRole).toTypedArray();
    }

    public CIMObjectpath[] associatorNames(CIMObjectname objectName) throws CIMClientException, LcrException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public CIMObjectpath[] associatorNames(String objectName, String assocClassString, String resultClassString, String role, String resultRole) throws CIMClientException, LcrException {
        CIMClassname assocClass = assocClassString == null ? null : CIMFactory.classname(assocClassString);
        CIMClassname resultClass = resultClassString == null ? null : CIMFactory.classname(resultClassString);
        ICIMObjRef ref = CIMFactory.createObjPathFromString(objectName);
        if (ref instanceof CIMClassname) {
            return this.clientImpl.associatorNames((CIMClassname)ref, assocClass, resultClass, role, resultRole).toTypedArray();
        }
        if (ref instanceof CIMInstancename) {
            return this.clientImpl.associatorNames((CIMInstancename)ref, assocClass, resultClass, role, resultRole).toTypedArray();
        }
        throw new CIMClientException("Invalid object name: " + objectName);
    }

    public CIMObjectpath[] associatorNames(String objectName) throws CIMClientException, LcrException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public CIMObjectpath[] associatorNames(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(className, assocClass, resultClass, role, resultRole).toTypedArray();
    }

    public CIMObjectpath[] associatorNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.associatorNames(className, null, null, null, null);
    }

    public CIMObjectpath[] associatorNames(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(instanceName, assocClass, resultClass, role, resultRole).toTypedArray();
    }

    public CIMObjectpath[] associatorNames(CIMInstancename instanceName) throws CIMClientException, LcrException {
        return this.associatorNames(instanceName, null, null, null, null);
    }

    public CIMObjectpath[] associatorNames(CIMObjectReference objRef, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        if (objRef.isCIMClass()) {
            return this.clientImpl.associatorNames(objRef.toCIMClassname(), assocClass, resultClass, role, resultRole).toTypedArray();
        }
        return this.clientImpl.associatorNames(objRef.toCIMInstancename(), assocClass, resultClass, role, resultRole).toTypedArray();
    }

    public CIMObjectpath[] associatorNames(CIMObjectReference objRef, String assocClass, String resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.associatorNames(objRef, assocClass == null ? (CIMClassname)null : CIMFactory.classname(assocClass), resultClass == null ? (CIMClassname)null : CIMFactory.classname(resultClass), role, resultRole);
    }

    public CIMObjectpath[] associatorNames(CIMObjectReference objRef) throws CIMClientException, LcrException {
        return this.associatorNames(objRef, (CIMClassname)null, null, null, null);
    }

    public CIMValueObjectWithPath[] associators(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] associators(CIMObjectname objName) throws CIMClientException, LcrException {
        return this.associators(objName, null, null, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] associators(String objectName, String assocClassString, String resultClassString, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMClassname assocClass = assocClassString == null ? null : CIMFactory.classname(assocClassString);
        CIMClassname resultClass = resultClassString == null ? null : CIMFactory.classname(resultClassString);
        ICIMObjRef ref = CIMFactory.createObjPathFromString(objectName);
        if (ref instanceof CIMClassname) {
            return this.clientImpl.associators((CIMClassname)ref, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
        }
        if (ref instanceof CIMInstancename) {
            return this.clientImpl.associators((CIMInstancename)ref, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
        }
        throw new CIMClientException("Invalid object name: " + objectName);
    }

    public CIMValueObjectWithPath[] associators(String objectName) throws CIMClientException, LcrException {
        return this.associators(objectName, null, null, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] associators(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(className, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] associators(CIMClassname className) throws CIMClientException, LcrException {
        return this.associators(className, null, null, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] associators(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(instanceName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] associators(CIMInstancename instanceName) throws CIMClientException, LcrException {
        return this.associators(instanceName, null, null, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] associators(CIMObjectReference objRef, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        if (objRef.isCIMClass()) {
            return this.associators(objRef.toCIMClassname(), assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        }
        return this.associators(objRef.toCIMInstancename(), assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPath[] associators(CIMObjectReference objRef, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.associators(objRef, assocClass == null ? (CIMClassname)null : CIMFactory.classname(assocClass), resultClass == null ? (CIMClassname)null : CIMFactory.classname(resultClass), role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPath[] associators(CIMObjectReference objRef) throws CIMClientException, LcrException {
        return this.associators(objRef, (CIMClassname)null, null, null, null, false, false, null);
    }

    public CIMObjectpathList copyInstance(CIMInstancename sourceName, CIMInstancename targetName, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        return this.clientImpl.copyInstance(sourceName, targetName, allowExistingTargets, additionalReferences, weakReferences, merge);
    }

    public CIMObjectpathList copyInstance(CIMInstancename sourceName, CIMInstancename targetName) throws CIMClientException, LcrException {
        return this.copyInstance(sourceName, targetName, true, true, true, true);
    }

    public void createClass(CIMClass newClass) throws CIMClientException, LcrException {
        this.clientImpl.createClass(newClass);
    }

    public CIMInstancename createInstance(CIMInstance newInstance) throws CIMClientException, LcrException {
        return this.clientImpl.createInstance(newInstance);
    }

    public CIMInstancename createInstance(String classname, String[] propNames, String[] propValues) throws CIMClientException, LcrException {
        CIMInstance newInstance;
        try {
            newInstance = CIMFactory.instance(classname, propNames, propValues);
        }
        catch (ItemConstructionExcp e) {
            throw new CIMClientException(e);
        }
        return this.createInstance(newInstance);
    }

    public CIMInstancename createInstance(String classname, String[] propNames, String[] propValues, String[] propTypes) throws CIMClientException, LcrException {
        CIMInstance newInstance;
        try {
            newInstance = CIMFactory.instance(classname, propNames, propValues, propTypes);
        }
        catch (ItemConstructionExcp e) {
            throw new CIMClientException(e);
        }
        return this.createInstance(newInstance);
    }

    public void deleteClass(CIMClassname className) throws CIMClientException, LcrException {
        this.clientImpl.deleteClass(className);
    }

    public void deleteClass(String className) throws CIMClientException, LcrException {
        this.deleteClass(CIMFactory.classname(className));
    }

    public void deleteClass(CIMObjectReference classRef) throws CIMClientException, LcrException {
        this.deleteClass(classRef.toCIMClassname());
    }

    public void deleteInstance(CIMInstancename instanceName) throws CIMClientException, LcrException {
        this.clientImpl.deleteInstance(instanceName);
    }

    public void deleteInstance(String className, String[] keys, String[] values) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        this.deleteInstance(aCIMInstancename);
    }

    public void deleteInstance(String className, String[] keys, String[] values, String[] types) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values, types);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        this.deleteInstance(aCIMInstancename);
    }

    public void deleteInstance(CIMObjectReference instanceRef) throws CIMClientException, LcrException {
        this.deleteInstance(instanceRef.toCIMInstancename());
    }

    public void deleteInstance(String instanceName) throws CIMClientException, LcrException {
        this.deleteInstance(CIMFactory.createInstancenameFromString(instanceName));
    }

    public CIMObjectpathList deleteInstance(CIMInstancename instanceName, boolean withReferences) throws CIMClientException, LcrException {
        return this.clientImpl.deleteInstance(instanceName, withReferences);
    }

    public void deleteQualifier(String qualifierName) throws CIMClientException, LcrException {
        this.clientImpl.deleteQualifier(qualifierName);
    }

    public CIMClass[] enumerateClasses(CIMClassname className, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateClasses(className, deepInheritance, localOnly, includeQualifiers, includeClassOrigin).toTypedArray();
    }

    public CIMClass[] enumerateClasses(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateClasses(className, false, true, true, false);
    }

    public CIMClass[] enumerateClasses(String className, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMClientException, LcrException {
        return this.enumerateClasses(className == null ? (CIMClassname)null : CIMFactory.classname(className), deepInheritance, localOnly, includeQualifiers, includeClassOrigin);
    }

    public CIMClass[] enumerateClasses(String classname) throws CIMClientException, LcrException {
        return this.enumerateClasses(classname == null ? (CIMClassname)null : CIMFactory.classname(classname), false, true, true, false);
    }

    public CIMClass[] enumerateClasses(CIMObjectReference classRef, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMClientException, LcrException {
        return this.enumerateClasses(classRef == null ? (CIMClassname)null : classRef.toCIMClassname(), deepInheritance, localOnly, includeQualifiers, includeClassOrigin);
    }

    public CIMClass[] enumerateClasses(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateClasses(classRef == null ? (CIMClassname)null : classRef.toCIMClassname(), false, true, true, false);
    }

    public CIMClass[] enumerateClasses() throws CIMClientException, LcrException {
        return this.enumerateClasses((CIMClassname)null, false, true, true, false);
    }

    public CIMClassname[] enumerateClassNames(CIMClassname className, boolean deepInheritance) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateClassNames(className, deepInheritance).toTypedArray();
    }

    public CIMClassname[] enumerateClassNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateClassNames(className, false);
    }

    public CIMClassname[] enumerateClassNames(String className, boolean deepInheritance) throws CIMClientException, LcrException {
        CIMClassname aCIMClassname = className == null ? null : CIMFactory.classname(className);
        return this.enumerateClassNames(aCIMClassname, deepInheritance);
    }

    public CIMClassname[] enumerateClassNames(String className) throws CIMClientException, LcrException {
        return this.enumerateClassNames(className == null ? (CIMClassname)null : CIMFactory.classname(className), false);
    }

    public CIMClassname[] enumerateClassNames(CIMObjectReference classRef, boolean deepInheritance) throws CIMClientException, LcrException {
        return this.enumerateClassNames(classRef == null ? (CIMClassname)null : classRef.toCIMClassname(), deepInheritance);
    }

    public CIMClassname[] enumerateClassNames(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateClassNames(classRef == null ? (CIMClassname)null : classRef.toCIMClassname(), false);
    }

    public CIMClassname[] enumerateClassNames() throws CIMClientException, LcrException {
        return this.enumerateClassNames((CIMClassname)null, false);
    }

    public CIMValueNamedInstance[] enumerateInstances(CIMClassname className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstances(className, localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueNamedInstance[] enumerateInstances(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateInstances(className, true, true, false, false, null);
    }

    public CIMValueNamedInstance[] enumerateInstances(String className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMClassname aCIMClassname = CIMFactory.classname(className);
        return this.enumerateInstances(aCIMClassname, localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueNamedInstance[] enumerateInstances(String className) throws CIMClientException, LcrException {
        return this.enumerateInstances(CIMFactory.classname(className), true, true, false, false, null);
    }

    public CIMValueNamedInstance[] enumerateInstances(CIMObjectReference classRef, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.enumerateInstances(classRef.toCIMClassname(), localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueNamedInstance[] enumerateInstances(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateInstances(classRef.toCIMClassname(), true, true, false, false, null);
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstancesNoSubclasses(className, localOnly, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(CIMClassname className) throws CIMClientException, LcrException {
        return this.enumerateInstancesNoSubclasses(className, true, false, false, null);
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(String className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.enumerateInstancesNoSubclasses(CIMFactory.classname(className), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(String className) throws CIMClientException, LcrException {
        return this.enumerateInstancesNoSubclasses(CIMFactory.classname(className), true, false, false, null);
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(CIMObjectReference classRef, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.enumerateInstancesNoSubclasses(classRef.toCIMClassname(), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueNamedInstance[] enumerateInstancesNoSubclasses(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateInstancesNoSubclasses(classRef.toCIMClassname(), true, false, false, null);
    }

    public CIMInstancename[] enumerateInstanceNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstanceNames(className).toTypedArray();
    }

    public CIMInstancename[] enumerateInstanceNames(String className) throws CIMClientException, LcrException {
        return this.enumerateInstanceNames(CIMFactory.classname(className));
    }

    public CIMInstancename[] enumerateInstanceNames(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateInstanceNames(classRef.toCIMClassname());
    }

    public CIMInstancename[] enumerateInstanceNamesNoSubclasses(CIMClassname className) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstanceNamesNoSubclasses(className).toTypedArray();
    }

    public CIMInstancename[] enumerateInstanceNamesNoSubclasses(String className) throws CIMClientException, LcrException {
        return this.enumerateInstanceNamesNoSubclasses(CIMFactory.classname(className));
    }

    public CIMInstancename[] enumerateInstanceNamesNoSubclasses(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.enumerateInstanceNamesNoSubclasses(classRef.toCIMClassname());
    }

    public CIMQualifierDeclarationList enumerateQualifiers() throws CIMClientException, LcrException {
        return this.clientImpl.enumerateQualifiers();
    }

    public CIMValueObjectWithPathList execQuery(String queryLanguage, String query) throws CIMClientException, LcrException {
        return this.clientImpl.execQuery(queryLanguage, query);
    }

    public CIMClass getCIMClass(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.getCIMClass(className, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMClass getCIMClass(CIMClassname className) throws CIMClientException, LcrException {
        return this.getCIMClass(className, true, true, false, null);
    }

    public CIMClass getCIMClass(String className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.getCIMClass(CIMFactory.classname(className), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMClass getCIMClass(String className) throws CIMClientException, LcrException {
        return this.getCIMClass(className, true, true, false, null);
    }

    public CIMClass getCIMClass(CIMObjectReference classRef, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.getCIMClass(classRef.toCIMClassname(), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMClass getCIMClass(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.getCIMClass(classRef.toCIMClassname(), true, true, false, null);
    }

    public CIMInstance getInstance(CIMInstancename instanceName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.getInstance(instanceName, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(CIMInstancename instanceName) throws CIMClientException, LcrException {
        return this.getInstance(instanceName, true, false, false, null);
    }

    public CIMInstance getInstance(String className, String[] keys, String[] values, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        return this.getInstance(aCIMInstancename, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(String className, String[] keys, String[] values) throws CIMClientException, LcrException {
        return this.getInstance(className, keys, values, true, false, false, null);
    }

    public CIMInstance getInstance(String className, String[] keys, String[] values, String[] types, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values, types);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        return this.getInstance(aCIMInstancename, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(String className, String[] keys, String[] values, String[] types) throws CIMClientException, LcrException {
        return this.getInstance(className, keys, values, types, true, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectReference instanceRef, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.getInstance(instanceRef.toCIMInstancename(), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(CIMObjectReference instanceRef) throws CIMClientException, LcrException {
        return this.getInstance(instanceRef.toCIMInstancename(), true, false, false, null);
    }

    public CIMInstance getInstance(String instanceName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.getInstance(CIMFactory.createInstancenameFromString(instanceName), localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(String instanceName) throws CIMClientException, LcrException {
        return this.getInstance(CIMFactory.createInstancenameFromString(instanceName), true, false, false, null);
    }

    public int getInstanceCount(CIMClassname className) throws CIMClientException, LcrException {
        return this.clientImpl.getInstanceCount(className);
    }

    public int getInstanceCount(String className) throws CIMClientException, LcrException {
        return this.getInstanceCount(CIMFactory.classname(className));
    }

    public int getInstanceCount(CIMObjectReference classRef) throws CIMClientException, LcrException {
        return this.getInstanceCount(classRef.toCIMClassname());
    }

    public String getObjectServer() throws CIMClientException, LcrException {
        return this.clientImpl.getObjectServer();
    }

    public CIMPropertyValue getProperty(CIMInstancename instanceName, String propertyName) throws CIMClientException, LcrException {
        return this.clientImpl.getProperty(instanceName, propertyName);
    }

    public CIMPropertyValue getProperty(String className, String keyvalue, String propertyName) throws CIMClientException, LcrException {
        CIMKeyValue aCIMKeyValue = CIMFactory.keyValue(keyvalue);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeyValue);
        return this.getProperty(aCIMInstancename, propertyName);
    }

    public CIMPropertyValue getProperty(String className, String[] keys, String[] values, String propertyName) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        return this.getProperty(aCIMInstancename, propertyName);
    }

    public CIMPropertyValue getProperty(String className, String[] keys, String[] values, String[] types, String propertyName) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values, types);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        return this.getProperty(aCIMInstancename, propertyName);
    }

    public CIMPropertyValue getProperty(CIMObjectReference instanceRef, String propertyName) throws CIMClientException, LcrException {
        return this.getProperty(instanceRef.toCIMInstancename(), propertyName);
    }

    public CIMPropertyValue getProperty(String instanceName, String propertyName) throws CIMClientException, LcrException {
        return this.getProperty(CIMFactory.createInstancenameFromString(instanceName), propertyName);
    }

    public CIMQualifierDeclaration getQualifier(String qualifierName) throws CIMClientException, LcrException {
        return this.clientImpl.getQualifier(qualifierName);
    }

    public void mergeInstance(CIMValueNamedInstance modifiedInstance) throws CIMClientException, LcrException {
        this.clientImpl.mergeInstance(modifiedInstance);
    }

    public void modifyClass(CIMClass modifiedClass) throws CIMClientException, LcrException {
        this.clientImpl.modifyClass(modifiedClass);
    }

    public void modifyInstance(CIMValueNamedInstance modifiedInstance) throws CIMClientException, LcrException {
        this.clientImpl.modifyInstance(modifiedInstance);
    }

    public void modifyInstance(CIMInstancename instanceName, CIMInstance modifiedInstance) throws CIMClientException, LcrException {
        this.modifyInstance(CIMFactory.valueNamedInstance(instanceName, modifiedInstance));
    }

    public void modifyInstance(CIMObjectReference instanceRef, CIMInstance modifiedInstance) throws CIMClientException, LcrException {
        this.modifyInstance(CIMFactory.valueNamedInstance(instanceRef.toCIMInstancename(), modifiedInstance));
    }

    public void modifyInstance(String instanceName, CIMInstance modifiedInstance) throws CIMClientException, LcrException {
        this.modifyInstance(CIMFactory.createInstancenameFromString(instanceName), modifiedInstance);
    }

    public CIMObjectpath[] referenceNames(CIMObjectname objectName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(objectName, resultClass, role).toTypedArray();
    }

    public CIMObjectpath[] referenceNames(CIMObjectname objectName) throws CIMClientException, LcrException {
        return this.referenceNames(objectName, null, null);
    }

    public CIMObjectpath[] referenceNames(String objectName, String resultClass, String role) throws CIMClientException, LcrException {
        CIMClassname resultClsName = resultClass == null ? null : CIMFactory.classname(resultClass);
        ICIMObjRef ref = CIMFactory.createObjPathFromString(objectName);
        if (ref instanceof CIMClassname) {
            return this.referenceNames((CIMClassname)ref, resultClsName, role);
        }
        if (ref instanceof CIMInstancename) {
            return this.referenceNames((CIMInstancename)ref, resultClsName, role);
        }
        throw new CIMClientException("Invalid object name: " + objectName);
    }

    public CIMObjectpath[] referenceNames(String objectName) throws CIMClientException, LcrException {
        return this.referenceNames(objectName, null, null);
    }

    public CIMObjectpath[] referenceNames(CIMInstancename instanceName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(instanceName, resultClass, role).toTypedArray();
    }

    public CIMObjectpath[] referenceNames(CIMInstancename instanceName) throws CIMClientException, LcrException {
        return this.referenceNames(instanceName, null, null);
    }

    public CIMObjectpath[] referenceNames(CIMClassname className, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(className, resultClass, role).toTypedArray();
    }

    public CIMObjectpath[] referenceNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.referenceNames(className, null, null);
    }

    public CIMObjectpath[] referenceNames(CIMObjectReference objRef, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        if (objRef.isCIMClass()) {
            return this.referenceNames(objRef.toCIMClassname(), resultClass, role);
        }
        return this.referenceNames(objRef.toCIMInstancename(), resultClass, role);
    }

    public CIMObjectpath[] referenceNames(CIMObjectReference objRef, String resultClass, String role) throws CIMClientException, LcrException {
        return this.referenceNames(objRef, resultClass == null ? null : CIMFactory.classname(resultClass), role);
    }

    public CIMObjectpath[] referenceNames(CIMObjectReference objRef) throws CIMClientException, LcrException {
        return this.referenceNames(objRef, (CIMClassname)null, null);
    }

    public CIMValueObjectWithPath[] references(CIMObjectname objectName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] references(CIMObjectname objectName) throws CIMClientException, LcrException {
        return this.references(objectName, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] references(String objectName, String resultClassString, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        CIMClassname resultClass = resultClassString == null ? null : CIMFactory.classname(resultClassString);
        ICIMObjRef ref = CIMFactory.createObjPathFromString(objectName);
        if (ref instanceof CIMClassname) {
            return this.references((CIMClassname)ref, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        }
        if (ref instanceof CIMInstancename) {
            return this.references((CIMInstancename)ref, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        }
        throw new CIMClientException("Invalid object name: " + objectName);
    }

    public CIMValueObjectWithPath[] references(String objectName) throws CIMClientException, LcrException {
        return this.references(objectName, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] references(CIMClassname className, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(className, resultClass, role, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] references(CIMClassname className) throws CIMClientException, LcrException {
        return this.references(className, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] references(CIMInstancename instanceName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(instanceName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList).toTypedArray();
    }

    public CIMValueObjectWithPath[] references(CIMInstancename instanceName) throws CIMClientException, LcrException {
        return this.references(instanceName, null, null, false, false, null);
    }

    public CIMValueObjectWithPath[] references(CIMObjectReference objRef, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        if (objRef.isCIMClass()) {
            return this.references(objRef.toCIMClassname(), resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        }
        return this.references(objRef.toCIMInstancename(), resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPath[] references(CIMObjectReference objRef, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.references(objRef, resultClass == null ? null : CIMFactory.classname(resultClass), role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPath[] references(CIMObjectReference objRef) throws CIMClientException, LcrException {
        return this.references(objRef, (CIMClassname)null, null, false, false, null);
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstancename targetName, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        return this.clientImpl.renameInstance(sourceName, targetName, allowExistingTargets, additionalReferences, weakReferences, merge);
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstancename targetName) throws CIMClientException, LcrException {
        return this.renameInstance(sourceName, targetName, true, true, true, true);
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstance targetInstance, boolean allowExistingTargets, boolean additionalReferences, boolean weakReferences, boolean merge) throws CIMClientException, LcrException {
        return this.clientImpl.renameInstance(sourceName, targetInstance, allowExistingTargets, additionalReferences, weakReferences, merge);
    }

    public CIMObjectpathList renameInstance(CIMInstancename sourceName, CIMInstance targetInstance) throws CIMClientException, LcrException {
        return this.renameInstance(sourceName, targetInstance, true, true, true, true);
    }

    public void setProperty(CIMInstancename instanceName, String propertyName, CIMPropertyValue newValue) throws CIMClientException, LcrException {
        this.clientImpl.setProperty(instanceName, propertyName, newValue);
    }

    public void setProperty(String className, String keyvalue, String propertyName, String newValue) throws CIMClientException, LcrException {
        CIMKeyValue aCIMKeyValue = CIMFactory.keyValue(keyvalue);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeyValue);
        CIMPropertyValue aPropertyValue = newValue == null ? null : CIMFactory.propertyValue(newValue);
        this.setProperty(aCIMInstancename, propertyName, aPropertyValue);
    }

    public void setProperty(String className, String[] keys, String[] values, String propertyName, String newValue) throws CIMClientException, LcrException {
        this.setProperty(className, keys, values, null, propertyName, newValue);
    }

    public void setProperty(String className, String[] keys, String[] values, String[] types, String propertyName, String newValue) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values, types);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        CIMPropertyValue aPropertyValue = newValue == null ? null : CIMFactory.propertyValue(newValue);
        this.setProperty(aCIMInstancename, propertyName, aPropertyValue);
    }

    public void setProperty(String className, String keyvalue, String propertyName, String[] newValue) throws CIMClientException, LcrException {
        CIMKeyValue aCIMKeyValue = CIMFactory.keyValue(keyvalue);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeyValue);
        CIMPropertyValue aPropertyValue = newValue == null ? null : CIMFactory.propertyValue(newValue);
        this.setProperty(aCIMInstancename, propertyName, aPropertyValue);
    }

    public void setProperty(String className, String[] keys, String[] values, String propertyName, String[] newValue) throws CIMClientException, LcrException {
        this.setProperty(className, keys, values, null, propertyName, newValue);
    }

    public void setProperty(String className, String[] keys, String[] values, String[] types, String propertyName, String[] newValue) throws CIMClientException, LcrException {
        CIMKeybindingList aCIMKeybindingList = CIMFactory.keybindingList(keys, values, types);
        CIMInstancename aCIMInstancename = CIMFactory.instancename(className, aCIMKeybindingList);
        CIMPropertyValue aPropertyValue = newValue == null ? null : CIMFactory.propertyValue(newValue);
        this.setProperty(aCIMInstancename, propertyName, aPropertyValue);
    }

    public void setProperty(CIMObjectReference instanceRef, String propertyName, CIMPropertyValue newValue) throws CIMClientException, LcrException {
        this.setProperty(instanceRef.toCIMInstancename(), propertyName, newValue);
    }

    public void setProperty(CIMObjectReference instanceRef, String propertyName, String newValue) throws CIMClientException, LcrException {
        this.setProperty(instanceRef.toCIMInstancename(), propertyName, newValue == null ? null : CIMFactory.propertyValue(newValue));
    }

    public void setProperty(CIMObjectReference instanceRef, String propertyName, String[] newValue) throws CIMClientException, LcrException {
        this.setProperty(instanceRef.toCIMInstancename(), propertyName, newValue == null ? null : CIMFactory.propertyValue(newValue));
    }

    public void setProperty(String instanceName, String propertyName, CIMPropertyValue newValue) throws CIMClientException, LcrException {
        this.setProperty(CIMFactory.createInstancenameFromString(instanceName), propertyName, newValue);
    }

    public void setProperty(String instanceName, String propertyName, String newValue) throws CIMClientException, LcrException {
        this.setProperty(CIMFactory.createInstancenameFromString(instanceName), propertyName, newValue == null ? null : CIMFactory.propertyValue(newValue));
    }

    public void setProperty(String instanceName, String propertyName, String[] newValue) throws CIMClientException, LcrException {
        this.setProperty(CIMFactory.createInstancenameFromString(instanceName), propertyName, newValue == null ? null : CIMFactory.propertyValue(newValue));
    }

    public void setProviderSyncTime(CIMInstancename instanceName, Date date) throws CIMClientException, LcrException {
        this.clientImpl.setProviderSyncTime(instanceName, date);
    }

    public void setProviderSyncTime(CIMInstancename instanceName) throws CIMClientException, LcrException {
        this.setProviderSyncTime(instanceName, null);
    }

    public void setQualifier(CIMQualifierDeclaration qualifierDeclaration) throws CIMClientException, LcrException {
        this.clientImpl.setQualifier(qualifierDeclaration);
    }

    public CIMObjectpathList listAssociatorNames(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(className, assocClass, resultClass, role, resultRole);
    }

    public CIMObjectpathList listAssociatorNames(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(instanceName, assocClass, resultClass, role, resultRole);
    }

    public CIMObjectpathList listAssociatorNames(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole) throws CIMClientException, LcrException {
        return this.clientImpl.associatorNames(objectName, assocClass, resultClass, role, resultRole);
    }

    public CIMValueObjectWithPathList listAssociators(CIMObjectname objectName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList listAssociators(CIMClassname className, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(className, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList listAssociators(CIMInstancename instanceName, CIMClassname assocClass, CIMClassname resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.associators(instanceName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMClassList listClasses(CIMClassname className, boolean deepInheritance, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateClasses(className, deepInheritance, localOnly, includeQualifiers, includeClassOrigin);
    }

    public CIMClassnameList listClassNames(CIMClassname className, boolean deepInheritance) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateClassNames(className, deepInheritance);
    }

    public CIMInstancenameList listInstanceNames(CIMClassname className) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstanceNames(className);
    }

    public CIMInstancenameList listInstanceNamesNoSubclasses(CIMClassname className) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstanceNamesNoSubclasses(className);
    }

    public CIMValueNamedInstanceList listInstances(CIMClassname className, boolean localOnly, boolean deepInheritance, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstances(className, localOnly, deepInheritance, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueNamedInstanceList listInstancesNoSubclasses(CIMClassname className, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.enumerateInstancesNoSubclasses(className, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMObjectpathList listReferenceNames(CIMObjectname objectName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(objectName, resultClass, role);
    }

    public CIMObjectpathList listReferenceNames(CIMClassname className, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(className, resultClass, role);
    }

    public CIMObjectpathList listReferenceNames(CIMInstancename instanceName, CIMClassname resultClass, String role) throws CIMClientException, LcrException {
        return this.clientImpl.referenceNames(instanceName, resultClass, role);
    }

    public CIMValueObjectWithPathList listReferences(CIMObjectname objectName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList listReferences(CIMClassname className, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(className, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValueObjectWithPathList listReferences(CIMInstancename instanceName, CIMClassname resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMClientException, LcrException {
        return this.clientImpl.references(instanceName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMBatchResult performBatchOperation(CIMBatchHandle batch) throws CIMClientException, LcrException {
        return this.clientImpl.performBatchOperation(batch);
    }
}

