/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import java.io.PrintWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private PrintWriter out;

    public XMLErrorHandler(PrintWriter out) {
        this.out = out;
    }

    private String getParseExceptionInfo(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ":\n" + spe.getMessage();
        return info;
    }

    public void warning(SAXParseException spe) throws SAXException {
        this.out.println("XML parse warning:\n" + this.getParseExceptionInfo(spe));
    }

    public void error(SAXParseException spe) throws SAXException {
        String message = "XML parse error:\n" + this.getParseExceptionInfo(spe);
        throw new SAXException(message);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        String message = "XML parse fatal error:\n" + this.getParseExceptionInfo(spe);
        throw new SAXException(message);
    }
}

