/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassList;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMPropertyReferenceList;
import com.sap.lcr.api.cim.CIMValueNamedObjectList;
import com.sap.lcr.api.cim.CIMValueObjectList;
import com.sap.lcr.api.cim.CIMValueObjectWithPathList;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjectContainer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class Sort {
    private static final Object INSTANCE_LIST_KEY = class$com$sap$lcr$api$cim$CIMInstance == null ? (class$com$sap$lcr$api$cim$CIMInstance = Sort.class$("com.sap.lcr.api.cim.CIMInstance")) : class$com$sap$lcr$api$cim$CIMInstance;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMInstance;

    private Sort() {
    }

    public static void sortClasses(CIMClassList classes, ClassPrerequisite[] prerequisites) {
        Sort.sortClassItems(classes, false, prerequisites);
    }

    public static void sortClasses(CIMValueObjectList list, ClassPrerequisite[] prerequisites) {
        Sort.sortClassItems(list, true, prerequisites);
    }

    public static void sortClasses(CIMValueNamedObjectList list, ClassPrerequisite[] prerequisites) {
        Sort.sortClassItems(list, true, prerequisites);
    }

    public static void sortClasses(CIMValueObjectWithPathList list, ClassPrerequisite[] prerequisites) {
        Sort.sortClassItems(list, true, prerequisites);
    }

    private static void sortClassItems(CIMItemList list, boolean isContainerList, ClassPrerequisite[] prerequisites) {
        HashMap dependencyMap = Sort.collectClassDependencyInfo(list, isContainerList, prerequisites);
        ArrayList instanceList = (ArrayList)dependencyMap.remove(INSTANCE_LIST_KEY);
        int nextIndex = 0;
        int numLeft = dependencyMap.size();
        boolean skipAssocs = true;
        while (numLeft > 0) {
            int numLeftPrevious = numLeft;
            int numLeftObjectClasses = 0;
            numLeft = 0;
            Iterator iter = dependencyMap.values().iterator();
            while (iter.hasNext()) {
                ClassDependencyInfo nextInfo = (ClassDependencyInfo)iter.next();
                if (nextInfo.processed) continue;
                if (nextInfo.isAssociation && skipAssocs) {
                    ++numLeft;
                    continue;
                }
                if (!Sort.dependenciesResolved(nextInfo, dependencyMap)) {
                    if (!nextInfo.isAssociation) {
                        ++numLeftObjectClasses;
                    }
                    ++numLeft;
                    continue;
                }
                list.setReadOnly(nextIndex++, nextInfo.listItem);
                nextInfo.processed = true;
            }
            if (skipAssocs && numLeftObjectClasses == 0) {
                skipAssocs = false;
            }
            if (numLeft < numLeftPrevious) continue;
            throw new IllegalArgumentException("Unresolvable dependencies due to invalid model or prerequisites");
        }
        if (instanceList != null) {
            int i = 0;
            while (i < instanceList.size()) {
                CIMItem instanceItem = (CIMItem)instanceList.get(i);
                list.setReadOnly(nextIndex++, instanceItem);
                ++i;
            }
        }
    }

    private static HashMap collectClassDependencyInfo(CIMItemList list, boolean isContainerList, ClassPrerequisite[] prerequisites) {
        int i;
        HashMap<Object, Object> classDependencyMap = new HashMap<Object, Object>();
        ArrayList<CIMItem> instanceList = null;
        HashMap<CIMClassname, ClassPrerequisite> prerequisiteMap = null;
        if (prerequisites != null && prerequisites.length != 0) {
            prerequisiteMap = new HashMap<CIMClassname, ClassPrerequisite>();
            i = 0;
            while (i < prerequisites.length) {
                ClassPrerequisite prerequisite = prerequisites[i];
                prerequisiteMap.put(prerequisite.dependent, prerequisite);
                ++i;
            }
        }
        i = 0;
        while (i < list.size()) {
            CIMClass cls;
            CIMItem item = list.getItem(i);
            CIMClass cIMClass = cls = isContainerList ? ((ICIMObjectContainer)((Object)item)).getCimClass() : (CIMClass)item;
            if (cls == null) {
                if (instanceList == null) {
                    instanceList = new ArrayList<CIMItem>();
                }
                instanceList.add(item);
            } else {
                CIMClassname classname = cls.getCIMClassname();
                if (classDependencyMap.containsKey(classname)) {
                    throw new IllegalArgumentException(MessageFormat.format("Duplicate occurrence of {0} in list", classname.toDisplayString()));
                }
                ClassDependencyInfo classDependencyInfo = new ClassDependencyInfo(cls, item);
                classDependencyMap.put(classname, classDependencyInfo);
                CIMClassname superClassName = cls.getCIMSuperclassname();
                if (superClassName != null) {
                    classDependencyInfo.addDependency(superClassName);
                }
            }
            ++i;
        }
        Iterator iter = classDependencyMap.values().iterator();
        while (iter.hasNext()) {
            ClassDependencyInfo superInfo;
            ClassDependencyInfo nextInfo = (ClassDependencyInfo)iter.next();
            CIMClassname superClassname = nextInfo.cls.getCIMSuperclassname();
            if (superClassname == null || (superInfo = (ClassDependencyInfo)classDependencyMap.get(superClassname)) == null) continue;
            superInfo.addDirectSubclass(nextInfo.cls.getCIMClassname());
        }
        Iterator iter2 = classDependencyMap.values().iterator();
        while (iter2.hasNext()) {
            ClassPrerequisite prerequisite;
            ClassDependencyInfo classDependencyInfo = (ClassDependencyInfo)iter2.next();
            CIMClass cls = classDependencyInfo.cls;
            if (cls.isAssociation()) {
                ClassDependencyInfo weakClassDependencyInfo;
                classDependencyInfo.isAssociation = true;
                CIMClassname weakClassName = null;
                CIMPropertyReferenceList propRefs = cls.getPropertyReferences();
                int p = 0;
                while (p < propRefs.size()) {
                    CIMPropertyReference propRef = propRefs.get(p);
                    CIMClassname refClassName = Sort.getRefClassName(propRef);
                    if (refClassName != null) {
                        classDependencyInfo.addDependency(refClassName);
                        Sort.addSubclassDependencies(classDependencyInfo, classDependencyMap, refClassName);
                        if (propRef.isWeak()) {
                            if (weakClassName != null) {
                                throw new IllegalArgumentException(MessageFormat.format("Illegal multiple weak references found in {0}", cls.getClassname()));
                            }
                            weakClassName = refClassName;
                        }
                    }
                    ++p;
                }
                if (weakClassName != null && (weakClassDependencyInfo = (ClassDependencyInfo)classDependencyMap.get(weakClassName)) != null) {
                    int p2 = 0;
                    while (p2 < propRefs.size()) {
                        CIMClassname strongName;
                        CIMPropertyReference propRef = propRefs.get(p2);
                        if (!propRef.isWeak() && (strongName = Sort.getRefClassName(propRef)) != null && !strongName.equals(weakClassName)) {
                            weakClassDependencyInfo.addDependency(strongName);
                        }
                        ++p2;
                    }
                }
            }
            if (prerequisiteMap == null || (prerequisite = (ClassPrerequisite)prerequisiteMap.get(cls.getCIMClassname())) == null) continue;
            int d = 0;
            while (d < prerequisite.dependencies.length) {
                CIMClassname dependencyName = prerequisite.dependencies[d];
                classDependencyInfo.addDependency(dependencyName);
                if (prerequisite.propagateToSubclasses) {
                    Sort.propagateDependencyToSubclasses(classDependencyInfo, classDependencyMap, dependencyName);
                }
                ++d;
            }
        }
        if (instanceList != null) {
            classDependencyMap.put(INSTANCE_LIST_KEY, instanceList);
        }
        return classDependencyMap;
    }

    private static boolean dependenciesResolved(ClassDependencyInfo info, HashMap classDependencyMap) {
        HashSet dependencyNames = info.dependencyClassNames;
        if (dependencyNames == null || dependencyNames.size() == 0) {
            return true;
        }
        Iterator iter = dependencyNames.iterator();
        while (iter.hasNext()) {
            CIMClassname nextName = (CIMClassname)iter.next();
            ClassDependencyInfo nextInfo = (ClassDependencyInfo)classDependencyMap.get(nextName);
            if (nextInfo == null || nextInfo.processed) continue;
            return false;
        }
        return true;
    }

    private static void propagateDependencyToSubclasses(ClassDependencyInfo info, HashMap dependencyMap, CIMClassname dependencyName) {
        if (info.directSubclassNames != null) {
            int i = 0;
            while (i < info.directSubclassNames.size()) {
                CIMClassname subclassName = info.directSubclassNames.get(i);
                ClassDependencyInfo subclassInfo = (ClassDependencyInfo)dependencyMap.get(subclassName);
                subclassInfo.addDependency(dependencyName);
                Sort.propagateDependencyToSubclasses(subclassInfo, dependencyMap, dependencyName);
                ++i;
            }
        }
    }

    private static void addSubclassDependencies(ClassDependencyInfo info, HashMap dependencyMap, CIMClassname dependencyName) {
        CIMClassnameList subDependencies;
        ClassDependencyInfo subDependenciesInfo = (ClassDependencyInfo)dependencyMap.get(dependencyName);
        if (subDependenciesInfo != null && (subDependencies = subDependenciesInfo.directSubclassNames) != null) {
            int i = 0;
            while (i < subDependencies.size()) {
                CIMClassname subDependencyName = subDependencies.get(i);
                info.addDependency(subDependencyName);
                Sort.addSubclassDependencies(info, dependencyMap, subDependencyName);
                ++i;
            }
        }
    }

    private static CIMClassname getRefClassName(CIMPropertyReference propRef) {
        String refClassNameString;
        CIMClassname refClassName = null;
        CIMValueReference valRef = propRef.getValueReference();
        if (valRef != null) {
            refClassName = valRef.getCIMClassname();
        }
        if (refClassName == null && (refClassNameString = propRef.getReferenceClass()) != null) {
            refClassName = CIMFactory.classname(refClassNameString);
        }
        return refClassName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassDependencyInfo {
        final CIMClass cls;
        final CIMItem listItem;
        boolean isAssociation;
        boolean processed;
        HashSet dependencyClassNames;
        CIMClassnameList directSubclassNames;

        ClassDependencyInfo(CIMClass cls, CIMItem listItem) {
            this.cls = cls;
            this.listItem = listItem;
        }

        void addDependency(CIMClassname classname) {
            if (this.dependencyClassNames == null) {
                this.dependencyClassNames = new HashSet();
            }
            this.dependencyClassNames.add(classname);
        }

        void addDirectSubclass(CIMClassname subClassname) {
            if (this.directSubclassNames == null) {
                this.directSubclassNames = CIMFactory.classnameList();
            }
            this.directSubclassNames.add(subClassname);
        }
    }

    public static final class ClassPrerequisite {
        final CIMClassname dependent;
        final CIMClassname[] dependencies;
        final boolean propagateToSubclasses;

        public ClassPrerequisite(CIMClassname dependent, CIMClassname[] dependencies, boolean propagateToSubclasses) {
            this.dependent = dependent;
            this.dependencies = dependencies;
            this.propagateToSubclasses = propagateToSubclasses;
        }

        public ClassPrerequisite(CIMClassname dependent, CIMClassname dependency, boolean propagateToSubclasses) {
            this(dependent, new CIMClassname[]{dependency}, propagateToSubclasses);
        }

        public ClassPrerequisite(CIMClassname dependent, CIMClassname[] dependencies) {
            this(dependent, dependencies, false);
        }

        public ClassPrerequisite(CIMClassname dependent, CIMClassname dependency) {
            this(dependent, new CIMClassname[]{dependency}, false);
        }
    }
}

