/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cimclient.WrapperException;
import java.text.MessageFormat;

public class ItemConstructionExcp
extends WrapperException {
    public static final int NoAddAllowed = 0;
    public static final int NoSetAttributes = 1;
    public static final int NoSetCharacters = 2;
    public static final int UnrecognizedTag = 3;
    public static final int NoEndForCim = 4;
    public static final int FileNotFound = 5;
    public static final int ConstructionFailed = 6;
    public static final int NoMergeSupported = 7;
    public static final int XMLInvalid = 8;
    public static final int DataAfterComplete = 9;
    public static final int IllegalCIMType = 10;
    public static final int RequiredAttributeMissing = 11;
    public static final int UnresolvableMergeConflict = 12;
    public static final int ArraySizeMismatch = 13;
    public static final int AttributeNotAllowed = 14;
    public static final int MergeTypeMismatch = 15;
    private static final String[] Errmsg = new String[]{"No add-method of this kind allowed", "No setAttributes allowed", "No setCharacters allowed", "Tag not recognized", "No endXmlBuild for CIM", "XML file not found", "Construction failed", "Merge not supported", "Invalid XML encountered", "More data after closing xml tag encountered", "Illegal CIM type", "Required attribute missing", "Unresolvable merge conflict detected", "Size mismatch of array parameters", "Attribute not allowed", "Type mismatch in merge"};
    private static final String OutOfBoundsMsg = "*** Unknown errorcode ***";
    private final int errorcode;
    private StringBuffer extendedMessage;

    static String getErrmsg(int errcode) {
        if (errcode >= 0 || errcode < Errmsg.length) {
            return Errmsg[errcode];
        }
        return OutOfBoundsMsg;
    }

    static ItemConstructionExcp createDuplicateSubelementExcp(ICIMItem parent, ICIMItem child) {
        return new ItemConstructionExcp(8, "Cannot add more than one {0} subelement to {1}", new Object[]{child.getDTDName(), CIMUtil.getQualifiedName(parent)});
    }

    static ItemConstructionExcp createUnexpectedSubelementExcp(ICIMItem parent, ICIMItem newChild, ICIMItem oldChild) {
        return new ItemConstructionExcp(8, "Cannot add {0} to {1} with subelement {2}", new Object[]{CIMUtil.getQualifiedName(newChild), CIMUtil.getQualifiedName(parent), CIMUtil.getQualifiedName(oldChild)});
    }

    static ItemConstructionExcp createNoAddAllowedExcp(ICIMItem itemToAdd, ICIMItem receivingItem) {
        return new ItemConstructionExcp(0, "Cannot add {0} to {1}", new Object[]{CIMUtil.getQualifiedName(itemToAdd), CIMUtil.getQualifiedName(receivingItem)});
    }

    static ItemConstructionExcp createAttributeNotAllowedExcp(String attributeName, CIMItem item) {
        return new ItemConstructionExcp(14, "Attribute {0} not allowed for element {1}", new Object[]{attributeName, item.getDTDName()});
    }

    static ItemConstructionExcp createMergeMismatchException(ICIMItem target, ICIMItem source) {
        return new ItemConstructionExcp(15, "Can not merge {0} and {1}", new Object[]{target.getDTDName(), source.getDTDName()});
    }

    static ItemConstructionExcp createRequiredAttributeMissingExcp(String attribute, ICIMItem item) {
        return new ItemConstructionExcp(11, "Required attribute {0} missing for element {1}", new Object[]{attribute, item.getDTDName()});
    }

    static ItemConstructionExcp createInvalidIntegerAttributeExcp(String invalidValue, String attribute, ICIMItem item) {
        return new ItemConstructionExcp(8, "{0} is not a valid integer value for attribute {1} in {2}", new Object[]{invalidValue, attribute, item.getDTDName()});
    }

    public ItemConstructionExcp(Exception e) {
        super(e);
        this.errorcode = -1;
    }

    public ItemConstructionExcp(String msg) {
        super(msg);
        this.errorcode = -1;
    }

    public ItemConstructionExcp(int e) {
        super(ItemConstructionExcp.getErrmsg(e));
        this.errorcode = e;
    }

    public ItemConstructionExcp(int e, String msg) {
        super(msg);
        this.errorcode = e;
    }

    public ItemConstructionExcp(int e, String pattern, Object[] arguments) {
        super(MessageFormat.format(pattern, arguments));
        this.errorcode = e;
    }

    ItemConstructionExcp(String pattern, Object[] arguments) {
        this(MessageFormat.format(pattern, arguments));
    }

    public ItemConstructionExcp(int e, CIMItem anItem) {
        super(anItem.getDTDName() + ": " + ItemConstructionExcp.getErrmsg(e));
        this.errorcode = e;
    }

    public int getErrorcode() {
        return this.errorcode;
    }

    public String getMessage() {
        return this.extendedMessage != null ? this.extendedMessage.toString() : super.getMessage();
    }

    void setXmlStackTrace(String xmlStackTrace) {
        if (xmlStackTrace != null) {
            String message = super.getMessage();
            this.extendedMessage = new StringBuffer(message.length() + CIMConstants.NEWLINE.length() + xmlStackTrace.length());
            this.extendedMessage.append(message).append(CIMConstants.NEWLINE).append(xmlStackTrace);
        }
    }

    void appendToMessage(ICIMItem item) {
        if (this.extendedMessage == null) {
            this.extendedMessage = new StringBuffer(super.getMessage());
        }
        this.extendedMessage.append(" in ");
        this.extendedMessage.append(CIMUtil.getQualifiedName(item));
    }
}

