/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class CanonicalizedStrings {
    private final HashMap map;

    public CanonicalizedStrings() {
        this.map = new HashMap();
    }

    public CanonicalizedStrings(int initialCapacity) {
        this.map = new HashMap(1 + 4 * initialCapacity / 3);
    }

    public CanonicalizedStrings(String[] names) {
        this(names.length);
        this.addAll(names);
    }

    public void add(String name) {
        this.map.put(name.toLowerCase(), name);
    }

    public void addAll(Collection names) {
        this.addAll(names.toArray(new String[names.size()]));
    }

    public void addAll(String[] names) {
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            this.map.put(name.toLowerCase(), name);
            ++i;
        }
    }

    public void addTo(Collection collection) {
        collection.addAll(this.map.values());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(String name) {
        return this.map.containsKey(name.toLowerCase());
    }

    public String get(String name) {
        return (String)this.map.get(name.toLowerCase());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public void remove(String name) {
        this.map.remove(name.toLowerCase());
    }

    public int size() {
        return this.map.size();
    }

    public String[] toArray() {
        Collection collection = this.map.values();
        return collection.toArray(new String[collection.size()]);
    }
}

