/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;

public final class CIMValue
extends CIMItem {
    public static final String DTD_NAME = "VALUE";
    private String value = "";

    protected CIMValue() {
        super(true);
    }

    protected CIMValue(String aValue) {
        super(true);
        if (aValue == null) {
            throw new NullPointerException("String value of VALUE tag must not be null.");
        }
        this.value = aValue.trim();
    }

    protected CIMValue(int aValue) {
        this(Integer.toString(aValue));
    }

    protected CIMValue(boolean aBooleanValue) {
        this(aBooleanValue ? "true" : "false");
    }

    public CIMValue toWritable() {
        return (CIMValue)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CIMValue) {
            return ((CIMValue)obj).value.equals(this.value);
        }
        return false;
    }

    public boolean equals(String arg) {
        return this.value.equals(arg);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    void trim() {
        this.value = this.value.trim();
    }

    void setCharacters(String nextChunk) {
        this.value = this.value + nextChunk;
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        this.trim();
        parentItem.addValue(this);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        if (this.value.length() == 0) {
            this.appendXml(writer, DTD_NAME, indent);
        } else {
            this.appendXml(writer, DTD_NAME, this.value, indent);
        }
    }

    public String getStringvalue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean isTrue() {
        return this.value.equalsIgnoreCase("true");
    }

    public boolean isFalse() {
        return this.value.equalsIgnoreCase("false");
    }

    public boolean isBoolean() {
        return this.isFalse() || this.isTrue();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        this.validateStringForXml(this.value, DTD_NAME);
    }
}

