/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMClassnameList;
import com.sap.lcr.api.cim.CIMConstants;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMObjectpathList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMPropertyReferenceList;
import com.sap.lcr.api.cim.CIMQualifier;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.ClientUtil;
import com.sap.lcr.api.cimclient.LcrException;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class CIMUtil {
    public static final BigInteger MAXUINT8 = new BigInteger("FF", 16);
    public static final BigInteger MAXUINT16 = new BigInteger("FFff", 16);
    public static final BigInteger MAXUINT32 = new BigInteger("FFffFFff", 16);
    public static final BigInteger MAXUINT64 = new BigInteger("FFffFFffFFffFFff", 16);
    public static final BigInteger MAXSINT8 = BigInteger.valueOf(127L);
    public static final BigInteger MAXSINT16 = BigInteger.valueOf(32767L);
    public static final BigInteger MAXSINT32 = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MAXSINT64 = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MINSINT8 = BigInteger.valueOf(-128L);
    public static final BigInteger MINSINT16 = BigInteger.valueOf(-32768L);
    public static final BigInteger MINSINT32 = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MINSINT64 = BigInteger.valueOf(Long.MIN_VALUE);
    public static final Comparator CIM_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s2;
            String s1;
            if (o1 instanceof ICIMNamedElement) {
                s1 = ((ICIMNamedElement)o1).getName();
                s2 = ((ICIMNamedElement)o2).getName();
            } else {
                s1 = (String)o1;
                s2 = (String)o2;
            }
            return s1.compareToIgnoreCase(s2);
        }
    };
    private static final char DELIMITERCHAR = '\"';
    private static final char ESCAPECHAR = '\\';

    private CIMUtil() {
    }

    static void checkCIMType(String type) throws ItemConstructionExcp {
        if (!CIMUtil.isValidCIMType(type)) {
            throw new ItemConstructionExcp(10, "Illegal CIM type: " + type);
        }
    }

    public static boolean isValidCIMType(String aType) {
        if (aType.equals("boolean")) {
            return true;
        }
        if (aType.equals("string")) {
            return true;
        }
        if (aType.equals("char16")) {
            return true;
        }
        if (aType.equals("uint8")) {
            return true;
        }
        if (aType.equals("sint8")) {
            return true;
        }
        if (aType.equals("uint16")) {
            return true;
        }
        if (aType.equals("sint16")) {
            return true;
        }
        if (aType.equals("uint32")) {
            return true;
        }
        if (aType.equals("sint32")) {
            return true;
        }
        if (aType.equals("uint64")) {
            return true;
        }
        if (aType.equals("sint64")) {
            return true;
        }
        if (aType.equals("datetime")) {
            return true;
        }
        if (aType.equals("real32")) {
            return true;
        }
        return aType.equals("real64");
    }

    public static boolean equalsBoolean(CIMValue value1, CIMValue value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.getStringvalue().equalsIgnoreCase(value2.getStringvalue());
    }

    public static boolean equalsBoolean(CIMValueArray array1, CIMValueArray array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.size() != array2.size()) {
            return false;
        }
        int i = 0;
        while (i < array1.size()) {
            String two;
            String one = array1.get(i).getStringvalue();
            if (!one.equalsIgnoreCase(two = array2.get(i).getStringvalue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static ArrayList cloneCIMItems(ArrayList list) {
        ArrayList clone = (ArrayList)list.clone();
        int size = clone.size();
        int i = 0;
        while (i < size) {
            CIMItem item = (CIMItem)clone.get(i);
            clone.set(i, item.clone());
            ++i;
        }
        return clone;
    }

    public static String date2CimDateTime(Date date) {
        return CIMUtil.date2CimDateTime(date, 0);
    }

    public static String date2CimDateTime(Date date, int microSeconds) {
        if (microSeconds < 0 || microSeconds > 999) {
            throw new IllegalArgumentException("Illegal microsecond value: " + microSeconds);
        }
        StringBuffer buf = new StringBuffer(25);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        CIMUtil.appendNumber(buf, calendar.get(1), 4);
        CIMUtil.appendNumber(buf, 1 + calendar.get(2), 2);
        CIMUtil.appendNumber(buf, calendar.get(5), 2);
        CIMUtil.appendNumber(buf, calendar.get(11), 2);
        CIMUtil.appendNumber(buf, calendar.get(12), 2);
        CIMUtil.appendNumber(buf, calendar.get(13), 2);
        buf.append('.');
        CIMUtil.appendNumber(buf, calendar.get(14), 3);
        CIMUtil.appendNumber(buf, microSeconds, 3);
        int utcCorrection = (calendar.get(15) + calendar.get(16)) / 60000;
        if (utcCorrection < 0) {
            buf.append('-');
            utcCorrection = -utcCorrection;
        } else {
            buf.append("+");
        }
        CIMUtil.appendNumber(buf, utcCorrection, 3);
        return buf.toString();
    }

    private static void appendNumber(StringBuffer buf, int num, int len) {
        String numString = String.valueOf(num);
        int diff = len - numString.length();
        int i = 0;
        while (i < diff) {
            buf.append('0');
            ++i;
        }
        buf.append(numString);
    }

    public static Date cimDateTime2Date(String cimDate) throws LcrException {
        Date parsedDate;
        if (cimDate.length() != 25) {
            throw new LcrException("CIM datetime must have 25 characters: " + cimDate);
        }
        if (cimDate.charAt(21) == ':') {
            throw new LcrException("Can not convert a CIM datetime interval: " + cimDate);
        }
        try {
            parsedDate = new SimpleDateFormat("yyyyMMddHHmmss'.'SSS", Locale.GERMANY).parse(cimDate.substring(0, 18));
        }
        catch (ParseException ex) {
            throw new LcrException(ex);
        }
        int utcCorrection = Integer.parseInt(cimDate.substring(22));
        if (cimDate.charAt(21) == '-') {
            utcCorrection = -utcCorrection;
        }
        long utcTime = parsedDate.getTime() - (long)(60000 * utcCorrection);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(utcTime));
        int localUtcCorrection = calendar.get(15) + calendar.get(16);
        return new Date(utcTime + (long)localUtcCorrection);
    }

    public static boolean isWritingCimMethod(String method) {
        int i = 0;
        while (i < CIMConstants.CIM_WRITING_MESSAGES.length) {
            if (method.equals(CIMConstants.CIM_WRITING_MESSAGES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTrue(String value) {
        return "true".equalsIgnoreCase(value);
    }

    public static boolean isFalse(String value) {
        return "false".equalsIgnoreCase(value);
    }

    private static void appendXmlAttribute(Writer writer, String name, String value, boolean noEscape) throws IOException {
        writer.write(32);
        writer.write(name);
        writer.write("=\"");
        if (noEscape) {
            writer.write(value);
        } else {
            CIMUtil.appendXmlEscaped(writer, value);
        }
        writer.write(34);
    }

    static void appendXmlAttribute(Writer writer, String name, boolean value) throws IOException {
        CIMUtil.appendXmlAttribute(writer, name, value ? "true" : "false", true);
    }

    static void appendXmlAttribute(Writer writer, String name, int value) throws IOException {
        CIMUtil.appendXmlAttribute(writer, name, Integer.toString(value), true);
    }

    static void appendXmlAttributeUnescaped(Writer writer, String name, String value) throws IOException {
        CIMUtil.appendXmlAttribute(writer, name, value, true);
    }

    static void appendXmlAttributeEscaped(Writer writer, String name, String value) throws IOException {
        CIMUtil.appendXmlAttribute(writer, name, value, false);
    }

    static void appendXmlEscaped(Writer writer, String text) throws IOException {
        int wlen;
        int len = text.length();
        int start = 0;
        int i = 0;
        while (i < len) {
            String escape;
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    escape = "&#xA;";
                    break;
                }
                case '\r': {
                    escape = "&#xD;";
                    break;
                }
                case '<': {
                    escape = "&lt;";
                    break;
                }
                case '>': {
                    escape = "&gt;";
                    break;
                }
                case '&': {
                    escape = "&amp;";
                    break;
                }
                case '\"': {
                    escape = "&quot;";
                    break;
                }
                case '\'': {
                    escape = "&apos;";
                    break;
                }
                default: {
                    escape = null;
                }
            }
            if (escape != null) {
                wlen = i - start;
                if (wlen > 0) {
                    writer.write(text, start, wlen);
                }
                start = i + 1;
                writer.write(escape);
            }
            ++i;
        }
        wlen = len - start;
        if (wlen > 0) {
            writer.write(text, start, wlen);
        }
    }

    static boolean string2boolean(String aString) throws ItemConstructionExcp {
        if ("true".equalsIgnoreCase(aString)) {
            return true;
        }
        if ("false".equalsIgnoreCase(aString)) {
            return false;
        }
        throw new ItemConstructionExcp(6, aString + " is not a valid boolean value");
    }

    public static String cimType2keypropertyType(String aCIMType) {
        if (aCIMType.equals("string") || aCIMType.equals("datetime")) {
            return "string";
        }
        if (aCIMType.equals("boolean")) {
            return "boolean";
        }
        if (aCIMType.equals("char16") || aCIMType.equals("uint8") || aCIMType.equals("sint8") || aCIMType.equals("uint16") || aCIMType.equals("sint16") || aCIMType.equals("uint32") || aCIMType.equals("sint32") || aCIMType.equals("uint64") || aCIMType.equals("sint64") || aCIMType.equals("real32") || aCIMType.equals("real64") || aCIMType.equals("numeric")) {
            return "numeric";
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static int getStringPatternMatches(String pattern, String text, int mode, int[][] found) {
        charList = new StringBuffer();
        savedPos = new ArrayList<int[]>();
        lcmode = 0;
        ilc = 0;
        jlc = false;
        if (mode < 0) {
            maxStartPos = -mode;
            ipos = maxStartPos - 1;
            maxMatchesToSearch = 1;
            equal = false;
        } else if (mode > 0) {
            maxStartPos = 0x7FFFFFFF;
            ipos = 0;
            maxMatchesToSearch = mode < found.length ? mode : found.length;
            equal = false;
        } else {
            maxStartPos = 1;
            ipos = 0;
            maxMatchesToSearch = 1;
            equal = true;
        }
        matches = 0;
        while (matches < maxMatchesToSearch && ipos < maxStartPos) {
            posText = ipos;
            mask = false;
            varpart = false;
            savedPos.clear();
            posPattern = 0;
            block9: while (posPattern < pattern.length() || equal) {
                block48: {
                    block46: {
                        block47: {
                            lcmode = 0;
                            isMatching = true;
                            if (posPattern < pattern.length()) break block46;
                            if (posText >= text.length()) break block47;
                            isMatching = false;
                            ** GOTO lbl-1000
                        }
                        equal = false;
                        --posPattern;
                        break block48;
                    }
                    switch (pattern.charAt(posPattern)) {
                        case '\\': {
                            if (!mask) {
                                mask = true;
                                break;
                            }
                            ** GOTO lbl78
                        }
                        case '.': {
                            if (!mask) {
                                if (posText++ < text.length()) break;
                                isMatching = false;
                            }
                            ** GOTO lbl78
                        }
                        case '*': {
                            if (!mask) {
                                varpart = true;
                                break;
                            }
                            ** GOTO lbl78
                        }
                        case '^': {
                            if (posPattern == 0) {
                                maxStartPos = 1;
                                break;
                            }
                            ** GOTO lbl78
                        }
                        case '$': {
                            if (!mask && posPattern == pattern.length() - 1) {
                                equal = true;
                                break;
                            }
                            ** GOTO lbl78
                        }
                        case '[': {
                            if (!mask) {
                                charList.delete(0, charList.length());
                                lcmode = pattern.charAt(++posPattern) == '^' ? -1 : 1;
                                startPos = ++posPattern;
                                bracketPos = pattern.indexOf(93, startPos);
                                posPattern = bracketPos == -1 ? pattern.length() - 1 : bracketPos;
                                endPos = bracketPos == -1 ? pattern.length() : bracketPos;
                                charList.append(pattern.substring(startPos, endPos));
                            }
                        }
lbl78:
                        // 9 sources

                        default: lbl-1000:
                        // 2 sources

                        {
                            if (isMatching) {
                                mask = false;
                                if (posText < text.length()) {
                                    if (varpart) {
                                        while (posText < text.length()) {
                                            poc = text.charAt(posText);
                                            if (lcmode > 0) {
                                                ilc = 0;
                                                jlc = false;
                                                while (ilc < charList.length()) {
                                                    if (poc == charList.charAt(ilc)) {
                                                        jlc = true;
                                                    }
                                                    ++ilc;
                                                }
                                            } else if (lcmode < 0) {
                                                ilc = 0;
                                                jlc = true;
                                                while (ilc < charList.length()) {
                                                    if (poc == charList.charAt(ilc)) {
                                                        jlc = false;
                                                    }
                                                    ++ilc;
                                                }
                                            } else {
                                                jlc = poc == pattern.charAt(posPattern);
                                            }
                                            ++posText;
                                            if (!jlc) continue;
                                            savedPos.add(new int[]{posText, posPattern});
                                            varpart = false;
                                            break;
                                        }
                                        if (!varpart) {
                                            break;
                                        }
                                    } else if (lcmode > 0) {
                                        ilc = 0;
                                        jlc = false;
                                        while (ilc < charList.length()) {
                                            if (text.charAt(posText) == charList.charAt(ilc)) {
                                                jlc = true;
                                            }
                                            ++ilc;
                                        }
                                        ++posText;
                                        if (jlc) {
                                            break;
                                        }
                                    } else if (lcmode < 0) {
                                        ilc = 0;
                                        jlc = true;
                                        while (ilc < charList.length()) {
                                            if (text.charAt(posText) == charList.charAt(ilc)) {
                                                jlc = false;
                                            }
                                            ++ilc;
                                        }
                                        ++posText;
                                        if (jlc) {
                                            break;
                                        }
                                    } else if (text.charAt(posText++) == pattern.charAt(posPattern)) break;
                                }
                            }
                            mask = false;
                            if (savedPos.size() != 0) {
                                xy = (int[])savedPos.remove(savedPos.size() - 1);
                                posText = xy[0];
                                posPattern = xy[1] - 1;
                                varpart = true;
                                break;
                            }
                            varpart = false;
                            break block9;
                        }
                    }
                }
                ++posPattern;
            }
            if (posPattern >= pattern.length() && (!equal || varpart || posText == text.length())) {
                found[matches][0] = ipos;
                found[matches][1] = posText;
                ++matches;
            }
            if (ipos == text.length()) break;
            ++ipos;
        }
        return matches;
    }

    public static boolean matchesPattern(String pattern, String text, boolean ignoreCase) {
        if (ignoreCase) {
            pattern = pattern.toLowerCase();
            text = text.toLowerCase();
        }
        return CIMUtil.getStringPatternMatches(pattern, text, 1, new int[1][2]) == 1;
    }

    public static String getMaskedValue(String value) {
        StringBuffer buf = new StringBuffer(2 + 12 * value.length() / 10);
        CIMUtil.appendMaskedValue(buf, value);
        return buf.toString();
    }

    static void appendMaskedValue(StringBuffer buf, String value) {
        int len = value.length();
        char[] valueChars = value.toCharArray();
        int start = 0;
        buf.append('\"');
        int i = 0;
        while (i < len) {
            String escape;
            char ch = valueChars[i];
            switch (ch) {
                case '\"': {
                    escape = "\\\"";
                    break;
                }
                case '\\': {
                    escape = "\\\\";
                    break;
                }
                default: {
                    escape = null;
                }
            }
            if (escape != null) {
                int wlen = i - start;
                if (wlen > 0) {
                    buf.append(valueChars, start, wlen);
                }
                start = i + 1;
                buf.append(escape);
            }
            ++i;
        }
        if (start == 0) {
            buf.append(value);
        } else {
            int wlen = len - start;
            if (wlen > 0) {
                buf.append(valueChars, start, wlen);
            }
        }
        buf.append('\"');
    }

    public static String getUnmaskedValue(String value) {
        int start = value.startsWith("\"") ? 1 : 0;
        int end = value.endsWith("\"") ? value.length() - 1 : value.length();
        char[] chars = value.toCharArray();
        StringBuffer buf = new StringBuffer(value.length());
        int last = start;
        int i = start;
        while (i < end) {
            char nc;
            char ch = chars[i];
            if (ch == '\\' && ((nc = value.charAt(++i)) == '\\' || nc == '\"')) {
                buf.append(chars, last, i - last - 1);
                buf.append(nc);
                last = i + 1;
            }
            ++i;
        }
        if (last < end) {
            buf.append(chars, last, end - last);
        }
        return buf.toString();
    }

    public static boolean isValidIdentifier(String id) {
        int len;
        int n = len = id == null ? 0 : id.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char ch = id.charAt(i);
            if (!(ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '\u00a0' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\uffef' || i != 0 && ch >= '0' && ch <= '9')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Character findInvalidCharForXml(String value) {
        if (value != null) {
            int len = value.length();
            int i = 0;
            while (i < len) {
                char ch = value.charAt(i);
                if (!(ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd')) {
                    return new Character(ch);
                }
                ++i;
            }
        }
        return null;
    }

    static String escapeCharactersInvalidForXml(String text) {
        if (CIMUtil.findInvalidCharForXml(text) == null) {
            return text;
        }
        StringBuffer buf = new StringBuffer(11 * text.length() / 10);
        int textLen = text.length();
        int i = 0;
        while (i < textLen) {
            char ch = text.charAt(i);
            if (!(ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd')) {
                String escape = Integer.toHexString(ch);
                buf.append("0x");
                int d = escape.length();
                while (d < 4) {
                    buf.append('0');
                    ++d;
                }
                buf.append(escape);
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isHex(String num) {
        return num.startsWith("0x") || num.startsWith("0X");
    }

    public static boolean isValidNumeric(String num) {
        boolean isHex = CIMUtil.isHex(num);
        try {
            if (isHex) {
                Long.parseLong(num.substring(2), 16);
            } else {
                Long.parseLong(num);
            }
            return true;
        }
        catch (NumberFormatException nfe) {
            try {
                BigInteger big = isHex ? new BigInteger(num.substring(2), 16) : new BigInteger(num);
                return big.compareTo(BigInteger.ZERO) >= 0 && big.compareTo(MAXUINT64) <= 0;
            }
            catch (NumberFormatException nfe2) {
                try {
                    if (num.length() != num.trim().length()) {
                        return false;
                    }
                    double d = Double.parseDouble(num);
                    return !Double.isInfinite(d) && !Double.isNaN(d);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
    }

    public static BigInteger toBigInt(String num) {
        return CIMUtil.isHex(num) ? new BigInteger(num.substring(2), 16) : new BigInteger(num);
    }

    public static BigInteger[] toBigIntRange(String num, String type) {
        if ("uint8".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXUINT8);
        }
        if ("uint16".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXUINT16);
        }
        if ("uint32".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXUINT32);
        }
        if ("uint64".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXUINT64);
        }
        if ("sint8".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXSINT8);
        }
        if ("sint16".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXSINT16);
        }
        if ("sint32".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXSINT32);
        }
        if ("sint64".equals(type)) {
            return CIMUtil.toBigIntRange(num, BigInteger.ZERO, MAXSINT64);
        }
        throw new NumberFormatException("Invalid integer type: " + type);
    }

    private static BigInteger[] toBigIntRange(String num, BigInteger smallest, BigInteger largest) {
        int pp = num.indexOf("..");
        if (pp == -1) {
            BigInteger bigint = CIMUtil.toBigInt(num);
            return new BigInteger[]{bigint, bigint};
        }
        BigInteger lowerBound = pp > 0 ? CIMUtil.toBigInt(num.substring(0, pp)) : smallest;
        BigInteger upperBound = (pp += 2) < num.length() ? CIMUtil.toBigInt(num.substring(pp)) : largest;
        return new BigInteger[]{lowerBound, upperBound};
    }

    public static int toInt(String number) {
        return CIMUtil.isHex(number) ? Integer.parseInt(number.substring(2), 16) : Integer.parseInt(number);
    }

    public static CIMKeyValue getKeyValueByName(CIMInstancename instancename, String keyName) {
        CIMKeybinding key = instancename.getKeybindingList().get(keyName);
        return key != null ? key.getKeyValue() : null;
    }

    public static CIMValueReference getValueReferenceByName(CIMInstancename instancename, String keyName) {
        CIMKeybinding key = instancename.getKeybindingList().get(keyName);
        return key != null ? key.getValueReference() : null;
    }

    public static boolean isValidValueForType(String value, String type) {
        if (value == null) {
            return true;
        }
        boolean isHex = CIMUtil.isHex(value);
        try {
            if (type.equals("string") || type.equals("char16")) {
                return true;
            }
            if (type.equals("boolean")) {
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
            }
            if (type.equals("datetime")) {
                return CIMUtil.checkDateTime(value);
            }
            if (type.equals("uint8")) {
                int uint8 = isHex ? Integer.parseInt(value.substring(2), 16) : Integer.parseInt(value);
                return 0 <= uint8 && uint8 <= 255;
            }
            if (type.equals("sint8")) {
                if (isHex) {
                    Byte.parseByte(value.substring(2), 16);
                } else {
                    Byte.parseByte(value);
                }
                return true;
            }
            if (type.equals("uint16")) {
                int uint16 = isHex ? Integer.parseInt(value.substring(2), 16) : Integer.parseInt(value);
                return 0 <= uint16 && uint16 <= 65535;
            }
            if (type.equals("sint16")) {
                if (isHex) {
                    Short.parseShort(value.substring(2), 16);
                } else {
                    Short.parseShort(value);
                }
                return true;
            }
            if (type.equals("uint32")) {
                long uint32 = isHex ? Long.parseLong(value.substring(2), 16) : Long.parseLong(value);
                return 0L <= uint32 && uint32 <= 0xFFFFFFFFL;
            }
            if (type.equals("sint32")) {
                if (isHex) {
                    Integer.parseInt(value.substring(2), 16);
                } else {
                    Integer.parseInt(value);
                }
                return true;
            }
            if (type.equals("uint64")) {
                BigInteger uint64 = isHex ? new BigInteger(value.substring(2), 16) : new BigInteger(value);
                return uint64.compareTo(BigInteger.ZERO) >= 0 && uint64.compareTo(MAXUINT64) <= 0;
            }
            if (type.equals("sint64")) {
                if (isHex) {
                    Long.parseLong(value.substring(2), 16);
                } else {
                    Long.parseLong(value);
                }
                return true;
            }
            if (type.equals("real32")) {
                float real32 = Float.parseFloat(value);
                return !Float.isInfinite(real32);
            }
            if (type.equals("real64")) {
                double real64 = Double.parseDouble(value);
                return !Double.isInfinite(real64);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkDateTime(String value) {
        if (value.length() != 25) {
            return false;
        }
        int utcSep = 32;
        int i = 0;
        while (i < 25) {
            switch (i) {
                case 14: {
                    if (value.charAt(14) == '.') break;
                    return false;
                }
                case 21: {
                    utcSep = value.charAt(21);
                    if (utcSep == 43 || utcSep == 45 || utcSep == 58) break;
                    return false;
                }
                default: {
                    char ch = value.charAt(i);
                    if (ch >= '0' && ch <= '9') break;
                    return false;
                }
            }
            ++i;
        }
        int hours = (value.charAt(8) - 48) * 10 + (value.charAt(9) - 48);
        if (hours > 23) {
            return false;
        }
        int minutes = (value.charAt(10) - 48) * 10 + (value.charAt(11) - 48);
        if (minutes > 59) {
            return false;
        }
        int seconds = (value.charAt(12) - 48) * 10 + (value.charAt(13) - 48);
        if (seconds > 59) {
            return false;
        }
        if (utcSep == 58) {
            int i2 = value.charAt(22) + value.charAt(23) + value.charAt(24) - 144;
            if (i2 != 0) {
                return false;
            }
        } else {
            int months = (value.charAt(4) - 48) * 10 + (value.charAt(5) - 48);
            if (months < 1 || months > 12) {
                return false;
            }
            int days = (value.charAt(6) - 48) * 10 + (value.charAt(7) - 48);
            if (days < 1 || days > 31) {
                return false;
            }
        }
        return true;
    }

    public static String findInvalidValueForType(CIMValueArray valueArray, String type) {
        if (valueArray == null || valueArray.size() == 0) {
            return null;
        }
        int size = valueArray.size();
        int v = 0;
        while (v < size) {
            String value = valueArray.get(v).getStringvalue();
            if (!CIMUtil.isValidValueForType(value, type)) {
                return value;
            }
            ++v;
        }
        return null;
    }

    public static CIMInstancename findNewName(CIMInstancename sourceName, CIMObjectpathList copyOrRenameResultList) {
        int evenIndex = 0;
        while (evenIndex < copyOrRenameResultList.size()) {
            CIMInstancename nextSourceName = copyOrRenameResultList.get(evenIndex).getInstancename();
            if (sourceName.equals(nextSourceName)) {
                return copyOrRenameResultList.get(evenIndex + 1).getInstancename();
            }
            evenIndex += 2;
        }
        return null;
    }

    public static String getQualifiedName(ICIMItem item) {
        String result = item.getDTDName();
        if (item instanceof ICIMNamedElement) {
            String name = ((ICIMNamedElement)item).getName();
            StringBuffer buf = new StringBuffer(1 + name.length() + result.length());
            buf.append(result);
            buf.append(' ');
            buf.append(name);
            result = buf.toString();
        }
        return result;
    }

    public static boolean violatesWeak(CIMOMHandle client, CIMClass assocClass, CIMInstancename firstName, CIMClass firstClass, String firstRole, CIMInstancename secondName, CIMClass secondClass) throws LcrException {
        CIMPropertyReferenceList propRefList = assocClass.getPropertyReferences();
        if (propRefList.size() != 2) {
            throw new LcrException("{0} is not a binary association", new Object[]{assocClass.getClassname()});
        }
        boolean firstFound = false;
        boolean weakFound = false;
        boolean firstIsWeak = false;
        String secondRole = null;
        int p = 0;
        while (p < propRefList.size()) {
            CIMPropertyReference propRef = propRefList.get(p);
            boolean isWeak = propRef.isWeak();
            weakFound |= isWeak;
            if (firstRole.equalsIgnoreCase(propRef.getName())) {
                firstFound = true;
                firstIsWeak = isWeak;
            } else {
                secondRole = propRef.getName();
            }
            ++p;
        }
        if (!firstFound) {
            throw new LcrException("Invalid role name {0} for class {1}", new Object[]{firstRole, assocClass.getClassname()});
        }
        if (weakFound) {
            if (firstIsWeak) {
                return CIMUtil.violatesWeakImpl(client, assocClass.getCIMClassname(), firstName, firstClass, firstRole, secondName, secondClass);
            }
            return CIMUtil.violatesWeakImpl(client, assocClass.getCIMClassname(), secondName, secondClass, secondRole, firstName, firstClass);
        }
        return false;
    }

    private static boolean violatesWeakImpl(CIMOMHandle client, CIMClassname assocClassname, CIMInstancename weakInstanceName, CIMClass weakClass, String weakRole, CIMInstancename strongInstanceName, CIMClass strongClass) throws LcrException {
        CIMKeybindingList strongKeys = strongInstanceName.getKeybindingList();
        int i = 0;
        while (i < strongKeys.size()) {
            CIMKeybinding strongKey = strongKeys.get(i);
            String strongName = strongKey.getName();
            String weakName = CIMUtil.findWeakName(assocClassname, strongClass, strongName, weakClass, new ClientClassReader(client), false);
            CIMKeybinding weakKey = weakInstanceName.getKeybindingList().get(weakName);
            String strongValue = strongKey.getKeyValue().getValue();
            String weakValue = weakKey.getKeyValue().getValue();
            if (!weakValue.equals(strongValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String findWeakName(CIMClassname assocClsName, CIMClass strongClass, String strongPropName, CIMClass weakClass, IClassReader classReader, boolean refreshPropgatedInfo) throws LcrException {
        CIMClass.PropagationMap propagationMap = weakClass.getPropagationMap(refreshPropgatedInfo);
        CIMClass.PropagationInfo propagationInfo = propagationMap.get(strongPropName);
        while (propagationInfo != null) {
            boolean classMatch;
            if (propagationInfo.propagatedClassName == null) {
                return propagationInfo.weakPropName;
            }
            CIMClassname propagatedClsName = propagationInfo.getPropagatedCIMClassName();
            boolean bl = classMatch = propagatedClsName.equals(strongClass.getCIMClassname()) || classReader.hasSuperclass(strongClass.getCIMClassname(), propagatedClsName);
            if (classMatch) {
                return propagationInfo.weakPropName;
            }
            propagationInfo = propagationInfo.next();
        }
        CIMProperty strongProperty = strongClass.getPropertyByName(strongPropName);
        CIMQualifier strongPropagated = strongProperty.getQualifierByName("Propagated");
        if (strongPropagated != null && strongPropagated.getCIMValue() != null) {
            String value = strongPropagated.getValue();
            int idx = value.indexOf(46);
            if (idx != -1) {
                String className = value.substring(0, idx);
                String propName = value.substring(idx + 1);
                return CIMUtil.findWeakName(assocClsName, classReader.getClass(CIMFactory.classname(className)), propName, weakClass, classReader, refreshPropgatedInfo);
            }
            propagationInfo = propagationMap.get(value);
            if (propagationInfo != null) {
                return propagationInfo.weakPropName;
            }
        }
        throw new LcrException("Weak association {0}: Key property {1}.{2} not propagated to weak association partner {3}", new Object[]{assocClsName.toDisplayString(), strongClass.getClassname(), strongPropName, weakClass.getClassname()});
    }

    private static class ClientClassReader
    implements IClassReader {
        private final CIMOMHandle client;

        ClientClassReader(CIMOMHandle client) {
            this.client = client;
        }

        public CIMClass getClass(CIMClassname classname) throws LcrException {
            try {
                return ClientUtil.getCIMClassComplete(this.client, classname);
            }
            catch (CIMClientException e) {
                throw new LcrException(e);
            }
        }

        public boolean hasSuperclass(CIMClassname classname, CIMClassname superClassname) throws LcrException {
            try {
                CIMClassnameList subclassNames = this.client.enumerateClassNames(superClassname, true);
                return subclassNames.contains(classname);
            }
            catch (CIMClientException e) {
                throw new LcrException(e);
            }
            catch (LcrException e) {
                if (e.getStatusCode() == 5) {
                    return false;
                }
                throw e;
            }
        }
    }

    public static interface IClassReader {
        public boolean hasSuperclass(CIMClassname var1, CIMClassname var2) throws LcrException;

        public CIMClass getClass(CIMClassname var1) throws LcrException;
    }
}

