/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMScope
extends CIMItemWA {
    public static final String DTD_NAME = "SCOPE";
    private boolean attrClass;
    private boolean attrAssociation;
    private boolean attrReference;
    private boolean attrProperty;
    private boolean attrMethod;
    private boolean attrParameter;
    private boolean attrIndication;

    protected CIMScope() {
    }

    public CIMScope toWritable() {
        return (CIMScope)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMScope) {
            CIMScope other = (CIMScope)obj;
            return this.attrClass == other.attrClass && this.attrAssociation == other.attrAssociation && this.attrReference == other.attrReference && this.attrProperty == other.attrProperty && this.attrMethod == other.attrMethod && this.attrParameter == other.attrParameter && this.attrIndication == other.attrIndication;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.attrClass) {
            hash |= 1;
        }
        if (this.attrAssociation) {
            hash |= 2;
        }
        if (this.attrIndication) {
            hash |= 4;
        }
        if (this.attrProperty) {
            hash |= 8;
        }
        if (this.attrReference) {
            hash |= 0x10;
        }
        if (this.attrMethod) {
            hash |= 0x20;
        }
        if (this.attrParameter) {
            hash |= 0x40;
        }
        return hash;
    }

    public boolean equalsOrExtends(CIMScope other) {
        if (other == null) {
            return this.attrClass && this.attrAssociation && this.attrReference && this.attrProperty && this.attrMethod && this.attrParameter && this.attrIndication;
        }
        if (!this.attrClass && other.attrClass) {
            return false;
        }
        if (!this.attrAssociation && other.attrAssociation) {
            return false;
        }
        if (!this.attrReference && other.attrReference) {
            return false;
        }
        if (!this.attrProperty && other.attrProperty) {
            return false;
        }
        if (!this.attrMethod && other.attrMethod) {
            return false;
        }
        if (!this.attrParameter && other.attrParameter) {
            return false;
        }
        return this.attrIndication || !other.attrIndication;
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("CLASS".equals(name)) {
                this.attrClass = CIMUtil.string2boolean(value);
            } else if ("ASSOCIATION".equals(name)) {
                this.attrAssociation = CIMUtil.string2boolean(value);
            } else if ("REFERENCE".equals(name)) {
                this.attrReference = CIMUtil.string2boolean(value);
            } else if ("PROPERTY".equals(name)) {
                this.attrProperty = CIMUtil.string2boolean(value);
            } else if ("METHOD".equals(name)) {
                this.attrMethod = CIMUtil.string2boolean(value);
            } else if ("PARAMETER".equals(name)) {
                this.attrParameter = CIMUtil.string2boolean(value);
            } else if ("INDICATION".equals(name)) {
                this.attrIndication = CIMUtil.string2boolean(value);
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addScope(this);
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        if (this.attrClass) {
            CIMUtil.appendXmlAttribute(writer, "CLASS", this.attrClass);
        }
        if (this.attrAssociation) {
            CIMUtil.appendXmlAttribute(writer, "ASSOCIATION", this.attrAssociation);
        }
        if (this.attrReference) {
            CIMUtil.appendXmlAttribute(writer, "REFERENCE", this.attrReference);
        }
        if (this.attrProperty) {
            CIMUtil.appendXmlAttribute(writer, "PROPERTY", this.attrProperty);
        }
        if (this.attrMethod) {
            CIMUtil.appendXmlAttribute(writer, "METHOD", this.attrMethod);
        }
        if (this.attrParameter) {
            CIMUtil.appendXmlAttribute(writer, "PARAMETER", this.attrParameter);
        }
        if (this.attrIndication) {
            CIMUtil.appendXmlAttribute(writer, "INDICATION", this.attrIndication);
        }
    }

    public boolean isScopeReference() {
        return this.attrReference;
    }

    public boolean isScopeProperty() {
        return this.attrProperty;
    }

    public boolean isScopeParameter() {
        return this.attrParameter;
    }

    public boolean isScopeMethod() {
        return this.attrMethod;
    }

    public boolean isScopeIndication() {
        return this.attrIndication;
    }

    public boolean isScopeClass() {
        return this.attrClass;
    }

    public boolean isScopeAssociation() {
        return this.attrAssociation;
    }

    public void setScopeAssociation(boolean attrAssociation) {
        this.checkWritable();
        this.attrAssociation = attrAssociation;
    }

    public void setScopeClass(boolean attrClass) {
        this.checkWritable();
        this.attrClass = attrClass;
    }

    public void setScopeIndication(boolean attrIndication) {
        this.checkWritable();
        this.attrIndication = attrIndication;
    }

    public void setScopeMethod(boolean attrMethod) {
        this.checkWritable();
        this.attrMethod = attrMethod;
    }

    public void setScopeParameter(boolean attrParameter) {
        this.checkWritable();
        this.attrParameter = attrParameter;
    }

    public void setScopeProperty(boolean attrProperty) {
        this.checkWritable();
        this.attrProperty = attrProperty;
    }

    public void setScopeReference(boolean attrReference) {
        this.checkWritable();
        this.attrReference = attrReference;
    }
}

