/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMReadOnly;
import com.sap.lcr.api.cim.ReadOnlyException;

public class CIMPropertyValue
implements ICIMReadOnly,
Cloneable {
    private CIMItem xmlAppender;
    private boolean readOnly;

    protected CIMPropertyValue() {
    }

    protected CIMPropertyValue(CIMValue aValue) {
        this();
        this.xmlAppender = aValue;
        this.readOnly = this.xmlAppender.isReadOnly();
    }

    protected CIMPropertyValue(CIMValueArray aValueArray) {
        this();
        this.xmlAppender = aValueArray;
        this.readOnly = this.xmlAppender.isReadOnly();
    }

    protected CIMPropertyValue(CIMValueReference aValueReference) {
        this();
        this.xmlAppender = aValueReference;
        this.readOnly = this.xmlAppender.isReadOnly();
    }

    protected CIMPropertyValue(String aValue) {
        this(CIMFactory.value(aValue));
    }

    protected CIMPropertyValue(String[] aValueArray) {
        this(CIMFactory.valueArray(aValueArray));
    }

    public CIMPropertyValue toWritable() {
        return (CIMPropertyValue)this.getWritable();
    }

    public void setValue(CIMValue aValue) {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
        this.xmlAppender = aValue.toWritable();
    }

    public void setValueArray(CIMValueArray aValueArray) {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
        this.xmlAppender = aValueArray.toWritable();
    }

    public void setValueReference(CIMValueReference aValueReference) {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
        this.xmlAppender = aValueReference.toWritable();
    }

    public CIMItem getValue() {
        return this.xmlAppender;
    }

    public Object clone() {
        try {
            CIMPropertyValue clone = (CIMPropertyValue)super.clone();
            this.readOnly = false;
            if (this.xmlAppender != null) {
                clone.xmlAppender = (CIMItem)this.xmlAppender.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public Object getWritable() {
        return this.readOnly ? this.clone() : this;
    }

    public final Object getReadOnly() {
        return this.readOnly ? this : ((ICIMReadOnly)this.clone()).makeReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Object makeReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            if (this.xmlAppender != null) {
                this.xmlAppender.makeReadOnly();
            }
        }
        return this;
    }
}

