/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWAWQ;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.log.Logger;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMParameterArray
extends CIMItemWAWQ
implements ICIMNamedElement {
    private static final Logger logger = Logger.getLogger((class$com$sap$lcr$api$cim$CIMParameterArray == null ? (class$com$sap$lcr$api$cim$CIMParameterArray = CIMParameterArray.class$("com.sap.lcr.api.cim.CIMParameterArray")) : class$com$sap$lcr$api$cim$CIMParameterArray).getName());
    public static final String DTD_NAME = "PARAMETER.ARRAY";
    private String attrName;
    private String attrType;
    private int attrArraySize;
    static /* synthetic */ Class class$com$sap$lcr$api$cim$CIMParameterArray;

    protected CIMParameterArray() {
    }

    protected CIMParameterArray(String aCIMName, String aCIMType) throws ItemConstructionExcp {
        this.checkNonNull(aCIMName, "NAME");
        this.checkNonNull(aCIMType, "TYPE");
        CIMUtil.checkCIMType(aCIMType);
        this.attrName = aCIMName;
        this.attrType = aCIMType;
    }

    public CIMParameterArray toWritable() {
        return (CIMParameterArray)this.getWritable();
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    void makeSubelementsReadOnlyWOQualifiers() {
    }

    boolean isDTDConformant() {
        return this.attrName != null && this.attrType != null;
    }

    public boolean equals(Object obj) {
        block4: {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CIMParameterArray) {
                CIMParameterArray other = (CIMParameterArray)obj;
                try {
                    return this.attrName.equalsIgnoreCase(other.attrName) && this.attrType.equals(other.attrType) && this.attrArraySize == other.attrArraySize && this.getQualifiers().equals(other.getQualifiers());
                }
                catch (NullPointerException npe) {
                    if (CIMTraceUtil.traceLevel < 3) break block4;
                    logger.debug("Inconsistent CIMParameterArray", npe);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.attrName.toLowerCase().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    public String getType() {
        return this.attrType;
    }

    public int getArraySize() {
        return this.attrArraySize;
    }

    public void setArraySize(int arraySize) {
        this.checkWritable();
        this.attrArraySize = arraySize > 0 ? arraySize : 0;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.getQualifiers(), indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
        CIMUtil.appendXmlAttributeUnescaped(writer, "TYPE", this.attrType);
        if (this.attrArraySize > 0) {
            CIMUtil.appendXmlAttribute(writer, "ARRAYSIZE", this.attrArraySize);
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMParameterArray)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMParameterArray source = (CIMParameterArray)sourceItem;
        this.mergeQualifiersWritable(source);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if ("NAME".equals(name)) {
                this.attrName = value;
            } else if ("TYPE".equals(name)) {
                this.attrType = value;
            } else if ("ARRAYSIZE".equals(name)) {
                try {
                    this.setArraySize(CIMUtil.toInt(value));
                }
                catch (NumberFormatException nfe) {
                    throw ItemConstructionExcp.createInvalidIntegerAttributeExcp(value, "ARRAYSIZE", this);
                }
            } else {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
        if (this.attrType == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("TYPE", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addParameterArray(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

