/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.ICIMReadOnly;
import com.sap.lcr.api.cim.ReadOnlyException;

public class CIMObjectname
implements ICIMReadOnly,
Cloneable {
    private CIMClassname classname;
    private CIMInstancename instancename;
    private boolean readOnly;

    protected CIMObjectname() {
    }

    protected CIMObjectname(CIMClassname aClassname) {
        if (aClassname == null) {
            throw new NullPointerException("Class name must not be null");
        }
        this.classname = aClassname;
        this.readOnly = this.classname.isReadOnly();
    }

    protected CIMObjectname(CIMInstancename anInstancename) {
        if (anInstancename == null) {
            throw new NullPointerException("Instance name must not be null");
        }
        this.instancename = anInstancename;
        this.readOnly = this.instancename.isReadOnly();
    }

    public CIMObjectname toWritable() {
        return (CIMObjectname)this.getWritable();
    }

    public void setClassname(CIMClassname aClassname) {
        if (aClassname == null) {
            throw new NullPointerException("Class name must not be null");
        }
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
        this.classname = aClassname.toWritable();
        this.instancename = null;
    }

    public void setInstancename(CIMInstancename anInstancename) {
        if (anInstancename == null) {
            throw new NullPointerException("Instance name must not be null");
        }
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
        this.classname = null;
        this.instancename = anInstancename.toWritable();
    }

    public CIMInstancename getInstancename() {
        return this.instancename;
    }

    public CIMClassname getCIMClassname() {
        return this.classname;
    }

    public String toDisplayString() {
        if (this.classname != null) {
            return this.classname.toDisplayString();
        }
        if (this.instancename != null) {
            return this.instancename.toDisplayString();
        }
        return "";
    }

    public String toString() {
        if (this.classname != null) {
            return this.classname.toString();
        }
        if (this.instancename != null) {
            return this.instancename.toString();
        }
        return "";
    }

    public Object clone() {
        try {
            CIMObjectname clone = (CIMObjectname)super.clone();
            this.readOnly = false;
            if (this.classname != null) {
                clone.classname = (CIMClassname)this.classname.clone();
            }
            if (this.instancename != null) {
                clone.instancename = (CIMInstancename)this.instancename.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public Object getWritable() {
        return this.readOnly ? this.clone() : this;
    }

    public final Object getReadOnly() {
        return this.readOnly ? this : ((ICIMReadOnly)this.clone()).makeReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Object makeReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            if (this.classname != null) {
                this.classname.makeReadOnly();
            }
            if (this.instancename != null) {
                this.instancename.makeReadOnly();
            }
        }
        return this;
    }
}

