/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMSimpleReq;
import com.sap.lcr.api.cim.CIMSimpleReqList;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import java.io.IOException;
import java.io.Writer;

public class CIMMultiReq
extends CIMItem {
    public static final String DTD_NAME = "MULTIREQ";
    private static final String COUNT_ERROR = "MULTIREQ must have at least two SIMPLEREQ subelements";
    private CIMSimpleReqList simpleRequests;

    protected CIMMultiReq() {
        this.simpleRequests = CIMFactory.simpleReqList();
    }

    protected CIMMultiReq(CIMSimpleReq firstReq, CIMSimpleReq secondReq) {
        this();
        if (firstReq == null || secondReq == null) {
            throw new NullPointerException(COUNT_ERROR);
        }
        this.simpleRequests.add(firstReq);
        this.simpleRequests.add(secondReq);
        if (firstReq.isReadOnly() || secondReq.isReadOnly()) {
            firstReq = (CIMSimpleReq)firstReq.getReadOnly();
            secondReq = (CIMSimpleReq)secondReq.getReadOnly();
            this.makeReadOnly();
        }
    }

    protected CIMMultiReq(CIMSimpleReqList simpleReqs) {
        if (simpleReqs.size() < 2) {
            throw new IllegalArgumentException(COUNT_ERROR);
        }
        this.simpleRequests = simpleReqs;
        if (this.simpleRequests.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    public CIMMultiReq toWritable() {
        return (CIMMultiReq)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        this.simpleRequests.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.simpleRequests.size() >= 2;
    }

    public Object clone() {
        CIMMultiReq clone = (CIMMultiReq)super.clone();
        clone.simpleRequests = (CIMSimpleReqList)this.simpleRequests.clone();
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void addSimpleReq(CIMSimpleReq aSimpleReq) {
        this.simpleRequests.add(aSimpleReq.toWritable());
    }

    public CIMSimpleReqList getSimpleReqs() {
        return this.simpleRequests;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.simpleRequests.iterator(), indent);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addMultiReq(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            this.simpleRequests.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }
}

