/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMNamedElement;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public class CIMKeybinding
extends CIMItemWA
implements ICIMNamedElement {
    public static final String DTD_NAME = "KEYBINDING";
    private String attrName;
    private CIMKeyValue keyValue;
    private CIMValueReference valueReference;
    private ICIMItem xmlAppender;

    protected CIMKeybinding() {
    }

    private CIMKeybinding(String aName) {
        this();
        this.checkNonNull(aName, "NAME");
        this.attrName = aName;
    }

    protected CIMKeybinding(String aName, CIMKeyValue aKeyvalue) {
        this(aName);
        this.checkNonNull(aKeyvalue, "KEYVALUE");
        this.keyValue = aKeyvalue;
        this.xmlAppender = this.keyValue;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMKeybinding(String aName, CIMValueReference aValueReference) {
        this(aName);
        this.checkNonNull(aValueReference, "VALUE.REFERENCE");
        this.valueReference = aValueReference;
        this.xmlAppender = this.valueReference;
        if (this.xmlAppender.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    protected CIMKeybinding(String aName, String aValue) {
        this(aName, CIMFactory.keyValue(aValue));
    }

    protected CIMKeybinding(String aName, String aType, String aValue) throws ItemConstructionExcp {
        this(aName, CIMFactory.keyValue(aValue, CIMUtil.cimType2keypropertyType(aType)));
    }

    public CIMKeybinding toWritable() {
        return (CIMKeybinding)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.xmlAppender != null) {
            this.xmlAppender.makeReadOnly();
        }
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (includeNames) {
                this.validateStringForXml(this.attrName, "NAME");
            }
            if (this.xmlAppender != null) {
                this.xmlAppender.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    boolean isDTDConformant() {
        return this.attrName != null && (this.keyValue != null || this.valueReference != null);
    }

    public Object clone() {
        CIMKeybinding clone = (CIMKeybinding)super.clone();
        if (this.keyValue != null) {
            clone.keyValue = (CIMKeyValue)this.keyValue.clone();
            clone.xmlAppender = clone.keyValue;
        } else if (this.valueReference != null) {
            clone.valueReference = (CIMValueReference)this.valueReference.clone();
            clone.xmlAppender = clone.valueReference;
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setKeyValue(CIMKeyValue aKeyValue) {
        this.checkNonNull(aKeyValue, "KEYVALUE");
        this.checkWritable();
        this.keyValue = aKeyValue.toWritable();
        this.xmlAppender = this.keyValue;
        this.valueReference = null;
    }

    public void setKeyValue(String value) {
        this.setKeyValue(value != null ? CIMFactory.keyValue(value) : null);
    }

    public void setValueReference(CIMValueReference aValueReference) {
        this.checkNonNull(aValueReference, "VALUE.REFERENCE");
        this.checkWritable();
        this.valueReference = aValueReference.toWritable();
        this.xmlAppender = this.valueReference;
        this.keyValue = null;
    }

    public String getValueString() {
        if (this.keyValue != null) {
            return this.keyValue.getValue();
        }
        if (this.valueReference != null) {
            this.valueReference.toString();
        }
        return "";
    }

    public String getName() {
        return this.attrName;
    }

    public boolean containsKeyValue() {
        return this.keyValue != null;
    }

    public boolean containsValueReference() {
        return this.valueReference != null;
    }

    public CIMKeyValue getKeyValue() {
        return this.keyValue;
    }

    public CIMValueReference getValueReference() {
        return this.valueReference;
    }

    void addToCIMObjectReference(CIMObjectReference reference) throws ReferenceConversionExcp {
        if (this.keyValue != null) {
            reference.addCIMKey(this.attrName, this.keyValue.getValue(), this.keyValue.getType());
            return;
        }
        if (this.valueReference != null) {
            reference.addCIMKey(this.attrName, this.valueReference.toCIMObjectReference());
            return;
        }
        throw new ReferenceConversionExcp(1);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.xmlAppender, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void addKeyValue(CIMKeyValue aKeyValue) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aKeyValue, this.xmlAppender);
        }
        this.setKeyValue(aKeyValue);
    }

    void addValueReference(CIMValueReference aValueReference) throws ItemConstructionExcp {
        if (this.xmlAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aValueReference, this.xmlAppender);
        }
        this.setValueReference(aValueReference);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addKeybinding(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CIMKeybinding) {
            CIMKeybinding other = (CIMKeybinding)obj;
            return Util.equalsIgnoreCase(this.attrName, other.attrName) && Util.equals(this.keyValue, other.keyValue) && Util.equals(this.valueReference, other.valueReference);
        }
        return false;
    }

    public int hashCode() {
        int hash;
        int n = hash = this.attrName == null ? 0 : this.attrName.hashCode();
        if (this.xmlAppender != null) {
            hash = 31 * hash + this.xmlAppender.hashCode();
        }
        return hash;
    }
}

