/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMXmlAppender;
import com.sap.lcr.api.cim.CIMXmlAppenderReadOnly;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMReadOnly;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReadOnlyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public abstract class CIMItemList
extends CIMXmlAppenderReadOnly {
    private ArrayList itemList;

    CIMItemList() {
        super(false);
        this.itemList = new ArrayList();
    }

    CIMItemList(int initialCapacity) {
        super(false);
        this.itemList = new ArrayList(initialCapacity);
    }

    CIMItemList(CIMItem item) {
        this();
        this.checkNonNull(item);
        this.itemList.add(item);
        if (item.isReadOnly()) {
            this.makeReadOnly();
        }
    }

    private void checkNonNull(ICIMItem item) {
        if (item == null) {
            throw new NullPointerException("Can not add null item to " + this.getClass().getName());
        }
    }

    public Object getShallowWritable() {
        return this.isReadOnly() ? this.doClone(false) : this;
    }

    final void makeSubelementsReadOnly() {
        int i = 0;
        while (i < this.itemList.size()) {
            ICIMReadOnly element = (ICIMReadOnly)this.itemList.get(i);
            element.makeReadOnly();
            ++i;
        }
    }

    final void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        int i = 0;
        while (i < this.itemList.size()) {
            ICIMItem element = (ICIMItem)this.itemList.get(i);
            element.validateCharacters(includeNames);
            ++i;
        }
    }

    public Object clone() {
        return this.doClone(true);
    }

    public Object cloneShallow() {
        CIMItemList clone = (CIMItemList)super.clone();
        clone.itemList = (ArrayList)this.itemList.clone();
        if (this.isReadOnly()) {
            clone.makeReadOnly();
        }
        return clone;
    }

    private Object doClone(boolean deep) {
        CIMItemList clone = (CIMItemList)super.clone();
        clone.itemList = deep ? CIMUtil.cloneCIMItems(this.itemList) : (ArrayList)this.itemList.clone();
        return clone;
    }

    public void ensureCapacity(int minCapacity) {
        this.itemList.ensureCapacity(minCapacity);
    }

    public final void addItemsTo(Collection aCollection) {
        aCollection.addAll(this.itemList);
    }

    public final Object[] toArray(Object[] array) {
        return this.itemList.toArray(array);
    }

    public final CIMItem remove(int idx) {
        this.checkWritable();
        return (CIMItem)this.itemList.remove(idx);
    }

    public final CIMItem getItem(int idx) {
        return (CIMItem)this.itemList.get(idx);
    }

    public final int size() {
        return this.itemList.size();
    }

    public final boolean isEmpty() {
        return this.itemList.isEmpty();
    }

    public final void clear() {
        this.checkWritable();
        this.itemList.clear();
    }

    public final Iterator iterator() {
        return new ReadOnlyIterator(((AbstractList)this.itemList).iterator(), this);
    }

    public final void sort(Comparator comparator) {
        Collections.sort(this.itemList, comparator);
    }

    public final void appendXml(Writer writer, String indent) throws IOException {
        Iterator iter = ((AbstractList)this.itemList).iterator();
        while (iter.hasNext()) {
            CIMXmlAppender nextAppender = (CIMXmlAppender)iter.next();
            nextAppender.appendXml(writer, indent);
        }
    }

    public String toString() {
        boolean tFirstTimeAround = true;
        StringBuffer tBuffer = new StringBuffer(200);
        Iterator iter = ((AbstractList)this.itemList).iterator();
        while (iter.hasNext()) {
            Object nextAppender = iter.next();
            if (tFirstTimeAround) {
                tBuffer.append(nextAppender);
                tFirstTimeAround = false;
                continue;
            }
            tBuffer.append("\n" + nextAppender);
        }
        return tBuffer.toString();
    }

    final void add(CIMItem anItem) {
        this.checkNonNull(anItem);
        this.checkWritable();
        this.itemList.add(anItem.getWritable());
    }

    final void addAll(CIMItemList aItemList) {
        this.checkWritable();
        aItemList = (CIMItemList)aItemList.getWritable();
        this.itemList.addAll(aItemList.itemList);
    }

    final void addReadOnly(CIMItem item) {
        this.checkNonNull(item);
        this.checkWritable();
        this.itemList.add(item);
    }

    final void addAllReadOnly(CIMItemList aItemList) {
        this.checkWritable();
        this.itemList.addAll(aItemList.itemList);
    }

    final void set(int idx, CIMItem item) {
        this.checkNonNull(item);
        this.checkWritable();
        this.itemList.set(idx, item.getWritable());
    }

    final void setReadOnly(int idx, CIMItem item) {
        this.checkNonNull(item);
        this.checkWritable();
        this.itemList.set(idx, item);
    }

    final void addAll(ICIMItem[] items) {
        this.checkWritable();
        this.itemList.ensureCapacity(this.itemList.size() + items.length);
        int i = 0;
        while (i < items.length) {
            ICIMItem item = items[i];
            this.checkNonNull(item);
            this.itemList.add(item.getWritable());
            ++i;
        }
    }

    final boolean contains(CIMItem item) {
        return this.itemList.contains(item);
    }

    final int indexOf(CIMItem item) {
        return this.itemList.indexOf(item);
    }

    final boolean remove(CIMItem item) {
        this.checkWritable();
        return ((AbstractCollection)this.itemList).remove(item);
    }
}

