/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.io.IOException;
import java.io.Writer;

public final class CIMHost
extends CIMItem {
    public static final String DTD_NAME = "HOST";
    private String hostname = "";
    private String hostnameLower = "";

    protected CIMHost() {
        super(true);
    }

    protected CIMHost(String aHostname) {
        super(true);
        this.checkNonNull(aHostname, "Value");
        this.hostname = aHostname.trim();
        this.hostnameLower = this.hostname.toLowerCase();
    }

    public CIMHost toWritable() {
        return (CIMHost)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return true;
    }

    void setCharacters(String nextChunk) {
        this.hostname = this.hostname + nextChunk;
        this.hostnameLower = this.hostname.toLowerCase();
    }

    void trim() {
        this.hostname = this.hostname.trim();
        this.hostnameLower = this.hostname.toLowerCase();
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        this.trim();
        parentItem.addHost(this);
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMHost) {
            return this.hostnameLower.equals(((CIMHost)aObj).hostnameLower);
        }
        return false;
    }

    public boolean equals(String aHostname) {
        return this.hostname.equalsIgnoreCase(aHostname);
    }

    public int hashCode() {
        return this.hostnameLower.hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void addToCIMObjectReference(CIMObjectReference reference) {
        reference.setHostName(this.hostname);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.hostname, indent);
    }

    public String toDisplayString() {
        return this.hostname;
    }

    public String toString() {
        return this.hostnameLower;
    }

    String toString(boolean comparable) {
        return comparable ? this.hostnameLower : this.hostname;
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        this.validateStringForXml(this.hostname, DTD_NAME);
    }
}

