/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMValueNamedObject;
import com.sap.lcr.api.cim.CIMValueNamedObjectList;
import com.sap.lcr.api.cim.ICIMDeclGroup;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMWithNamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import java.io.IOException;
import java.io.Writer;

public class CIMDeclgroupWithName
extends CIMItem
implements ICIMWithNamespacepath,
ICIMDeclGroup {
    public static final String DTD_NAME = "DECLGROUP.WITHNAME";
    private CIMLocalnamespacepath localnamespacepath;
    private CIMNamespacepath namespacepath;
    private ICIMItem path2append;
    private CIMQualifierDeclarationList qualifierDeclarations = CIMFactory.qualifierDeclarationList();
    private CIMValueNamedObjectList valueNamedObjects = CIMFactory.valueNamedObjectList();

    protected CIMDeclgroupWithName() {
    }

    public CIMDeclgroupWithName toWritable() {
        return (CIMDeclgroupWithName)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.localnamespacepath != null) {
            this.localnamespacepath.makeReadOnly();
        }
        if (this.namespacepath != null) {
            this.namespacepath.makeReadOnly();
        }
        this.qualifierDeclarations.makeReadOnly();
        this.valueNamedObjects.makeReadOnly();
    }

    boolean isDTDConformant() {
        return true;
    }

    public Object clone() {
        CIMDeclgroupWithName clone = (CIMDeclgroupWithName)super.clone();
        clone.qualifierDeclarations = (CIMQualifierDeclarationList)this.qualifierDeclarations.clone();
        clone.valueNamedObjects = (CIMValueNamedObjectList)this.valueNamedObjects.clone();
        if (this.path2append != null) {
            if (this.localnamespacepath != null) {
                clone.localnamespacepath = (CIMLocalnamespacepath)this.localnamespacepath.clone();
                clone.path2append = clone.localnamespacepath;
            } else {
                clone.namespacepath = (CIMNamespacepath)this.namespacepath.clone();
                clone.path2append = clone.namespacepath;
            }
        }
        return clone;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setLocalnamespacepath(CIMLocalnamespacepath aPath) {
        this.checkWritable();
        this.namespacepath = null;
        this.localnamespacepath = aPath;
        this.path2append = this.localnamespacepath;
        if (this.path2append != null) {
            this.path2append = (ICIMItem)this.path2append.getWritable();
        }
    }

    public void setNamespacepath(CIMNamespacepath aPath) {
        this.checkWritable();
        this.namespacepath = aPath;
        this.path2append = this.namespacepath;
        this.localnamespacepath = null;
        if (this.path2append != null) {
            this.path2append = (ICIMItem)this.path2append.getWritable();
        }
    }

    void addLocalnamespacepath(CIMLocalnamespacepath aPath) throws ItemConstructionExcp {
        if (this.path2append != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aPath, this.path2append);
        }
        this.setLocalnamespacepath(aPath);
    }

    void addNamespacepath(CIMNamespacepath aPath) throws ItemConstructionExcp {
        if (this.path2append != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aPath, this.path2append);
        }
        this.setNamespacepath(aPath);
    }

    public void addQualifierDeclaration(CIMQualifierDeclaration aQualifierDeclaration) {
        this.qualifierDeclarations.add(aQualifierDeclaration);
    }

    public void addValueNamedObject(CIMValueNamedObject aValueNamedObject) {
        this.valueNamedObjects.add(aValueNamedObject);
    }

    public CIMValueNamedObjectList getValueObjects() {
        return this.valueNamedObjects;
    }

    public CIMQualifierDeclaration getQualifierDeclarationByName(String qualifierName) {
        return this.qualifierDeclarations.get(qualifierName);
    }

    public CIMValueNamedObject getValueNamedObjectByClassName(String className) {
        int j = 0;
        while (j < this.valueNamedObjects.size()) {
            CIMValueNamedObject nextValueNamedObject = this.valueNamedObjects.get(j);
            CIMClass nextClass = nextValueNamedObject.getCimClass();
            if (nextClass != null && className.equalsIgnoreCase(nextClass.getClassname())) {
                return nextValueNamedObject;
            }
            ++j;
        }
        return null;
    }

    public CIMValueNamedObject getValueNamedObjectByInstanceName(CIMInstancename instanceName) {
        int j = 0;
        while (j < this.valueNamedObjects.size()) {
            CIMValueNamedObject nextValueNamedObject = this.valueNamedObjects.get(j);
            CIMInstancename nextInstanceName = nextValueNamedObject.getInstancename();
            if (nextInstanceName != null && instanceName.equals(nextInstanceName)) {
                return nextValueNamedObject;
            }
            ++j;
        }
        return null;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        if (this.path2append != null) {
            subelements.addObject(this.path2append);
        }
        subelements.addIterator(this.qualifierDeclarations);
        subelements.addIterator(this.valueNamedObjects);
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMDeclgroupWithName)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMDeclgroupWithName source = (CIMDeclgroupWithName)sourceItem;
        int i = 0;
        while (i < source.qualifierDeclarations.size()) {
            CIMQualifierDeclaration sourceQualifierDecl = source.qualifierDeclarations.get(i);
            String sourceQualifierName = sourceQualifierDecl.getName();
            CIMQualifierDeclaration targetQualifierDecl = this.getQualifierDeclarationByName(sourceQualifierName);
            if (targetQualifierDecl != null) {
                targetQualifierDecl.merge(sourceQualifierDecl);
            } else {
                this.qualifierDeclarations.add((CIMQualifierDeclaration)sourceQualifierDecl.clone());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < source.valueNamedObjects.size()) {
            CIMValueNamedObject targetValueNamedObject;
            CIMValueNamedObject sourceValueNamedObject = source.valueNamedObjects.get(i2);
            CIMClass sourceClass = sourceValueNamedObject.getCimClass();
            if (sourceClass != null) {
                targetValueNamedObject = this.getValueNamedObjectByClassName(sourceClass.getClassname());
                if (targetValueNamedObject != null) {
                    targetValueNamedObject.merge(sourceValueNamedObject);
                } else {
                    this.addValueNamedObject((CIMValueNamedObject)sourceValueNamedObject.clone());
                }
            } else {
                CIMInstancename sourceInstanceName = sourceValueNamedObject.getInstancename();
                if (sourceInstanceName != null) {
                    targetValueNamedObject = this.getValueNamedObjectByInstanceName(sourceInstanceName);
                    if (targetValueNamedObject != null) {
                        targetValueNamedObject.merge(sourceValueNamedObject);
                    } else {
                        this.addValueNamedObject((CIMValueNamedObject)sourceValueNamedObject.clone());
                    }
                }
            }
            ++i2;
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addDeclgroupWithName(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.path2append != null) {
                this.path2append.validateCharacters(includeNames);
            }
            this.qualifierDeclarations.validateCharacters(includeNames);
            this.valueNamedObjects.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    public CIMHost getHost() {
        return this.namespacepath == null ? null : this.namespacepath.getHost();
    }

    public String getHostname() {
        CIMHost host = this.getHost();
        return host == null ? "" : host.toString();
    }

    public CIMNamespacepath getNamespacepath() {
        return this.namespacepath;
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        if (this.localnamespacepath != null) {
            return this.localnamespacepath;
        }
        return this.namespacepath == null ? null : this.namespacepath.getLocalnamespacepath();
    }

    public CIMItemList getObjectList() {
        return this.valueNamedObjects;
    }

    public CIMQualifierDeclarationList getQualifierDeclarations() {
        return this.qualifierDeclarations;
    }
}

