/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemList;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMQualifierDeclaration;
import com.sap.lcr.api.cim.CIMQualifierDeclarationList;
import com.sap.lcr.api.cim.CIMValueObject;
import com.sap.lcr.api.cim.CIMValueObjectList;
import com.sap.lcr.api.cim.ICIMDeclGroup;
import com.sap.lcr.api.cim.ICIMItem;
import com.sap.lcr.api.cim.ICIMWithNamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.MultiIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CIMDeclgroup
extends CIMItem
implements ICIMWithNamespacepath,
ICIMDeclGroup {
    public static final String DTD_NAME = "DECLGROUP";
    private CIMLocalnamespacepath localnamespacepath;
    private CIMNamespacepath namespacepath;
    private ICIMItem pathAppender;
    private CIMQualifierDeclarationList qualifierDeclarations = CIMFactory.qualifierDeclarationList();
    private CIMValueObjectList valueObjects = CIMFactory.valueObjectList();
    private HashMap mergeMap;

    protected CIMDeclgroup() {
    }

    public CIMDeclgroup toWritable() {
        return (CIMDeclgroup)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        if (this.localnamespacepath != null) {
            this.localnamespacepath.makeReadOnly();
        }
        if (this.namespacepath != null) {
            this.namespacepath.makeReadOnly();
        }
        this.qualifierDeclarations.makeReadOnly();
        this.valueObjects.makeReadOnly();
    }

    boolean isDTDConformant() {
        return true;
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public Object clone() {
        CIMDeclgroup clone = (CIMDeclgroup)super.clone();
        clone.qualifierDeclarations = (CIMQualifierDeclarationList)this.qualifierDeclarations.clone();
        clone.valueObjects = (CIMValueObjectList)this.valueObjects.clone();
        if (this.pathAppender != null) {
            if (this.localnamespacepath != null) {
                clone.localnamespacepath = (CIMLocalnamespacepath)this.localnamespacepath.clone();
                clone.pathAppender = clone.localnamespacepath;
            } else {
                clone.namespacepath = (CIMNamespacepath)this.namespacepath.clone();
                clone.pathAppender = clone.namespacepath;
            }
        }
        return clone;
    }

    public void setLocalnamespacepath(CIMLocalnamespacepath aPath) {
        this.checkWritable();
        this.localnamespacepath = aPath;
        this.pathAppender = this.localnamespacepath;
        this.namespacepath = null;
        if (this.pathAppender != null) {
            this.pathAppender = (ICIMItem)this.pathAppender.getWritable();
        }
    }

    public void setNamespacepath(CIMNamespacepath aPath) {
        this.checkWritable();
        this.localnamespacepath = null;
        this.namespacepath = aPath;
        this.pathAppender = this.namespacepath;
        if (this.pathAppender != null) {
            this.pathAppender = (ICIMItem)this.pathAppender.getWritable();
        }
    }

    void addLocalnamespacepath(CIMLocalnamespacepath aPath) throws ItemConstructionExcp {
        if (this.pathAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aPath, this.pathAppender);
        }
        this.setLocalnamespacepath(aPath);
    }

    void addNamespacepath(CIMNamespacepath aPath) throws ItemConstructionExcp {
        if (this.pathAppender != null) {
            throw ItemConstructionExcp.createUnexpectedSubelementExcp(this, aPath, this.pathAppender);
        }
        this.setNamespacepath(aPath);
    }

    public void addQualifierDeclaration(CIMQualifierDeclaration aQualifierDeclaration) {
        this.qualifierDeclarations.add(aQualifierDeclaration);
    }

    public void addValueObject(CIMValueObject aValueObject) {
        this.valueObjects.add(aValueObject);
    }

    public CIMValueObjectList getValueObjects() {
        return this.valueObjects;
    }

    public CIMQualifierDeclaration getQualifierDeclarationByName(String qualifierName) {
        return this.qualifierDeclarations.get(qualifierName);
    }

    public CIMValueObject getValueObjectByClassName(String className) {
        int j = 0;
        while (j < this.valueObjects.size()) {
            CIMValueObject nextValueObject = this.valueObjects.get(j);
            CIMClass nextClass = nextValueObject.getCimClass();
            if (nextClass != null && className.equalsIgnoreCase(nextClass.getClassname())) {
                return nextValueObject;
            }
            ++j;
        }
        return null;
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        MultiIterator subelements = new MultiIterator();
        if (this.pathAppender != null) {
            subelements.addObject(this.pathAppender);
        }
        subelements.addIterator(this.qualifierDeclarations);
        subelements.addIterator(this.valueObjects);
        this.appendXml(writer, DTD_NAME, subelements, indent);
    }

    public void sortClasses() {
        if (this.mergeMap == null) {
            this.mergeMap = new HashMap();
        } else {
            this.mergeMap.clear();
        }
        this.collectForSortedMerge(this, true);
        CIMValueObjectList sortedValueObjects = this.sortCollectedElements();
        if (sortedValueObjects != this.valueObjects) {
            this.addInstanceObjects(this, sortedValueObjects, false);
            this.valueObjects = sortedValueObjects;
        }
    }

    void mergeWritable(ICIMItem sourceItem) throws ItemConstructionExcp {
        if (!(sourceItem instanceof CIMDeclgroup)) {
            throw ItemConstructionExcp.createMergeMismatchException(this, sourceItem);
        }
        CIMDeclgroup source = (CIMDeclgroup)sourceItem;
        if (this.mergeMap == null) {
            this.mergeMap = new HashMap();
        } else {
            this.mergeMap.clear();
        }
        int i = 0;
        while (i < source.qualifierDeclarations.size()) {
            CIMQualifierDeclaration sourceQualifierDecl = source.qualifierDeclarations.get(i);
            String sourceQualifierName = sourceQualifierDecl.getName();
            CIMQualifierDeclaration targetQualifierDecl = this.getQualifierDeclarationByName(sourceQualifierName);
            if (targetQualifierDecl != null) {
                targetQualifierDecl.merge(sourceQualifierDecl);
            } else {
                this.qualifierDeclarations.add(sourceQualifierDecl);
            }
            ++i;
        }
        this.collectForSortedMerge(this, true);
        this.collectForSortedMerge(source, false);
        this.mergeCollectedElements(source);
        CIMValueObjectList sortedValueObjects = this.sortCollectedElements();
        if (sortedValueObjects != this.valueObjects) {
            this.addInstanceObjects(this, sortedValueObjects, false);
            this.addInstanceObjects(source, sortedValueObjects, true);
            this.valueObjects = sortedValueObjects;
        } else {
            this.addInstanceObjects(source, this.valueObjects, true);
        }
    }

    private void collectForSortedMerge(CIMDeclgroup source, boolean prefered) {
        ArrayList<CIMClassname[]> inheritanceList = new ArrayList<CIMClassname[]>();
        ArrayList referenceList = new ArrayList();
        ArrayList weakStrongList = new ArrayList();
        int i = 0;
        while (i < source.valueObjects.size()) {
            CIMValueObject sourceValueObject = source.valueObjects.get(i);
            CIMClass sourceClass = sourceValueObject.getCimClass();
            if (sourceClass != null) {
                CIMClassname sourceClassName = sourceClass.getCIMClassname();
                ItemSortState mappedItemState = (ItemSortState)this.mergeMap.get(sourceClassName);
                if (mappedItemState == null) {
                    mappedItemState = new ItemSortState(sourceValueObject);
                    this.mergeMap.put(sourceClassName, mappedItemState);
                }
                if (prefered) {
                    mappedItemState.setFirstIndex(i);
                } else {
                    mappedItemState.setSecondIndex(i);
                }
                CIMClassname sourceSuperClassName = sourceClass.getCIMSuperclassname();
                if (sourceSuperClassName != null) {
                    inheritanceList.add(new CIMClassname[]{sourceClassName, sourceSuperClassName});
                }
                if (sourceClass.isAssociation()) {
                    mappedItemState.setAssocType(true);
                    this.collectAssociationDependencies(sourceClass, sourceClassName, mappedItemState, referenceList, weakStrongList);
                }
            }
            ++i;
        }
        int k = 0;
        while (k < inheritanceList.size()) {
            CIMClassname[] relatives = (CIMClassname[])inheritanceList.get(k);
            this.addReferenceDependency(relatives[0], relatives[1], false);
            this.addInheritanceRelation(relatives[0], relatives[1]);
            ++k;
        }
        int k2 = 0;
        while (k2 < referenceList.size()) {
            CIMClassname[] referers = (CIMClassname[])referenceList.get(k2);
            this.addReferenceDependency(referers[0], referers[1], true);
            ++k2;
        }
        int k3 = 0;
        while (k3 < weakStrongList.size()) {
            CIMClassname[] partners = (CIMClassname[])weakStrongList.get(k3);
            this.addReferenceDependency(partners[0], partners[1], false);
            ++k3;
        }
    }

    private void collectAssociationDependencies(CIMClass sourceClass, CIMClassname sourceClassName, ItemSortState mappedItemState, ArrayList referenceList, ArrayList weakStrongList) {
        Iterator refIter = sourceClass.getPropertyReferenceIterator();
        CIMClassname weakEnd = null;
        while (refIter.hasNext()) {
            CIMPropertyReference nextPropRef = (CIMPropertyReference)refIter.next();
            String nextRefNameString = nextPropRef.getReferenceClass();
            if (nextRefNameString == null) continue;
            CIMClassname nextRefName = CIMFactory.classname(nextRefNameString);
            referenceList.add(new CIMClassname[]{sourceClassName, nextRefName});
            if (!nextPropRef.isWeak()) continue;
            weakEnd = nextRefName;
        }
        if (weakEnd != null) {
            Iterator refIter2 = sourceClass.getPropertyReferenceIterator();
            while (refIter2.hasNext()) {
                CIMClassname nextRefName;
                CIMPropertyReference nextPropRef = (CIMPropertyReference)refIter2.next();
                String nextRefNameString = nextPropRef.getReferenceClass();
                if (nextRefNameString == null || (nextRefName = CIMFactory.classname(nextRefNameString)).equals(weakEnd)) continue;
                weakStrongList.add(new CIMClassname[]{weakEnd, nextRefName});
            }
        }
    }

    private void addReferenceDependency(CIMClassname dependent, CIMClassname antecedent, boolean expandToSubClasses) {
        ItemSortState anteItemState = (ItemSortState)this.mergeMap.get(antecedent);
        ItemSortState depItemState = (ItemSortState)this.mergeMap.get(dependent);
        if (anteItemState != null && depItemState != null) {
            this.addReferenceDependency(antecedent, depItemState);
            if (expandToSubClasses) {
                int j = 0;
                while (j < anteItemState.subClassNames.size()) {
                    CIMClassname nextAnteChildName = (CIMClassname)anteItemState.subClassNames.get(j);
                    this.addReferenceDependency(dependent, nextAnteChildName, expandToSubClasses);
                    ++j;
                }
            }
        }
    }

    private void addReferenceDependency(CIMClassname aClassName, ItemSortState anItemState) {
        boolean refFound = false;
        int j = 0;
        while (j < anItemState.refClassNames.size()) {
            CIMClassname refName = (CIMClassname)anItemState.refClassNames.get(j);
            if (refName.equals(aClassName)) {
                refFound = true;
                break;
            }
            ++j;
        }
        if (!refFound) {
            anItemState.addRefClassName(aClassName);
        }
    }

    private void addInheritanceRelation(CIMClassname child, CIMClassname parent) {
        ItemSortState parentItemState = (ItemSortState)this.mergeMap.get(parent);
        ItemSortState childItemState = (ItemSortState)this.mergeMap.get(child);
        if (parentItemState != null && childItemState != null) {
            boolean childFound = false;
            int j = 0;
            while (j < parentItemState.subClassNames.size()) {
                CIMClassname subName = (CIMClassname)parentItemState.subClassNames.get(j);
                if (subName.equals(child)) {
                    childFound = true;
                    break;
                }
                ++j;
            }
            if (!childFound) {
                parentItemState.addSubClassName(child);
            }
        }
    }

    private void mergeCollectedElements(CIMDeclgroup source) throws ItemConstructionExcp {
        Set mergeSet = this.mergeMap.entrySet();
        Iterator mergeEntryIterator = mergeSet.iterator();
        while (mergeEntryIterator.hasNext()) {
            Map.Entry nextEntry = mergeEntryIterator.next();
            ItemSortState nextSortState = (ItemSortState)nextEntry.getValue();
            this.mergeStateItem(nextSortState, source);
        }
    }

    private CIMValueObjectList sortCollectedElements() {
        CIMValueObjectList result = CIMFactory.valueObjectList();
        Set sortSet = this.mergeMap.entrySet();
        int numLeft = sortSet.size();
        if (this.isCurrentOrderAlright()) {
            return this.valueObjects;
        }
        boolean classesProcessed = false;
        while (numLeft > 0) {
            int numLeftPrevious = numLeft;
            int numLeftClasses = 0;
            numLeft = 0;
            Iterator sortEntryIterator = sortSet.iterator();
            while (sortEntryIterator.hasNext()) {
                Map.Entry nextEntry = sortEntryIterator.next();
                ItemSortState nextSortState = (ItemSortState)nextEntry.getValue();
                if (nextSortState.processed) continue;
                if (nextSortState.assocType && !classesProcessed) {
                    ++numLeft;
                    continue;
                }
                if (!this.dependenciesResolved(nextSortState)) {
                    if (!nextSortState.assocType) {
                        ++numLeftClasses;
                    }
                    ++numLeft;
                    continue;
                }
                this.processItem(nextSortState, result);
                nextSortState.setProcessed(true);
            }
            if (!classesProcessed && numLeftClasses == 0) {
                classesProcessed = true;
            }
            if (numLeft < numLeftPrevious) continue;
            Iterator errorEntryIterator = sortSet.iterator();
            while (errorEntryIterator.hasNext()) {
                Map.Entry nextEntry = errorEntryIterator.next();
                ItemSortState nextSortState = (ItemSortState)nextEntry.getValue();
                if (nextSortState.processed) continue;
                this.processItem(nextSortState, result);
                nextSortState.setProcessed(true);
            }
        }
        return result;
    }

    private boolean dependenciesResolved(ItemSortState aSortState) {
        int j = 0;
        while (j < aSortState.refClassNames.size()) {
            CIMClassname refName = (CIMClassname)aSortState.refClassNames.get(j);
            ItemSortState refState = (ItemSortState)this.mergeMap.get(refName);
            if (refState != null && !refState.processed) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private void mergeStateItem(ItemSortState aSortState, CIMDeclgroup source) throws ItemConstructionExcp {
        int targetIndex = aSortState.firstIndex;
        int sourceIndex = aSortState.secondIndex;
        if (sourceIndex >= 0) {
            CIMValueObject sourceValueObject = source.valueObjects.get(sourceIndex);
            if (targetIndex >= 0) {
                CIMValueObject targetValueObject = this.valueObjects.get(targetIndex);
                targetValueObject.merge(sourceValueObject);
            } else {
                aSortState.setFirstIndex(this.valueObjects.size());
                this.valueObjects.add((CIMValueObject)sourceValueObject.clone());
            }
        }
    }

    private void processItem(ItemSortState aSortState, CIMValueObjectList result) {
        int targetIndex = aSortState.firstIndex;
        if (targetIndex >= 0) {
            CIMValueObject targetValueObject = this.valueObjects.get(targetIndex);
            result.add(targetValueObject);
        }
    }

    private void addInstanceObjects(CIMDeclgroup source, CIMValueObjectList result, boolean clone) {
        int i = 0;
        while (i < source.valueObjects.size()) {
            CIMValueObject sourceValueObject = source.valueObjects.get(i);
            CIMClass sourceClass = sourceValueObject.getCimClass();
            if (sourceClass == null) {
                if (clone) {
                    sourceValueObject = (CIMValueObject)sourceValueObject.clone();
                }
                result.add(sourceValueObject);
            }
            ++i;
        }
    }

    private boolean isCurrentOrderAlright() {
        int numOfClassObjects = 0;
        int i = 0;
        while (i < this.valueObjects.size()) {
            CIMClassname sourceClassName = this.getItemClassName(this.valueObjects.get(i));
            if (sourceClassName != null) {
                ItemSortState mappedItemState = (ItemSortState)this.mergeMap.get(sourceClassName);
                if (mappedItemState == null) {
                    return false;
                }
                if (!this.dependenciesFulfilled(mappedItemState, i)) {
                    return false;
                }
                ++numOfClassObjects;
            }
            ++i;
        }
        return numOfClassObjects == this.mergeMap.size();
    }

    private CIMClassname getItemClassName(CIMValueObject aValueObject) {
        CIMClass sourceClass = aValueObject.getCimClass();
        if (sourceClass == null) {
            return null;
        }
        return sourceClass.getCIMClassname();
    }

    private boolean dependenciesFulfilled(ItemSortState aSortState, int objIndex) {
        int j = 0;
        while (j < aSortState.refClassNames.size()) {
            CIMClassname refName = (CIMClassname)aSortState.refClassNames.get(j);
            ItemSortState refState = (ItemSortState)this.mergeMap.get(refName);
            if (refState != null && refState.firstIndex > objIndex) {
                return false;
            }
            ++j;
        }
        return true;
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addDeclgroup(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.pathAppender != null) {
                this.pathAppender.validateCharacters(includeNames);
            }
            this.qualifierDeclarations.validateCharacters(includeNames);
            this.valueObjects.validateCharacters(includeNames);
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    public CIMHost getHost() {
        return this.namespacepath == null ? null : this.namespacepath.getHost();
    }

    public String getHostname() {
        CIMHost host = this.getHost();
        return host == null ? "" : host.toString();
    }

    public CIMNamespacepath getNamespacepath() {
        return this.namespacepath;
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        if (this.localnamespacepath != null) {
            return this.localnamespacepath;
        }
        return this.namespacepath == null ? null : this.namespacepath.getLocalnamespacepath();
    }

    public CIMItemList getObjectList() {
        return this.valueObjects;
    }

    public CIMQualifierDeclarationList getQualifierDeclarations() {
        return this.qualifierDeclarations;
    }

    private static class ItemSortState {
        CIMValueObject valueObject;
        int firstIndex = -1;
        int secondIndex = -1;
        boolean assocType = false;
        ArrayList refClassNames = new ArrayList();
        ArrayList subClassNames = new ArrayList();
        boolean processed = false;

        ItemSortState(CIMValueObject aCIMValueObject) {
            this.valueObject = aCIMValueObject;
        }

        void setFirstIndex(int index) {
            this.firstIndex = index;
        }

        void setSecondIndex(int index) {
            this.secondIndex = index;
        }

        void setAssocType(boolean flag) {
            this.assocType = flag;
        }

        void addRefClassName(CIMClassname aClassName) {
            this.refClassNames.add(aClassName);
        }

        void setProcessed(boolean flag) {
            this.processed = flag;
        }

        void addSubClassName(CIMClassname aClassName) {
            this.subClassNames.add(aClassName);
        }
    }
}

