/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClassname;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMHost;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjRef;
import com.sap.lcr.api.cim.ICIMWithNamespacepath;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimname.CIMObjectReference;
import java.io.IOException;
import java.io.Writer;

public class CIMClasspath
extends CIMItem
implements ICIMWithNamespacepath,
ICIMObjRef {
    public static final String DTD_NAME = "CLASSPATH";
    private CIMNamespacepath namespacepath;
    private CIMClassname classname;

    protected CIMClasspath() {
    }

    protected CIMClasspath(CIMNamespacepath aNamespacepath, CIMClassname aClassname) {
        this();
        this.checkNonNull(aClassname, "CLASSNAME");
        this.checkNonNull(aNamespacepath, "NAMESPACEPATH");
        this.namespacepath = aNamespacepath;
        this.classname = aClassname;
        if (this.classname.isReadOnly() || this.namespacepath.isReadOnly()) {
            this.classname = (CIMClassname)this.classname.getReadOnly();
            this.namespacepath = (CIMNamespacepath)this.namespacepath.getReadOnly();
            this.makeReadOnly();
        }
    }

    public CIMClasspath toWritable() {
        return (CIMClasspath)this.getWritable();
    }

    void makeSubelementsReadOnly() {
        this.classname.makeReadOnly();
        this.namespacepath.makeReadOnly();
    }

    boolean isDTDConformant() {
        return this.classname != null && this.namespacepath != null;
    }

    public Object clone() {
        CIMClasspath clone = (CIMClasspath)super.clone();
        if (this.namespacepath != null) {
            clone.namespacepath = (CIMNamespacepath)this.namespacepath.clone();
        }
        if (this.classname != null) {
            clone.classname = (CIMClassname)this.classname.clone();
        }
        return clone;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMClasspath) {
            CIMClasspath cp = (CIMClasspath)aObj;
            if (this.classname == null && cp.classname != null) {
                return false;
            }
            if (this.namespacepath == null && cp.namespacepath != null) {
                return false;
            }
            return this.classname.equals(cp.classname) && this.namespacepath.equals(cp.namespacepath);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public void setNamespacepath(CIMNamespacepath aNamespacepath) {
        this.checkNonNull(aNamespacepath, "NAMESPACEPATH");
        this.checkWritable();
        this.namespacepath = aNamespacepath.toWritable();
    }

    public void setClassname(CIMClassname aClassname) {
        this.checkNonNull(aClassname, "CLASSNAME");
        this.checkWritable();
        this.classname = aClassname.toWritable();
    }

    public CIMClassname getCIMClassname() {
        return this.classname;
    }

    public String getClassname() {
        return this.classname == null ? "" : this.classname.toDisplayString();
    }

    String toString(boolean comparable) {
        if (this.classname == null || this.namespacepath == null) {
            return "";
        }
        String cls = this.classname.toString(comparable);
        String nsp = this.namespacepath.toString(comparable);
        StringBuffer buf = new StringBuffer(nsp.length() + 1 + cls.length());
        return buf.append(nsp).append(':').append(cls).toString();
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, this.namespacepath, this.classname, indent);
    }

    void addNamespacepath(CIMNamespacepath aNamespacepath) throws ItemConstructionExcp {
        if (this.namespacepath != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aNamespacepath);
        }
        this.setNamespacepath(aNamespacepath);
    }

    void addClassname(CIMClassname aClassname) throws ItemConstructionExcp {
        if (this.classname != null) {
            throw ItemConstructionExcp.createDuplicateSubelementExcp(this, aClassname);
        }
        this.setClassname(aClassname);
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addClasspath(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        try {
            if (this.classname != null) {
                this.classname.validateCharacters(includeNames);
            }
            if (this.namespacepath != null) {
                this.namespacepath.validateCharacters(includeNames);
            }
        }
        catch (ItemConstructionExcp e) {
            e.appendToMessage(this);
            throw e;
        }
    }

    public boolean equals(String classPath) {
        if (classPath == null) {
            return false;
        }
        try {
            return this.equals(CIMFactory.createClasspathFromString(classPath));
        }
        catch (LcrException ex) {
            return false;
        }
    }

    public String toDisplayString() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(true);
    }

    public CIMValueReference createValueReference() {
        return CIMFactory.valueReference(this);
    }

    public CIMObjectReference toCIMObjectReference() throws ReferenceConversionExcp {
        CIMObjectReference reference = this.classname.toCIMObjectReference();
        this.namespacepath.addToCIMObjectReference(reference);
        return reference;
    }

    public CIMHost getHost() {
        return this.namespacepath == null ? null : this.namespacepath.getHost();
    }

    public String getHostname() {
        CIMHost host = this.getHost();
        return host == null ? "" : host.toString();
    }

    public CIMNamespacepath getNamespacepath() {
        return this.namespacepath;
    }

    public CIMLocalnamespacepath getLocalnamespacepath() {
        return this.namespacepath == null ? null : this.namespacepath.getLocalnamespacepath();
    }
}

