/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.cim;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMItem;
import com.sap.lcr.api.cim.CIMItemWA;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjRef;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cim.ReferenceConversionExcp;
import com.sap.lcr.api.cimname.CIMObjectReference;
import com.sap.lcr.api.util.Util;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;

public final class CIMClassname
extends CIMItemWA
implements ICIMObjRef {
    public static final String DTD_NAME = "CLASSNAME";
    private String attrName;
    private String lowerName;

    protected CIMClassname() {
        super(true);
    }

    protected CIMClassname(String aClassname) {
        super(true);
        this.checkNonNull(aClassname, "NAME");
        this.attrName = aClassname;
        this.lowerName = this.attrName.toLowerCase();
    }

    public CIMClassname toWritable() {
        return (CIMClassname)this.getWritable();
    }

    void makeSubelementsReadOnly() {
    }

    boolean isDTDConformant() {
        return this.attrName != null;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj instanceof CIMClassname) {
            CIMClassname other = (CIMClassname)aObj;
            return Util.equals(this.lowerName, other.lowerName);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerName == null ? 0 : this.lowerName.hashCode();
    }

    public final String getDTDName() {
        return DTD_NAME;
    }

    public String getName() {
        return this.attrName;
    }

    String toString(boolean comparable) {
        return comparable ? this.toString() : this.toDisplayString();
    }

    public CIMClass newCIMClass() {
        return CIMFactory.cimclass(this.attrName);
    }

    public void appendXml(Writer writer, String indent) throws IOException {
        this.appendXml(writer, DTD_NAME, indent);
    }

    void doAppendXmlAttributes(Writer writer) throws IOException {
        CIMUtil.appendXmlAttributeUnescaped(writer, "NAME", this.attrName);
    }

    void setAttributesWritable(Attributes attributes) throws ItemConstructionExcp {
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (!"NAME".equals(name)) {
                throw ItemConstructionExcp.createAttributeNotAllowedExcp(name, this);
            }
            this.attrName = value;
            this.lowerName = this.attrName.toLowerCase();
            ++i;
        }
        if (this.attrName == null) {
            throw ItemConstructionExcp.createRequiredAttributeMissingExcp("NAME", this);
        }
    }

    void endXmlBuildWritable(CIMItem parentItem) throws ItemConstructionExcp {
        parentItem.addClassname(this);
    }

    public void validateCharacters(boolean includeNames) throws ItemConstructionExcp {
        if (includeNames) {
            this.validateStringForXml(this.attrName, "class name");
        }
    }

    public boolean equals(String className) {
        return className == null ? false : className.equalsIgnoreCase(this.attrName);
    }

    public CIMObjectReference toCIMObjectReference() throws ReferenceConversionExcp {
        if (this.attrName != null) {
            return new CIMObjectReference(this.attrName);
        }
        throw new ReferenceConversionExcp(1, "toCIMObjectReference() failed because of missing class name");
    }

    public CIMValueReference createValueReference() {
        return CIMFactory.valueReference(this);
    }

    public String toString() {
        return this.lowerName;
    }

    public String toDisplayString() {
        return this.attrName;
    }
}

