/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder.examples;

import com.sap.lcr.api.builder.AssociatorsDeltaAnalyzer;
import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericDeltaBuilder;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDelta;
import com.sap.lcr.api.builder.InvalidDataException;
import com.sap.lcr.api.builder.MappingUtility;
import com.sap.lcr.api.builder.examples.ReleaseBuilderConstants;
import com.sap.lcr.api.builder.examples.ReleaseData;
import com.sap.lcr.api.cimclient.CIMOMHandle;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.api.util.Version;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ReleaseBuilder
extends GenericDeltaBuilder
implements ReleaseBuilderConstants {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$examples$ReleaseBuilder == null ? (class$com$sap$lcr$api$builder$examples$ReleaseBuilder = ReleaseBuilder.class$("com.sap.lcr.api.builder.examples.ReleaseBuilder")) : class$com$sap$lcr$api$builder$examples$ReleaseBuilder).getName());
    private boolean testMode = false;
    static /* synthetic */ Class class$com$sap$lcr$api$builder$examples$ReleaseBuilder;

    public ReleaseBuilder(CIMOMHandle aCIMClient) {
        super(aCIMClient);
    }

    protected Logger getLogger() {
        return myLogger;
    }

    protected void buildDelta() throws LcrException {
        ReleaseData data = (ReleaseData)this.getCurrentData();
        List newData = data.getElements();
        if (newData.size() < 2) {
            throw new LcrException("Source or target software component not set");
        }
        DeltaElement sourceSCElem = (DeltaElement)newData.get(0);
        DeltaElement targetSCElem = (DeltaElement)newData.get(1);
        String sourceRelease = MappingUtility.getKeyValue(sourceSCElem, ReleaseBuilderConstants.SC_KEYPROP_NAMES[3]);
        String targetRelease = MappingUtility.getKeyValue(targetSCElem, ReleaseBuilderConstants.SC_KEYPROP_NAMES[3]);
        String logMsg = MessageFormat.format("Copying DCs from release \"{0}\" to release \"{1}\"...", sourceRelease, targetRelease);
        myLogger.info(logMsg);
        List sourceDCElems = this.listAssociators(sourceSCElem, "SAP_PrimarySoftwareComponentDevComp", "SAP_DevelopmentComponent");
        List targetDCElems = this.listAssociators(targetSCElem, "SAP_PrimarySoftwareComponentDevComp", "SAP_DevelopmentComponent");
        if (sourceDCElems.size() == 0) {
            myLogger.info("No DCs found for source SC, nothing done");
            return;
        }
        myLogger.info("Number of source DCs found = " + sourceDCElems.size());
        if (targetDCElems.size() > 0) {
            myLogger.info("Number of " + targetDCElems.size() + " DCs found for target SC (-> update possible)");
        } else {
            myLogger.info("No target DCs found, performing only inserts");
        }
        ArrayList newDCElems = this.deriveNewDCList(targetRelease, sourceDCElems);
        this.createNewSCMembers(targetSCElem, newDCElems);
        IDelta result = this.getCurrentDelta();
        if (this.isTestMode()) {
            myLogger.info("Test mode switched on, the following objecs would be synced:");
            myLogger.info("============================================================");
            int i = 0;
            while (i < result.size()) {
                DeltaElement nextElem = result.getObject(i);
                myLogger.info(nextElem.toDisplayString());
                result.setExecuted(i);
                ++i;
            }
            myLogger.info("=============================================");
            myLogger.info("Test mode switched on, delta set to executed.");
            myLogger.info(result.printCounts());
            return;
        }
        result.processDelta();
        this.createNewPatchInstances(newDCElems);
        this.createNewDCLMembers(sourceDCElems, newDCElems);
        myLogger.info("=================================");
        myLogger.info("Printing element counts in delta.");
        myLogger.info(result.printCounts());
    }

    public String getSupplierName() {
        return "DefineReleaseStructure";
    }

    public Version getRequiredModelVersion() {
        return new Version(1, 3);
    }

    public void refresh() throws LcrException {
    }

    public boolean accept(IData dataObj) {
        return dataObj instanceof ReleaseData;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean b) {
        this.testMode = b;
    }

    private ArrayList deriveNewDCList(String targetRelease, List sourceDCElems) throws LcrException {
        ArrayList<DeltaElement> derivedDCElems = new ArrayList<DeltaElement>();
        Iterator iter = sourceDCElems.iterator();
        while (iter.hasNext()) {
            DeltaElement nextSourceDC = (DeltaElement)iter.next();
            DeltaElement nextDerivedDC = (DeltaElement)nextSourceDC.clone();
            try {
                String newCaption;
                MappingUtility.changeKeyValue(nextDerivedDC, "Version", targetRelease, null, null);
                String specName = MappingUtility.getValue(nextSourceDC, "SpecificationName");
                String specVers = MappingUtility.getValue(nextSourceDC, "SpecificationVersion");
                if (specName == null) {
                    specName = "Unknown caption";
                }
                if ((newCaption = specVers == null ? MessageFormat.format("{0}, Release {1}", specName, targetRelease) : MessageFormat.format("{0} {1}, Release {2}", specName, specVers, targetRelease)).length() > 64) {
                    newCaption = newCaption.substring(0, 64);
                }
                MappingUtility.changeValue(nextDerivedDC, "Caption", newCaption, null, null);
            }
            catch (InvalidDataException ivde) {
                String logMsg2 = MessageFormat.format("Invalid data in object \"{0}\".", nextDerivedDC.toDisplayString());
                myLogger.error(logMsg2, ivde);
                throw new LcrException(ivde);
            }
            derivedDCElems.add(nextDerivedDC);
        }
        return derivedDCElems;
    }

    private void createNewSCMembers(DeltaElement targetSCElem, List newDCElems) throws LcrException {
        AssociatorsDeltaAnalyzer myAnalyzer = new AssociatorsDeltaAnalyzer(this, targetSCElem, "SAP_PrimarySoftwareComponentDevComp", "GroupComponent", "PartComponent");
        myAnalyzer.evaluateAssociatorsDelta(newDCElems, this.getCurrentDelta());
    }

    private void createNewDCLMembers(List sourceDCElems, List newDCElems) throws LcrException {
        if (sourceDCElems.size() != newDCElems.size()) {
            throw new LcrException("List sizes of old / new DCs differ: " + sourceDCElems.size() + " / " + newDCElems.size());
        }
        int i = 0;
        while (i < sourceDCElems.size()) {
            DeltaElement nextSourceDC = (DeltaElement)sourceDCElems.get(i);
            DeltaElement nextNewDC = (DeltaElement)newDCElems.get(i);
            List nextDCLines = this.listAssociators(nextSourceDC, "SAP_MemberOfDevCompLine", null);
            if (nextDCLines.size() > 0) {
                AssociatorsDeltaAnalyzer myAnalyzer = new AssociatorsDeltaAnalyzer(this, nextNewDC, "SAP_MemberOfDevCompLine", "Member", "Collection");
                myAnalyzer.setSynchronizeMembers(false);
                myAnalyzer.evaluateAssociatorsDelta(nextDCLines, this.getCurrentDelta());
            }
            ++i;
        }
    }

    private void createNewPatchInstances(List newDCElems) throws LcrException {
        int i = 0;
        while (i < newDCElems.size()) {
            DeltaElement nextDCPatch;
            DeltaElement nextNewDC = (DeltaElement)newDCElems.get(i);
            MappingUtility.checkNonEmptyKeyValues(nextNewDC);
            String kv0 = MappingUtility.getKeyValue(nextNewDC, ReleaseBuilderConstants.DCPAT_KEYPROP_NAMES[0]);
            String kv1 = MappingUtility.getKeyValue(nextNewDC, ReleaseBuilderConstants.DCPAT_KEYPROP_NAMES[1]);
            String kv2 = MappingUtility.getKeyValue(nextNewDC, ReleaseBuilderConstants.DCPAT_KEYPROP_NAMES[2]);
            String kv3 = MappingUtility.getKeyValue(nextNewDC, ReleaseBuilderConstants.DCPAT_KEYPROP_NAMES[3]);
            SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String patchVersion = kv3 + "." + tsFormat.format(new Date()) + ".0000";
            String patchCaption = "Patch 0 of " + MappingUtility.getValue(nextNewDC, "Caption");
            if (patchCaption.length() > 64) {
                patchCaption = patchCaption.substring(0, 64);
            }
            try {
                nextDCPatch = MappingUtility.createDeltaElement("SAP_DevCompPatch", ReleaseBuilderConstants.DCPAT_KEYPROP_NAMES, new String[]{kv0, kv1, kv2, patchVersion}, null, null);
                MappingUtility.changeValue(nextDCPatch, "Caption", patchCaption, null, null);
                MappingUtility.changeValue(nextDCPatch, "PatchLevel", "0", null, null);
            }
            catch (InvalidDataException ivde) {
                throw new LcrException(ivde);
            }
            AssociatorsDeltaAnalyzer myAnalyzer = new AssociatorsDeltaAnalyzer(this, nextNewDC, "SAP_PatchedDevComp", "Antecedent", "Dependent");
            myAnalyzer.setMergeMembers(false);
            ArrayList<DeltaElement> patList = new ArrayList<DeltaElement>();
            patList.add(nextDCPatch);
            IDelta result = this.getCurrentDelta();
            myAnalyzer.evaluateAssociatorsDelta(patList, result);
            myAnalyzer.evaluateMembersCleanup(true, result);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

