/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder.examples;

import com.sap.lcr.api.builder.DataQueue;
import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.GenericInputData;
import com.sap.lcr.api.builder.InvalidDataException;
import com.sap.lcr.api.builder.MappingUtility;
import com.sap.lcr.api.builder.SynchronousDirector;
import com.sap.lcr.api.builder.examples.HostedSystemBuilderFactory;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMOMClient;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import com.tssap.dtr.client.lib.protocol.URL;
import java.util.ArrayList;

public class DefineHostedSystem {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$examples$DefineHostedSystem == null ? (class$com$sap$lcr$api$builder$examples$DefineHostedSystem = DefineHostedSystem.class$("com.sap.lcr.api.builder.examples.DefineHostedSystem")) : class$com$sap$lcr$api$builder$examples$DefineHostedSystem).getName());
    private static final String[] SYSTEM_KEYPROP_NAMES = new String[]{"CreationClassName", "Name"};
    private static final String HOSTED_ASSOC_NAME = "SAP_HostedApplicationSystem";
    static /* synthetic */ Class class$com$sap$lcr$api$builder$examples$DefineHostedSystem;

    public static void main(String[] args) {
        DeltaElement hostedSystem;
        CIMOMClient myCIMClient;
        if (args.length < 8) {
            System.out.println("Usage: DefineHostedSystem <host> <port> <user> <pwd> <HostedCreationClassName> <HostedName> <HostingCreationClassName> <HostingName>");
            return;
        }
        String myHost = args[0];
        String myPort = args[1];
        String myUser = args[2];
        String myPwd = args[3];
        ArrayList<DeltaElement> inputObjList = new ArrayList<DeltaElement>();
        try {
            URL myCimOmURL = ClientFactory.newSAPHttpURL(myHost, Integer.parseInt(myPort));
            myCIMClient = ClientFactory.newInstance().createClient(myCimOmURL, myUser, myPwd);
            String[] hostedKeyValues = new String[]{args[4], args[5]};
            hostedSystem = MappingUtility.createDeltaElement(args[4], SYSTEM_KEYPROP_NAMES, hostedKeyValues, null, null);
            MappingUtility.changeValue(hostedSystem, "Caption", "SLD on " + args[7], null, null);
            String[] hostingKeyValues = new String[]{args[6], args[7]};
            DeltaElement hostingSystem = MappingUtility.createDeltaElement(args[6], SYSTEM_KEYPROP_NAMES, hostingKeyValues, null, null);
            DeltaElement hostedDependency = MappingUtility.createDeltaElement(HOSTED_ASSOC_NAME, hostingSystem, "Antecedent", hostedSystem, "Dependent");
            inputObjList.add(hostedSystem);
            inputObjList.add(hostedDependency);
        }
        catch (CIMClientException cce) {
            System.out.println("Client exception " + cce.getMessage() + " thrown, aborted.");
            cce.printStackTrace();
            return;
        }
        catch (LcrException lce) {
            System.out.println("Unable to create delta elements.");
            lce.printStackTrace();
            return;
        }
        catch (NumberFormatException nfe) {
            System.out.println("Illegal port specified: " + myPort);
            nfe.printStackTrace();
            return;
        }
        catch (InvalidDataException ivde) {
            System.out.println("Invalid input data.");
            ivde.printStackTrace();
            return;
        }
        SynchronousDirector myDirector = new SynchronousDirector();
        HostedSystemBuilderFactory myBuilderFactory = new HostedSystemBuilderFactory();
        try {
            myDirector.addCIMClient(myCIMClient);
            myDirector.addBuilders(myBuilderFactory);
        }
        catch (CIMClientException cce) {
            System.out.println("Unable to setup director.");
            cce.printStackTrace();
            return;
        }
        catch (LcrException lce) {
            System.out.println("Unable to setup director.");
            lce.printStackTrace();
            return;
        }
        DataQueue myQueue = new DataQueue();
        GenericInputData myData = new GenericInputData(inputObjList, null);
        myQueue.add(myData);
        myDirector.setDataQueue(myQueue);
        try {
            myDirector.distributeData();
        }
        catch (LcrException lce) {
            System.out.println("Error when synchronizing hosted systems, data distribution aborted.");
            lce.printStackTrace();
            return;
        }
        myLogger.info("Hosted system synchronized: " + hostedSystem.toDisplayString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

