/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DeltaElement;
import com.sap.lcr.api.builder.InvalidDataException;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMKeyValue;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMPropertyArrayList;
import com.sap.lcr.api.cim.CIMPropertyList;
import com.sap.lcr.api.cim.CIMPropertyReference;
import com.sap.lcr.api.cim.CIMPropertyReferenceList;
import com.sap.lcr.api.cim.CIMUtil;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.LcrException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class MappingUtility {
    public static final String SRCTYPE_BOOLEAN = "BOOLEAN";
    public static final String SRCTYPE_DATE_TIMESTAMP = "TIMESTAMP";
    public static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    public static final String SRCTYPE_DATE_PRINTTIME = "PRINTTIME";
    public static final String PRINTTIME_DATE_FORMAT = "yyyy-MM-dd";
    public static final String PRINTTIME_FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String INITIAL_DATE_PRINTDATE = "0000-00-00";
    public static final String INITIAL_DATE_STAMPDATE = "00000000000000";
    public static final String INITIAL_CIMDATE = "00000000000000.000000+000";

    public static DeltaElement createDeltaElement(String aClassName, String[] keyNames, String[] keyValues, String[] keyTypes, String[] sourceTypes) throws LcrException, InvalidDataException {
        DeltaElement result;
        if (keyNames == null || keyValues == null || keyValues.length != keyNames.length || keyTypes != null && keyTypes.length != keyNames.length) {
            throw new LcrException("illegal parameters submitted to createDeltaElement");
        }
        if (!MappingUtility.validKeyValues(keyValues)) {
            throw new InvalidDataException("Missing key value for class " + aClassName);
        }
        try {
            result = keyTypes == null ? new DeltaElement(aClassName, keyNames, keyValues) : new DeltaElement(aClassName, keyNames, keyValues, keyTypes);
        }
        catch (ItemConstructionExcp ice) {
            throw new LcrException(ice);
        }
        return result;
    }

    public static boolean validKeyValues(String[] keyValues) {
        if (keyValues == null) {
            return false;
        }
        int i = 0;
        while (i < keyValues.length) {
            if (keyValues[i] == null || keyValues[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DeltaElement createDeltaElement(String anAssocName, DeltaElement leftSide, String leftRole, DeltaElement rightSide, String rightRole) throws LcrException, InvalidDataException {
        if (leftSide == null || rightSide == null) {
            throw new LcrException("illegal parameters submitted to createDeltaElement");
        }
        if (leftSide.getMyInstanceName() == null || rightSide.getMyInstanceName() == null) {
            throw new InvalidDataException("association ends not valid");
        }
        return new DeltaElement(anAssocName, leftSide.getMyInstanceName(), leftRole, rightSide.getMyInstanceName(), rightRole);
    }

    public static String getKeyValue(DeltaElement obj, String keyName) throws LcrException {
        CIMInstancename objName = obj.getMyInstanceName();
        if (objName != null) {
            CIMKeyValue keyValue = CIMUtil.getKeyValueByName(objName, keyName);
            return keyValue == null ? null : keyValue.getValue();
        }
        throw new LcrException("Undefined instance name in getKeyValue");
    }

    public static void changeKeyValue(DeltaElement obj, String keyName, String keyValue, String keyType, String sourceType) throws LcrException, InvalidDataException {
        String keyPropType;
        if (obj == null) {
            throw new LcrException("No delta element supplied to change in changeKeyValue");
        }
        CIMInstancename targetInstanceName = obj.getMyInstanceName();
        if (targetInstanceName == null) {
            throw new LcrException("No instance name supplied to change in changeKeyValue");
        }
        CIMInstance targetInstance = obj.getMyInstance();
        if (keyName == null || keyName.length() == 0 || keyValue == null || keyValue.length() == 0) {
            throw new InvalidDataException("Undefined key value supplied");
        }
        if (keyType != null) {
            keyPropType = CIMUtil.cimType2keypropertyType(keyType);
            if (keyPropType == null) {
                throw new LcrException("Invalid key property type submitted to changeKeyValue");
            }
        } else {
            keyPropType = "string";
        }
        try {
            CIMKeybinding newKeyBinding = CIMFactory.keybinding(keyName, keyPropType, keyValue);
            targetInstanceName.addKeybinding(newKeyBinding);
            if (targetInstance != null) {
                String propType = keyType != null ? keyType : "string";
                CIMProperty newProperty = CIMFactory.property(keyName, propType, keyValue);
                targetInstance.addProperty(newProperty);
            }
        }
        catch (ItemConstructionExcp ice) {
            throw new LcrException(ice);
        }
    }

    public static String getValue(DeltaElement obj, String propertyName) throws LcrException {
        CIMInstance objInst = obj.getMyInstance();
        if (objInst != null) {
            return objInst.getPropertyValue(propertyName);
        }
        throw new LcrException("Undefined instance in getValue");
    }

    public static void changeValue(DeltaElement obj, String propertyName, String propertyValue, String propertyType, String sourceType) throws LcrException, InvalidDataException {
        if (obj == null) {
            throw new LcrException("No delta element supplied to change in changeValue");
        }
        CIMInstance targetInstance = obj.getMyInstance();
        if (targetInstance == null) {
            throw new LcrException("No instance supplied to change in changeValue");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new InvalidDataException("Undefined property name submitted to changeValue");
        }
        try {
            String propType = propertyType != null ? propertyType : "string";
            CIMProperty newProperty = CIMFactory.property(propertyName, propType, propertyValue);
            targetInstance.addProperty(newProperty);
        }
        catch (ItemConstructionExcp ice) {
            throw new LcrException(ice);
        }
    }

    public static String[] getValueArray(DeltaElement obj, String propertyName) throws LcrException {
        CIMInstance objInst = obj.getMyInstance();
        if (objInst != null) {
            CIMPropertyArray propArray = objInst.getPropertyArrayByName(propertyName);
            if (propArray != null) {
                CIMValueArray valueArray = propArray.getValueArray();
                String[] result = new String[valueArray.size()];
                int index = 0;
                Iterator iterator = valueArray.iterator();
                while (iterator.hasNext()) {
                    CIMValue element = (CIMValue)iterator.next();
                    result[index++] = element.getStringvalue();
                }
                return result;
            }
            return null;
        }
        throw new LcrException("Undefined instance in getValueArray");
    }

    public static void changeValueArray(DeltaElement obj, String propertyName, String[] propertyValues, String propertyType, String sourceType) throws LcrException, InvalidDataException {
        if (obj == null) {
            throw new LcrException("No delta element supplied to change in changeValueArray");
        }
        CIMInstance targetInstance = obj.getMyInstance();
        if (targetInstance == null) {
            throw new LcrException("No instance supplied to change in changeValueArray");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new InvalidDataException("Undefined property name submitted to changeValueArray");
        }
        try {
            String propType = propertyType != null ? propertyType : "string";
            CIMValueArray newValueArray = CIMFactory.valueArray(propertyValues);
            CIMPropertyArray newPropertyArray = CIMFactory.propertyArray(propertyName, propType, newValueArray);
            targetInstance.addPropertyArray(newPropertyArray);
        }
        catch (ItemConstructionExcp ice) {
            throw new LcrException(ice);
        }
    }

    public static DeltaElement extractReferencedName(DeltaElement refElem, String role) {
        CIMInstancename refElemName = refElem.getMyInstanceName();
        CIMValueReference vref = CIMUtil.getValueReferenceByName(refElemName, role);
        if (vref == null) {
            return null;
        }
        CIMInstancename vName = vref.getInstancename();
        if (vName == null) {
            return null;
        }
        return new DeltaElement(vName, null);
    }

    public static String transformValue(String propertyValue, String propertyType, String sourceType) throws InvalidDataException {
        String convertedValue = propertyValue;
        if (propertyType != null) {
            if (propertyType.equals("boolean")) {
                convertedValue = MappingUtility.convertToCIMBoolean(propertyValue);
            } else if (propertyType.equals("datetime")) {
                convertedValue = MappingUtility.convertToCIMDatetime(propertyValue, sourceType);
            }
        }
        return convertedValue;
    }

    public static String convertToCIMBoolean(String bval) throws InvalidDataException {
        if (bval.equalsIgnoreCase("false")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("true")) {
            return "true";
        }
        if (bval.trim().equals("")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("X")) {
            return "true";
        }
        if (bval.trim().equals("NO")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("YES")) {
            return "true";
        }
        if (bval.trim().equals("OFF")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("ON")) {
            return "true";
        }
        if (bval.trim().equals("F")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("T")) {
            return "true";
        }
        if (bval.trim().equals("0")) {
            return "false";
        }
        if (bval.equalsIgnoreCase("1")) {
            return "true";
        }
        throw new InvalidDataException("Failed to convert string to CIM boolean: " + bval);
    }

    public static String convertToCIMDatetime(String sdate, String format) throws InvalidDataException {
        if (format != null) {
            if (format.equals(SRCTYPE_DATE_PRINTTIME)) {
                return MappingUtility.getCIMTimeStampFromPrintDate(sdate);
            }
            if (format.equals(SRCTYPE_DATE_TIMESTAMP)) {
                return MappingUtility.getCIMTimeStampFromTimeStamp(sdate);
            }
        } else {
            return MappingUtility.getCIMTimeStamp(sdate, format);
        }
        return "";
    }

    public static String getCIMTimeStampFromPrintDate(String printDate) throws InvalidDataException {
        String inputFormat;
        if (printDate == null) {
            return INITIAL_CIMDATE;
        }
        if (printDate.length() == 19) {
            if (printDate.substring(0, 10).equals(INITIAL_DATE_PRINTDATE)) {
                throw new InvalidDataException("Initial date 0000-00-00 not accepted");
            }
            inputFormat = PRINTTIME_FULL_FORMAT;
        } else if (printDate.length() == 10) {
            if (printDate.equals(INITIAL_DATE_PRINTDATE)) {
                throw new InvalidDataException("Initial date 0000-00-00 not accepted");
            }
            inputFormat = PRINTTIME_DATE_FORMAT;
        } else {
            throw new InvalidDataException("Illegal input date: " + printDate);
        }
        return MappingUtility.getCIMTimeStamp(printDate, inputFormat);
    }

    public static String getCIMTimeStampFromTimeStamp(String stampDate) throws InvalidDataException {
        if (stampDate == null) {
            return INITIAL_CIMDATE;
        }
        if (stampDate.length() == 14) {
            if (stampDate.equals(INITIAL_DATE_STAMPDATE)) {
                throw new InvalidDataException("Initial date 00000000000000 not accepted");
            }
        } else {
            throw new InvalidDataException("Illegal input date: " + stampDate);
        }
        String inputFormat = TIMESTAMP_FORMAT;
        return MappingUtility.getCIMTimeStamp(stampDate, inputFormat);
    }

    public static String getCIMTimeStamp(String sourceDate, String sourceFormat) throws InvalidDataException {
        if (sourceDate == null) {
            return INITIAL_CIMDATE;
        }
        try {
            Date date = new SimpleDateFormat(sourceFormat).parse(sourceDate);
            return CIMUtil.date2CimDateTime(date);
        }
        catch (ParseException pe) {
            throw new InvalidDataException(pe);
        }
    }

    public static String getCIMDiffTime(String date1, String date2) throws InvalidDataException {
        if (date1 == null || date2 == null) {
            throw new InvalidDataException("Missing CIM time parameter");
        }
        try {
            Date d1 = CIMUtil.cimDateTime2Date(date1);
            Date d2 = CIMUtil.cimDateTime2Date(date2);
            long ldiff = Math.abs(d1.getTime() - d2.getTime());
            long ldd = ldiff / 86400000L;
            String sdd = String.valueOf(ldd);
            sdd = MappingUtility.patStr(sdd, '0', 8);
            long ldh = (ldiff -= ldd * 86400000L) / 3600000L;
            String sdh = String.valueOf(ldh);
            sdh = MappingUtility.patStr(sdh, '0', 2);
            long ldm = (ldiff -= ldh * 3600000L) / 60000L;
            String sdm = String.valueOf(ldm);
            sdm = MappingUtility.patStr(sdm, '0', 2);
            long lds = (ldiff -= ldm * 60000L) / 1000L;
            String sds = String.valueOf(lds);
            sds = MappingUtility.patStr(sds, '0', 2);
            return sdd + sdh + sdm + sds + ".000000:000";
        }
        catch (LcrException e) {
            throw new InvalidDataException(e);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDataException(nfe);
        }
    }

    private static String patStr(String inStr, char ch, int size) {
        StringBuffer strBuf = new StringBuffer(inStr);
        while (strBuf.length() != size) {
            strBuf = strBuf.insert(0, ch);
        }
        return strBuf.toString();
    }

    public static String currentCIMDatetime() {
        return CIMUtil.date2CimDateTime(new Date());
    }

    public static String printValues(String[] values) {
        if (values == null) {
            return "";
        }
        StringBuffer result = new StringBuffer("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                result.append(", ");
            }
            if (values[i] == null) {
                result.append("<null>");
            } else if (values[i].length() == 0) {
                result.append("<empty>");
            } else {
                result.append(values[i]);
            }
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    public static boolean haveEqualValues(DeltaElement firstObj, DeltaElement secondObj) {
        CIMPropertyReferenceList prl2;
        CIMPropertyArrayList pal2;
        CIMPropertyList pl2;
        CIMInstance firstInst = MappingUtility.stripNullValues(firstObj).getMyInstance();
        CIMInstance secondInst = MappingUtility.stripNullValues(secondObj).getMyInstance();
        if (firstInst == null) {
            return secondInst == null;
        }
        if (secondInst == null) {
            return false;
        }
        CIMPropertyList pl1 = firstInst.getProperties();
        if (!MappingUtility.areEqualPropertyLists(pl1, pl2 = secondInst.getProperties())) {
            return false;
        }
        CIMPropertyArrayList pal1 = firstInst.getPropertyArrays();
        if (!MappingUtility.areEqualPropertyArrayLists(pal1, pal2 = secondInst.getPropertyArrays())) {
            return false;
        }
        CIMPropertyReferenceList prl1 = firstInst.getPropertyReferences();
        return MappingUtility.areEqualPropertyReferenceLists(prl1, prl2 = secondInst.getPropertyReferences());
    }

    private static boolean areEqualPropertyLists(CIMPropertyList pl1, CIMPropertyList pl2) {
        if (pl1 == pl2) {
            return true;
        }
        if (pl1 == null || pl2 == null) {
            return false;
        }
        if (pl1.size() != pl2.size()) {
            return false;
        }
        int i = 0;
        while (i < pl1.size()) {
            CIMProperty p1 = pl1.get(i);
            CIMProperty p2 = pl2.get(p1.getName());
            if (p2 == null) {
                return false;
            }
            String v1 = p1.getValue();
            String v2 = p2.getValue();
            if (v1 == null ? v2 != null : (v2 == null ? v1 != null : !v1.equals(v2))) {
                return false;
            }
            String t1 = p1.getType();
            String t2 = p2.getType();
            if (t1 == null ? t2 != null : (t2 == null ? t1 != null : !t1.equals(t2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean areEqualPropertyArrayLists(CIMPropertyArrayList pal1, CIMPropertyArrayList pal2) {
        if (pal1 == pal2) {
            return true;
        }
        if (pal1 == null || pal2 == null) {
            return false;
        }
        if (pal1.size() != pal2.size()) {
            return false;
        }
        int i = 0;
        while (i < pal1.size()) {
            CIMPropertyArray pa1 = pal1.get(i);
            CIMPropertyArray pa2 = pal2.get(pa1.getName());
            if (pa2 == null) {
                return false;
            }
            CIMValueArray va1 = pa1.getValueArray();
            CIMValueArray va2 = pa2.getValueArray();
            if (va1 == null ? va2 != null : (va2 == null ? va1 != null : !va1.equals(va2))) {
                return false;
            }
            String ta1 = pa1.getType();
            String ta2 = pa2.getType();
            if (ta1 == null ? ta2 != null : (ta2 == null ? ta1 != null : !ta1.equals(ta2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean areEqualPropertyReferenceLists(CIMPropertyReferenceList prl1, CIMPropertyReferenceList prl2) {
        if (prl1 == prl2) {
            return true;
        }
        if (prl1 == null || prl2 == null) {
            return false;
        }
        if (prl1.size() != prl2.size()) {
            return false;
        }
        int i = 0;
        while (i < prl1.size()) {
            CIMPropertyReference pr1 = prl1.get(i);
            CIMPropertyReference pr2 = prl2.get(pr1.getName());
            if (pr2 == null) {
                return false;
            }
            CIMValueReference vr1 = pr1.getValueReference();
            CIMValueReference vr2 = pr2.getValueReference();
            if (vr1 == null ? vr2 != null : (vr2 == null ? vr1 != null : !vr1.equals(vr2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean haveEqualKeyValues(DeltaElement firstObj, DeltaElement secondObj) {
        CIMInstancename firstInstName = firstObj.getMyInstanceName();
        CIMInstancename secondInstName = secondObj.getMyInstanceName();
        if (firstInstName == null) {
            return secondInstName == null;
        }
        if (secondInstName == null) {
            return false;
        }
        CIMKeybindingList la = firstInstName.getKeybindingList();
        CIMKeybindingList lb = secondInstName.getKeybindingList();
        if (la.size() != lb.size()) {
            return false;
        }
        int i = 0;
        while (i < la.size()) {
            CIMKeybinding pa = la.get(i);
            CIMKeybinding pb = lb.get(pa.getName());
            if (pb == null) {
                return false;
            }
            CIMKeyValue va = pa.getKeyValue();
            CIMKeyValue vb = pb.getKeyValue();
            if (va == null ? vb != null : (vb == null ? va != null : !va.equals(vb))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkNonEmptyKeyValues(DeltaElement obj) throws LcrException {
        CIMInstancename instName = obj.getMyInstanceName();
        if (instName == null) {
            throw new LcrException("Key not defined for delta element");
        }
        CIMKeybindingList lk = instName.getKeybindingList();
        int i = 0;
        while (i < lk.size()) {
            CIMKeybinding pk = lk.get(i);
            CIMKeyValue vk = pk.getKeyValue();
            if (vk.getValue().length() == 0) {
                throw new LcrException("Key value " + pk.getName() + " is empty in delta element " + instName.toDisplayString());
            }
            ++i;
        }
    }

    public static boolean checkNonEmptyStringArray(String[] keyValues) {
        if (keyValues == null) {
            return false;
        }
        int i = 0;
        while (i < keyValues.length) {
            if (keyValues[i] == null || keyValues[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DeltaElement stripNullValues(DeltaElement obj) {
        CIMPropertyReferenceList prlist;
        CIMPropertyArrayList palist;
        DeltaElement result = obj;
        CIMInstance inst = obj.getMyInstance();
        if (inst == null) {
            return result;
        }
        CIMPropertyList plist = inst.getProperties();
        if (plist != null) {
            int i = 0;
            while (i < plist.size()) {
                CIMValue nextValue = plist.get(i).getCIMValue();
                if (nextValue == null) {
                    if (result == obj) {
                        result = (DeltaElement)obj.clone();
                    }
                    result.getMyInstance().removeProperty(plist.get(i).getName());
                }
                ++i;
            }
        }
        if ((palist = inst.getPropertyArrays()) != null) {
            int i = 0;
            while (i < palist.size()) {
                CIMValueArray nextValueArray = palist.get(i).getValueArray();
                if (nextValueArray == null) {
                    if (result == obj) {
                        result = (DeltaElement)obj.clone();
                    }
                    result.getMyInstance().removePropertyArray(palist.get(i).getName());
                }
                ++i;
            }
        }
        if ((prlist = inst.getPropertyReferences()) != null) {
            int i = 0;
            while (i < prlist.size()) {
                CIMValueReference nextValueRef = prlist.get(i).getValueReference();
                if (nextValueRef == null) {
                    if (result == obj) {
                        result = (DeltaElement)obj.clone();
                    }
                    result.getMyInstance().removePropertyReference(prlist.get(i).getName());
                }
                ++i;
            }
        }
        return result;
    }

    public static void changeSupplierName(DeltaElement obj, String supplierName) throws LcrException {
        obj.setMySupplierName(supplierName);
        String qval = obj.getMySupplierName();
        if (qval == null || !qval.equals(supplierName)) {
            throw new LcrException("Name of the data supplier could not be set in delta element");
        }
    }
}

