/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.api.builder;

import com.sap.lcr.api.builder.DataQueue;
import com.sap.lcr.api.builder.GenericDirector;
import com.sap.lcr.api.builder.IBuilder;
import com.sap.lcr.api.builder.IData;
import com.sap.lcr.api.builder.IDataQueue;
import com.sap.lcr.api.builder.IDataSource;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.log.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AsynchronousDirector
extends GenericDirector {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$lcr$api$builder$AsynchronousDirector == null ? (class$com$sap$lcr$api$builder$AsynchronousDirector = AsynchronousDirector.class$("com.sap.lcr.api.builder.AsynchronousDirector")) : class$com$sap$lcr$api$builder$AsynchronousDirector).getName());
    private int dataCount = 0;
    private DataDistributor myDistributor;
    private IDataSource myDataSource;
    private boolean stoppedOnError = false;
    static /* synthetic */ Class class$com$sap$lcr$api$builder$AsynchronousDirector;

    public AsynchronousDirector(IDataSource aDataSource) {
        this.myDataSource = aDataSource;
        this.setDataQueue(new DataQueue());
    }

    public IDataSource getMyDataSource() {
        return this.myDataSource;
    }

    public boolean isAlive() {
        return this.myDistributor != null && this.myDistributor.isAlive();
    }

    public void waitForTermination() throws InterruptedException {
        this.myDistributor.join();
    }

    public boolean isStoppedOnError() {
        if (this.myDistributor == null || this.myDistributor.isAlive()) {
            return false;
        }
        return this.stoppedOnError;
    }

    protected void setStoppedOnError(boolean flag) {
        this.stoppedOnError = flag;
    }

    public void distributeData() throws LcrException {
        ArrayList currentBuilders = (ArrayList)this.myBuilders.clone();
        this.myDistributor = new DataDistributor(this.getDataQueue(), currentBuilders, this);
        String threadName = this.myDistributor.getName();
        this.stoppedOnError = false;
        this.myDistributor.start();
        if (CIMTraceUtil.traceLevel >= 2) {
            myLogger.info("Asynchronous data distribution started in thread " + threadName);
        }
    }

    public String printStatus() {
        return MessageFormat.format("{0} data elements synchronized, {1} elements currently in data queue", new Integer(this.dataCount), new Integer(this.getDataQueue().size()));
    }

    public boolean stopDataDistribution(long maxWaitTime) {
        String threadName;
        block4: {
            threadName = this.myDistributor.getName();
            this.myDistributor.interrupt();
            try {
                this.myDistributor.join(maxWaitTime);
            }
            catch (InterruptedException ire) {
                if (CIMTraceUtil.traceLevel < 2) break block4;
                myLogger.info("Asynchronous data distribution in thread " + threadName + " interupted.", ire);
            }
        }
        if (!this.myDistributor.isAlive()) {
            if (CIMTraceUtil.traceLevel >= 2) {
                myLogger.info("Asynchronous data distribution in thread " + threadName + " stopped successfully.");
            }
            return true;
        }
        return false;
    }

    void incrementDataCount() {
        ++this.dataCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DataDistributor
    extends Thread {
        private IDataQueue myDataQueue;
        private ArrayList myDataBuilders;
        private AsynchronousDirector myDirector;

        DataDistributor(IDataQueue aDataQueue, ArrayList aBuilderList, AsynchronousDirector aDirector) {
            this.myDataQueue = aDataQueue;
            this.myDataBuilders = aBuilderList;
            this.myDirector = aDirector;
        }

        public void run() {
            boolean stopRun = false;
            IDataSource dataSource = this.myDirector.getMyDataSource();
            boolean addCarefully = dataSource.hasDuplicates();
            Thread thisThread = Thread.currentThread();
            while (true) {
                IData[] newData = dataSource.getNewData();
                int i = 0;
                while (i < newData.length) {
                    if (addCarefully) {
                        this.myDataQueue.addUnique(newData[i]);
                    } else {
                        this.myDataQueue.add(newData[i]);
                    }
                    ++i;
                }
                while (!this.myDataQueue.isEmpty()) {
                    IData nextData = this.myDataQueue.pick();
                    int i2 = 0;
                    while (i2 < this.myDataBuilders.size()) {
                        IBuilder nextBuilder = (IBuilder)this.myDataBuilders.get(i2);
                        if (thisThread.isInterrupted()) {
                            if (CIMTraceUtil.traceLevel >= 3) {
                                myLogger.debug("Asynchronous data distribution interupted, closing thread " + thisThread.getName());
                            }
                            stopRun = true;
                            break;
                        }
                        if (nextBuilder.accept(nextData)) {
                            try {
                                nextBuilder.syncData(nextData);
                            }
                            catch (LcrException lce) {
                                if (CIMTraceUtil.traceLevel >= 1) {
                                    myLogger.warning("Exception in thread " + thisThread.getName() + " during asynchronous data distribution." + " If the data distribution process stops," + " a manual restart may be necessary.", lce);
                                }
                                this.myDirector.setStoppedOnError(true);
                                this.myDataQueue.free(nextData);
                                stopRun = true;
                                break;
                            }
                            try {
                                nextBuilder.executeDelta();
                            }
                            catch (LcrException lce) {
                                if (CIMTraceUtil.traceLevel >= 1) {
                                    myLogger.warning("Exception in thread " + thisThread.getName() + " during asynchronous delta execution." + " If the data distribution process stops," + " a manual restart may be necessary.", lce);
                                }
                                this.myDirector.setStoppedOnError(true);
                                this.myDataQueue.free(nextData);
                                stopRun = true;
                                break;
                            }
                        }
                        ++i2;
                    }
                    if (stopRun) break;
                    this.myDataQueue.acknowledge(nextData);
                    this.myDirector.incrementDataCount();
                    if (!thisThread.isInterrupted()) continue;
                    if (CIMTraceUtil.traceLevel >= 2) {
                        myLogger.info("Asynchronous data distribution interupted, closing thread " + thisThread.getName());
                    }
                    stopRun = true;
                    break;
                }
                if (stopRun) break;
                try {
                    Thread.sleep(dataSource.getWaitPeriod());
                }
                catch (InterruptedException ire) {
                    if (CIMTraceUtil.traceLevel < 2) break;
                    myLogger.info("Asynchronous data distribution pause of thread " + this.getName() + " interupted.", ire);
                    break;
                }
            }
        }
    }
}

