/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.jarsap.archive;

import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.IComponent;
import com.tssap.tools.archive.IComponentBuildInfo;
import com.tssap.tools.archive.internal.BaseAntBuilder;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IBuildLogger;
import com.tssap.tools.archive.internal.IPostBuildTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class JarSapHelper
implements IPostBuildTask {
    private static final String[] DEPENDENCYTAG_REPLACEVARS = new String[]{"DependencyType", "DependencySpecName", "DependencySpecVersion", "DependencyImplTitle", "DependencyImplVenorid"};
    private static final String PLACEHOLDER_DEPLFILE = "$$DeployFile$$";
    private static final String PLACEHOLDER_BUILD_COUNTER = "$$BuildCounter$$";
    private static final String PLACEHOLDER_DEPENDENCIES = "$$Dependencies$$";
    private static final String UNZIP_TARGETNAME = "unzipTarget";

    public void perform(File archive, IAntArchiveDesriptor arDescr, IBuildLogger logger, IProgressMonitor monitor) {
        monitor.subTask("JarSap " + BaseAntBuilder.getNameFromPath((String)arDescr.getDestPath()));
        this.jarSapArchive(archive, (IComponentBuildInfo)arDescr, monitor, logger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void jarSapArchive(File arFile, IComponentBuildInfo compInfo, IProgressMonitor monitor, IBuildLogger logger) {
        File tmpArFile;
        block12: {
            logger.log("Starting Jarsap");
            long time = System.currentTimeMillis();
            Project unzipProj = new Project();
            unzipProj.init();
            Target unzipTarget = new Target();
            unzipTarget.setName(UNZIP_TARGETNAME);
            unzipTarget.setProject(unzipProj);
            unzipProj.addTarget(unzipTarget);
            File tmpFolder = this.getTempUnzipFolderPath(arFile);
            File tmpContentFolder = new File(tmpFolder, "content");
            tmpArFile = new File(arFile.getParentFile(), arFile.getName() + ".renTmp");
            Expand unzip = new Expand();
            unzip.setOwningTarget(unzipTarget);
            unzip.setProject(unzipProj);
            unzip.setDest(tmpContentFolder);
            unzip.setOverwrite(true);
            unzip.setSrc(arFile);
            unzipTarget.addTask((Task)unzip);
            try {
                try {
                    try {
                        if (tmpFolder.exists()) {
                            this.delTree(tmpFolder);
                        }
                        tmpFolder.mkdir();
                        logger.log("Start unzip - " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                        unzipProj.executeTarget(UNZIP_TARGETNAME);
                        logger.log("Finished unzip - " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                        tmpArFile.delete();
                        arFile.renameTo(tmpArFile);
                        arFile.delete();
                    }
                    catch (BuildException e) {
                        throw new ArchiveBuildException("Error preparing jarSap operation", (Throwable)e);
                    }
                    try {
                        File deployFile = this.createDeployFile(tmpFolder, compInfo);
                        File buildFile = this.createBuildFile(tmpFolder, deployFile, compInfo);
                        if (buildFile == null) throw new ArchiveBuildException("Unable to create jarSap build File");
                        AntRunner antRunner = new AntRunner();
                        antRunner.setArguments(this.getAntRunnerArgs(arFile, tmpContentFolder, buildFile, deployFile, compInfo));
                        antRunner.setBuildFileLocation(buildFile.getAbsolutePath());
                        logger.log("Start jarSap Ant Task - " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                        antRunner.run();
                        logger.log("Finished jarSap Ant Task - " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                    }
                    catch (CoreException e) {
                        throw new ArchiveBuildException("Error calling Ant to jarSap archive", (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new ArchiveBuildException("Error calling Ant to jarSap archive", e);
                    }
                    Object var17_19 = null;
                }
                catch (RuntimeException e) {
                    if (!(e instanceof ArchiveBuildException)) throw new ArchiveBuildException("Error jarSap archive", (Throwable)e);
                    throw e;
                }
                this.delTree(tmpFolder);
                if (arFile.exists()) break block12;
                tmpArFile.renameTo(arFile);
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                this.delTree(tmpFolder);
                if (!arFile.exists()) {
                    tmpArFile.renameTo(arFile);
                }
                tmpArFile.delete();
                throw throwable;
            }
        }
        tmpArFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createDeployFile(File tmpFolder, IComponentBuildInfo compInfo) {
        File deployFile = null;
        deployFile = new File(tmpFolder, "sda-dd.xml");
        if (deployFile.exists()) {
            return null;
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(deployFile);
                String deployFileContent = this.getDeployFileFileContent(compInfo);
                if (deployFileContent != null) {
                    out.write(deployFileContent.getBytes());
                } else {
                    deployFile = null;
                }
            }
            catch (FileNotFoundException e) {
                throw new ArchiveBuildException("Error writing jarSap deploy file ", (Throwable)e);
            }
            catch (IOException e) {
                throw new ArchiveBuildException("Error writing jarSap deploy file ", (Throwable)e);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        out.close();
        return deployFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDeployFileFileContent(IComponentBuildInfo compInfo) {
        String ret = null;
        ret = compInfo.getDeployFileContent();
        if (ret != null) {
            return ret;
        }
        if (compInfo.getDeployFile() == null) return ret;
        FileInputStream in = null;
        try {
            try {
                byte[] b = null;
                in = new FileInputStream(compInfo.getDeployFile());
                if (in != null) {
                    b = new byte[((InputStream)in).available()];
                    ((InputStream)in).read(b);
                    ret = new String(b);
                }
            }
            catch (IOException e) {
                throw new ArchiveBuildException("Error reading deployFile", (Throwable)e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (in == null) return ret;
        ((InputStream)in).close();
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createBuildFile(File tmpFolder, File deployFile, IComponentBuildInfo compInfo) {
        File buildFile = null;
        int counter = 0;
        while ((buildFile = new File(tmpFolder, "build" + Integer.toString(counter++) + ".xml")).exists()) {
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(buildFile);
                String buildFileTemplate = this.getBuildFileTemplate();
                buildFileTemplate = this.createBuildFileContent(buildFileTemplate, deployFile, compInfo);
                if (buildFileTemplate != null) {
                    out.write(buildFileTemplate.getBytes());
                } else {
                    buildFile = null;
                }
            }
            catch (FileNotFoundException e) {
                throw new ArchiveBuildException("Error writing jarSap build file ", (Throwable)e);
            }
            catch (IOException e) {
                throw new ArchiveBuildException("Error writing jarSap build file ", (Throwable)e);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        out.close();
        return buildFile;
    }

    private String createBuildFileContent(String buildFileTemplate, File deployFile, IComponentBuildInfo compInfo) {
        String deployFileStr = null;
        String dependencyStr = null;
        deployFileStr = deployFile != null && deployFile.exists() ? "deployfile=\"" + deployFile.getName() + "\"" : "";
        if (compInfo.getDependencies() != null && compInfo.getDependencies().length > 0) {
            StringBuffer buf = new StringBuffer();
            IComponent[] dependencies = compInfo.getDependencies();
            String dependencyTagTemplate = this.getDependencyTagTemplate();
            int i = 0;
            while (i < dependencies.length) {
                String depTag = dependencyTagTemplate;
                int j = 0;
                while (j < DEPENDENCYTAG_REPLACEVARS.length) {
                    depTag = JarSapHelper.replaceStr(depTag, DEPENDENCYTAG_REPLACEVARS[j], DEPENDENCYTAG_REPLACEVARS[j] + Integer.toString(i));
                    ++j;
                }
                buf.append(depTag);
                ++i;
            }
            dependencyStr = buf.toString();
        } else {
            dependencyStr = "";
        }
        String ret = JarSapHelper.replaceStr(buildFileTemplate, PLACEHOLDER_DEPLFILE, deployFileStr);
        ret = JarSapHelper.replaceStr(ret, PLACEHOLDER_BUILD_COUNTER, this.createBuildFileCounter());
        ret = JarSapHelper.replaceStr(ret, PLACEHOLDER_DEPENDENCIES, dependencyStr);
        return ret;
    }

    private String createBuildFileCounter() {
        StringBuffer ret = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        ret.append(cal.get(1));
        ret.append(".");
        ret.append(this.formatNumStr(cal.get(2) + 1, 2));
        ret.append(".");
        ret.append(this.formatNumStr(cal.get(5), 2));
        ret.append(".");
        ret.append(this.formatNumStr(cal.get(11), 2));
        ret.append(".");
        ret.append(this.formatNumStr(cal.get(12), 2));
        ret.append(".");
        ret.append(this.formatNumStr(cal.get(13), 2));
        return ret.toString();
    }

    private String formatNumStr(int i, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Given length must be larger than zero");
        }
        String ret = Integer.toString(i);
        if (ret.length() < length) {
            char[] zeros = new char[length - ret.length()];
            Arrays.fill(zeros, '0');
            ret = new String(zeros) + ret;
        } else if (ret.length() > length) {
            ret = ret.substring(ret.length() - length);
        }
        return ret;
    }

    private String getBuildFileTemplate() {
        return this.getResourceContent("com/sap/ide/eclipse/jarsap/archive/template/JarSapBuildTemplate.tml");
    }

    private String getDependencyTagTemplate() {
        return this.getResourceContent("com/sap/ide/eclipse/jarsap/archive/template/DependencyTagTemplate.tml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResourceContent(String resourceName) {
        byte[] b = null;
        String ret = null;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (in == null) throw new ArchiveBuildException("Error reading resource " + resourceName + ". Resource not found ");
        try {
            try {
                b = new byte[in.available()];
                in.read(b);
                ret = new String(b);
            }
            catch (IOException e) {
                throw new ArchiveBuildException("Error reading resource " + resourceName, (Throwable)e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return ret;
    }

    private String getAntRunnerArgs(File destFile, File folderToPack, File buildFile, File deployFile, IComponentBuildInfo compInfo) {
        StringBuffer ret = new StringBuffer();
        ret.append("-Dvendor=");
        ret.append("\"");
        ret.append(compInfo.getComponent().getVendor());
        ret.append("\"");
        ret.append(" -DcompName=");
        ret.append("\"");
        ret.append(compInfo.getComponent().getName());
        ret.append("\"");
        ret.append(" -DarchiveDestination=");
        ret.append("\"");
        ret.append(destFile.getAbsolutePath());
        ret.append("\"");
        ret.append(" -DfolderToPack=");
        ret.append("\"");
        ret.append(folderToPack.getAbsolutePath());
        ret.append("\"");
        IComponent[] depComps = compInfo.getDependencies();
        if (depComps != null && depComps.length > 0) {
            StringBuffer depStrBuf = new StringBuffer();
            int i = 0;
            while (i < depComps.length) {
                int j = 0;
                while (j < DEPENDENCYTAG_REPLACEVARS.length) {
                    depStrBuf.append(" -D");
                    depStrBuf.append(DEPENDENCYTAG_REPLACEVARS[j]);
                    depStrBuf.append(Integer.toString(i));
                    depStrBuf.append("=\"");
                    switch (j) {
                        case 0: {
                            depStrBuf.append("GLOBAL");
                            break;
                        }
                        case 1: {
                            depStrBuf.append(depComps[i].getName());
                            break;
                        }
                        case 2: {
                            depStrBuf.append("SpecVersion");
                            break;
                        }
                        case 3: {
                            depStrBuf.append("ImplTitle");
                            break;
                        }
                        case 4: {
                            depStrBuf.append(depComps[i].getVendor());
                            break;
                        }
                    }
                    depStrBuf.append("\"");
                    ++j;
                }
                ++i;
            }
            ret.append((Object)depStrBuf);
        }
        return ret.toString();
    }

    private void delTree(File fileFolder) {
        if (fileFolder.isDirectory()) {
            File[] children = fileFolder.listFiles();
            int i = 0;
            while (i < children.length) {
                this.delTree(children[i]);
                ++i;
            }
        }
        fileFolder.delete();
    }

    private File getTempUnzipFolderPath(File arFile) {
        File tmpFile = new File(arFile.getParentFile(), arFile.getName() + "_TmpUnzip");
        return tmpFile;
    }

    private static String replaceStr(String s, String replaceStr, String withStr) {
        StringBuffer buf = new StringBuffer();
        int position = 0;
        int index = -1;
        do {
            if ((index = s.indexOf(replaceStr, position)) >= 0) {
                buf.append(s.substring(position, index));
                buf.append(withStr);
                position = index + replaceStr.length();
                continue;
            }
            buf.append(s.substring(position, s.length()));
        } while (index >= 0);
        return buf.toString();
    }
}

