/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.util.BasicSAPConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;

public class SAPCharToUCLEByteConverter
extends BasicSAPConverter
implements SAPCharToByteConverter {
    protected SAPCharToUCLEByteConverter(String charEncoding) {
        super(charEncoding);
        this.codepageType = (byte)3;
    }

    public int convert(char[] in, int inBeginIndex, int inEndIndex, byte[] out, int outBeginIndex, int outEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        while (inIndex <= inEndIndex && outIndex <= outEndIndex - 1) {
            out[outIndex++] = (byte)(in[inIndex] & 0xFF);
            out[outIndex++] = (byte)(in[inIndex++] >>> 8);
        }
        return outIndex - outBeginIndex;
    }

    public byte[] convert(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return new byte[0];
        }
        if (inBeginIndex < 0) {
            return new byte[0];
        }
        if (inBeginIndex >= in.length) {
            return new byte[0];
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return new byte[0];
        }
        int outLength = this.outLength(in, inBeginIndex, inEndIndex);
        byte[] out = new byte[outLength];
        this.convert(in, inBeginIndex, inEndIndex, out, 0, outLength - 1);
        return out;
    }

    public byte[] convert(char[] in) {
        if (in == null) {
            return new byte[0];
        }
        int outLength = this.outLength(in, 0, in.length - 1);
        byte[] out = new byte[outLength];
        this.convert(in, 0, in.length - 1, out, 0, outLength - 1);
        return out;
    }

    public int outLength(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        return (inEndIndex - inBeginIndex + 1) * 2;
    }

    public int outLength(char[] in) {
        if (in == null) {
            return 0;
        }
        return this.outLength(in, 0, in.length - 1);
    }
}

