/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.BasicSAPConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;

public class SAPCharToNUCByteConverter
extends BasicSAPConverter
implements SAPCharToByteConverter {
    private static final byte TYPE_UNKNOWN = 0;
    private static final byte TYPE_CHARLENGTH1TOBYTEOFFSET_ARRAY = 1;
    private static final byte TYPE_CHARLENGTH1TOBYTE_ARRAY = 2;
    private static final byte TYPE_CHARLENGTH1TOBYTELENGTH3_ARRAY = 3;
    private static final byte TYPE_CHARLENGTH2TOBYTEOFFSET1_ARRAY = 4;
    private static final byte TYPE_CHARLENGTH2TOBYTEOFFSET2_ARRAY = 5;
    private static final byte TYPE_CHARLENGTH2TOBYTEOFFSET3_ARRAY = 6;
    private static final byte TYPE_CHARLENGTH2TOBYTE_ARRAY = 7;
    private static final byte TYPE_CHARLENGTH2TOBYTELENGTH3_ARRAY = 8;
    private char[] charLength1ToByteOffset = null;
    private byte[] charLength1ToByte = null;
    private byte[] charLength1ToByteLength3 = null;
    private char[] charLength2ToByteOffset1 = null;
    private int[] charLength2ToByteOffset2 = null;
    private int[] charLength2ToByteOffset3 = null;
    private byte[] charLength2ToByte = null;
    private byte[] charLength2ToByteLength3 = null;

    protected SAPCharToNUCByteConverter(String charEncoding) {
        super(charEncoding);
        if (charEncoding.startsWith("SAP")) {
            charEncoding = charEncoding.substring(3);
        }
        if (this.nativeInitialize(charEncoding) != 0) {
            throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + charEncoding + ".");
        }
        this.initialize();
    }

    protected native int nativeInitialize(String var1);

    protected void initialize() {
        if (this.charLength1ToByteOffset != null && this.charLength1ToByte != null) {
            char offset = this.charLength1ToByteOffset[0];
            int i = 32;
            while (i < 127) {
                if (this.charLength1ToByte[(offset | i) * 3] != 1 || this.charLength1ToByte[(offset | i) * 3 + 1] != i) break;
                ++i;
            }
            this.codepageType = i == 127 ? (byte)1 : (byte)2;
        }
    }

    protected void setByteArray(byte type, String version, byte[] array) {
        switch (type) {
            case 2: {
                if (!"1.0".equals(version)) break;
                this.charLength1ToByte = array;
                return;
            }
            case 3: {
                if (!"1.0".equals(version)) break;
                this.charLength1ToByteLength3 = array;
                return;
            }
            case 7: {
                if (!"1.0".equals(version)) break;
                this.charLength2ToByte = array;
                return;
            }
            case 8: {
                if (!"1.0".equals(version)) break;
                this.charLength2ToByteLength3 = array;
                return;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setCharArray(byte type, String version, char[] array) {
        switch (type) {
            case 1: {
                if (!"1.0".equals(version)) break;
                this.charLength1ToByteOffset = array;
                return;
            }
            case 4: {
                if (!"1.0".equals(version)) break;
                this.charLength2ToByteOffset1 = array;
                return;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setIntArray(byte type, String version, int[] array) {
        switch (type) {
            case 5: {
                if (!"1.0".equals(version)) break;
                this.charLength2ToByteOffset2 = array;
                return;
            }
            case 6: {
                if (!"1.0".equals(version)) break;
                this.charLength2ToByteOffset3 = array;
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setLongArray(byte type, String version, long[] array) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    protected void setShortArray(byte type, String version, short[] array) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                return;
            }
        }
        throw new JCO.Exception(134, "JCO_ERROR_INITIALIZATION", "Could not initialize SAPCharToByteConverter for codepage " + this.charEncoding + ". SAP Java Connector runtime archive version " + version + " is required.");
    }

    public int convert(char[] in, int inBeginIndex, int inEndIndex, byte[] out, int outBeginIndex, int outEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        block15: while (inIndex <= inEndIndex && outIndex <= outEndIndex) {
            byte numBytes;
            int tabIndex;
            block33: {
                block34: {
                    block32: {
                        if (in[inIndex] < '\ud800' || in[inIndex] > '\udbff') break block32;
                        if (inIndex < inEndIndex && in[inIndex + 1] >= '\udc00' && in[inIndex + 1] <= '\udfff') {
                            tabIndex = (this.charLength2ToByteOffset3[this.charLength2ToByteOffset2[this.charLength2ToByteOffset1[in[inIndex] >> 8] | in[inIndex] & 0xFF] | in[inIndex + 1] >> 8] | in[inIndex + 1] & 0xFF) * 3;
                            numBytes = this.charLength2ToByte[tabIndex];
                            if (outIndex + numBytes - 1 > outEndIndex) break;
                            switch (numBytes) {
                                case 1: {
                                    out[outIndex++] = this.charLength2ToByte[++tabIndex];
                                    break;
                                }
                                case 2: {
                                    out[outIndex++] = this.charLength2ToByte[++tabIndex];
                                    out[outIndex++] = this.charLength2ToByte[++tabIndex];
                                    break;
                                }
                                case 3: {
                                    tabIndex = ((this.charLength2ToByte[tabIndex + 1] & 0xFF) << 8 | this.charLength2ToByte[tabIndex + 2] & 0xFF) * 3;
                                    out[outIndex++] = this.charLength2ToByteLength3[tabIndex++];
                                    out[outIndex++] = this.charLength2ToByteLength3[tabIndex++];
                                    out[outIndex++] = this.charLength2ToByteLength3[tabIndex];
                                    break;
                                }
                                default: {
                                    out[outIndex++] = this.codepageType == 2 ? 123 : 35;
                                }
                            }
                            inIndex += 2;
                            continue;
                        }
                        break block33;
                    }
                    if (in[inIndex] != '\uf8fc') break block34;
                    if (inIndex >= inEndIndex) break block33;
                    tabIndex = (this.charLength2ToByteOffset3[this.charLength2ToByteOffset2[this.charLength2ToByteOffset1[in[inIndex] >> 8] | in[inIndex] & 0xFF] | in[inIndex + 1] >> 8] | in[inIndex + 1] & 0xFF) * 3;
                    numBytes = this.charLength2ToByte[tabIndex];
                    if (outIndex + numBytes - 1 > outEndIndex) break;
                    switch (numBytes) {
                        case 1: {
                            if (this.charLength2ToByte[++tabIndex] != 35) {
                                out[outIndex++] = this.charLength2ToByte[tabIndex];
                                inIndex += 2;
                                continue block15;
                            }
                            break block33;
                        }
                        case 2: {
                            out[outIndex++] = this.charLength2ToByte[++tabIndex];
                            out[outIndex++] = this.charLength2ToByte[++tabIndex];
                            inIndex += 2;
                            continue block15;
                        }
                        case 3: {
                            tabIndex = ((this.charLength2ToByte[tabIndex + 1] & 0xFF) << 8 | this.charLength2ToByte[tabIndex + 2] & 0xFF) * 3;
                            out[outIndex++] = this.charLength2ToByteLength3[tabIndex++];
                            out[outIndex++] = this.charLength2ToByteLength3[tabIndex++];
                            out[outIndex++] = this.charLength2ToByteLength3[tabIndex];
                            inIndex += 2;
                            continue block15;
                        }
                    }
                    break block33;
                }
                if (in[inIndex] == '\uf8fd' && inIndex + 2 <= inEndIndex) {
                    char sapIconChar1 = in[inIndex + 1];
                    char sapIconChar2 = in[inIndex + 2];
                    if ((sapIconChar1 >= '0' && sapIconChar1 <= '9' || sapIconChar1 >= 'A' && sapIconChar1 <= 'Z' || sapIconChar1 >= 'a' && sapIconChar1 <= 'z') && (sapIconChar2 >= '0' && sapIconChar2 <= '9' || sapIconChar2 >= 'A' && sapIconChar2 <= 'Z' || sapIconChar2 >= 'a' && sapIconChar2 <= 'z')) {
                        if (outIndex + 3 > outEndIndex) break;
                        if (this.codepageType == 1) {
                            out[outIndex++] = 27;
                            out[outIndex++] = 44;
                            out[outIndex++] = (byte)sapIconChar1;
                            out[outIndex++] = (byte)sapIconChar2;
                            inIndex += 3;
                            continue;
                        }
                        if (this.codepageType == 2) {
                            out[outIndex++] = 27;
                            out[outIndex++] = 107;
                            out[outIndex++] = this.charLength1ToByte[(this.charLength1ToByteOffset[0] | sapIconChar1) * 3 + 1];
                            out[outIndex++] = this.charLength1ToByte[(this.charLength1ToByteOffset[0] | sapIconChar2) * 3 + 1];
                            inIndex += 3;
                            continue;
                        }
                    }
                }
            }
            if (outIndex + (numBytes = this.charLength1ToByte[tabIndex = (this.charLength1ToByteOffset[in[inIndex] >> 8] | in[inIndex] & 0xFF) * 3]) - 1 > outEndIndex) break;
            switch (numBytes) {
                case 1: {
                    out[outIndex++] = this.charLength1ToByte[++tabIndex];
                    break;
                }
                case 2: {
                    out[outIndex++] = this.charLength1ToByte[++tabIndex];
                    out[outIndex++] = this.charLength1ToByte[++tabIndex];
                    break;
                }
                case 3: {
                    tabIndex = ((this.charLength1ToByte[tabIndex + 1] & 0xFF) << 8 | this.charLength1ToByte[tabIndex + 2] & 0xFF) * 3;
                    out[outIndex++] = this.charLength1ToByteLength3[tabIndex++];
                    out[outIndex++] = this.charLength1ToByteLength3[tabIndex++];
                    out[outIndex++] = this.charLength1ToByteLength3[tabIndex];
                    break;
                }
                default: {
                    out[outIndex++] = this.codepageType == 2 ? 123 : 35;
                }
            }
            ++inIndex;
        }
        return outIndex - outBeginIndex;
    }

    public byte[] convert(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return new byte[0];
        }
        if (inBeginIndex < 0) {
            return new byte[0];
        }
        if (inBeginIndex >= in.length) {
            return new byte[0];
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return new byte[0];
        }
        int outLength = this.outLength(in, inBeginIndex, inEndIndex);
        byte[] out = new byte[outLength];
        this.convert(in, inBeginIndex, inEndIndex, out, 0, outLength - 1);
        return out;
    }

    public byte[] convert(char[] in) {
        if (in == null) {
            return new byte[0];
        }
        int outLength = this.outLength(in, 0, in.length - 1);
        byte[] out = new byte[outLength];
        this.convert(in, 0, in.length - 1, out, 0, outLength - 1);
        return out;
    }

    public int outLength(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        int outLength = 0;
        int inIndex = inBeginIndex;
        while (inIndex <= inEndIndex) {
            byte numBytes;
            if (in[inIndex] >= '\ud800' && in[inIndex] <= '\udbff') {
                if (inIndex < inEndIndex && in[inIndex + 1] >= '\udc00' && in[inIndex + 1] <= '\udfff') {
                    numBytes = this.charLength2ToByte[(this.charLength2ToByteOffset3[this.charLength2ToByteOffset2[this.charLength2ToByteOffset1[in[inIndex] >> 8] | in[inIndex] & 0xFF] | in[inIndex + 1] >> 8] | in[inIndex + 1] & 0xFF) * 3];
                    outLength = numBytes > 0 && numBytes < 4 ? (outLength += numBytes) : ++outLength;
                    inIndex += 2;
                    continue;
                }
            } else if (in[inIndex] == '\uf8fc') {
                if (inIndex < inEndIndex) {
                    int tabIndex = (this.charLength2ToByteOffset3[this.charLength2ToByteOffset2[this.charLength2ToByteOffset1[in[inIndex] >> 8] | in[inIndex] & 0xFF] | in[inIndex + 1] >> 8] | in[inIndex + 1] & 0xFF) * 3;
                    numBytes = this.charLength2ToByte[tabIndex];
                    if (numBytes == 1 && this.charLength2ToByte[tabIndex + 1] != 35) {
                        ++outLength;
                        inIndex += 2;
                        continue;
                    }
                    if (numBytes > 1 && numBytes < 4) {
                        outLength += numBytes;
                        inIndex += 2;
                        continue;
                    }
                }
            } else if (in[inIndex] == '\uf8fd' && inIndex + 2 <= inEndIndex) {
                char sapIconChar1 = in[inIndex + 1];
                char sapIconChar2 = in[inIndex + 2];
                if ((sapIconChar1 >= '0' && sapIconChar1 <= '9' || sapIconChar1 >= 'A' && sapIconChar1 <= 'Z' || sapIconChar1 >= 'a' && sapIconChar1 <= 'z') && (sapIconChar2 >= '0' && sapIconChar2 <= '9' || sapIconChar2 >= 'A' && sapIconChar2 <= 'Z' || sapIconChar2 >= 'a' && sapIconChar2 <= 'z')) {
                    outLength += 4;
                    inIndex += 3;
                    continue;
                }
            }
            outLength = (numBytes = this.charLength1ToByte[(this.charLength1ToByteOffset[in[inIndex] >> 8] | in[inIndex] & 0xFF) * 3]) > 0 && numBytes < 4 ? (outLength += numBytes) : ++outLength;
            ++inIndex;
        }
        return outLength;
    }

    public int outLength(char[] in) {
        if (in == null) {
            return 0;
        }
        return this.outLength(in, 0, in.length - 1);
    }
}

