/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.cbs.ant.taskdefs.jom;

import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.api.IJlinTask;
import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.api.IRequestCreator;
import com.sap.tc.jtools.jlint.cbs.ant.taskdefs.api.JLinRunner;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.exceptions.ToolInitializationException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Javac;

public class JLinJavaTask
extends Javac
implements IJlinTask,
IRequestCreator {
    public static final String ANT_PROPERTY_JDK_HOME_DIR = "jlin.jdk.dir";
    public static final String PARAMETER_CLASS_FOLDERS = "Class folders";
    public static final String PARAMETER_JAVA_LIBRARIES = "Java libraries";
    public static final String PARAMETER_SOURCE_FOLDERS = "Source folders";
    public static final String JAVA_MODULE_ID = "com.sap.tc.jtools.jlin.java";
    public static final String JAR_EXTENSION = ".jar";
    private static final int FILE_NUMBER_MAX = 200;
    private static final FileFilter JAR_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().toLowerCase().endsWith(JLinJavaTask.JAR_EXTENSION);
        }
    };
    private JLinRunner runner;
    private String jdkHomeDir;
    private ParameterInterface javaLibraries;
    private ParameterInterface classFolders;
    private ParameterInterface sourceFolders;
    private File jlinHomeDir;
    private File testConfigFile;
    private File resultsDir;

    public void execute() throws BuildException {
        try {
            this.initialize();
        }
        catch (ToolInitializationException e) {
            throw new BuildException((Throwable)e);
        }
        this.jlinLog("Source compilation starting...", 3);
        try {
            super.execute();
        }
        catch (BuildException e) {
            this.jlinLog("Source compilation failed");
            throw e;
        }
        this.jlinLog("Source compilation successfully completed");
        this.setSearchPaths();
        try {
            this.runner.run((IRequestCreator)this);
        }
        catch (ToolInitializationException e) {
            this.runner.log((Exception)((Object)e));
        }
        catch (PerformException e) {
            this.runner.log((Exception)((Object)e));
        }
    }

    private void jlinLog(String msg) {
        this.jlinLog(msg, 3);
    }

    private void initialize() throws ToolInitializationException {
        this.runner = new JLinRunner(this.jlinHomeDir, this.resultsDir, this.testConfigFile);
        this.jdkHomeDir = ((ProjectComponent)this).project.getProperty(ANT_PROPERTY_JDK_HOME_DIR);
        if (this.empty(this.jdkHomeDir)) {
            this.jdkHomeDir = System.getProperty("java.home");
        }
        if (!new File(this.jdkHomeDir).isDirectory()) {
            throw new BuildException("ant property jlin.jdk.dir: " + this.jdkHomeDir + " is not a directory!");
        }
    }

    private boolean empty(String string) {
        return string == null || string.trim().equals("");
    }

    private void setSearchPaths() {
        ArrayList<String> jarLibraries = new ArrayList<String>();
        ArrayList<String> sourceFoldersList = new ArrayList<String>();
        ArrayList<String> classFoldersList = new ArrayList<String>();
        this.addJDKJars(jarLibraries);
        String[] mixedLibraries = this.getClasspath().list();
        int i = 0;
        while (i < mixedLibraries.length) {
            if (mixedLibraries[i].endsWith(JAR_EXTENSION)) {
                jarLibraries.add(JLinJavaTask.noBackSlashes(mixedLibraries[i]));
            } else {
                sourceFoldersList.add(JLinJavaTask.noBackSlashes(mixedLibraries[i]));
                classFoldersList.add(JLinJavaTask.noBackSlashes(mixedLibraries[i]));
            }
            ++i;
        }
        String[] sources = this.getSrcdir().list();
        int i2 = 0;
        while (i2 < sources.length) {
            sourceFoldersList.add(JLinJavaTask.noBackSlashes(sources[i2]));
            ++i2;
        }
        File destDir = this.getDestdir();
        if (destDir == null) {
            int i3 = 0;
            while (i3 < sources.length) {
                classFoldersList.add(JLinJavaTask.noBackSlashes(sources[i3]));
                ++i3;
            }
        } else {
            classFoldersList.add(JLinJavaTask.noBackSlashes(destDir.toString()));
        }
        this.javaLibraries = ParameterTool.createParameter((String)PARAMETER_JAVA_LIBRARIES, (String)"STRING[]", (Object)jarLibraries.toArray(new String[jarLibraries.size()]));
        this.classFolders = ParameterTool.createParameter((String)PARAMETER_CLASS_FOLDERS, (String)"STRING[]", (Object)classFoldersList.toArray(new String[classFoldersList.size()]));
        this.sourceFolders = ParameterTool.createParameter((String)PARAMETER_SOURCE_FOLDERS, (String)"STRING[]", (Object)sourceFoldersList.toArray(new String[sourceFoldersList.size()]));
    }

    private void addJDKJars(List jarLibraries) {
        File[] jdkLibExtJars;
        File[] jdkLibJars = new File(this.jdkHomeDir, "lib").listFiles(JAR_FILE_FILTER);
        if (jdkLibJars != null) {
            int i = 0;
            while (i < jdkLibJars.length) {
                jarLibraries.add(JLinJavaTask.noBackSlashes(jdkLibJars[i].getAbsolutePath()));
                ++i;
            }
        }
        if ((jdkLibExtJars = new File(this.jdkHomeDir, "lib/ext").listFiles(JAR_FILE_FILTER)) != null) {
            int i = 0;
            while (i < jdkLibExtJars.length) {
                jarLibraries.add(JLinJavaTask.noBackSlashes(jdkLibExtJars[i].getAbsolutePath()));
                ++i;
            }
        }
    }

    public void setJlinHomeDir(File jlinHomeDir) {
        this.jlinHomeDir = jlinHomeDir;
    }

    public void setTestConfigFile(File testConfigFile) {
        this.testConfigFile = testConfigFile;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    public String getModuleID() {
        return JAVA_MODULE_ID;
    }

    public PerformRequest[] createRequests(Test[] tests) {
        ArrayList<PerformRequest> requests = new ArrayList<PerformRequest>();
        JavaFileArrayTestObject[] testObjects = this.getTestObjects();
        int testObjNo = 0;
        while (testObjNo < testObjects.length) {
            PerformRequest performRequest = new PerformRequest("JLin Java Perform Request");
            performRequest.addParameter(this.javaLibraries);
            performRequest.addParameter(this.classFolders);
            performRequest.addParameter(this.sourceFolders);
            int i = 0;
            while (i < tests.length) {
                performRequest.addTest(tests[i]);
                ++i;
            }
            int fileCount = 0;
            while (testObjNo < testObjects.length && fileCount < 200) {
                performRequest.addSource((TestObject)testObjects[testObjNo]);
                fileCount += testObjects[testObjNo].getFileNames().length;
                ++testObjNo;
            }
            requests.add(performRequest);
        }
        return requests.toArray(new PerformRequest[0]);
    }

    private JavaFileArrayTestObject[] getTestObjects() {
        String[] srcDirs = this.getSrcdir().list();
        HashMap<String, String[]> fileMap = new HashMap<String, String[]>(srcDirs.length);
        ArrayList<JavaFileArrayTestObject> testObjs = new ArrayList<JavaFileArrayTestObject>(srcDirs.length);
        ArrayList<String> srcFiles = new ArrayList<String>(this.compileList.length);
        try {
            int i = 0;
            while (i < this.compileList.length) {
                srcFiles.add(JLinJavaTask.noBackSlashes(this.compileList[i].getCanonicalPath()));
                ++i;
            }
            int i2 = 0;
            while (i2 < srcDirs.length) {
                ArrayList<String> matchingFiles = new ArrayList<String>();
                String srcDir = JLinJavaTask.noBackSlashes(((ProjectComponent)this).project.resolveFile(srcDirs[i2]).getCanonicalPath());
                Iterator iter = srcFiles.iterator();
                while (iter.hasNext()) {
                    String src = (String)iter.next();
                    if (!src.startsWith(srcDir)) continue;
                    matchingFiles.add(src.substring(srcDir.length() + 1));
                    iter.remove();
                }
                fileMap.put(JLinJavaTask.noBackSlashes(((ProjectComponent)this).project.resolveFile(srcDirs[i2]).getCanonicalPath()), matchingFiles.toArray(new String[matchingFiles.size()]));
                ++i2;
            }
            Iterator iter = fileMap.keySet().iterator();
            while (iter.hasNext()) {
                String baseDir = (String)iter.next();
                String[] files = (String[])fileMap.get(baseDir);
                if (files.length < 200) {
                    testObjs.add(new JavaFileArrayTestObject(baseDir, files));
                    continue;
                }
                int fileCount = 0;
                while (fileCount < files.length) {
                    int arraySize = fileCount + 200 < files.length ? 200 : files.length - fileCount;
                    String[] fileArrayChunk = new String[arraySize];
                    System.arraycopy(files, fileCount, fileArrayChunk, 0, arraySize);
                    testObjs.add(new JavaFileArrayTestObject(baseDir, fileArrayChunk));
                    fileCount += arraySize;
                }
            }
        }
        catch (IOException e) {
            this.runner.log((Exception)e);
        }
        catch (InvalidTestObjectSpecification e) {
            this.runner.log((Exception)((Object)e));
        }
        return testObjs.toArray(new JavaFileArrayTestObject[testObjs.size()]);
    }

    private void jlinLog(String message, int severity) {
        this.log(message, severity);
        this.runner.log(message);
    }

    private static String noBackSlashes(String string) {
        return string.replace('\\', '/');
    }
}

