/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.secstorefs;

import com.sap.security.core.server.secstorefs.DuplicateException;
import com.sap.security.core.server.secstorefs.FileExistsException;
import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.FileMissingException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.NotFoundException;
import com.sap.security.core.server.secstorefs.ReservedKeyException;
import iaik.utils.Base64Exception;
import iaik.utils.Base64InputStream;
import iaik.utils.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class StorageHandler {
    private static final String FILEHEADER = "SAP Secure Store file - Don't edit this file manually!";
    private static final String BACKUP_PREFIX = "Copy";
    private static final String BACKUP_SUFFIX = ".bak";
    private static final String MARKER_NAME = "$internal/mode";
    private static final String MARKER_INSECURE = "Not encrypted";
    private static final String MARKER_SECURE = "encrypted";
    private boolean opened = false;
    private boolean modified;
    private String filename = null;
    private File file;
    private Properties contents;

    private static String base64Encode(byte[] rawData) throws InvalidStateException {
        String valueString;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Base64OutputStream b64os = new Base64OutputStream((OutputStream)baos);
        try {
            b64os.write(rawData, 0, rawData.length);
            b64os.flush();
            valueString = baos.toString("UTF-8");
        }
        catch (IOException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0008", ex);
        }
        return valueString;
    }

    private static byte[] base64Decode(String encodedString) throws InvalidStateException {
        byte[] chunk;
        int BUFFER_SIZE = 1000;
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedString.getBytes());
        Base64InputStream b64is = new Base64InputStream((InputStream)bais);
        Vector<byte[]> v = new Vector<byte[]>();
        int totalLength = 0;
        try {
            chunk = new byte[1000];
            int lengthThisChunk = b64is.read(chunk, 0, chunk.length);
            while (lengthThisChunk == 1000) {
                v.addElement(chunk);
                totalLength += lengthThisChunk;
                chunk = new byte[1000];
                lengthThisChunk = b64is.read(chunk, 0, chunk.length);
            }
            if (lengthThisChunk > 0) {
                byte[] lastChunk = new byte[lengthThisChunk];
                System.arraycopy(chunk, 0, lastChunk, 0, lengthThisChunk);
                v.addElement(lastChunk);
                totalLength += lengthThisChunk;
            }
            b64is.close();
        }
        catch (Base64Exception ex) {
            throw new InvalidStateException("security.class_secStoreFS_0011", ex);
        }
        catch (IOException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0010", ex);
        }
        byte[] array = new byte[totalLength];
        int arrayIndex = 0;
        int vIndex = 0;
        while (vIndex < v.size()) {
            chunk = (byte[])v.elementAt(vIndex);
            System.arraycopy(chunk, 0, array, arrayIndex, chunk.length);
            arrayIndex += chunk.length;
            ++vIndex;
        }
        return array;
    }

    StorageHandler() {
    }

    void createNewStore(String filename, boolean encrypted) throws InvalidStateException, FileIOException, FileExistsException {
        if (this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0001", filename);
        }
        this.file = new File(filename);
        if (this.file.exists()) {
            throw new FileExistsException(filename);
        }
        this.contents = new Properties();
        if (encrypted) {
            this.contents.setProperty(MARKER_NAME, MARKER_SECURE);
        } else {
            this.contents.setProperty(MARKER_NAME, MARKER_INSECURE);
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            this.contents.store(fos, FILEHEADER);
            fos.close();
        }
        catch (IOException ex) {
            throw new FileIOException(filename, ex);
        }
        this.opened = true;
        this.modified = false;
        this.filename = filename;
    }

    boolean openExistingStore(String filename) throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException {
        boolean encrypted;
        if (this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0001", filename);
        }
        this.file = new File(filename);
        if (!this.file.exists()) {
            throw new FileMissingException(filename);
        }
        this.contents = new Properties();
        try {
            FileInputStream fis = new FileInputStream(filename);
            this.contents.load(fis);
            fis.close();
        }
        catch (IOException ex) {
            throw new FileIOException(filename, ex);
        }
        String value = this.contents.getProperty(MARKER_NAME);
        if (value == null) {
            throw new FileInvalidException("security.class_secStoreFS_0003", filename, MARKER_NAME);
        }
        if (value.equals(MARKER_SECURE)) {
            encrypted = true;
        } else if (value.equals(MARKER_INSECURE)) {
            encrypted = false;
        } else {
            throw new FileInvalidException("security.class_secStoreFS_0012", (Object)filename, (Object)MARKER_NAME, value);
        }
        this.opened = true;
        this.modified = false;
        this.filename = filename;
        return encrypted;
    }

    void markEncrypted() throws InvalidStateException, FileInvalidException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        String value = this.contents.getProperty(MARKER_NAME);
        if (value == null) {
            throw new FileInvalidException("security.class_secStoreFS_0003", this.filename, MARKER_NAME);
        }
        if (value.equals(MARKER_INSECURE)) {
            this.contents.setProperty(MARKER_NAME, MARKER_SECURE);
            this.modified = true;
        } else if (!value.equals(MARKER_SECURE)) {
            throw new FileInvalidException("security.class_secStoreFS_0012", (Object)this.filename, (Object)MARKER_NAME, value);
        }
    }

    void insertPair(String key, byte[] value) throws InvalidStateException, ReservedKeyException, DuplicateException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        if (key.equals(MARKER_NAME)) {
            throw new ReservedKeyException(MARKER_NAME);
        }
        if (((Hashtable)this.contents).containsKey(key)) {
            throw new DuplicateException(key);
        }
        String valueString = StorageHandler.base64Encode(value);
        this.contents.setProperty(key, valueString);
        this.modified = true;
    }

    void updatePair(String key, byte[] value) throws InvalidStateException, ReservedKeyException, NotFoundException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        if (key.equals(MARKER_NAME)) {
            throw new ReservedKeyException(MARKER_NAME);
        }
        if (!((Hashtable)this.contents).containsKey(key)) {
            throw new NotFoundException(key);
        }
        String valueString = StorageHandler.base64Encode(value);
        this.contents.setProperty(key, valueString);
        this.modified = true;
    }

    void deletePair(String key) throws InvalidStateException, ReservedKeyException, NotFoundException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        if (key.equals(MARKER_NAME)) {
            throw new ReservedKeyException(MARKER_NAME);
        }
        Object oldValue = ((Hashtable)this.contents).remove(key);
        if (oldValue == null) {
            throw new NotFoundException(key);
        }
        this.modified = true;
    }

    byte[] getValue(String key) throws InvalidStateException, ReservedKeyException, NotFoundException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        if (key.equals(MARKER_NAME)) {
            throw new ReservedKeyException(MARKER_NAME);
        }
        String stringValue = this.contents.getProperty(key);
        if (stringValue == null) {
            throw new NotFoundException(key);
        }
        return StorageHandler.base64Decode(stringValue);
    }

    Hashtable getPairs() throws InvalidStateException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        Hashtable<String, byte[]> ht = new Hashtable<String, byte[]>();
        Enumeration<?> keys = this.contents.propertyNames();
        while (keys.hasMoreElements()) {
            String currentKey = (String)keys.nextElement();
            if (currentKey.equals(MARKER_NAME)) continue;
            String currentValueString = this.contents.getProperty(currentKey);
            byte[] currentValueBytes = StorageHandler.base64Decode(currentValueString);
            ht.put(currentKey, currentValueBytes);
        }
        return ht;
    }

    void flush() throws InvalidStateException, FileIOException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        if (this.modified) {
            try {
                FileOutputStream fos = new FileOutputStream(this.filename);
                this.contents.store(fos, FILEHEADER);
                fos.close();
            }
            catch (IOException ex) {
                throw new FileIOException(this.filename, ex);
            }
            this.modified = false;
        }
    }

    void close() throws InvalidStateException, FileIOException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        this.flush();
        this.opened = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String createCopy() throws InvalidStateException, FileIOException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0002");
        }
        File backupFile = null;
        int BUFFER_SIZE = 1000;
        byte[] buffer = new byte[1000];
        FileInputStream fis = null;
        boolean fisOpen = false;
        FileOutputStream fos = null;
        boolean fosOpen = false;
        try {
            try {
                String directoryString = this.file.getParent();
                if (directoryString == null) {
                    directoryString = ".";
                }
                File directory = new File(directoryString);
                backupFile = File.createTempFile(BACKUP_PREFIX, BACKUP_SUFFIX, directory);
                fis = new FileInputStream(this.file);
                fisOpen = true;
                fos = new FileOutputStream(backupFile);
                fosOpen = true;
                int byteCount = fis.read(buffer);
                while (byteCount > 0) {
                    fos.write(buffer, 0, byteCount);
                    byteCount = fis.read(buffer);
                }
            }
            catch (IOException ex) {
                throw new FileIOException(this.filename, ex);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (fosOpen) {
                    fos.close();
                }
                if (!fisOpen) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new FileIOException(this.filename, ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new FileIOException(this.filename, ex);
        }
        if (fosOpen) {
            fos.close();
        }
        if (!fisOpen) return backupFile.getPath();
        fis.close();
        return backupFile.getPath();
    }

    void deleteCopy(String filename) throws FileMissingException, FileIOException {
        File backupFile = new File(filename);
        if (!backupFile.exists()) {
            throw new FileMissingException(filename);
        }
        try {
            boolean deleted = backupFile.delete();
            if (!deleted) {
                throw new FileIOException("security.class_secStoreFS_0012", filename);
            }
        }
        catch (SecurityException ex) {
            throw new FileIOException(filename, ex);
        }
    }
}

