/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.secstorefs;

import com.sap.security.core.server.secstorefs.Crypt;
import com.sap.security.core.server.secstorefs.DuplicateException;
import com.sap.security.core.server.secstorefs.FileExistsException;
import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.FileMissingException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.KeyRequiredException;
import com.sap.security.core.server.secstorefs.NoEncryptionException;
import com.sap.security.core.server.secstorefs.NoHashException;
import com.sap.security.core.server.secstorefs.NoKeyRequiredException;
import com.sap.security.core.server.secstorefs.NoSIDException;
import com.sap.security.core.server.secstorefs.NotFoundException;
import com.sap.security.core.server.secstorefs.ReservedKeyException;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import com.sap.security.core.server.secstorefs.StorageHandler;
import com.sap.security.core.server.secstorefs.WrongKeyException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import iaik.utils.Base64Exception;
import iaik.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.BadPaddingException;

public class SecStoreFS {
    private static final String PROP_FILENAME = "SAPSECFILE";
    private static final String PROP_DEFAULT_DIR = "DIR_GLOBAL";
    private static final String DEFAULT_FILENAME = "SecStore.properties";
    private static final String SW_VERSION = "6.30.000.001";
    private static final String STRING_TYPE = "java.lang.String";
    private static final char DELIMITER = '|';
    private static final byte BYTE_DELIMITER = 124;
    private static final int PADDING_LENGTH = 20;
    private static final String RESERVED_PREFIX = "$internal/";
    private static final String CHECK_KEY = "$internal/check";
    private static final String CHECK_VALUE = "SAP Secure Store";
    private static final String VERSION_KEY = "$internal/version";
    private static final String BUNDLE_NAME = "com.sap.security.core.server.secstorefs.SecStoreFSResources";
    private static Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$secstorefs$SecStoreFS == null ? (class$com$sap$security$core$server$secstorefs$SecStoreFS = SecStoreFS.class$("com.sap.security.core.server.secstorefs.SecStoreFS")) : class$com$sap$security$core$server$secstorefs$SecStoreFS));
    private static Category cat = Category.getCategory((String)"/System/Security/SecStoreFS");
    private static String defaultDataFilename = null;
    private String filename = null;
    private boolean opened = false;
    private boolean encrypted;
    private Crypt crypt;
    private StorageHandler sh = new StorageHandler();
    private String fileVersion;
    static /* synthetic */ Class class$com$sap$security$core$server$secstorefs$SecStoreFS;

    public static void setSID(String SID) {
        Crypt.setSID(SID);
    }

    public static void setDefaultFilenames(String dataFilename, String keyFilename) throws InvalidStateException {
        if (dataFilename == null) {
            throw new InvalidStateException("security.class_secStoreFS_0046");
        }
        if (dataFilename.equals("")) {
            throw new InvalidStateException("security.class_secStoreFS_0047");
        }
        if (keyFilename == null) {
            throw new InvalidStateException("security.class_secStoreFS_0048");
        }
        if (keyFilename.equals("")) {
            throw new InvalidStateException("security.class_secStoreFS_0049");
        }
        if (defaultDataFilename != null && !defaultDataFilename.equals(dataFilename)) {
            throw new InvalidStateException("security.class_secStoreFS_0044", (Object)defaultDataFilename, dataFilename);
        }
        Crypt.setDefaultKeyFilename(keyFilename);
        defaultDataFilename = dataFilename;
    }

    private static String getFilename() {
        String method = "getFilename ()";
        if (defaultDataFilename != null) {
            loc.infoT(method, "setDefaultFilenames () called, filename = \"" + defaultDataFilename + "\".");
            return defaultDataFilename;
        }
        String dataFile = System.getProperty(PROP_FILENAME);
        if (dataFile != null) {
            loc.infoT(method, "System property SAPSECFILE set, filename = \"" + dataFile + "\".");
            return dataFile;
        }
        String dir = System.getProperty(PROP_DEFAULT_DIR);
        if (dir != null) {
            dataFile = dir + File.separatorChar + DEFAULT_FILENAME;
            loc.infoT(method, "System property DIR_GLOBAL set, filename = \"" + dataFile + "\".");
            return dataFile;
        }
        dataFile = DEFAULT_FILENAME;
        loc.infoT(method, "System properties SAPSECFILE and DIR_GLOBAL not found, filename = \"" + dataFile + "\".");
        return dataFile;
    }

    public static boolean isKeyDialogRequired() throws InvalidStateException, FileIOException, FileInvalidException {
        SecStoreFS SSFS = new SecStoreFS();
        boolean result = SSFS.isKeyDialogRequiredForThisInstance();
        return result;
    }

    public static void setDefaultKeyPhrase(String keyPhrase) {
        Crypt.setDefaultKeyPhrase(keyPhrase);
    }

    private static void usage(String message) {
        String keyPhraseStuff = "-p \"<key phrase>\" [-nostore]";
        System.out.println("Usage:");
        System.out.println();
        System.out.println("SecStoreFS status  <standard>");
        System.out.println("SecStoreFS exists  <standard>");
        System.out.println("SecStoreFS create  <standard> -noenc");
        System.out.println("SecStoreFS create  <standard> -enc -p \"<key phrase>\" [-nostore]");
        System.out.println("SecStoreFS insert  <standard> <key> <value>");
        System.out.println("SecStoreFS encrypt <standard>      -p \"<key phrase>\" [-nostore]");
        System.out.println("SecStoreFS updatep <standard>      -p \"<key phrase>\" [-nostore]");
        System.out.println();
        System.out.println("where <standard> is [-s <SID>] [-f <data filename> -k <key filename>]");
        if (message != null && !message.equals("")) {
            System.out.println();
            System.out.println(message);
        }
    }

    private static String handleKeyPhrase() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Warning: this command line user interface is meant as a last resort if");
        System.out.println("everything else fails.");
        System.out.println("The key phrase that you must type in now will be visible on the screen!");
        System.out.print("Key Phrase => ");
        String keyPhrase = in.readLine();
        in.close();
        return keyPhrase;
    }

    private static void handleStatus(String[] args) throws SecStoreFSException, IOException {
        SecStoreFS SSFS;
        int argc = args.length;
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        if (dataFilename != null) {
            SecStoreFS.setDefaultFilenames(dataFilename, keyFilename);
        }
        if (SecStoreFS.isKeyDialogRequired()) {
            String keyPhrase = SecStoreFS.handleKeyPhrase();
            SecStoreFS.setDefaultKeyPhrase(keyPhrase);
        }
        if ((SSFS = new SecStoreFS()).isEncryptionPossible()) {
            System.out.println("Encryption is possible.");
        } else {
            System.out.println("Encryption is not possible.");
        }
        if (SSFS.isKeyRequired()) {
            System.out.println("An encryption key (key phrase) is required.");
        } else {
            System.out.println("An encryption key (key phrase) is not required.");
        }
        if (SecStoreFS.isKeyDialogRequired()) {
            System.out.println("A key dialog is required for the default store.");
        } else {
            System.out.println("A key dialog is not required for the default store.");
        }
        try {
            SSFS.openExistingStore();
            if (SSFS.isEncrypted()) {
                if (dataFilename == null) {
                    System.out.println("The default store is encrypted.");
                } else {
                    System.out.println("Store \"" + dataFilename + "\" is encrypted.");
                }
            } else if (dataFilename == null) {
                System.out.println("The default store is not encrypted.");
            } else {
                System.out.println("Store \"" + dataFilename + "\" is not encrypted.");
            }
        }
        catch (FileMissingException ex) {
            if (dataFilename == null) {
                System.out.println("A default store doesn't exist.");
            }
            System.out.println("Store \"" + dataFilename + "\" doesn't exist.");
        }
    }

    private static void handleExists(String[] args) throws SecStoreFSException, IOException {
        int argc = args.length;
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        if (dataFilename != null) {
            SecStoreFS.setDefaultFilenames(dataFilename, keyFilename);
        }
        if (SecStoreFS.isKeyDialogRequired()) {
            String keyPhrase = SecStoreFS.handleKeyPhrase();
            SecStoreFS.setDefaultKeyPhrase(keyPhrase);
        }
        SecStoreFS SSFS = new SecStoreFS();
        try {
            SSFS.openExistingStore();
            if (dataFilename == null) {
                System.out.println("A default store exists.");
            } else {
                System.out.println("Store \"" + dataFilename + "\" exists.");
            }
        }
        catch (FileMissingException ex) {
            if (dataFilename == null) {
                System.out.println("A default store doesn't exist.");
            } else {
                System.out.println("Store \"" + dataFilename + "\" doesn't exist.");
            }
            System.exit(2);
        }
    }

    private static void handleCreate(String[] args) throws SecStoreFSException {
        int argc = args.length;
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        String keyPhrase = null;
        String encryption = null;
        boolean storeKeyPhrase = true;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else if (args[index].equals("-p")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Key phrase missing after option \"-p\"!");
                    System.exit(1);
                }
                keyPhrase = args[index];
            } else if (args[index].equals("-enc") || args[index].equals("-noenc")) {
                if (encryption != null) {
                    SecStoreFS.usage(encryption + " has already been specified.");
                }
                encryption = args[index];
            } else if (args[index].equals("-nostore")) {
                storeKeyPhrase = false;
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (encryption == null) {
            SecStoreFS.usage("\"-enc\" or \"-noenc\" required!");
            System.exit(1);
        }
        if (encryption.equals("-noenc") && keyPhrase != null) {
            SecStoreFS.usage("Can't specify a key phrase with -noenc!");
            System.exit(1);
        }
        if (encryption.equals("-noenc") && !storeKeyPhrase) {
            SecStoreFS.usage("Can't specify -nostore with -noenc!");
            System.exit(1);
        }
        if (keyPhrase == null && !storeKeyPhrase) {
            SecStoreFS.usage("Can't specify -nostore without a key phrase!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        if (encryption.equals("-enc")) {
            SecStoreFS SSFS = new SecStoreFS();
            if (dataFilename != null) {
                SSFS.setFilenames(dataFilename, keyFilename);
            }
            if (!SSFS.isEncryptionPossible()) {
                SecStoreFS.usage("Encryption is not possible in this installation!");
                System.exit(1);
            }
            if (keyPhrase == null) {
                if (SSFS.isKeyRequired()) {
                    SecStoreFS.usage("A key phrase is required but none was given!");
                    System.exit(1);
                }
                SSFS.createStoreWithEncryption();
                System.out.println("Store with encryption but without a key phrase created.");
            } else {
                if (!SSFS.isKeyRequired()) {
                    SecStoreFS.usage("A key phrase is not required but a key phrase was given!");
                    System.exit(1);
                }
                SSFS.createStoreWithEncryption(keyPhrase, storeKeyPhrase);
                System.out.println("Store with encryption and a key phrase created.");
            }
        } else {
            if (keyPhrase != null) {
                SecStoreFS.usage("\"-noenc\" specified but a key phrase was given.");
                System.exit(1);
            }
            SecStoreFS SSFS = new SecStoreFS();
            if (dataFilename != null) {
                SSFS.setFilenames(dataFilename, keyFilename);
            }
            SSFS.createStoreWithoutEncryption();
            System.out.println("Store without encryption created.");
        }
    }

    private static void handleInsert(String[] args) throws SecStoreFSException, IOException {
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        String key = null;
        String value = null;
        int argc = args.length;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else if (key == null) {
                key = args[index];
            } else if (value == null) {
                value = args[index];
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (key == null) {
            SecStoreFS.usage("No key given!");
            System.exit(1);
        }
        if (value == null) {
            SecStoreFS.usage("No value given!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        SecStoreFS SSFS = new SecStoreFS();
        if (dataFilename != null) {
            SSFS.setFilenames(dataFilename, keyFilename);
        }
        if (SSFS.isKeyDialogRequiredForThisInstance()) {
            String oldKeyPhrase = SecStoreFS.handleKeyPhrase();
            SSFS.openExistingStore(oldKeyPhrase);
        } else {
            SSFS.openExistingStore();
        }
        try {
            SSFS.insertPair(key, value);
            System.out.println("Key/value pair inserted.");
        }
        catch (DuplicateException ex) {
            System.out.println("A key/value pair with this key already exists in the store.");
            System.exit(2);
        }
    }

    private static void handleEncrypt(String[] args) throws SecStoreFSException {
        int argc = args.length;
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        String keyPhrase = null;
        boolean storeKeyPhrase = true;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else if (args[index].equals("-p")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Key phrase missing after option \"-p\"!");
                    System.exit(1);
                }
                keyPhrase = args[index];
            } else if (args[index].equals("-nostore")) {
                storeKeyPhrase = false;
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (keyPhrase == null) {
            SecStoreFS.usage("No key phrase given!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        SecStoreFS SSFS = new SecStoreFS();
        if (dataFilename != null) {
            SSFS.setFilenames(dataFilename, keyFilename);
        }
        SSFS.openExistingStore();
        if (SSFS.isEncrypted()) {
            SecStoreFS.usage("This store is already encrypted!");
            System.exit(1);
        }
        SSFS.migrateUnencrypted2Encrypted(keyPhrase, storeKeyPhrase);
        System.out.println("The store is encrypted now.");
    }

    private static void handleUpdateP(String[] args) throws SecStoreFSException, IOException {
        int argc = args.length;
        String SID = null;
        String dataFilename = null;
        String keyFilename = null;
        String keyPhrase = null;
        boolean storeKeyPhrase = true;
        int index = 1;
        while (index < argc) {
            if (args[index].equals("-s")) {
                if (++index >= argc) {
                    SecStoreFS.usage("SID missing after option \"-s\"!");
                    System.exit(1);
                }
                SID = args[index];
            } else if (args[index].equals("-f")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-f\"!");
                    System.exit(1);
                }
                dataFilename = args[index];
            } else if (args[index].equals("-k")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Filename missing after option \"-k\"!");
                    System.exit(1);
                }
                keyFilename = args[index];
            } else if (args[index].equals("-p")) {
                if (++index >= argc) {
                    SecStoreFS.usage("Key phrase missing after option \"-p\"!");
                    System.exit(1);
                }
                keyPhrase = args[index];
            } else if (args[index].equals("-nostore")) {
                storeKeyPhrase = false;
            } else {
                SecStoreFS.usage("Unknown option \"" + args[index] + "\".");
                System.exit(1);
            }
            ++index;
        }
        if (dataFilename == null && keyFilename != null) {
            SecStoreFS.usage("Can't specify the name of key file but not the name of data file!");
            System.exit(1);
        } else if (dataFilename != null && keyFilename == null) {
            SecStoreFS.usage("Can't specify the name of data file but not the name of key file!");
            System.exit(1);
        }
        if (keyPhrase == null) {
            SecStoreFS.usage("No key phrase given!");
            System.exit(1);
        }
        if (SID != null) {
            SecStoreFS.setSID(SID);
        }
        SecStoreFS SSFS = new SecStoreFS();
        if (dataFilename != null) {
            SSFS.setFilenames(dataFilename, keyFilename);
        }
        if (SSFS.isKeyDialogRequiredForThisInstance()) {
            String oldKeyPhrase = SecStoreFS.handleKeyPhrase();
            SSFS.openExistingStore(oldKeyPhrase);
        } else {
            SSFS.openExistingStore();
        }
        if (!SSFS.isEncrypted()) {
            SecStoreFS.usage("This store is not encrypted!");
            System.exit(1);
        }
        SSFS.migrateEncryptionKey(keyPhrase, storeKeyPhrase);
        System.out.println("The key phrase and the encrypted data were updated.");
    }

    public static void main(String[] args) throws SecStoreFSException, IOException {
        int argc;
        System.out.println("SAP Secure Store in the File System - Copyright (c) 2003 SAP AG");
        System.out.println();
        File loggingFile = new File("logging.properties");
        if (loggingFile.exists()) {
            PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator(loggingFile);
            propertiesConfigurator.configure();
        }
        if ((argc = args.length) < 1) {
            SecStoreFS.usage("Please specify the action!");
            System.exit(1);
        }
        try {
            if (args[0].equals("help") || args[0].equals("-help") || args[0].equals("h") || args[0].equals("-h") || args[0].equals("?") || args[0].equals("-?")) {
                SecStoreFS.usage(null);
            } else if (args[0].equals("status")) {
                SecStoreFS.handleStatus(args);
            } else if (args[0].equals("exists")) {
                SecStoreFS.handleExists(args);
            } else if (args[0].equals("create")) {
                SecStoreFS.handleCreate(args);
            } else if (args[0].equals("insert")) {
                SecStoreFS.handleInsert(args);
            } else if (args[0].equals("encrypt")) {
                SecStoreFS.handleEncrypt(args);
            } else if (args[0].equals("updatep")) {
                SecStoreFS.handleUpdateP(args);
            } else {
                SecStoreFS.usage("Invalid action \"" + args[0] + "\" specified!");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }

    public SecStoreFS() {
        this.crypt = new Crypt();
        loc.infoT("SecStorFS (java.lang.String)", "SecStoreFS object initialized.");
    }

    public boolean isEncryptionPossible() {
        return this.crypt.isEncryptionPossible();
    }

    public boolean isKeyRequired() {
        return this.crypt.isKeyRequired();
    }

    public void setFilenames(String dataFilename, String keyFilename) throws InvalidStateException {
        if (this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0001");
        }
        this.filename = dataFilename;
        this.crypt.setKeyFilename(keyFilename);
        loc.infoT("setFilenames ()", "dataFilename set to \"" + dataFilename + "\"," + "keyFilename set to \"" + keyFilename + "\"");
    }

    public boolean isKeyDialogRequiredForThisInstance() throws InvalidStateException, FileIOException, FileInvalidException {
        if (this.filename == null) {
            this.filename = SecStoreFS.getFilename();
        }
        try {
            boolean encrypted = this.sh.openExistingStore(this.filename);
            this.sh.close();
            if (!encrypted) {
                return false;
            }
        }
        catch (InvalidStateException ex) {
            throw ex;
        }
        catch (FileIOException ex) {
            throw ex;
        }
        catch (FileMissingException ex) {
            return false;
        }
        catch (FileInvalidException ex) {
            throw ex;
        }
        if (!this.crypt.isKeyRequired()) {
            return false;
        }
        return this.crypt.isKeyDialogRequiredForThisInstance();
    }

    private void writeVersionRecord() throws InvalidStateException {
        try {
            byte[] byteValue = SW_VERSION.getBytes("UTF-8");
            this.sh.insertPair(VERSION_KEY, byteValue);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        catch (ReservedKeyException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0029", (Object)CHECK_KEY, (Throwable)((Object)ex));
        }
        catch (DuplicateException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0034", (Object)VERSION_KEY, (Throwable)((Object)ex));
        }
    }

    private void writeCheckRecord() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoHashException, NoSIDException {
        try {
            byte[] byteValue = CHECK_VALUE.getBytes("UTF-8");
            byteValue = this.crypt.encrypt(byteValue);
            this.sh.insertPair(CHECK_KEY, byteValue);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        catch (NoEncryptionException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
        }
        catch (ReservedKeyException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0029", (Object)CHECK_KEY, (Throwable)((Object)ex));
        }
        catch (DuplicateException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0033", (Object)CHECK_KEY, (Throwable)((Object)ex));
        }
    }

    public void createStoreWithoutEncryption() throws InvalidStateException, FileIOException, FileExistsException {
        this.encrypted = false;
        if (this.filename == null) {
            this.filename = SecStoreFS.getFilename();
        }
        this.sh.createNewStore(this.filename, false);
        this.writeVersionRecord();
        this.sh.flush();
        this.opened = true;
        this.fileVersion = SW_VERSION;
        loc.infoT("createStoreWithoutEncryption ()", "Store without encryption created.");
    }

    public void createStoreWithEncryption(String keyPhrase, boolean storeKey) throws InvalidStateException, FileIOException, FileMissingException, FileExistsException, FileInvalidException, NoEncryptionException, NoKeyRequiredException, NoHashException, NoSIDException {
        if (!this.crypt.isEncryptionPossible()) {
            throw new NoEncryptionException(this.crypt.getRootCause());
        }
        if (this.filename == null) {
            this.filename = SecStoreFS.getFilename();
        }
        if (storeKey) {
            this.crypt.setNewKeyInFile(keyPhrase, SW_VERSION);
        } else {
            this.crypt.setKeyForSession(keyPhrase);
        }
        this.encrypted = true;
        this.sh.createNewStore(this.filename, true);
        this.writeVersionRecord();
        this.writeCheckRecord();
        this.sh.flush();
        this.opened = true;
        this.fileVersion = SW_VERSION;
        loc.infoT("createStoreWithEncryption (java.lang.String)", "Store with encryption and key phrase created.");
    }

    public void createStoreWithEncryption() throws InvalidStateException, FileIOException, FileMissingException, FileExistsException, FileInvalidException, NoEncryptionException, KeyRequiredException, NoHashException, NoSIDException {
        if (!this.crypt.isEncryptionPossible()) {
            throw new NoEncryptionException(this.crypt.getRootCause());
        }
        if (this.crypt.isKeyRequired()) {
            throw new KeyRequiredException();
        }
        if (this.filename == null) {
            this.filename = SecStoreFS.getFilename();
        }
        this.encrypted = true;
        this.sh.createNewStore(this.filename, true);
        this.writeVersionRecord();
        this.writeCheckRecord();
        this.sh.flush();
        this.opened = true;
        this.fileVersion = SW_VERSION;
        loc.infoT("createStoreWithEncryption ()", "Store with encryption but without a key phrase created.");
    }

    private void checkCompatibility(String fileVersion) throws FileInvalidException {
        String relevantSWVersion;
        String method = "checkCompatibility (java.lang.String)";
        loc.infoT("checkCompatibility (java.lang.String)", "File version = \"" + fileVersion + "\", " + "software version = \"" + SW_VERSION + "\".");
        if (fileVersion.length() < 12) {
            throw new FileInvalidException("security.class_secStoreFS_0050", this.filename, fileVersion);
        }
        String relevantFileVersion = fileVersion.substring(0, 8);
        if (!relevantFileVersion.equals(relevantSWVersion = SW_VERSION.substring(0, 8))) {
            throw new FileInvalidException("security.class_secStoreFS_0036", (Object)this.filename, (Object)SW_VERSION, fileVersion);
        }
        if (fileVersion.compareTo(SW_VERSION) > 0) {
            loc.warningT("checkCompatibility (java.lang.String)", "File version is newer than software version!");
        }
    }

    public void openExistingStore() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoEncryptionException, WrongKeyException, NoHashException, NoSIDException {
        byte[] byteValue;
        if (this.filename == null) {
            this.filename = SecStoreFS.getFilename();
        }
        this.encrypted = this.sh.openExistingStore(this.filename);
        try {
            byteValue = this.sh.getValue(VERSION_KEY);
            this.fileVersion = new String(byteValue, "UTF-8");
            this.checkCompatibility(this.fileVersion);
        }
        catch (NotFoundException ex) {
            throw new FileInvalidException("security.class_secStoreFS_0035", (Object)this.filename, (Object)VERSION_KEY, (Throwable)((Object)ex));
        }
        catch (ReservedKeyException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0029", (Object)VERSION_KEY, (Throwable)((Object)ex));
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0017", ex);
        }
        if (this.encrypted) {
            if (!this.crypt.isEncryptionPossible()) {
                throw new NoEncryptionException(this.crypt.getRootCause());
            }
            try {
                byteValue = this.sh.getValue(CHECK_KEY);
                byteValue = this.crypt.decrypt(byteValue);
                String value = new String(byteValue, "UTF-8");
                if (!value.equals(CHECK_VALUE)) {
                    throw new WrongKeyException();
                }
                loc.infoT("openExistingStore ()", "Check record okay.");
            }
            catch (NotFoundException ex) {
                throw new FileInvalidException("security.class_secStoreFS_0031", (Object)ex);
            }
            catch (ReservedKeyException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0029", (Object)CHECK_KEY, (Throwable)((Object)ex));
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
            catch (UnsupportedEncodingException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0017", ex);
            }
            catch (InvalidStateException ex) {
                Throwable cause = ex.getCause();
                if (cause != null && cause instanceof BadPaddingException) {
                    throw new WrongKeyException((Throwable)((Object)ex));
                }
                throw ex;
            }
        }
        this.opened = true;
        loc.infoT("openExistingStore ()", "Existing store opened.");
    }

    public void openExistingStore(String keyPhrase) throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoEncryptionException, WrongKeyException, NoHashException, NoSIDException, NoKeyRequiredException {
        this.crypt.setKeyForSession(keyPhrase);
        this.openExistingStore();
    }

    public boolean isEncrypted() throws InvalidStateException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        return this.encrypted;
    }

    private String enrichString(String value) {
        int length = value.length();
        int padLength = 20 - length % 20;
        if (padLength == 0) {
            padLength = 20;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < padLength) {
            sb.append("$");
            ++index;
        }
        String enrichedValue = "java.lang.String|" + value.length() + '|' + value + sb.toString();
        return enrichedValue;
    }

    public void insertPair(String key, String value) throws InvalidStateException, ReservedKeyException, DuplicateException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (key.startsWith(RESERVED_PREFIX)) {
            throw new ReservedKeyException(key);
        }
        String enrichedValue = this.enrichString(value);
        byte[] byteValue = null;
        try {
            byteValue = enrichedValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        if (this.encrypted) {
            try {
                byteValue = this.crypt.encrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
        }
        this.sh.insertPair(key, byteValue);
        this.sh.flush();
    }

    public void updatePair(String key, String value) throws InvalidStateException, ReservedKeyException, NotFoundException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (key.startsWith(RESERVED_PREFIX)) {
            throw new ReservedKeyException(key);
        }
        String enrichedValue = this.enrichString(value);
        byte[] byteValue = null;
        try {
            byteValue = enrichedValue.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        if (this.encrypted) {
            try {
                byteValue = this.crypt.encrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
        }
        this.sh.updatePair(key, byteValue);
        this.sh.flush();
    }

    public void deletePair(String key) throws InvalidStateException, ReservedKeyException, NotFoundException, FileIOException, NoHashException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (key.startsWith(RESERVED_PREFIX)) {
            throw new ReservedKeyException(key);
        }
        this.sh.deletePair(key);
        this.sh.flush();
    }

    private String getValueType(String key, byte[] value) throws FileInvalidException, InvalidStateException {
        String type;
        int index = 0;
        while (index < value.length) {
            if (value[index] == 124) break;
            ++index;
        }
        if (index >= value.length || index == 0) {
            throw new FileInvalidException("security.class_secStoreFS_0037", this.filename, key);
        }
        try {
            type = new String(value, 0, index, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0017", ex);
        }
        return type;
    }

    private String getStringPayload(String key, String value) throws FileInvalidException, InvalidStateException {
        if (!value.startsWith(STRING_TYPE)) {
            throw new InvalidStateException("security.class_secStoreFS_0039", key);
        }
        int delimiterIndex = STRING_TYPE.length();
        if (value.charAt(delimiterIndex) != '|') {
            throw new FileInvalidException("security.class_secStoreFS_0040", this.filename, key);
        }
        String restValue = value.substring(delimiterIndex + 1);
        if ((delimiterIndex = restValue.indexOf(124)) < 0) {
            throw new FileInvalidException("security.class_secStoreFS_0041", this.filename, key);
        }
        String lengthString = restValue.substring(0, delimiterIndex);
        int length = 0;
        try {
            length = Integer.parseInt(lengthString);
        }
        catch (NumberFormatException ex) {
            throw new FileInvalidException("security.class_secStoreFS_0042", (Object)this.filename, (Object)key, lengthString);
        }
        restValue = restValue.substring(delimiterIndex + 1);
        if (restValue.length() > length) {
            restValue = restValue.substring(0, length);
        }
        return restValue;
    }

    public String getStringValue(String key) throws InvalidStateException, ReservedKeyException, NotFoundException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException {
        String value;
        String type;
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (key.startsWith(RESERVED_PREFIX)) {
            throw new ReservedKeyException(key);
        }
        byte[] byteValue = this.sh.getValue(key);
        if (this.encrypted) {
            try {
                byteValue = this.crypt.decrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
        }
        if (!(type = this.getValueType(key, byteValue)).equals(STRING_TYPE)) {
            throw new FileInvalidException("security.class_secStoreFS_0038", (Object)this.filename, (Object)key, type);
        }
        try {
            value = new String(byteValue, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0017", ex);
        }
        String payload = this.getStringPayload(key, value);
        return payload;
    }

    public Properties getStringPairs() throws InvalidStateException, FileIOException, FileMissingException, FileInvalidException, NoSIDException, NoHashException {
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        Hashtable ht = this.sh.getPairs();
        Properties p = new Properties();
        Enumeration keys = ht.keys();
        while (keys.hasMoreElements()) {
            String value;
            String type;
            String key = (String)keys.nextElement();
            if (key.startsWith(RESERVED_PREFIX)) continue;
            byte[] byteValue = (byte[])ht.get(key);
            if (this.encrypted) {
                try {
                    byteValue = this.crypt.decrypt(byteValue);
                }
                catch (NoEncryptionException ex) {
                    throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
                }
            }
            if (!(type = this.getValueType(key, byteValue)).equals(STRING_TYPE)) continue;
            try {
                value = new String(byteValue, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0017", ex);
            }
            String payload = this.getStringPayload(key, value);
            ((Hashtable)p).put(key, payload);
        }
        return p;
    }

    public void migrateUnencrypted2Encrypted(String keyPhrase, boolean storeKey) throws InvalidStateException, NoEncryptionException, NoKeyRequiredException, FileIOException, FileMissingException, FileInvalidException, NoHashException, NoSIDException {
        String method = "migrateUnencrypted2Encrypted (java.lang.String)";
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (!this.crypt.isEncryptionPossible()) {
            throw new NoEncryptionException(this.crypt.getRootCause());
        }
        if (!this.crypt.isKeyRequired()) {
            throw new NoKeyRequiredException(this.crypt.getRootCause());
        }
        if (this.encrypted) {
            throw new InvalidStateException("security.class_secStoreFS_0023");
        }
        this.sh.flush();
        String backupFilename = this.sh.createCopy();
        cat.info(loc, method, (Object)"security.class_secStoreFS_1000", new Object[]{this.filename, backupFilename}, "Secure Store file \"{0}\" backed up to \"{1}\".");
        Hashtable ht_old = this.sh.getPairs();
        if (storeKey) {
            this.crypt.setNewKeyInFile(keyPhrase, SW_VERSION);
        } else {
            this.crypt.setKeyForSession(keyPhrase);
        }
        Enumeration keys = ht_old.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(VERSION_KEY)) continue;
            byte[] byteValue = (byte[])ht_old.get(key);
            try {
                byteValue = this.crypt.encrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
            try {
                this.sh.updatePair(key, byteValue);
            }
            catch (NotFoundException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0032", (Object)key, (Throwable)((Object)ex));
            }
            catch (ReservedKeyException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0029", (Object)key, (Throwable)((Object)ex));
            }
        }
        this.sh.markEncrypted();
        this.writeCheckRecord();
        this.sh.flush();
        cat.info(loc, method, (Object)"security.class_secStoreFS_1006", "Migration of the Secure Store to encryption done.");
        try {
            this.sh.deleteCopy(backupFilename);
            cat.info(loc, method, (Object)"security.class_secStoreFS_1003", new Object[]{backupFilename}, "Backup file \"{0}\" deleted.");
        }
        catch (FileMissingException ex) {
            cat.error(loc, method, (Object)"security.class_secStoreFS_1004", new Object[]{backupFilename}, "Could not delete backup file \"{0}\", file does not exist any more.");
            throw ex;
        }
        catch (FileIOException ex) {
            cat.error(loc, method, (Object)"security.class_secStoreFS_1005", new Object[]{backupFilename}, "Could not delete backup file \"{0}\".");
            throw ex;
        }
    }

    public void migrateEncryptionKey(String newKeyPhrase, boolean storeKey) throws InvalidStateException, NoEncryptionException, NoKeyRequiredException, FileMissingException, FileIOException, FileInvalidException, NoHashException, NoSIDException {
        String backupKeyFilename;
        String method = "migrateEncryptionKey (java.lang.String, boolean)";
        if (!this.opened) {
            throw new InvalidStateException("security.class_secStoreFS_0015");
        }
        if (!this.crypt.isEncryptionPossible()) {
            throw new NoEncryptionException(this.crypt.getRootCause());
        }
        if (!this.crypt.isKeyRequired()) {
            throw new NoKeyRequiredException(this.crypt.getRootCause());
        }
        if (!this.encrypted) {
            throw new InvalidStateException("security.class_secStoreFS_0024");
        }
        this.sh.flush();
        String backupFilename = this.sh.createCopy();
        cat.info(loc, method, (Object)"security.class_secStoreFS_1000", new Object[]{this.filename, backupFilename}, "Secure Store file \"{0}\" backed up to \"{1}\".");
        if (this.crypt.isKeyRequired() && !this.crypt.isKeyDialogRequiredForThisInstance()) {
            backupKeyFilename = this.crypt.createKeyCopy();
            cat.info(loc, method, (Object)"security.class_secStoreFS_1001", new Object[]{backupKeyFilename}, "Key file of the Secure Store backed up to \"{0}\".");
        } else {
            backupKeyFilename = null;
            cat.info(loc, method, (Object)"security.class_secStoreFS_1007", "Key file of the Secure Store doesn't have to be backed up.");
        }
        Hashtable ht_old = this.sh.getPairs();
        Enumeration keys = ht_old.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(VERSION_KEY)) continue;
            byte[] byteValue = (byte[])ht_old.get(key);
            try {
                byteValue = this.crypt.decrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
            ht_old.put(key, byteValue);
        }
        if (this.crypt.isKeyDialogRequiredForThisInstance()) {
            if (storeKey) {
                this.crypt.setNewKeyInFile(newKeyPhrase, SW_VERSION);
            } else {
                this.crypt.setKeyForSession(newKeyPhrase);
            }
        } else if (storeKey) {
            this.crypt.updateKeyInFile(newKeyPhrase, SW_VERSION);
        } else {
            this.crypt.setKeyForSession(newKeyPhrase);
        }
        Enumeration keys2 = ht_old.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            if (key.equals(VERSION_KEY)) continue;
            byte[] byteValue = (byte[])ht_old.get(key);
            try {
                byteValue = this.crypt.encrypt(byteValue);
            }
            catch (NoEncryptionException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0026", (Throwable)((Object)ex));
            }
            try {
                this.sh.updatePair(key, byteValue);
            }
            catch (NotFoundException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0032", (Object)key, (Throwable)((Object)ex));
            }
            catch (ReservedKeyException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0029", (Object)key, (Throwable)((Object)ex));
            }
        }
        this.sh.flush();
        cat.info(loc, method, (Object)"security.class_secStoreFS_1002", "Migration of the Secure Store to new key phrase done.");
        FileMissingException toBeThrownFME = null;
        FileIOException toBeThrownFIOE = null;
        try {
            this.sh.deleteCopy(backupFilename);
            cat.info(loc, method, (Object)"security.class_secStoreFS_1003", new Object[]{backupFilename}, "Backup file \"{0}\" deleted.");
        }
        catch (FileMissingException ex) {
            cat.error(loc, method, (Object)"security.class_secStoreFS_1004", new Object[]{backupFilename}, "Could not delete backup file \"{0}\", file does not exist any more.");
            toBeThrownFME = ex;
        }
        catch (FileIOException ex) {
            cat.error(loc, method, (Object)"security.class_secStoreFS_1005", new Object[]{backupFilename}, "Could not delete backup file \"{0}\".");
            toBeThrownFIOE = ex;
        }
        if (backupKeyFilename != null) {
            try {
                this.crypt.deleteKeyCopy(backupKeyFilename);
                cat.info(loc, method, (Object)"security.class_secStoreFS_1003", new Object[]{backupKeyFilename}, "Backup file \"{0}\" deleted.");
            }
            catch (FileMissingException ex) {
                cat.error(loc, method, (Object)"security.class_secStoreFS_1004", new Object[]{backupKeyFilename}, "Could not delete backup file \"{0}\", file does not exist any more.");
                if (toBeThrownFME != null) {
                    throw toBeThrownFME;
                }
                if (toBeThrownFIOE != null) {
                    throw toBeThrownFIOE;
                }
                throw ex;
            }
            catch (FileIOException ex) {
                cat.error(loc, method, (Object)"security.class_secStoreFS_1005", new Object[]{backupKeyFilename}, "Could not delete backup file \"{0}\".");
                if (toBeThrownFME != null) {
                    throw toBeThrownFME;
                }
                if (toBeThrownFIOE != null) {
                    throw toBeThrownFIOE;
                }
                throw ex;
            }
            catch (NoKeyRequiredException ex) {
                cat.error(loc, method, (Object)"security.class_secStoreFS_1005", new Object[]{backupKeyFilename}, "Could not delete backup file \"{0}\".");
                if (toBeThrownFME != null) {
                    throw toBeThrownFME;
                }
                if (toBeThrownFIOE != null) {
                    throw toBeThrownFIOE;
                }
                throw ex;
            }
        }
    }

    public byte[] generateKey() throws SecStoreFSException {
        return this.crypt.generateKey();
    }

    public String encryptString(String stringToEncrypt, byte[] keyInBytes) throws SecStoreFSException {
        byte[] value = stringToEncrypt.getBytes();
        value = this.crypt.encryptByteArray(value, keyInBytes);
        String encryptedString = new String(Util.Base64Encode((byte[])value));
        return encryptedString;
    }

    public String decryptString(String stringToDecrypt, byte[] keyInBytes) throws SecStoreFSException {
        byte[] value = stringToDecrypt.getBytes();
        try {
            value = Util.Base64Decode((byte[])value);
            value = this.crypt.decryptByteArray(value, keyInBytes);
            String decryptedString = new String(value);
            return decryptedString;
        }
        catch (Base64Exception e) {
            throw new SecStoreFSException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.setResourceBundleName(BUNDLE_NAME);
        cat.setResourceBundleName(BUNDLE_NAME);
    }
}

