/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.secstorefs;

import com.sap.security.core.server.secstorefs.FileExistsException;
import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.FileMissingException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.NoHashException;
import com.sap.security.core.server.secstorefs.NoSIDException;
import com.sap.tc.logging.Location;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.provider.IAIK;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

class KeyHandler {
    private static final String PROP_FILENAME = "SAPKEYFILE";
    private static final String PROP_DEFAULT_DIR = "DIR_GLOBAL";
    private static final String DEFAULT_FILENAME = "SecStore.key";
    private static final int HASH_LENGTH = 20;
    private static final int BUFFER_SIZE = 100;
    private static final String BACKUP_PREFIX = "Copy";
    private static final String BACKUP_SUFFIX = ".bak";
    private static final char DELIMITER = '|';
    private static final byte BYTE_DELIMITER = 124;
    private static String defaultKeyFilename = null;
    private static String defaultKeyPhrase = null;
    private static String SID = null;
    private static Location loc = Location.getLocation((Class)(class$com$sap$security$core$server$secstorefs$KeyHandler == null ? (class$com$sap$security$core$server$secstorefs$KeyHandler = KeyHandler.class$("com.sap.security.core.server.secstorefs.KeyHandler")) : class$com$sap$security$core$server$secstorefs$KeyHandler));
    private boolean fileParametersLoaded = false;
    private String filename = null;
    private File file;
    private boolean fileExists;
    private boolean keyPhraseLoaded = false;
    private String keyPhrase;
    static /* synthetic */ Class class$com$sap$security$core$server$secstorefs$KeyHandler;

    static void setDefaultKeyFilename(String keyFilename) throws InvalidStateException {
        if (defaultKeyFilename != null && !defaultKeyFilename.equals(keyFilename)) {
            throw new InvalidStateException("security.class_secStoreFS_0045", (Object)defaultKeyFilename, keyFilename);
        }
        defaultKeyFilename = keyFilename;
    }

    static void setDefaultKeyPhrase(String keyPhrase) {
        defaultKeyPhrase = keyPhrase;
    }

    static void setSID(String SID) {
        KeyHandler.SID = SID;
    }

    private static String getFilename() {
        String method = "getFilename ()";
        if (defaultKeyFilename != null) {
            loc.infoT(method, "setDefaultKeyFilename () called, filename = \"" + defaultKeyFilename + "\".");
            return defaultKeyFilename;
        }
        String keyFile = System.getProperty(PROP_FILENAME);
        if (keyFile != null) {
            loc.infoT(method, "System property SAPKEYFILE set, filename = \"" + keyFile + "\".");
            return keyFile;
        }
        String directory = System.getProperty(PROP_DEFAULT_DIR);
        if (directory != null) {
            keyFile = directory + File.separatorChar + DEFAULT_FILENAME;
            loc.infoT(method, "System property DIR_GLOBAL set, filename = \"" + keyFile + "\".");
            return keyFile;
        }
        keyFile = DEFAULT_FILENAME;
        loc.infoT(method, "setDefaultKeyFilename () not called, system properties SAPKEYFILE and DIR_GLOBAL not found, filename = \"" + keyFile + "\".");
        return keyFile;
    }

    KeyHandler() {
    }

    void setKeyFilename(String keyFilename) {
        this.filename = keyFilename;
        loc.infoT("setKeyFilename (String)", "setKeyFilename () called, filename = \"" + keyFilename + "\".");
    }

    private void fillFileParameters() {
        if (this.fileParametersLoaded) {
            return;
        }
        if (this.filename == null) {
            this.filename = KeyHandler.getFilename();
        }
        this.file = new File(this.filename);
        this.fileExists = this.file.exists();
        this.fileParametersLoaded = true;
    }

    boolean isKeyDialogRequiredForThisInstance() {
        this.fillFileParameters();
        return !this.fileExists;
    }

    private byte[] xor(byte[] array) throws NoHashException {
        byte[] hash = new byte[]{43, -74, -113, -6, -106, -20, -74, 16, 36, 71, -110, 101, 23, -80, 9, -60, 62, 10, -41, -67};
        int restLength = array.length;
        int indexArray = 0;
        while (restLength > 0) {
            int thisRound = restLength >= 20 ? 20 : restLength;
            int indexHash = 0;
            while (thisRound > 0) {
                int n = indexArray++;
                array[n] = (byte)(array[n] ^ hash[indexHash]);
                ++indexHash;
                --thisRound;
                --restLength;
            }
            if (restLength <= 0) continue;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new NoHashException(ex);
            }
            hash = md.digest(hash);
        }
        return array;
    }

    private byte[] encryptKey(String plaintext) throws InvalidStateException, NoHashException {
        byte[] byteKey = null;
        try {
            byteKey = plaintext.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        byte[] result = this.xor(byteKey);
        return result;
    }

    private String decryptKey(byte[] ciphertext) throws InvalidStateException, NoHashException {
        byte[] plaintext = this.xor(ciphertext);
        String keyPhrase = null;
        try {
            keyPhrase = new String(plaintext, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0017", ex);
        }
        return keyPhrase;
    }

    void setKeyForSession(String keyPhrase) {
        this.keyPhraseLoaded = true;
        this.keyPhrase = keyPhrase;
    }

    private void writeKeyIntoFile(String keyPhrase, String fileFormatVersion) throws FileIOException, InvalidStateException, NoHashException {
        byte[] version = null;
        try {
            version = fileFormatVersion.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidStateException("security.class_secStoreFS_0016", ex);
        }
        byte[] ciphertext = this.encryptKey(keyPhrase);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
            out.write(version);
            out.write(124);
            out.write(ciphertext);
            out.close();
        }
        catch (IOException ex) {
            throw new FileIOException(this.filename, ex);
        }
        this.keyPhraseLoaded = true;
        this.keyPhrase = keyPhrase;
    }

    void setNewKeyInFile(String keyPhrase, String fileFormatVersion) throws FileExistsException, FileIOException, InvalidStateException, NoHashException {
        this.fillFileParameters();
        if (this.fileExists) {
            throw new FileExistsException(this.filename);
        }
        this.writeKeyIntoFile(keyPhrase, fileFormatVersion);
    }

    void updateKeyInFile(String keyPhrase, String fileFormatVersion) throws FileMissingException, FileIOException, InvalidStateException, NoHashException {
        this.fillFileParameters();
        if (!this.fileExists) {
            throw new FileMissingException(this.filename);
        }
        this.writeKeyIntoFile(keyPhrase, fileFormatVersion);
    }

    private void loadKeyFromFile() throws FileMissingException, FileIOException, FileInvalidException, InvalidStateException, NoHashException {
        this.fillFileParameters();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.filename));
            Vector<byte[]> v = new Vector<byte[]>();
            int totalLength = 0;
            while (true) {
                byte[] block = new byte[100];
                int index = 0;
                while (index < 100) {
                    int rc = in.read();
                    if (rc == -1) break;
                    block[index] = (byte)rc;
                    ++index;
                }
                if (index == 0) break;
                if (index < 100) {
                    byte[] lastBlock = new byte[index];
                    System.arraycopy(block, 0, lastBlock, 0, index);
                    v.add(lastBlock);
                    totalLength += index;
                    break;
                }
                v.add(block);
                totalLength += 100;
            }
            in.close();
            byte[] bytes = new byte[totalLength];
            int offset = 0;
            Iterator iter = ((AbstractList)v).iterator();
            while (iter.hasNext()) {
                byte[] block = (byte[])iter.next();
                System.arraycopy(block, 0, bytes, offset, block.length);
                offset += block.length;
            }
            int delimIndex = 0;
            while (delimIndex < totalLength) {
                if (bytes[delimIndex] == 124) break;
                ++delimIndex;
            }
            if (delimIndex >= totalLength) {
                throw new FileInvalidException("security.class_secStoreFS_0043", this.filename);
            }
            int lengthVersion = delimIndex;
            try {
                String version = new String(bytes, 0, lengthVersion, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new InvalidStateException("security.class_secStoreFS_0017", ex);
            }
            int lengthKey = totalLength - delimIndex - 1;
            byte[] byteKey = new byte[lengthKey];
            int toIndex = 0;
            int fromIndex = delimIndex + 1;
            while (fromIndex < totalLength) {
                byteKey[toIndex] = bytes[fromIndex];
                ++toIndex;
                ++fromIndex;
            }
            this.keyPhrase = this.decryptKey(byteKey);
        }
        catch (FileNotFoundException ex) {
            throw new FileMissingException(this.filename);
        }
        catch (IOException ex) {
            throw new FileIOException(this.filename, ex);
        }
        if (this.keyPhrase == null) {
            throw new FileInvalidException("security.class_secStoreFS_0018", this.filename);
        }
        this.keyPhraseLoaded = true;
    }

    private PBEKeyBMP computeEffectiveKey(String keyPhrase) throws NoSIDException {
        if (SID == null && (SID = System.getProperty("SAPSYSTEMNAME")) == null) {
            throw new NoSIDException();
        }
        String rawKey = keyPhrase + SID;
        PBEKeyBMP effectiveKey = new PBEKeyBMP(rawKey);
        return effectiveKey;
    }

    PBEKeyBMP getEffectiveKey() throws FileMissingException, FileIOException, FileInvalidException, NoSIDException, InvalidStateException, NoHashException {
        if (!this.keyPhraseLoaded) {
            if (this.filename != null) {
                this.loadKeyFromFile();
            } else if (defaultKeyPhrase != null) {
                this.keyPhrase = defaultKeyPhrase;
                this.keyPhraseLoaded = true;
            } else {
                this.loadKeyFromFile();
            }
        }
        return this.computeEffectiveKey(this.keyPhrase);
    }

    void deleteKeyFile() throws FileMissingException, FileIOException {
        this.fillFileParameters();
        if (!this.fileExists) {
            throw new FileMissingException(this.filename);
        }
        try {
            boolean deleted = this.file.delete();
            if (!deleted) {
                throw new FileIOException("security.class_secStoreFS_0012", this.filename);
            }
        }
        catch (SecurityException ex) {
            throw new FileIOException(this.filename, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String createKeyCopy() throws FileIOException {
        File backupFile = null;
        byte[] buffer = new byte[100];
        FileInputStream fis = null;
        boolean fisOpen = false;
        FileOutputStream fos = null;
        boolean fosOpen = false;
        this.fillFileParameters();
        try {
            try {
                String directoryString = this.file.getParent();
                if (directoryString == null) {
                    directoryString = ".";
                }
                File directory = new File(directoryString);
                backupFile = File.createTempFile(BACKUP_PREFIX, BACKUP_SUFFIX, directory);
                fis = new FileInputStream(this.file);
                fisOpen = true;
                fos = new FileOutputStream(backupFile);
                fosOpen = true;
                int byteCount = fis.read(buffer);
                while (byteCount > 0) {
                    fos.write(buffer, 0, byteCount);
                    byteCount = fis.read(buffer);
                }
            }
            catch (IOException ex) {
                throw new FileIOException(this.filename, ex);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (fosOpen) {
                    fos.close();
                }
                if (!fisOpen) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new FileIOException(this.filename, ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new FileIOException(this.filename, ex);
        }
        if (fosOpen) {
            fos.close();
        }
        if (!fisOpen) return backupFile.getPath();
        fis.close();
        return backupFile.getPath();
    }

    void deleteKeyCopy(String filename) throws FileMissingException, FileIOException {
        this.fillFileParameters();
        File backupFile = new File(filename);
        if (!backupFile.exists()) {
            throw new FileMissingException(filename);
        }
        try {
            boolean deleted = backupFile.delete();
            if (!deleted) {
                throw new FileIOException("security.class_secStoreFS_0012", filename);
            }
        }
        catch (SecurityException ex) {
            throw new FileIOException(filename, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IAIK.addAsJDK14Provider();
    }
}

