/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.krn.perf;

import com.sap.bc.krn.perf.PerfException;
import com.sap.bc.krn.perf.PerfSync;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class PerfTimes
extends Thread {
    static int PerfTimesVersion = 3;
    private static boolean InitDone = false;
    static String macAddress = null;
    private int RequiredNativeLibVersion = PerfTimesVersion;
    private int NativeLibVersion;
    private int NativeLibSystemId;
    private int NativeLibBitsize;
    private int NativeLibUnicode;
    private int NativeLibVersionDate;
    private int NativeLibReleaseNo;
    private int NativeLibThreads;
    private int NativeLibStartTime;

    private void internal_TRC(String string) {
    }

    private void TRC(String string) {
    }

    private void TRC1(String string) {
    }

    private void TRC3(String string) {
    }

    private void TRCERR(String string) {
        this.internal_TRC(string);
    }

    private void loadNativeLayer(String string) {
        if (!InitDone) {
            String string2 = System.getProperty("java.library.path");
            System.loadLibrary("jperflib");
            PerfTimes.init();
            InitDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfTimes() {
        Object object = PerfSync.o;
        synchronized (object) {
            this.loadNativeLayer("PerfTimes()");
            this.checkNativeLayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfTimes(boolean bl) {
        Object object = PerfSync.o;
        synchronized (object) {
            if (!bl) {
                this.loadNativeLayer("PerfTimes(NoNative=false)");
                this.checkNativeLayer();
            }
        }
    }

    private void tell2ndAttempt(String string, String string2) {
        System.out.println("*************************************************************");
        System.out.println("**                                                         **");
        System.out.println("** getMacAddress() failed with " + string);
        System.out.println("**                                                         **");
        System.out.println("** trying a 2nd attempt with " + string2);
        System.out.println("**                                                         **");
        System.out.println("*************************************************************");
    }

    private void tell2ndAttemptSuccessful(String string) {
        System.out.println("*************************************************************");
        System.out.println("**                                                         **");
        System.out.println("** successful 2nd attempt, got mac address with " + string);
        System.out.println("**                                                         **");
        System.out.println("*************************************************************");
    }

    public String getMacAddress() throws IOException {
        return this.getMacAddress(null, null);
    }

    public String getMacAddress(String string, String string2) throws IOException {
        block45: {
            if (macAddress == null) {
                File file = new File("MAC_ADDRESS");
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                string3 = string == null ? System.getProperty("os.name") : string;
                string5 = string2;
                try {
                    if (string3.startsWith("Windows")) {
                        if (string2 == null) {
                            string5 = "ipconfig /all";
                        }
                        macAddress = this.windowsParseMacAddress(this.RunIfConfigCommand(string5));
                        break block45;
                    }
                    if (string3.startsWith("Linux")) {
                        if (string2 == null) {
                            string4 = "/sbin/";
                            string5 = string4 + "ifconfig";
                            string6 = "ifconfig";
                            try {
                                macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                this.tell2ndAttempt(string5, string6);
                                macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string6));
                                this.tell2ndAttemptSuccessful(string6);
                            }
                        } else {
                            macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string5));
                        }
                        break block45;
                    }
                    if (string3.startsWith("OSF1")) {
                        if (string2 == null) {
                            string4 = "/usr/sbin/";
                            string5 = string4 + "netstat -i";
                            string6 = "netstat -i";
                            try {
                                macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                this.tell2ndAttempt(string5, string6);
                                macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string6));
                                this.tell2ndAttemptSuccessful(string6);
                            }
                        } else {
                            macAddress = this.linuxParseMacAddress(this.RunIfConfigCommand(string5));
                        }
                        break block45;
                    }
                    if (string3.startsWith("HP-UX")) {
                        if (string2 == null) {
                            string4 = "/usr/sbin/";
                            string5 = string4 + "lanscan -a";
                            string6 = "lanscan -a";
                            try {
                                macAddress = this.hpuxParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                this.tell2ndAttempt(string5, string6);
                                macAddress = this.hpuxParseMacAddress(this.RunIfConfigCommand(string6));
                                this.tell2ndAttemptSuccessful(string6);
                            }
                        } else {
                            macAddress = this.hpuxParseMacAddress(this.RunIfConfigCommand(string5));
                        }
                        break block45;
                    }
                    if (string3.startsWith("SunOS")) {
                        if (string2 == null) {
                            string4 = "/usr/sbin/";
                            string5 = string4 + "arp " + InetAddress.getLocalHost().getHostName();
                            string6 = "arp " + InetAddress.getLocalHost().getHostName();
                            try {
                                macAddress = this.sunParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                try {
                                    this.tell2ndAttempt(string5, string6);
                                    macAddress = this.sunParseMacAddress(this.RunIfConfigCommand(string6));
                                    this.tell2ndAttemptSuccessful(string6);
                                    break block45;
                                }
                                catch (ParseException parseException2) {
                                    string5 = string6;
                                    string6 = "arp -a";
                                    try {
                                        this.tell2ndAttempt(string5, string6);
                                        macAddress = this.sunParseMacAddress(this.RunIfConfigCommand(string6));
                                        this.tell2ndAttemptSuccessful(string6);
                                        break block45;
                                    }
                                    catch (ParseException parseException3) {
                                        string5 = string6;
                                        string6 = string4 + "arp -a";
                                        this.tell2ndAttempt(string5, string6);
                                        macAddress = this.sunParseMacAddress(this.RunIfConfigCommand(string6));
                                        this.tell2ndAttemptSuccessful(string6);
                                    }
                                }
                            }
                            break block45;
                        }
                        macAddress = this.sunParseMacAddress(this.RunIfConfigCommand(string5));
                        break block45;
                    }
                    if (string3.startsWith("AIX")) {
                        if (string2 == null) {
                            string4 = "/bin/";
                            string5 = "netstat -i";
                            string6 = string4 + "netstat -i";
                            try {
                                macAddress = this.aixParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                this.tell2ndAttempt(string5, string6);
                                macAddress = this.aixParseMacAddress(this.RunIfConfigCommand(string6));
                                this.tell2ndAttemptSuccessful(string6);
                            }
                        } else {
                            macAddress = this.aixParseMacAddress(this.RunIfConfigCommand(string5));
                        }
                        break block45;
                    }
                    if (string3.startsWith("OS/400")) {
                        if (string2 == null) {
                            string5 = "SAPIPCFG";
                        }
                        macAddress = this.os400ParseMacAddress(this.RunIfConfigCommand(string5));
                        break block45;
                    }
                    if (string3.startsWith("z/OS")) {
                        if (string2 == null) {
                            string4 = "/usr/lpp/tcpip/bin/";
                            string5 = "onetstat -R " + InetAddress.getLocalHost().getHostAddress();
                            string6 = string4 + "onetstat -R " + InetAddress.getLocalHost().getHostAddress();
                            try {
                                macAddress = this.os390ParseMacAddress(this.RunIfConfigCommand(string5));
                            }
                            catch (ParseException parseException) {
                                this.tell2ndAttempt(string5, string6);
                                macAddress = this.os390ParseMacAddress(this.RunIfConfigCommand(string6));
                                this.tell2ndAttemptSuccessful(string6);
                            }
                        } else {
                            macAddress = this.os390ParseMacAddress(this.RunIfConfigCommand(string5));
                        }
                        break block45;
                    }
                    if (string2 == null) {
                        string5 = "cat " + file;
                    }
                    try {
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** getMacAddress()  for this platform not implemented yet  **");
                        System.out.println("**                                                         **");
                        System.out.println("** trying to get mac address from                          **");
                        System.out.println("** file " + file.getAbsolutePath());
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                        macAddress = this.voidParseMacAddress(this.RunIfConfigCommand(string5));
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** successful, got mac address from                        **");
                        System.out.println("** file " + file.getAbsolutePath());
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                    }
                    catch (ParseException parseException) {
                        macAddress = "not_impl_yet";
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** Suggested workaround:                                   **");
                        System.out.println("**                                                         **");
                        System.out.println("** create a file " + file.getAbsolutePath());
                        System.out.println("** with hostname and mac address in the following format:  **");
                        System.out.println("** <hostname> xx:xx:xx:xx:xx:xx                            **");
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                        macAddress = "not_impl_yet";
                        throw new IOException("unknown operating system: " + string3);
                    }
                }
                catch (ParseException parseException) {
                    string5 = "cat " + file;
                    try {
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** getMacAddress() failed                                  **");
                        System.out.println("**                                                         **");
                        System.out.println("** trying to get mac address from                          **");
                        System.out.println("** file " + file.getAbsolutePath());
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                        macAddress = this.voidParseMacAddress(this.RunIfConfigCommand(string5));
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** successful, got mac address from                        **");
                        System.out.println("** file " + file.getAbsolutePath());
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                        return macAddress;
                    }
                    catch (ParseException parseException4) {
                        System.out.println("*************************************************************");
                        System.out.println("**                                                         **");
                        System.out.println("** Suggested workaround:                                   **");
                        System.out.println("**                                                         **");
                        System.out.println("** create file " + file.getAbsolutePath());
                        System.out.println("** with hostname and mac address in the following format:  **");
                        System.out.println("** <hostname> xx:xx:xx:xx:xx:xx                            **");
                        System.out.println("**                                                         **");
                        System.out.println("*************************************************************");
                        macAddress = "mac_adr_fail";
                        parseException.printStackTrace();
                        throw new IOException(parseException.getMessage());
                    }
                }
            }
        }
        return macAddress;
    }

    private String condenseMacAddress(String string) {
        String string2 = "";
        for (int i = 0; i < 6; ++i) {
            string2 = string2 + string.substring(i * 3, i * 3 + 2);
        }
        string2 = string2.toUpperCase();
        return string2;
    }

    private boolean isHex(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private String extractMacAddress(String string, char c) {
        String string2 = string.toUpperCase();
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (string2.length() >= 11) {
            string3 = null;
            int n = string2.indexOf(c);
            int n2 = string2.indexOf(c, n + 1);
            int n3 = string2.indexOf(c, n2 + 1);
            int n4 = string2.indexOf(c, n3 + 1);
            int n5 = string2.indexOf(c, n4 + 1);
            if (bl) {
                System.out.println("line: " + string2 + " length:" + string2.length());
                System.out.println("Colon1: " + n + " Colon2: " + n2 + " Colon3: " + n3 + " Colon4: " + n4 + " Colon5: " + n5);
            }
            if (n < 0) {
                return null;
            }
            if (n >= 1 && n2 >= n + 2 && n2 <= n + 3 && n3 >= n2 + 2 && n3 <= n2 + 3 && n4 >= n3 + 2 && n4 <= n3 + 3 && n5 >= n4 + 2 && n5 <= n4 + 3) {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                string4 = n == 1 || !this.isHex(string2.charAt(n - 2)) ? string2.substring(n - 1, n) : string2.substring(n - 2, n);
                if (bl) {
                    System.out.println(" A0: <" + string4 + ">");
                }
                string5 = string2.substring(n + 1, n2);
                if (bl) {
                    System.out.println(" A1: <" + string5 + ">");
                }
                string6 = string2.substring(n2 + 1, n3);
                if (bl) {
                    System.out.println(" A2: <" + string6 + ">");
                }
                string7 = string2.substring(n3 + 1, n4);
                if (bl) {
                    System.out.println(" A3: <" + string7 + ">");
                }
                string8 = string2.substring(n4 + 1, n5);
                if (bl) {
                    System.out.println(" A4: <" + string8 + ">");
                }
                if (string2.length() >= n5 + 3 && this.isHex(string2.charAt(n5 + 2))) {
                    string9 = string2.substring(n5 + 1, n5 + 3);
                } else if (string2.length() >= n5 + 2) {
                    string9 = string2.substring(n5 + 1, n5 + 2);
                }
                if (bl) {
                    System.out.println(" A5: <" + string9 + ">");
                }
                if (string4.length() == 2) {
                    string3 = string4;
                } else if (string4.length() == 1) {
                    string3 = "0" + string4;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                if (string5.length() == 2) {
                    string3 = string3 + string5;
                } else if (string5.length() == 1) {
                    string3 = string3 + "0" + string5;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                if (string6.length() == 2) {
                    string3 = string3 + string6;
                } else if (string6.length() == 1) {
                    string3 = string3 + "0" + string6;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                if (string7.length() == 2) {
                    string3 = string3 + string7;
                } else if (string7.length() == 1) {
                    string3 = string3 + "0" + string7;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                if (string8.length() == 2) {
                    string3 = string3 + string8;
                } else if (string8.length() == 1) {
                    string3 = string3 + "0" + string8;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                if (string9.length() == 2) {
                    string3 = string3 + string9;
                } else if (string9.length() == 1) {
                    string3 = string3 + "0" + string9;
                }
                if (bl) {
                    System.out.println(" MacAdr: <" + string3 + ">");
                }
                int n6 = 0;
                for (int i = 0; i < 12; ++i) {
                    if (this.isHex(string3.charAt(i))) continue;
                    if (bl) {
                        System.out.println("macAdrInvalid: " + n6);
                    }
                    n6 = 1;
                }
                if (n6 == 0) {
                    return string3;
                }
            }
            string2 = string2.substring(n + 1);
        }
        return string3;
    }

    private String RunIfConfigCommand(String string) throws IOException {
        int n;
        Process process = Runtime.getRuntime().exec(string);
        if (System.getProperty("os.name").startsWith("OS/400")) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "Cp500"));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            return string2;
        }
        if (System.getProperty("os.name").startsWith("z/OS")) {
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "Cp500"));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            String string3 = stringBuffer.toString();
            bufferedReader.close();
            return string3;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            stringBuffer.append((char)n);
        }
        String string4 = stringBuffer.toString();
        ((InputStream)bufferedInputStream).close();
        return string4;
    }

    private String linuxParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl;
            object = stringTokenizer.nextToken().trim();
            boolean bl2 = bl = ((String)object).indexOf(string2) >= 0;
            if (bl && string5 != null) {
                return string5;
            }
            string3 = this.extractMacAddress((String)object, ':');
            if (string3 != null) {
                string5 = string3;
            }
            if (string4 != null) continue;
            string4 = string5;
        }
        if (string4 != null) {
            return string4;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String osf1ParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl;
            object = stringTokenizer.nextToken().trim();
            boolean bl2 = bl = ((String)object).indexOf(string2) >= 0;
            if (bl && string4 != null) {
                return string4;
            }
            string3 = this.extractMacAddress((String)object, ':');
            if (string3 != null) {
                string4 = string3;
            }
            if (string5 != null) continue;
            string5 = string4;
        }
        if (string5 != null) {
            return string5;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String sunParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            boolean bl = ((String)object).indexOf(string2) >= 0;
            string3 = this.extractMacAddress((String)object, ':');
            if (!bl || string3 == null) continue;
            return string3;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String aixParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            string3 = this.extractMacAddress((String)object, '.');
            if (string3 == null) continue;
            return string3;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String hpuxParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            object = stringTokenizer.nextToken().trim();
            String string4 = ((String)object).substring((n = ((String)object).indexOf("0x")) + 2).trim();
            if (!this.hpuxIsMacAddress(string4)) continue;
            string3 = string4;
            return string3;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private boolean hpuxIsMacAddress(String string) {
        return string.length() == 12;
    }

    private String windowsParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).endsWith(string2) && string5 != null) {
                return string5;
            }
            string3 = this.extractMacAddress((String)object, '-');
            if (string3 != null) {
                string5 = string3;
            }
            if (string4 != null) continue;
            string4 = string5;
        }
        if (string4 != null) {
            return string4;
        }
        object = new ParseException("cannot read MAC address from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String os400ParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            string3 = this.extractMacAddress((String)object, ':');
            if (string3 == null) continue;
            return string3;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private String os390ParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            object = stringTokenizer.nextToken().trim();
            String string4 = ((String)object).substring((n = ((String)object).indexOf("ETHERNET: ")) + 10).trim();
            if (!this.os390IsMacAddress(string4)) continue;
            string3 = string4;
            return string3;
        }
        object = new ParseException("cannot read MAC address from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private boolean os390IsMacAddress(String string) {
        return string.length() == 12;
    }

    private String voidParseMacAddress(String string) throws ParseException {
        Object object;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new ParseException(unknownHostException.getMessage(), 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            boolean bl = ((String)object).indexOf(string2) >= 0;
            string3 = this.extractMacAddress((String)object, ':');
            if (!bl || string3 == null) continue;
            return string3;
        }
        object = new ParseException("cannot read MAC address for " + string2 + " from [" + string + "]", 0);
        ((Throwable)object).printStackTrace();
        throw object;
    }

    private native int nativeInfo(int var1);

    private static native int init();

    public native long getStampUs();

    public native long getDeltaUs(long var1);

    public native long getDelta2Us(long var1, long var3);

    public native long elapsed();

    public native long cpuTimeUs();

    public native boolean cpuTimePerThread();

    public int getTechInfo(int n) {
        int n2 = this.nativeInfo(n);
        return n2;
    }

    public int checkNativeLayer() throws UnsatisfiedLinkError {
        String string = "checkNativeLayer";
        for (int i = 0; i < 10; ++i) {
            int n = this.getTechInfo(i);
            if (n == -1) continue;
            this.TRC3(string + ": infoType = " + i + " info = " + n);
            switch (i) {
                case 0: {
                    this.NativeLibVersion = n;
                }
                case 1: {
                    this.NativeLibSystemId = n;
                }
                case 2: {
                    this.NativeLibBitsize = n;
                }
                case 3: {
                    this.NativeLibUnicode = n;
                }
                case 4: {
                    this.NativeLibVersionDate = n;
                }
                case 5: {
                    this.NativeLibReleaseNo = n;
                }
                case 6: {
                    this.NativeLibThreads = n;
                }
                case 7: {
                    this.NativeLibStartTime = n;
                }
            }
        }
        if (this.NativeLibVersion != this.RequiredNativeLibVersion) {
            this.TRCERR(string + ": incompatible jperflib version");
            this.TRCERR(string + ": NativeLibVersion         = " + this.NativeLibVersion);
            this.TRCERR(string + ": RequiredNativeLibVersion = " + this.RequiredNativeLibVersion);
            this.TRC1("NativeLibVersion     = " + this.NativeLibVersion);
            this.TRC1("NativeLibSystemId    = " + this.NativeLibSystemId);
            this.TRC1("NativeLibBitsize     = " + this.NativeLibBitsize);
            this.TRC1("NativeLibUnicode     = " + this.NativeLibUnicode);
            this.TRC1("NativeLibVersionDate = " + this.NativeLibVersionDate);
            this.TRC1("NativeLibReleaseNo   = " + this.NativeLibReleaseNo);
            this.TRC1("NativeLibThreads     = " + this.NativeLibThreads);
            this.TRC1("NativeLibStartTime   = " + this.NativeLibStartTime);
            this.TRCERR(string + ": throw PerfException: incompatible jperflib version");
            throw new UnsatisfiedLinkError("Perf Exception: incompatible jperflib version. loaded " + this.NativeLibVersion + " required " + this.RequiredNativeLibVersion);
        }
        return 0;
    }

    public String[] getNativeVersionText() throws PerfException {
        String string = "getNativeVersion";
        this.checkNativeLayer();
        String[] stringArray = new String[15];
        stringArray[0] = this.NativeLibVersion == this.RequiredNativeLibVersion ? "Native Lib Version Check = OK" : "Native Lib Version Check = FAILED";
        stringArray[1] = "RequiredNativeLibVersion = " + this.RequiredNativeLibVersion;
        stringArray[2] = "NativeLibVersion         = " + this.NativeLibVersion;
        stringArray[3] = "NativeLibSystemId        = " + this.NativeLibSystemId;
        stringArray[4] = "NativeLibBitsize         = " + this.NativeLibBitsize;
        stringArray[5] = "NativeLibUnicode         = " + this.NativeLibUnicode;
        stringArray[6] = "NativeLibVersionDate     = " + this.NativeLibVersionDate;
        stringArray[7] = "NativeLibReleaseNo       = " + this.NativeLibReleaseNo;
        stringArray[8] = "NativeLibThreads         = " + this.NativeLibThreads;
        stringArray[9] = "NativeLibStartTime       = " + this.NativeLibStartTime;
        return stringArray;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        System.out.println("PerfTimes Version: " + PerfTimesVersion);
        if (stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("-version") == 0) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].compareTo("-time") == 0) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].compareTo("-mac") == 0) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].compareTo("-all") == 0) {
                bl = true;
                continue;
            }
            if (stringArray[i].compareTo("-nonative") == 0) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].compareTo("-help") == 0) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].compareTo("-experthelp") == 0) {
                bl7 = true;
                continue;
            }
            if (stringArray[i].compareTo("-test") == 0) {
                bl8 = true;
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].compareTo("-macsys") == 0) {
                if (i > stringArray.length || stringArray[i + 1].charAt(0) == '-') continue;
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].compareTo("-maccmd") == 0) {
                if (i > stringArray.length || stringArray[i + 1].charAt(0) == '-') continue;
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            bl = true;
        }
        if (bl6) {
            System.out.println("PerfTimes - high precision usec time measurement");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("-time      check time measurement methods");
            System.out.println("-mac       get MAC address");
            System.out.println("-all       check all functions");
            System.out.println("-nonative  stop before loading native lib");
            System.out.println("-help      print this help text");
        }
        if (bl7) {
            System.out.println("- testmac <string>  test mac address parsing for <string>");
            System.out.println("- macsys  <os>      test mac address for <os> = [Windows, AIX, ...]");
            System.out.println("- maccmd  <cmd>     test mac address cor command <cmd> = [ipconfig, cat <file>, ...] ");
            System.out.println("- experthelp        print this help text");
        }
        try {
            PerfTimes perfTimes = new PerfTimes(true);
            if (bl8) {
                System.out.println("extractMacAddress(" + string3 + ") : " + " sep ':' <" + perfTimes.extractMacAddress(string3, ':') + ">" + "  sep '-' <" + perfTimes.extractMacAddress(string3, '-') + ">");
                System.exit(0);
            }
            if (bl3 || bl) {
                try {
                    System.out.println();
                    System.out.println("Network info, native lib not loaded");
                    System.out.println("  Operating System: " + System.getProperty("os.name"));
                    System.out.println("  Hostname........: " + InetAddress.getLocalHost().getHostName());
                    System.out.println("  IP-Address......: " + InetAddress.getLocalHost().getHostAddress());
                    System.out.println("  MAC Address.....: " + perfTimes.getMacAddress(string, string2));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (bl5) {
                System.exit(0);
            }
            perfTimes = new PerfTimes();
            if (bl || bl2) {
                String[] stringArray2 = perfTimes.getNativeVersionText();
                System.out.println();
                System.out.println("PerfTimes: Check Native Lib");
                System.out.println();
                for (int i = 0; i < stringArray2.length && stringArray2[i] != null; ++i) {
                    System.out.println(stringArray2[i]);
                }
            }
            if (bl4 || bl) {
                int n;
                int n2;
                int n3;
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                System.out.println();
                System.out.println("Time measurement: Overhead");
                System.out.println();
                l = perfTimes.getStampUs();
                l2 = perfTimes.getDeltaUs(l);
                System.out.println("getStampUs, getDeltaUs     : " + l2 + "us");
                l = perfTimes.getStampUs();
                l2 = perfTimes.getDeltaUs(l);
                System.out.println("getStampUs, getDeltaUs     : " + l2 + "us");
                l = perfTimes.getStampUs();
                l2 = perfTimes.getStampUs();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("getStampUs 2x, getDelta2Us : " + l3 + "us");
                l = perfTimes.getStampUs();
                l2 = perfTimes.getStampUs();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("getStampUs 2x, getDelta2Us : " + l3 + "us");
                l = perfTimes.elapsed();
                l2 = perfTimes.elapsed();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("elapsed 2x, getDelta2Us    : " + l3 + "us");
                l = perfTimes.elapsed();
                l2 = perfTimes.elapsed();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("elapsed 2x, getDelta2Us    : " + l3 + "us");
                l = perfTimes.cpuTimeUs();
                l2 = perfTimes.cpuTimeUs();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("cpu 2x, getDelta2Us        : " + l3 + "us");
                l = perfTimes.elapsed();
                l3 = System.currentTimeMillis();
                l2 = perfTimes.elapsed();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("System.currentTimeMillis() : " + l3 + "us (elapsed())");
                l = perfTimes.elapsed();
                l3 = System.currentTimeMillis();
                l2 = perfTimes.elapsed();
                l3 = perfTimes.getDelta2Us(l, l2);
                System.out.println("System.currentTimeMillis() : " + l3 + "us (elapsed())");
                l = perfTimes.getStampUs();
                l3 = System.currentTimeMillis();
                l2 = perfTimes.getDeltaUs(l);
                System.out.println("System.currentTimeMillis() : " + l2 + "us (getStampUs())");
                System.out.println("");
                System.out.println("Time accuracy: polling time for 100ms");
                System.out.println("");
                l3 = System.currentTimeMillis() / 100L;
                while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    l3 = System.currentTimeMillis() / 100L;
                    while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                    }
                    l = perfTimes.getStampUs();
                    while (System.currentTimeMillis() / 100L == l4) {
                    }
                    l2 = perfTimes.getDeltaUs(l);
                    l4 = l2 - 100000L;
                    System.out.println("100 milliseconds, getStampUs : " + l2 + "us" + " (difference " + l4 + "us)");
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    l3 = System.currentTimeMillis() / 100L;
                    while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                    }
                    l = perfTimes.elapsed();
                    while (System.currentTimeMillis() / 100L == l4) {
                    }
                    l2 = perfTimes.elapsed();
                    l3 = perfTimes.getDelta2Us(l, l2);
                    l4 = l3 - 100000L;
                    System.out.println("100 milliseconds, elapsed    : " + l3 + "us" + " (difference " + l4 + "us)");
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    l3 = System.currentTimeMillis() / 100L;
                    while ((l4 = System.currentTimeMillis() / 100L) == l3) {
                    }
                    l = perfTimes.cpuTimeUs();
                    while (System.currentTimeMillis() / 100L == l4) {
                    }
                    l2 = perfTimes.cpuTimeUs();
                    l4 = l3 = l2 - l;
                    System.out.println("100 milliseconds, cpu        : " + l3 + "us" + " (difference " + l4 + "us)");
                }
                System.out.println("");
                if (perfTimes.cpuTimePerThread()) {
                    System.out.println("Platform provides CPU time per thread");
                } else {
                    System.out.println("Platform provides CPU time per process");
                }
                System.out.println("");
                l = perfTimes.cpuTimeUs();
                while (perfTimes.cpuTimeUs() == l) {
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    l = perfTimes.cpuTimeUs();
                    while (perfTimes.cpuTimeUs() == l) {
                    }
                    l2 = perfTimes.cpuTimeUs();
                    l3 = l2 - l;
                    System.out.println("cpu time granularity         : abs = " + l2 + "us (difference " + l3 + "us)");
                }
                System.out.println("");
                Thread[] threadArray = new Thread[8];
                l = System.currentTimeMillis() / 1000L;
                while (System.currentTimeMillis() / 1000L == l) {
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    l = System.currentTimeMillis() / 1000L;
                    l3 = perfTimes.cpuTimeUs();
                    while (System.currentTimeMillis() / 1000L == l) {
                    }
                    l4 = perfTimes.cpuTimeUs();
                    l = l4 - l3;
                    System.out.println("cpu time consumed in 1 s     : " + l + "us.  Nr of busy parallel threads : " + n2);
                    threadArray[n2] = new PerfTimes();
                    threadArray[n2].start();
                }
                n2 = 1;
                while (n2 != 0) {
                    n2 = 0;
                    for (n = 0; n < 8; ++n) {
                        if (threadArray[n] == null || !threadArray[n].isAlive()) continue;
                        n2 = 1;
                    }
                    PerfTimes.sleep(100L);
                }
                System.out.println("");
                System.out.println("Time accuracy: sleep(100ms)");
                System.out.println("");
                for (n = 0; n < 3; ++n) {
                    l = perfTimes.getStampUs();
                    Thread.sleep(100L);
                    l2 = perfTimes.getDeltaUs(l);
                    l3 = l2 - 100000L;
                    System.out.println("Thread.sleep(100), getStampUs : " + l2 + "us" + " (difference " + l3 + "us)");
                }
                for (n = 0; n < 3; ++n) {
                    l = perfTimes.elapsed();
                    Thread.sleep(100L);
                    l2 = perfTimes.elapsed();
                    l3 = perfTimes.getDelta2Us(l, l2);
                    l4 = l3 - 100000L;
                    System.out.println("Thread.sleep(100), elapsed    : " + l3 + "us" + " (difference " + l4 + "us)");
                }
                System.out.println("");
                l = perfTimes.getStampUs();
                l2 = perfTimes.elapsed();
                l3 = System.currentTimeMillis() * 1000L;
                System.out.println("Time via perfTimes.getStampUs()     : " + l + "us");
                System.out.println("Time via perfTimes.elapsed()        : " + l2 + "us");
                System.out.println("Time via System.currentTimeMillis() : " + l3 + "us");
            }
            if (bl3 || bl) {
                try {
                    System.out.println();
                    System.out.println("Network infos");
                    System.out.println("  Operating System: " + System.getProperty("os.name"));
                    System.out.println("  Hostname........: " + InetAddress.getLocalHost().getHostName());
                    System.out.println("  IP-Address......: " + InetAddress.getLocalHost().getHostAddress());
                    System.out.println("  MAC Address.....: " + perfTimes.getMacAddress(string, string2));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception.getMessage());
        }
    }

    public void run() {
        try {
            for (int i = 0; i < 10; ++i) {
                long l = System.currentTimeMillis() / 1000L;
                while (System.currentTimeMillis() / 1000L == l) {
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

