/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample4.page;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.ControllerPage;
import com.sap.ip.me.mdk.api.awt.gui.page.DetailListPage;
import com.sap.ip.me.mdk.api.awt.gui.util.NavHelper;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Component;
import java.awt.Image;
import java.awt.TextField;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import persistenceexample4.Constants;

public class DetailList
extends DetailListPage
implements Constants {
    private static final String footerMsg = "Page";
    private static final String headerTitle = "Car inventory: ";
    private Vector data = null;
    private NavHelper navHelper = null;
    protected LinkButton characterNavLink = null;
    protected LinkButton[] characterNavLinks = null;
    private LinkButton[] tableNavListLink = null;
    private LinkButton[] tableLink = null;
    private TextLabel[] tableDescription = null;
    private LinkButton[] tableHeaderLink = null;
    private TextLabel[] tableHeaderDescription = null;
    private TextField tfCurrentPage = null;
    private TextLabel tlPageString = null;
    private TextLabel tlTotalPage = null;
    private LinkButton gotoPage = null;
    private Image imgPlay = ComponentConstants.getImage("run.gif");
    private String[] tableHeaderLines = new String[]{"  Make/Model  ", "License           "};

    public DetailList(ControllerPage mainPage) {
        super(mainPage.getActionHandler());
        String[] charsNav = (String[])this.getAttribute("CHARNAV");
        this.characterNavLinks = new LinkButton[charsNav.length];
        int i = 0;
        while (i < this.characterNavLinks.length) {
            this.characterNavLinks[i] = new LinkButton(charsNav[i]);
            this.characterNavLinks[i].addMouseListener(this.actionHandler);
            this.characterNavLinks[i].setTargetPage("DetailList", "DetailList", charsNav[i]);
            this.characterNavLinks[i].setTargetHandler("showList", "showCharacterList", charsNav[i]);
            this.characterNavLinks[i].setName(charsNav[i].toString());
            ++i;
        }
        this.setCharacterNavLinks(this.characterNavLinks);
        this.tfCurrentPage = ComponentConstants.createTextField(1, 3, true);
        this.tfCurrentPage.setSize(this.tfCurrentPage.getSize().width / 2, this.tfCurrentPage.getSize().height * 2 / 3);
        this.tlPageString = new TextLabel(footerMsg);
        this.tlTotalPage = new TextLabel("/??");
        this.gotoPage = ComponentConstants.createImageButton(this.imgPlay, "", "getDesiredPage");
        this.gotoPage.addMouseListener(this.actionHandler);
    }

    public void setCharacterNavLinks(LinkButton[] links) {
        if (links != null && links.length > 0) {
            this.actionBar.addToLeft(links);
        }
    }

    public void initializePage() {
        String[] pgHandlers = new String[]{"gotoFirstPage", "gotoPrevPage", "gotoNextPage", "gotoLastPage"};
        this.setPageNavHandlers(pgHandlers);
        this.setCreateActionAttributes("CarCreatePage", "showCarCreate");
        this.setPagingContols(new Component[]{this.tlPageString, this.tfCurrentPage, this.tlTotalPage, this.gotoPage});
    }

    public Object getObject() {
        if (Utilities.isNumber(this.tfCurrentPage.getText())) {
            int n = Integer.parseInt(this.tfCurrentPage.getText());
            NavHelper.PG_CURPAGE = n < 1 ? 1 : (n > NavHelper.PG_PAGECOUNT ? NavHelper.PG_PAGECOUNT : n);
        }
        return this.navHelper;
    }

    public void destroyPage() {
        this.clearAttributes();
    }

    public void updatePage() {
        this.navHelper = (NavHelper)this.getAttribute("NAVHELPER");
        this.data = (Vector)this.getAttribute("OBJECTLIST");
        this.setHeaderTexts(new String[]{headerTitle + (String)this.getAttribute("CURNAVCHAR")});
        this.tfCurrentPage.setText("" + NavHelper.PG_CURPAGE);
        this.tlTotalPage.setLabel("/" + NavHelper.PG_PAGECOUNT);
        if (NavHelper.PG_TOPPREV) {
            this.enableFirstPrevPageNav();
        } else {
            this.disableFirstPrevPageNav();
        }
        if (NavHelper.PG_NEXTLAST) {
            this.enableNextLastPageNav();
        } else {
            this.disableNextLastPageNav();
        }
        int i = 0;
        this.tableHeaderDescription = new TextLabel[1];
        this.tableHeaderLink = new LinkButton[1];
        this.tableHeaderLink[i] = new LinkButton(this.tableHeaderLines[0]);
        this.tableHeaderLink[i].addMouseListener(this.actionHandler);
        this.tableHeaderLink[i].setTargetPage("DetailList");
        this.tableHeaderLink[i].setTargetHandler("sortByCar");
        this.tableHeaderLink[i].setTextColor(ComponentConstants.linkHeaderColor);
        this.tableHeaderDescription[i] = new TextLabel(this.tableHeaderLines[1]);
        this.tableHeaderDescription[i].setTextColor(ComponentConstants.headerTextColor);
        this.setListHeader(this.tableHeaderLink, this.tableHeaderDescription);
        Iterator dataIterator = ((AbstractList)this.data).iterator();
        this.tableDescription = new TextLabel[this.data.size()];
        this.tableLink = new LinkButton[this.data.size()];
        Vector dataEntry = null;
        while (dataIterator.hasNext()) {
            dataEntry = (Vector)dataIterator.next();
            this.tableLink[i] = new LinkButton(dataEntry.elementAt(1).toString() + "-" + dataEntry.elementAt(2).toString());
            this.tableLink[i].addMouseListener(this.actionHandler);
            this.tableLink[i].setTargetPage("CarDetailPage");
            this.tableLink[i].setTargetHandler("showCarDetails");
            this.tableLink[i].setName(dataEntry.elementAt(0).toString());
            this.tableDescription[i] = new TextLabel(dataEntry.elementAt(3).toString());
            ++i;
        }
        this.setList(this.tableLink, this.tableDescription);
        this.validate();
    }
}

