/*
 * Decompiled with CFR 0.152.
 */
package persistenceexample4.datafactory;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.QueryRuntime;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import java.util.Vector;
import persistenceexample4.Constants;
import persistenceexample4.datafactory.Car;
import persistenceexample4.datafactory.ExamplePackagePersistenceMaster;
import persistenceexample4.datafactory.License;

public class ReadWriteEntities
implements Constants {
    private static PersistenceRuntime persistence;
    private static PersistenceManager perManager;
    private static ExamplePackagePersistenceMaster master;
    private static int idCount;
    private static int currentIndex;
    private static int persistedEntityCount;

    public static void setupPersistenceRuntime() {
        try {
            persistence = PersistenceRuntime.getInstance();
            master = new ExamplePackagePersistenceMaster();
            persistence.registerPersistenceMaster((PackagePersistenceMaster)master);
            perManager = persistence.getPersistenceManager(VisibilityType.SEPARATED);
            perManager.registerEntityFactory((EntityFactory)master);
            perManager.beginTransaction(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error during startup");
            System.exit(-1);
        }
    }

    public static PersistableEntity createCarEntity(String name) {
        Car car = new Car(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_CAR, name));
        return car;
    }

    public static PersistableEntity createLicenseEntity(String number) {
        License license = new License(perManager.getPersistedObjectFactory().createPersistedObject(ExamplePackagePersistenceMaster.P_CLASS_LICENSE, number));
        return license;
    }

    public static void combineCarLicense(PersistableEntity car, PersistableEntity license) {
        License l = (License)license;
        Car c = (Car)car;
        c.setLicense(l);
    }

    public static void setCarAttributes(PersistableEntity car, String make, String model, String engine, int cyl, int valves) {
        Car c = (Car)car;
        c.setValues(make, model, engine, cyl, valves);
    }

    public static void writeEntity(PersistableEntity obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                perManager.update(obj, TreeOptionType.COMPLETE);
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void addEntity(String make, String model, String engine, String cylinders, String valves, String lic) {
        PersistableEntity ecar = null;
        PersistableEntity elic = null;
        if (make.length() > 0) {
            ecar = ReadWriteEntities.createCarEntity(Integer.toString(idCount));
            ++idCount;
        }
        if (lic.length() > 0) {
            elic = ReadWriteEntities.createLicenseEntity(lic);
        }
        if (elic != null && ecar != null) {
            ReadWriteEntities.combineCarLicense(ecar, elic);
        }
        int cyl = Integer.parseInt(cylinders);
        int val = Integer.parseInt(valves);
        ReadWriteEntities.setCarAttributes(ecar, make, model, engine, cyl, val);
        ReadWriteEntities.writeEntity(ecar);
        ReadWriteEntities.writeEntity(elic);
    }

    public static MeIterator readEntity(int index, int sortIndex, boolean sort_ascending, String[] filter) {
        int count = 0;
        MeIterator entities = null;
        try {
            if (perManager == null) {
                System.out.println(" trxmanager is null");
            } else {
                QueryRuntime queryRuntime = QueryRuntime.getInstance();
                SortOrder sortOrder = null;
                SortOrder[] sortOrderMake = new SortOrder[2];
                Condition cond = null;
                Query query = null;
                sortOrderMake[0] = queryRuntime.createSortOrder(ExamplePackagePersistenceMaster.CAR_ATTRIBS[sortIndex], sort_ascending);
                sortOrderMake[1] = queryRuntime.createSortOrder(ExamplePackagePersistenceMaster.CAR_ATTRIBS[sortIndex + 1], true);
                sortOrder = queryRuntime.createSortOrder(sortOrderMake);
                if (index < 0) {
                    cond = queryRuntime.createCondition(ExamplePackagePersistenceMaster.CAR_ATTRIBS[0], RelationalOperatorType.GREATER_THAN, (Object)"");
                } else {
                    Condition[] filterCond = new Condition[filter.length];
                    int i = 0;
                    while (i < filter.length) {
                        filterCond[i] = queryRuntime.createCondition(ExamplePackagePersistenceMaster.CAR_ATTRIBS[index - 1], RelationalOperatorType.STARTS_WITH, (Object)filter[i]);
                        ++i;
                    }
                    cond = queryRuntime.createCondition(filterCond, LogicalOperatorType.OR);
                }
                query = queryRuntime.createQuery(ExamplePackagePersistenceMaster.CLASSTYPES[0], cond, sortOrder);
                entities = perManager.get(query);
                while (entities.hasNext()) {
                    Car entity = (Car)entities.next();
                    ++count;
                }
                ReadWriteEntities.setPersistedEntityCount(count);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        return entities;
    }

    public static void deleteEntity(String obj) {
        if (obj != null) {
            PersistenceException e = null;
            try {
                PersistableEntity toDel = perManager.get(master.getClassDescriptor("Car-Query"), obj);
                perManager.delete(toDel, TreeOptionType.COMPLETE);
            }
            catch (PersistenceException e1) {
                e = e1;
                e1.printStackTrace();
            }
        }
    }

    public static void commit() {
        try {
            perManager.commit();
        }
        catch (PersistenceException e) {
            System.out.println("Data can not be stored");
            e.printStackTrace();
        }
    }

    public static void writeExampleEntries() {
        int count = ReadWriteEntities.numberOfEntries();
        if (count == 0) {
            idCount = 0;
            ReadWriteEntities.addEntity("BMW", "540", "Gasoline", "8", "2", "HD-JD1234");
            ReadWriteEntities.addEntity("BMW", "320", "Gasoline", "6", "2", "HD-JM2345");
            ReadWriteEntities.addEntity("VW", "Passat", "Diesel", "4", "2", "");
            ReadWriteEntities.addEntity("Opel", "Vectra", "Diesel", "4", "4", "HD-JL3456");
            ReadWriteEntities.addEntity("Toyota", "Camry", "Diesel", "4", "2", "BRA-XX456");
            ReadWriteEntities.addEntity("Mazda", "6", "Gasoline", "4", "2", "SFA-BA456");
            ReadWriteEntities.addEntity("Renault", "Megane", "Diesel", "4", "2", "F-ME1256");
            ReadWriteEntities.addEntity("Renault", "Scenic", "Gasoline", "4", "2", "F-SC 5478");
            ReadWriteEntities.addEntity("Ford", "Mondeo", "Gasoline", "6", "2", "K-MO 1239");
            ReadWriteEntities.addEntity("Peugeot", "307", "Gasoline", "4", "2", "AA-X 139");
        }
    }

    private static int numberOfEntries() {
        idCount = -1;
        int count = 0;
        try {
            MeIterator entities = perManager.getAll(master.getClassDescriptor("Car-Query"));
            while (entities.hasNext()) {
                ++count;
                Car entity = (Car)entities.next();
                int id = Integer.parseInt(entity.toString());
                if (id <= idCount) continue;
                idCount = id;
            }
            ++idCount;
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return count;
    }

    public static int getPersistedEntityCount() {
        return persistedEntityCount;
    }

    public static void setPersistedEntityCount(int i) {
        persistedEntityCount = i;
    }

    public static Vector getEntities(MeIterator persistenceEntities, int fromIndex, int count) {
        int recCount = count;
        int start_index = fromIndex;
        Vector retSubVec = new Vector();
        Vector<String> found_entities = null;
        int i = 0;
        persistenceEntities.reset();
        while (persistenceEntities.hasNext()) {
            Car entity = (Car)persistenceEntities.next();
            if (i >= fromIndex) {
                found_entities = new Vector<String>();
                found_entities.addElement(entity.toString());
                found_entities.addElement(entity.makeToString());
                found_entities.addElement(entity.modelToString());
                found_entities.addElement(entity.licToString());
                found_entities.addElement(entity.engineToString());
                found_entities.addElement(entity.cylToString());
                found_entities.addElement(entity.valveToString());
                System.err.println("got car: " + entity.toString() + " : " + entity.makeToString());
                retSubVec.add(found_entities);
            }
            if (++i < fromIndex + count) continue;
            return retSubVec;
        }
        return retSubVec;
    }

    public static int getEntity(MeIterator persistenceEntities, String id, int prev) {
        Car entity = null;
        String prevId = null;
        currentIndex = -1;
        persistenceEntities.reset();
        while (persistenceEntities.hasNext()) {
            ++currentIndex;
            entity = (Car)persistenceEntities.next();
            if (entity == null) continue;
            if (entity.toString().compareTo(id) == 0) {
                if (prev == 0) {
                    return currentIndex;
                }
                if (prev == -1) {
                    if (prevId != null) {
                        return --currentIndex;
                    }
                    return currentIndex;
                }
                if (prev == 1) {
                    if (persistenceEntities.hasNext()) {
                        return ++currentIndex;
                    }
                    return currentIndex;
                }
            }
            prevId = entity.toString();
        }
        return currentIndex;
    }

    public static int getCurrentIndex() {
        return currentIndex;
    }
}

