/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.page;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListHeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.page.BasicPage;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.PageNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

public abstract class DetailListPage
extends BasicPage {
    private LinkButton homeLink = null;
    protected LinkButton createLink = null;
    protected LinkButton backLink = null;
    private ListPanel listTable = null;
    private ListHeaderPanel listTableHeaderLeft = null;
    private ListHeaderPanel listTableHeaderRight = null;
    private TopNavLink topLink = null;
    private PageNavPanel pageNav = null;
    protected MouseListener actionHandler = null;
    protected static Image imgNew = ComponentConstants.getImage("nnew.gif");
    protected static Image imgBack = ComponentConstants.getImage("jgtop.gif");

    private DetailListPage() {
    }

    public DetailListPage(MouseListener actionHandler) {
        this.actionHandler = actionHandler;
        this.createLink = new LinkButton(imgNew);
        this.createLink.addMouseListener(actionHandler);
        this.createLink.setName("Add new car");
        this.setActionBarLinks(new LinkButton[]{this.createLink});
        this.listTableHeaderLeft = new ListHeaderPanel();
        this.listTableHeaderRight = new ListHeaderPanel();
        this.listTable = new ListPanel();
        this.setBody(this.listTable);
        this.pageNav = new PageNavPanel();
        this.pageNav.setCommonActionHandler(actionHandler);
        this.setFooterNavBar(this.pageNav);
    }

    public void setBackActionAttributes(String targetPage, String targetHandler) {
        if (this.backLink == null) {
            this.backLink = new LinkButton(imgBack);
        }
        this.backLink.addMouseListener(this.actionHandler);
        this.backLink.setTargetPage(targetPage);
        this.backLink.setTargetHandler(targetHandler);
        this.setActionBarLinks(new LinkButton[]{this.createLink, this.backLink});
        this.validate();
    }

    public void setCreateActionAttributes(String targetPage, String targetHandler) {
        this.createLink.setTargetPage(targetPage);
        this.createLink.setTargetHandler(targetHandler);
    }

    public void setPageNavHandlers(String[] handlerNames) {
        this.pageNav.setTargetHandler(handlerNames);
    }

    public void setTopLinkCommand(String targetPage, String handlerName) {
        this.homeLink.setTargetPage(targetPage);
        this.homeLink.setTargetHandler(handlerName);
    }

    public void setFooterMessage(String msgText) {
        this.pageNav.setMessageText(msgText);
    }

    public void setPagingContols(Component[] c) {
        this.pageNav.addToLeft(c);
    }

    public void removePageNav() {
        this.remove(this.pageNav);
        this.validate();
    }

    public void setList(LinkButton[] links, TextLabel[] texts) {
        this.listTable.removeAll();
        int count = links.length < texts.length ? links.length : texts.length;
        this.listTable.appendLine((Component)this.listTableHeaderLeft, this.listTableHeaderRight);
        int i = 0;
        while (i < count) {
            this.listTable.appendLine((Component)links[i], texts[i]);
            ++i;
        }
        this.listTable.validate();
    }

    public void setListHeader(LinkButton[] links, TextLabel[] texts) {
        this.listTableHeaderLeft.removeAll();
        this.listTableHeaderRight.removeAll();
        int count = links.length < texts.length ? links.length : texts.length;
        int i = 0;
        while (i < count) {
            this.listTableHeaderLeft.appendLine(links[i]);
            this.listTableHeaderRight.appendLine(texts[i]);
            ++i;
        }
    }

    public void disableFirstPrevPageNav() {
        this.pageNav.disableFirstAndPrevious();
    }

    public void disableNextLastPageNav() {
        this.pageNav.disableNextAndLast();
    }

    public void enableFirstPrevPageNav() {
        this.pageNav.enableFirstAndPrevious();
    }

    public void enableNextLastPageNav() {
        this.pageNav.enableNextAndLast();
    }

    public abstract void initializePage();

    public abstract void destroyPage();

    public abstract void updatePage();
}

